/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.info.ProductVersionHolder;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SPSDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.ConnectionChild;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GenericConstantActionFactory;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GenericExecutionFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class EmbedDatabaseMetaData
extends ConnectionChild
implements DatabaseMetaData,
PrivilegedAction {
    private static final int ILLEGAL_UDT_TYPE = 0;
    private final String url;
    private GenericConstantActionFactory constantActionFactory;
    private static Properties queryDescriptions;
    private static Properties queryDescriptions_net;
    private static final ReentrantLock spsLock;

    public EmbedDatabaseMetaData(EmbedConnection connection, String url) throws SQLException {
        super(connection);
        this.url = url;
    }

    private Properties getQueryDescriptions(boolean net) {
        Properties p;
        Properties properties = p = net ? queryDescriptions_net : queryDescriptions;
        if (p != null) {
            return p;
        }
        this.loadQueryDescriptions();
        return net ? queryDescriptions_net : queryDescriptions;
    }

    private void PBloadQueryDescriptions() {
        String[] files = new String[]{"metadata.properties", "/com/pivotal/gemfirexd/internal/impl/sql/catalog/metadata_net.properties"};
        Properties[] props = new Properties[files.length];
        for (int i = 0; i < files.length; ++i) {
            try {
                props[i] = new Properties();
                InputStream is = this.getClass().getResourceAsStream(files[i]);
                props[i].load(is);
                is.close();
                continue;
            }
            catch (IOException ioe) {
                SanityManager.THROWASSERT((String)("Error reading " + files[i]), (Throwable)ioe);
            }
        }
        queryDescriptions = props[0];
        queryDescriptions_net = props[1];
    }

    @Override
    public boolean allProceduresAreCallable() {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public final String getURL() {
        if (this.url == null) {
            return this.url;
        }
        int attributeStart = this.url.indexOf(59);
        if (attributeStart == -1) {
            return this.url;
        }
        return this.url.substring(0, attributeStart);
    }

    @Override
    public String getUserName() {
        return this.getEmbedConnection().getTR().getUserName();
    }

    @Override
    public boolean isReadOnly() {
        return this.getLanguageConnectionContext().getDatabase().isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public String getDatabaseProductName() {
        return Monitor.getMonitor().getEngineVersion().getProductName();
    }

    @Override
    public String getDatabaseProductVersion() {
        ProductVersionHolder myPVH = Monitor.getMonitor().getEngineVersion();
        return myPVH.getVersionBuildString(true);
    }

    @Override
    public String getDriverName() {
        return "GemFireXD Embedded JDBC Driver";
    }

    @Override
    public String getDriverVersion() {
        return this.getDatabaseProductVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return this.getEmbedConnection().getLocalDriver().getMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return this.getEmbedConnection().getLocalDriver().getMinorVersion();
    }

    @Override
    public boolean usesLocalFiles() {
        return true;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String getSQLKeywords() {
        return "ALIAS,BIGINT,BOOLEAN,CALL,CLASS,COPY,DB2J_DEBUG,EXECUTE,EXPLAIN,FILE,FILTER,GETCURRENTCONNECTION,INDEX,INSTANCEOF,METHOD,NEW,OFF,PROPERTIES,RECOMPILE,RENAME,RUNTIMESTATISTICS,STATEMENT,STATISTICS,TIMING,WAIT";
    }

    @Override
    public String getNumericFunctions() {
        return "ABS,ACOS,ASIN,ATAN,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MOD,PI,RADIANS,RAND,SIGN,SIN,SQRT,TAN";
    }

    @Override
    public String getStringFunctions() {
        return "CONCAT,LENGTH,LCASE,LOCATE,LTRIM,RTRIM,SUBSTRING,UCASE";
    }

    @Override
    public String getSystemFunctions() {
        return "USER";
    }

    @Override
    public String getTimeDateFunctions() {
        return "CURDATE,CURTIME,HOUR,MINUTE,MONTH,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,YEAR";
    }

    @Override
    public String getSearchStringEscape() {
        return "";
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return false;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public String getSchemaTerm() {
        return "SCHEMA";
    }

    @Override
    public String getProcedureTerm() {
        return "PROCEDURE";
    }

    @Override
    public String getCatalogTerm() {
        return "CATALOG";
    }

    @Override
    public boolean isCatalogAtStart() {
        return false;
    }

    @Override
    public String getCatalogSeparator() {
        return "";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    @Override
    public boolean supportsUnion() {
        return true;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 128;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 128;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 128;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 128;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return true;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 128;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 30;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 0;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return level == 2 || level == 4 || level == 1 || level == 0;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return this.doGetProcs(catalog, schemaPattern, procedureNamePattern, "getProcedures40");
    }

    public ResultSet getProceduresForODBC(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return this.doGetProcs(catalog, schemaPattern, procedureNamePattern, "odbc_getProcedures");
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return this.doGetProcs(catalog, schemaPattern, functionNamePattern, "getFunctions");
    }

    private ResultSet doGetProcs(String catalog, String schemaPattern, String procedureNamePattern, String queryName) throws SQLException {
        PreparedStatement s = this.getPreparedQuery(queryName);
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schemaPattern));
        s.setString(3, EmbedDatabaseMetaData.swapNull(procedureNamePattern));
        return s.executeQuery();
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return this.doGetProcCols(catalog, schemaPattern, procedureNamePattern, columnNamePattern, "getProcedureColumns40");
    }

    public ResultSet getProcedureColumnsForODBC(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return this.doGetProcCols(catalog, schemaPattern, procedureNamePattern, columnNamePattern, "odbc_getProcedureColumns");
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String parameterNamePattern) throws SQLException {
        return this.doGetProcCols(catalog, schemaPattern, functionNamePattern, parameterNamePattern, "getFunctionColumns");
    }

    private ResultSet doGetProcCols(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern, String queryName) throws SQLException {
        PreparedStatement s = this.getPreparedQuery(queryName);
        s.setString(1, EmbedDatabaseMetaData.swapNull(schemaPattern));
        s.setString(2, EmbedDatabaseMetaData.swapNull(procedureNamePattern));
        s.setString(3, EmbedDatabaseMetaData.swapNull(columnNamePattern));
        return s.executeQuery();
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        int i;
        PreparedStatement s = this.getPreparedQuery("getTables");
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schemaPattern));
        s.setString(3, EmbedDatabaseMetaData.swapNull(tableNamePattern));
        int numberOfTableTypesInDerby = 9;
        if (types == null) {
            types = new String[]{"TABLE", "VIEW", "SYNONYM", "SYSTEM TABLE", "COLUMN TABLE", "EXTERNAL TABLE", "STREAM TABLE", "SAMPLE TABLE", "TOPK TABLE"};
        }
        String[] typeParams = new String[9];
        for (i = 0; i < 9; ++i) {
            typeParams[i] = null;
        }
        for (i = 0; i < types.length; ++i) {
            if ("TABLE".equals(types[i])) {
                typeParams[0] = "T";
                continue;
            }
            if ("VIEW".equals(types[i])) {
                typeParams[1] = "V";
                continue;
            }
            if ("SYNONYM".equals(types[i])) {
                typeParams[2] = "A";
                continue;
            }
            if ("SYSTEM TABLE".equals(types[i]) || "SYSTEM_TABLE".equals(types[i])) {
                typeParams[3] = "S";
                continue;
            }
            if ("COLUMN TABLE".equals(types[i]) || "COLUMN_TABLE".equals(types[i])) {
                typeParams[4] = "COLUMN";
                continue;
            }
            if ("EXTERNAL TABLE".equals(types[i])) {
                typeParams[5] = "EXTERNAL";
                continue;
            }
            if ("STREAM TABLE".equals(types[i])) {
                typeParams[6] = "STREAM";
                continue;
            }
            if ("SAMPLE TABLE".equals(types[i])) {
                typeParams[7] = "SAMPLE";
                continue;
            }
            if (!"TOPK TABLE".equals(types[i])) continue;
            typeParams[8] = "TOPK";
        }
        for (i = 0; i < 9; ++i) {
            if (typeParams[i] == null) {
                s.setNull(i + 4, 1);
                continue;
            }
            s.setString(i + 4, typeParams[i]);
        }
        s.setString(13, EmbedDatabaseMetaData.swapNull(schemaPattern));
        s.setString(14, EmbedDatabaseMetaData.swapNull(tableNamePattern));
        return s.executeQuery();
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return this.getSimpleQuery("getCatalogs");
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return this.getSimpleQuery("getTableTypes");
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.doGetCols(catalog, schemaPattern, tableNamePattern, columnNamePattern, "getColumns");
    }

    public ResultSet getColumnsForODBC(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        return this.doGetCols(catalog, schemaPattern, tableNamePattern, columnNamePattern, "odbc_getColumns");
    }

    private ResultSet doGetCols(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern, String queryName) throws SQLException {
        PreparedStatement s = this.getPreparedQuery(queryName);
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schemaPattern));
        s.setString(3, EmbedDatabaseMetaData.swapNull(tableNamePattern));
        s.setString(4, EmbedDatabaseMetaData.swapNull(columnNamePattern));
        s.setString(5, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(6, EmbedDatabaseMetaData.swapNull(schemaPattern));
        s.setString(7, EmbedDatabaseMetaData.swapNull(tableNamePattern));
        s.setString(8, EmbedDatabaseMetaData.swapNull(columnNamePattern));
        s.setString(9, EmbedDatabaseMetaData.swapNull(schemaPattern));
        s.setString(10, EmbedDatabaseMetaData.swapNull(tableNamePattern));
        s.setString(11, EmbedDatabaseMetaData.swapNull(columnNamePattern));
        return s.executeQuery();
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        if (table == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        PreparedStatement s = this.getPreparedQuery("getColumnPrivileges");
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schema));
        s.setString(3, table);
        s.setString(4, EmbedDatabaseMetaData.swapNull(columnNamePattern));
        return s.executeQuery();
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        PreparedStatement s = this.getPreparedQuery("getTablePrivileges");
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schemaPattern));
        s.setString(3, EmbedDatabaseMetaData.swapNull(tableNamePattern));
        return s.executeQuery();
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalogPattern, String schemaPattern, String table, int scope, boolean nullable) throws SQLException {
        return this.doGetBestRowId(catalogPattern, schemaPattern, table, scope, nullable, "");
    }

    public ResultSet getBestRowIdentifierForODBC(String catalogPattern, String schemaPattern, String table, int scope, boolean nullable) throws SQLException {
        return this.doGetBestRowId(catalogPattern, schemaPattern, table, scope, nullable, "odbc_");
    }

    private ResultSet doGetBestRowId(String catalogPattern, String schemaPattern, String table, int scope, boolean nullable, String queryPrefix) throws SQLException {
        if (table == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        int nullableInIntForm = 0;
        if (nullable) {
            nullableInIntForm = 1;
        }
        if (catalogPattern == null) {
            catalogPattern = "%";
        }
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        if (scope < 0 || scope > 2) {
            PreparedStatement ps = this.getPreparedQuery("getBestRowIdentifierEmpty");
            return ps.executeQuery();
        }
        PreparedStatement ps = this.getPreparedQuery("getBestRowIdentifierPrimaryKey");
        ps.setString(1, catalogPattern);
        ps.setString(2, schemaPattern);
        ps.setString(3, table);
        ResultSet rs = ps.executeQuery();
        boolean done = rs.next();
        String constraintId = "";
        if (done) {
            constraintId = rs.getString(1);
        }
        rs.close();
        ps.close();
        if (done) {
            ps = this.getPreparedQuery(queryPrefix + "getBestRowIdentifierPrimaryKeyColumns");
            ps.setString(1, constraintId);
            ps.setString(2, constraintId);
            return ps.executeQuery();
        }
        ps = this.getPreparedQuery("getBestRowIdentifierUniqueConstraint");
        ps.setString(1, catalogPattern);
        ps.setString(2, schemaPattern);
        ps.setString(3, table);
        rs = ps.executeQuery();
        done = rs.next();
        if (done) {
            constraintId = rs.getString(1);
        }
        rs.close();
        ps.close();
        if (done) {
            ps = this.getPreparedQuery(queryPrefix + "getBestRowIdentifierUniqueKeyColumns");
            ps.setString(1, constraintId);
            ps.setString(2, constraintId);
            ps.setInt(3, nullableInIntForm);
            return ps.executeQuery();
        }
        ps = this.getPreparedQuery("getBestRowIdentifierUniqueIndex");
        ps.setString(1, catalogPattern);
        ps.setString(2, schemaPattern);
        ps.setString(3, table);
        rs = ps.executeQuery();
        done = rs.next();
        long indexNum = 0L;
        if (done) {
            indexNum = rs.getLong(1);
        }
        rs.close();
        ps.close();
        if (done) {
            ps = this.getPreparedQuery(queryPrefix + "getBestRowIdentifierUniqueIndexColumns");
            ps.setLong(1, indexNum);
            ps.setInt(2, nullableInIntForm);
            return ps.executeQuery();
        }
        ps = this.getPreparedQuery(queryPrefix + "getBestRowIdentifierAllColumns");
        ps.setString(1, catalogPattern);
        ps.setString(2, schemaPattern);
        ps.setString(3, table);
        ps.setInt(4, scope);
        ps.setInt(5, nullableInIntForm);
        return ps.executeQuery();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return this.doGetVersionCols(catalog, schema, table, "getVersionColumns");
    }

    public ResultSet getVersionColumnsForODBC(String catalog, String schema, String table) throws SQLException {
        return this.doGetVersionCols(catalog, schema, table, "odbc_getVersionColumns");
    }

    private ResultSet doGetVersionCols(String catalog, String schema, String table, String queryName) throws SQLException {
        if (table == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        PreparedStatement s = this.getPreparedQuery(queryName);
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schema));
        s.setString(3, table);
        return s.executeQuery();
    }

    private boolean notInSoftUpgradeMode() throws SQLException {
        boolean notInSoftUpgradeMode;
        if (this.getEmbedConnection().isClosed()) {
            throw Util.noCurrentConnection();
        }
        try {
            notInSoftUpgradeMode = this.getLanguageConnectionContext().getDataDictionary().checkVersion(-1, null);
        }
        catch (Throwable t) {
            throw this.handleException(t);
        }
        return notInSoftUpgradeMode;
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        PreparedStatement s = this.getPreparedQuery("getPrimaryKeys");
        if (table == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schema));
        s.setString(3, table);
        return s.executeQuery();
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        if (table == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        PreparedStatement s = this.getPreparedQuery("getImportedKeys");
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schema));
        s.setString(3, table);
        return s.executeQuery();
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        if (table == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        PreparedStatement s = this.getPreparedQuery("getCrossReference");
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schema));
        s.setString(3, table);
        s.setString(4, EmbedDatabaseMetaData.swapNull(null));
        s.setString(5, EmbedDatabaseMetaData.swapNull(null));
        s.setString(6, EmbedDatabaseMetaData.swapNull(null));
        return s.executeQuery();
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        if (primaryTable == null || foreignTable == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        PreparedStatement s = this.getPreparedQuery("getCrossReference");
        s.setString(1, EmbedDatabaseMetaData.swapNull(primaryCatalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(primarySchema));
        s.setString(3, primaryTable);
        s.setString(4, EmbedDatabaseMetaData.swapNull(foreignCatalog));
        s.setString(5, EmbedDatabaseMetaData.swapNull(foreignSchema));
        s.setString(6, foreignTable);
        return s.executeQuery();
    }

    public ResultSet getCrossReferenceForODBC(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        PreparedStatement s = this.getPreparedQuery("odbc_getCrossReference");
        s.setString(1, EmbedDatabaseMetaData.swapNull(primaryCatalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(primarySchema));
        s.setString(3, EmbedDatabaseMetaData.swapNull(primaryTable));
        s.setString(4, EmbedDatabaseMetaData.swapNull(foreignCatalog));
        s.setString(5, EmbedDatabaseMetaData.swapNull(foreignSchema));
        s.setString(6, EmbedDatabaseMetaData.swapNull(foreignTable));
        return s.executeQuery();
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return this.getSimpleQuery("getTypeInfo");
    }

    public ResultSet getTypeInfoForODBC(short dataType) throws SQLException {
        if (dataType == 0) {
            return this.getSimpleQuery("odbc_getTypeInfo");
        }
        PreparedStatement ps = this.getPreparedQuery("getTypeInfo2_odbc");
        ps.setInt(1, dataType);
        return ps.executeQuery();
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return this.doGetIndexInfo(catalog, schema, table, unique, approximate, "getIndexInfo");
    }

    public ResultSet getIndexInfoForODBC(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return this.doGetIndexInfo(catalog, schema, table, unique, approximate, "odbc_getIndexInfo");
    }

    private ResultSet doGetIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate, String queryName) throws SQLException {
        if (table == null) {
            throw Util.generateCsSQLException("XJ103.S");
        }
        int approximateInInt = 0;
        if (approximate) {
            approximateInInt = 1;
        }
        PreparedStatement s = this.getPreparedQuery(queryName);
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schema));
        s.setString(3, table);
        s.setBoolean(4, unique);
        s.setInt(5, approximateInInt);
        return s.executeQuery();
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return type == 1003 || type == 1004;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return type != 1005;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return type == 1004;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return type == 1004;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return type == 1003;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return type == 1003;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return type == 1003;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return type == 1004;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return type == 1004;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        int getClassTypes = 0;
        if (types == null) {
            getClassTypes = 2000;
        } else if (types.length > 0) {
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != 2000) continue;
                getClassTypes = 2000;
            }
        }
        PreparedStatement s = this.getPreparedQuery("getUDTs");
        s.setInt(1, 2000);
        s.setString(2, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(3, EmbedDatabaseMetaData.swapNull(schemaPattern));
        s.setString(4, EmbedDatabaseMetaData.swapNull(typeNamePattern));
        s.setInt(5, getClassTypes);
        return s.executeQuery();
    }

    @Override
    public Connection getConnection() {
        return this.getEmbedConnection().getApplicationConnection();
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return holdability != 1;
    }

    @Override
    public int getResultSetHoldability() {
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() {
        ProductVersionHolder pvh = Monitor.getMonitor().getEngineVersion();
        if (pvh == null) {
            return -1;
        }
        return pvh.getMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() {
        ProductVersionHolder pvh = Monitor.getMonitor().getEngineVersion();
        if (pvh == null) {
            return -1;
        }
        return pvh.getMinorVersion();
    }

    @Override
    public int getJDBCMajorVersion() {
        return 3;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 0;
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.getSimpleQuery("getSuperTypes");
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return this.getSimpleQuery("getSuperTables");
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return this.getSimpleQuery("getAttributes");
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return this.getSimpleQuery("getClientInfoProperties");
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        PreparedStatement s = this.getPreparedQuery("getSchemas");
        s.setString(1, EmbedDatabaseMetaData.swapNull(catalog));
        s.setString(2, EmbedDatabaseMetaData.swapNull(schemaPattern));
        s.setString(3, EmbedDatabaseMetaData.swapNull(schemaPattern));
        return s.executeQuery();
    }

    public ResultSet getClientCachedMetaData() throws SQLException {
        return this.getSimpleQuery("METADATA", true);
    }

    private ResultSet getSimpleQuery(String nameKey, boolean net) throws SQLException {
        PreparedStatement ps = this.getPreparedQuery(nameKey, net);
        if (ps == null) {
            return null;
        }
        return ps.executeQuery();
    }

    protected ResultSet getSimpleQuery(String nameKey) throws SQLException {
        return this.getSimpleQuery(nameKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement getPreparedQueryUsingSystemTables(String nameKey, boolean net) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack(true);
            PreparedStatement ps = null;
            try {
                String queryText = this.getQueryDescriptions(net).getProperty(nameKey);
                if (queryText == null) {
                    throw Util.notImplemented(nameKey);
                }
                ps = this.prepareSPS(nameKey, queryText, net);
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
            return ps;
        }
    }

    private PreparedStatement getPreparedQuery(String queryName, boolean net) throws SQLException {
        PreparedStatement s;
        if (this.notInSoftUpgradeMode() && !this.isReadOnly()) {
            s = this.getPreparedQueryUsingSystemTables(queryName, net);
        } else {
            try {
                String queryText = this.getQueryFromDescription(queryName, net);
                s = this.getEmbedConnection().prepareMetaDataStatement(queryText);
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
        }
        return s;
    }

    protected PreparedStatement getPreparedQuery(String queryName) throws SQLException {
        return this.getPreparedQuery(queryName, false);
    }

    private String getQueryFromDescription(String queryName, boolean net) throws StandardException {
        DataDictionary dd = this.getLanguageConnectionContext().getDataDictionary();
        if (!dd.checkVersion(140, null)) {
            if (queryName.equals("getColumnPrivileges")) {
                queryName = "getColumnPrivileges_10_1";
            }
            if (queryName.equals("getTablePrivileges")) {
                queryName = "getTablePrivileges_10_1";
            }
        }
        return this.getQueryDescriptions(net).getProperty(queryName);
    }

    private PreparedStatement prepareSPS(String spsName, String spsText, boolean net) throws StandardException, SQLException {
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        lcc.beginNestedTransaction(true);
        DataDictionary dd = this.getLanguageConnectionContext().getDataDictionary();
        boolean spsLocked = false;
        try {
            spsLocked = spsLock.tryLock(GfxdLockSet.MAX_LOCKWAIT_VAL, TimeUnit.SECONDS);
            if (!spsLocked) {
                throw StandardException.newException("40XL1");
            }
            SPSDescriptor spsd = dd.getSPSDescriptor(spsName, net ? dd.getSysIBMSchemaDescriptor() : dd.getSystemSchemaDescriptor());
            lcc.commitNestedTransaction();
            if (spsd == null) {
                throw Util.notImplemented(spsName);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress((Throwable)ie);
            throw StandardException.newException("40XL1", ie);
        }
        finally {
            if (spsLocked) {
                spsLock.unlock();
            }
        }
        String queryText = "EXECUTE STATEMENT " + (net ? "SYSIBM" : "SYS") + ".\"" + spsName + "\"";
        return this.getEmbedConnection().prepareMetaDataStatement(queryText);
    }

    protected static final String swapNull(String s) {
        return s == null ? "%" : s;
    }

    private GenericConstantActionFactory getGenericConstantActionFactory() throws StandardException {
        if (this.constantActionFactory == null) {
            GenericExecutionFactory execFactory = (GenericExecutionFactory)this.getLanguageConnectionContext().getLanguageConnectionFactory().getExecutionFactory();
            this.constantActionFactory = execFactory.getConstantActionFactory();
        }
        return this.constantActionFactory;
    }

    private LanguageConnectionContext getLanguageConnectionContext() {
        return this.getEmbedConnection().getLanguageConnection();
    }

    private void loadQueryDescriptions() {
        AccessController.doPrivileged(this);
    }

    public final Object run() {
        this.PBloadQueryDescriptions();
        return null;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new AssertionError((Object)"only expected to be called in JDBC 4.0");
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw new AssertionError((Object)"only expected to be called in JDBC 4.0");
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        throw new AssertionError((Object)"only expected to be called in JDBC 4.0");
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        throw new AssertionError((Object)"only expected to be called in JDBC 4.0");
    }

    @Override
    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        throw new AssertionError((Object)"only expected to be called in JDBC 4.0");
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new AssertionError((Object)"only expected to be called in JDBC 4.1");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        throw new AssertionError((Object)"only expected to be called in JDBC 4.1");
    }

    static {
        spsLock = new ReentrantLock();
    }
}

