/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.drda;

import com.gemstone.gemfire.cache.TransactionFlag;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.stats.ConnectionStats;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineConnection;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedResource;
import com.pivotal.gemfirexd.internal.impl.drda.DRDAStatement;
import com.pivotal.gemfirexd.internal.impl.drda.NetworkServerControlImpl;
import com.pivotal.gemfirexd.internal.impl.drda.PiggyBackedSessionData;
import com.pivotal.gemfirexd.internal.impl.drda.Pkgnamcsn;
import com.pivotal.gemfirexd.internal.impl.jdbc.TransactionResourceImpl;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

class Database {
    protected String dbName;
    protected String shortDbName;
    String attrString = "";
    protected int securityMechanism;
    protected String userId;
    protected String password;
    protected String decryptedUserId;
    protected String decryptedPassword;
    protected byte[] passwordSubstitute;
    public static final byte READ_ONLY = 0;
    public static final byte ALLOW_UPDATE = 1;
    public static final byte FAILOVER = 3;
    protected boolean rdbAllowUpdates = true;
    protected boolean failover = false;
    protected boolean disableStreaming = false;
    protected boolean skipListeners = false;
    protected boolean queryHDFS = false;
    protected boolean routeQuery = false;
    protected boolean skipConstraintChecks = false;
    protected boolean syncCommits = false;
    protected boolean disableTXBatching = false;
    protected boolean skipLocks = false;
    protected ConnectionStats connectionStats;
    protected long connectionBeginTime;
    protected Timestamp connectionBeginTimeStamp;
    protected int ncjBatchSize = 0;
    protected int ncjCacheSize = 0;
    protected int accessCount;
    protected byte[] secTokenIn;
    protected byte[] secTokenOut;
    protected byte[] crrtkn;
    protected String typDefNam;
    protected int byteOrder;
    protected int ccsidSBC;
    protected int ccsidDBC;
    protected int ccsidMBC;
    protected String ccsidSBCEncoding;
    protected String ccsidDBCEncoding;
    protected String ccsidMBCEncoding;
    protected boolean RDBUPDRM_sent = false;
    protected boolean sendTRGDFTRT = false;
    private EngineConnection conn;
    DRDAStatement defaultStatement;
    private DRDAStatement currentStatement;
    private Hashtable stmtTable;
    boolean forXA = false;
    private boolean locatorSupport = false;
    private boolean locatorSupportChecked = false;
    private PiggyBackedSessionData pbsd_ = null;

    Database(String dbName) {
        if (dbName != null) {
            int attrOffset = dbName.indexOf(59);
            if (attrOffset != -1) {
                this.attrString = dbName.substring(attrOffset, dbName.length());
                this.shortDbName = dbName.substring(0, attrOffset);
            } else {
                this.shortDbName = dbName;
            }
        }
        this.dbName = dbName;
        this.stmtTable = new Hashtable();
        this.initializeDefaultStatement();
    }

    private void initializeDefaultStatement() {
        this.defaultStatement = new DRDAStatement(this);
    }

    final void setConnection(EngineConnection conn) throws SQLException {
        if (this.conn != conn) {
            this.pbsd_ = null;
        }
        this.conn = conn;
        if (conn != null) {
            this.checkAndSetPossibleNCJBatchSizeDuplicate();
            this.checkAndSetPossibleNCJCacheSizeDuplicate();
            this.checkAndSetPossibleDuplicate();
            this.defaultStatement.setStatement(conn);
        }
    }

    final void checkAndSetPossibleNCJBatchSizeDuplicate() {
        LanguageConnectionContext lcc;
        if (this.conn != null && (lcc = this.conn.getLanguageConnectionContext()) != null) {
            if (SanityManager.TraceClientStatementHA) {
                SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("Set ncjBatchSize " + this.ncjBatchSize + " for connection: " + this.conn));
            }
            lcc.setNcjBatchSize(this.ncjBatchSize);
        }
    }

    final void checkAndSetPossibleNCJCacheSizeDuplicate() {
        LanguageConnectionContext lcc;
        if (this.conn != null && (lcc = this.conn.getLanguageConnectionContext()) != null) {
            if (SanityManager.TraceClientStatementHA) {
                SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("Set ncjCacheSize " + this.ncjCacheSize + " for connection: " + this.conn));
            }
            lcc.setNcjCacheSize(this.ncjCacheSize);
        }
    }

    final void checkAndSetPossibleDuplicate() throws SQLException {
        if (this.conn != null) {
            if (this.failover) {
                if (SanityManager.TraceClientStatementHA) {
                    SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("setting FAILOVER flag for connection: " + this.conn));
                }
                this.conn.setPossibleDuplicate(true);
            } else {
                this.conn.setPossibleDuplicate(false);
            }
            if (this.disableStreaming && SanityManager.TraceClientStatementHA) {
                SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("disabling STREAMING flag for connection: " + this.conn));
            }
            this.conn.setEnableStreaming(!this.disableStreaming);
            LanguageConnectionContext lcc = this.conn.getLanguageConnectionContext();
            if (this.skipListeners) {
                if (SanityManager.TraceClientStatementHA) {
                    SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("setting skip-listeners flag for connection: " + this.conn));
                }
                if (lcc != null) {
                    lcc.setSkipListeners();
                }
            }
            if (lcc != null) {
                lcc.setQueryHDFS(this.queryHDFS);
                lcc.setQueryRouting(this.routeQuery);
                if (this.skipConstraintChecks && SanityManager.TraceClientStatementHA) {
                    SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("skip-constraint-checks=true for connection: " + this.conn));
                }
                lcc.setSkipConstraintChecks(this.skipConstraintChecks);
                if (this.skipLocks) {
                    SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("setting skip-locks=true for connection: " + this.conn));
                }
                try {
                    lcc.setSkipLocksForConnection(this.skipLocks);
                }
                catch (StandardException se) {
                    throw Util.generateCsSQLException(se);
                }
            }
            EnumSet<TransactionFlag> txFlags = null;
            if (this.syncCommits) {
                if (SanityManager.TraceClientStatementHA) {
                    SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("enabling txn sync-commits for connection: " + this.conn));
                }
                txFlags = GemFireXDUtils.addTXFlag(TransactionFlag.SYNC_COMMITS, TXManagerImpl.SYNC_COMMITS, txFlags);
            }
            if (this.disableTXBatching) {
                if (SanityManager.TraceClientStatementHA) {
                    SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("disabling txn batching for connection: " + this.conn));
                }
                txFlags = GemFireXDUtils.addTXFlag(TransactionFlag.DISABLE_BATCHING, TXManagerImpl.DISABLE_BATCHING, txFlags);
            }
            if (lcc != null) {
                lcc.setTXFlags(txFlags);
            }
        }
    }

    final EngineConnection getConnection() {
        return this.conn;
    }

    protected DRDAStatement getCurrentStatement() {
        return this.currentStatement;
    }

    protected DRDAStatement getDefaultStatement() {
        this.currentStatement = this.defaultStatement;
        return this.defaultStatement;
    }

    protected DRDAStatement getDefaultStatement(Pkgnamcsn pkgnamcsn) {
        this.currentStatement = this.defaultStatement;
        this.currentStatement.setPkgnamcsn(pkgnamcsn);
        return this.currentStatement;
    }

    protected DRDAStatement newDRDAStatement(Pkgnamcsn pkgnamcsn) throws SQLException {
        DRDAStatement stmt = this.getDRDAStatement(pkgnamcsn);
        if (stmt != null) {
            stmt.close();
            stmt.reset();
        } else {
            stmt = new DRDAStatement(this);
            stmt.setPkgnamcsn(pkgnamcsn);
            this.storeStatement(stmt);
        }
        return stmt;
    }

    protected DRDAStatement getDRDAStatement(Pkgnamcsn pkgnamcsn) {
        DRDAStatement newStmt = (DRDAStatement)this.stmtTable.get(pkgnamcsn.getStatementKey());
        if (newStmt != null) {
            this.currentStatement = newStmt;
            this.currentStatement.setCurrentDrdaResultSet(pkgnamcsn);
        }
        return newStmt;
    }

    void makeConnection(Properties p) throws SQLException {
        this.connectionStats = InternalDriver.activeDriver().getConnectionStats();
        this.connectionStats.incClientConnectionsAttempt();
        p.put("user", this.userId);
        if (this.password != null) {
            p.put("password", this.password);
        }
        try {
            Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(null);
        }
        catch (Throwable t) {
            throw TransactionResourceImpl.wrapInSQLException(t);
        }
        p.put("gemfirexd.__rt.drdaClientConnection", "true");
        long beginConnection = ConnectionStats.getStatTime();
        boolean isStoreSnappy = Misc.getMemStore().isSnappyStore();
        String protocol = isStoreSnappy ? "jdbc:snappydata:" : "jdbc:gemfirexd:";
        EngineConnection conn = (EngineConnection)NetworkServerControlImpl.getDriver().connect(protocol + this.attrString, p);
        if (conn != null) {
            this.connectionStats.incClientConnectionsOpenTime(beginConnection);
            this.connectionStats.incClientConnectionsOpened();
            this.connectionBeginTime = ConnectionStats.getStatTime();
            this.connectionBeginTimeStamp = new Timestamp(System.currentTimeMillis());
            conn.setAutoCommit(false);
        }
        this.setConnection(conn);
    }

    void makeDummyConnection() {
        try {
            boolean isStoreSnappy = Misc.getMemStore().isSnappyStore();
            String protocol = isStoreSnappy ? "jdbc:snappydata:" : "jdbc:gemfirexd:";
            EngineConnection conn = (EngineConnection)NetworkServerControlImpl.getDriver().connect(protocol + this.attrString, new Properties());
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    String appendAttrString(Properties p) {
        if (p == null) {
            return null;
        }
        Enumeration<?> pKeys = p.propertyNames();
        while (pKeys.hasMoreElements()) {
            String key = (String)pKeys.nextElement();
            this.attrString = this.attrString + ";" + key + "=" + p.getProperty(key);
        }
        return this.attrString;
    }

    protected void storeStatement(DRDAStatement stmt) throws SQLException {
        this.stmtTable.put(stmt.getPkgnamcsn().getStatementKey(), stmt);
    }

    protected void removeStatement(DRDAStatement stmt) throws SQLException {
        this.stmtTable.remove(stmt.getPkgnamcsn().getStatementKey());
        stmt.close();
    }

    protected void setCurrentStatement(DRDAStatement stmt) {
        this.currentStatement = stmt;
    }

    protected void commit() throws SQLException {
        if (this.conn != null) {
            this.conn.commit();
        }
    }

    protected void rollback() throws SQLException {
        if (this.conn != null) {
            this.conn.rollback();
        }
    }

    protected void close() throws SQLException {
        try {
            if (this.stmtTable != null) {
                Enumeration e = this.stmtTable.elements();
                while (e.hasMoreElements()) {
                    ((DRDAStatement)e.nextElement()).close();
                }
            }
            if (this.defaultStatement != null) {
                this.defaultStatement.close();
            }
            if (this.conn != null && !this.conn.isClosed()) {
                if (!this.forXA) {
                    this.conn.internalRollback();
                }
                this.conn.internalClose();
            }
        }
        finally {
            if (this.conn != null) {
                if (this.connectionStats != null) {
                    this.connectionStats.incClientConnectionsClosed();
                    this.connectionStats.incClientConnectionsLifeTime(this.connectionBeginTime);
                }
                this.conn = null;
            }
            this.currentStatement = null;
            this.defaultStatement = null;
            this.stmtTable = null;
        }
    }

    final void setDrdaID(String drdaID) {
        if (this.conn != null) {
            this.conn.setDrdaID(drdaID);
        }
    }

    final void setPrepareIsolation(int level) throws SQLException {
        this.conn.setPrepareIsolation(level);
    }

    final int getPrepareIsolation() throws SQLException {
        return this.conn.getPrepareIsolation();
    }

    protected String buildRuntimeInfo(String indent, LocalizedResource localLangUtil) {
        String s = indent + localLangUtil.getTextMessage("DRDA_RuntimeInfoDatabase.I") + this.dbName + "\n" + localLangUtil.getTextMessage("DRDA_RuntimeInfoUser.I") + this.userId + "\n" + localLangUtil.getTextMessage("DRDA_RuntimeInfoNumStatements.I") + this.stmtTable.size() + "\n";
        s = s + localLangUtil.getTextMessage("DRDA_RuntimeInfoPreparedStatementHeader.I");
        Enumeration e = this.stmtTable.elements();
        while (e.hasMoreElements()) {
            s = s + ((DRDAStatement)e.nextElement()).toDebugString(indent + "\t") + "\n";
        }
        return s;
    }

    boolean supportsLocator() throws SQLException {
        if (!this.locatorSupportChecked) {
            ResultSet rs = this.getConnection().getMetaData().getProcedures(null, "SYSIBM", "BLOBTRUNCATE");
            this.locatorSupport = rs.next();
            rs.close();
            this.locatorSupportChecked = true;
        }
        return this.locatorSupport;
    }

    public void reset() {
        this.decryptedUserId = null;
        this.decryptedPassword = null;
        this.passwordSubstitute = null;
        this.secTokenIn = null;
        this.secTokenOut = null;
        this.userId = null;
        this.password = null;
        this.securityMechanism = 0;
        this.ncjBatchSize = 0;
        this.ncjCacheSize = 0;
        this.resetFlags();
    }

    void resetFlags() {
        this.rdbAllowUpdates = true;
        this.failover = false;
        this.disableStreaming = false;
        this.skipListeners = false;
        this.queryHDFS = false;
        this.skipConstraintChecks = false;
        this.syncCommits = false;
        this.disableTXBatching = false;
        this.skipLocks = false;
    }

    public PiggyBackedSessionData getPiggyBackedSessionData(boolean createOnDemand) throws SQLException {
        this.pbsd_ = PiggyBackedSessionData.getInstance(this.pbsd_, this.conn, createOnDemand);
        return this.pbsd_;
    }

    public void incClientConnectionsFailed() {
        if (this.connectionStats != null) {
            this.connectionStats.incClientConnectionsFailed();
        }
    }
}

