/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.jdbc;

import com.pivotal.gemfirexd.NetworkInterface;
import com.pivotal.gemfirexd.internal.engine.diag.SessionsVTI;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

public final class DRDAServerStarter
implements ModuleControl,
Runnable {
    private Object server;
    private Method runServerMethod;
    private Method serverShutdownMethod;
    private Thread serverThread;
    private static final String serverClassName = "com.pivotal.gemfirexd.internal.impl.drda.NetworkServerControlImpl";
    private Class<?> serverClass;
    private InetAddress listenAddress = null;
    private int portNumber = -1;
    private String userArg = null;
    private String passwordArg = null;
    private PrintWriter consoleWriter = null;

    public void setStartInfo(InetAddress listenAddress, int portNumber, String userName, String password, PrintWriter consoleWriter) {
        this.userArg = userName;
        this.passwordArg = password;
        this.setStartInfo(listenAddress, portNumber, consoleWriter);
    }

    public void setStartInfo(InetAddress listenAddress, int portNumber, PrintWriter consoleWriter) {
        this.listenAddress = listenAddress;
        this.portNumber = portNumber;
        this.consoleWriter = consoleWriter != null ? new PrintWriter((Writer)consoleWriter, true) : consoleWriter;
    }

    public void setStartInfo(String userName, String password) {
        this.userArg = userName;
        this.passwordArg = password;
    }

    private void findStartStopMethods(Class serverClass) throws SecurityException, NoSuchMethodException {
        this.runServerMethod = serverClass.getMethod("blockingStart", PrintWriter.class);
        this.serverShutdownMethod = serverClass.getMethod("shutdown", new Class[0]);
        this.initOtherPropertiesMethodHandle();
    }

    @Override
    public void boot(boolean create, Properties properties) {
        if (this.server != null) {
            SanityManager.THROWASSERT((String)"Network server starter module booted twice.");
            return;
        }
        try {
            this.serverClass = Class.forName(serverClassName);
        }
        catch (ClassNotFoundException cnfe) {
            Monitor.logTextMessage("J100", serverClassName);
            return;
        }
        catch (Error e) {
            Monitor.logTextMessage("J101", serverClassName, e.getMessage());
            return;
        }
        try {
            Constructor serverConstructor;
            try {
                serverConstructor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<?>>(){

                    @Override
                    public Constructor<?> run() throws NoSuchMethodException, SecurityException {
                        if (DRDAServerStarter.this.listenAddress == null) {
                            return DRDAServerStarter.this.serverClass.getConstructor(String.class, String.class);
                        }
                        return DRDAServerStarter.this.serverClass.getConstructor(InetAddress.class, Integer.TYPE, String.class, String.class);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception e1 = e.getException();
                Monitor.logTextMessage("J102", e1.getMessage());
                e.printStackTrace(Monitor.getStream().getPrintWriter());
                return;
            }
            this.findStartStopMethods(this.serverClass);
            this.server = this.listenAddress == null ? serverConstructor.newInstance(this.userArg, this.passwordArg) : serverConstructor.newInstance(this.listenAddress, this.portNumber, this.userArg, this.passwordArg);
            this.serverThread = Monitor.getMonitor().getDaemonThread(this, "NetworkServerStarter", false);
            this.serverThread.start();
        }
        catch (Exception e) {
            Monitor.logTextMessage("J102", e.getMessage());
            this.server = null;
            e.printStackTrace(Monitor.getStream().getPrintWriter());
        }
    }

    public void ping() {
        if (this.serverThread == null || !this.serverThread.isAlive()) {
            throw new IllegalStateException("Server thread not available");
        }
        this.invoke(NetworkServerControlProps.ping, null);
    }

    public void setConnectionListener(NetworkInterface.ConnectionListener connListener) {
        if (this.serverThread == null || !this.serverThread.isAlive()) {
            throw new IllegalStateException("Server thread not available");
        }
        this.invoke(NetworkServerControlProps.setConnectionListener, new Object[]{connListener});
    }

    public void collectStatisticsSamples() {
        if (this.serverThread == null || !this.serverThread.isAlive()) {
            return;
        }
        this.invoke(NetworkServerControlProps.collectStatisticsSamples, null);
    }

    public void getSessionInfo(SessionsVTI.SessionInfo info) {
        if (this.serverThread == null || !this.serverThread.isAlive()) {
            return;
        }
        this.invoke(NetworkServerControlProps.getSessionInfo, new Object[]{info});
    }

    @Override
    public void run() {
        try {
            this.runServerMethod.invoke(this.server, this.consoleWriter);
        }
        catch (InvocationTargetException ite) {
            Monitor.logTextMessage("J102", ite.getTargetException().getMessage());
            ite.printStackTrace(Monitor.getStream().getPrintWriter());
            this.server = null;
        }
        catch (Exception e) {
            Monitor.logTextMessage("J102", e.getMessage());
            this.server = null;
            e.printStackTrace(Monitor.getStream().getPrintWriter());
        }
    }

    @Override
    public void stop() {
        try {
            if (this.serverThread != null && this.serverThread.isAlive()) {
                this.serverShutdownMethod.invoke(this.server, (Object[])null);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        DRDAServerStarter.this.serverThread.interrupt();
                        return null;
                    }
                });
                this.serverThread = null;
            }
        }
        catch (InvocationTargetException ite) {
            Monitor.logTextMessage("J103", ite.getTargetException().getMessage());
            ite.printStackTrace(Monitor.getStream().getPrintWriter());
        }
        catch (Exception e) {
            Monitor.logTextMessage("J103", e.getMessage());
            e.printStackTrace(Monitor.getStream().getPrintWriter());
        }
        this.serverThread = null;
        this.server = null;
        this.serverClass = null;
        this.listenAddress = null;
        this.portNumber = -1;
        this.consoleWriter = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.listenAddress);
        sb.append(" [ ");
        sb.append(this.portNumber);
        sb.append(" ] ");
        sb.append(" user = ");
        sb.append(this.userArg);
        return sb.toString();
    }

    public Object invoke(NetworkServerControlProps method, Object[] args) {
        return method.invoke(this.server, args);
    }

    private void initOtherPropertiesMethodHandle() throws SecurityException, NoSuchMethodException {
        for (NetworkServerControlProps e : NetworkServerControlProps.values()) {
            e.initMethodHandle(this.serverClass);
        }
    }

    public static enum NetworkServerControlProps {
        ping{

            @Override
            public void initMethodHandle(Class<?> serverClass) throws SecurityException, NoSuchMethodException {
                this.methodHandle = serverClass.getMethod("ping", new Class[0]);
            }
        }
        ,
        traceBoolean{

            @Override
            public void initMethodHandle(Class<?> serverClass) throws SecurityException, NoSuchMethodException {
                this.methodHandle = serverClass.getMethod("trace", Boolean.TYPE);
            }
        }
        ,
        traceConnNumBoolean{

            @Override
            public void initMethodHandle(Class<?> serverClass) throws SecurityException, NoSuchMethodException {
                this.methodHandle = serverClass.getMethod("trace", Integer.TYPE, Boolean.TYPE);
            }
        }
        ,
        logConnections{

            @Override
            public void initMethodHandle(Class<?> serverClass) throws SecurityException, NoSuchMethodException {
                this.methodHandle = serverClass.getMethod("logConnections", Boolean.TYPE);
            }
        }
        ,
        sendSetTraceDirectory{

            @Override
            public void initMethodHandle(Class<?> serverClass) throws SecurityException, NoSuchMethodException {
                this.methodHandle = serverClass.getMethod("sendSetTraceDirectory", String.class);
            }
        }
        ,
        sysinfo{

            @Override
            public void initMethodHandle(Class<?> serverClass) throws SecurityException, NoSuchMethodException {
                this.methodHandle = serverClass.getMethod("sysinfo", new Class[0]);
            }
        }
        ,
        runtimeInfo{

            @Override
            public void initMethodHandle(Class<?> serverClass) throws SecurityException, NoSuchMethodException {
                this.methodHandle = serverClass.getMethod("runtimeInfo", new Class[0]);
            }
        }
        ,
        netSetMaxThreads{

            @Override
            public void initMethodHandle(Class<?> serverClass) throws SecurityException, NoSuchMethodException {
                this.methodHandle = serverClass.getMethod("netSetMaxThreads", Integer.TYPE);
            }
        }
        ,
        netSetTimeSlice{

            @Override
            public void initMethodHandle(Class<?> serverClass) throws SecurityException, NoSuchMethodException {
                this.methodHandle = serverClass.getMethod("netSetTimeSlice", Integer.TYPE);
            }
        }
        ,
        getHostAddressAndPort{

            @Override
            public void initMethodHandle(Class<?> serverClass) throws SecurityException, NoSuchMethodException {
                this.methodHandle = serverClass.getMethod("getHostAddressAndPort", int[].class);
            }
        }
        ,
        getCurrentProperties{

            @Override
            public void initMethodHandle(Class<?> serverClass) throws SecurityException, NoSuchMethodException {
                this.methodHandle = serverClass.getMethod("getCurrentProperties", new Class[0]);
            }
        }
        ,
        setConnectionListener{

            @Override
            public void initMethodHandle(Class<?> serverClass) throws SecurityException, NoSuchMethodException {
                this.methodHandle = serverClass.getMethod("setConnectionListener", NetworkInterface.ConnectionListener.class);
            }
        }
        ,
        collectStatisticsSamples{

            @Override
            void initMethodHandle(Class<?> serverClass) throws SecurityException, NoSuchMethodException {
                this.methodHandle = serverClass.getMethod("collectStatisticsSample", new Class[0]);
            }
        }
        ,
        getSessionInfo{

            @Override
            void initMethodHandle(Class<?> serverClass) throws SecurityException, NoSuchMethodException {
                this.methodHandle = serverClass.getMethod("getSessionInfo", SessionsVTI.SessionInfo.class);
            }
        };

        protected Method methodHandle = null;

        abstract void initMethodHandle(Class<?> var1) throws SecurityException, NoSuchMethodException;

        final Object invoke(Object server, Object[] args) {
            try {
                return this.methodHandle.invoke(server, args);
            }
            catch (IllegalAccessException ie) {
                throw new IllegalStateException(ie);
            }
            catch (InvocationTargetException ie) {
                throw new IllegalStateException(ie.getTargetException());
            }
        }
    }
}

