/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.db;

import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.ConnectionUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import java.sql.SQLException;

public class OnlineCompress {
    private OnlineCompress() {
    }

    public static void compressTable(String schemaName, String tableName, boolean purgeRows, boolean defragmentRows, boolean truncateEnd) throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        TransactionController tc = lcc.getTransactionExecute();
        try {
            DataDictionary data_dictionary = lcc.getDataDictionary();
            if (purgeRows) {
                OnlineCompress.purgeRows(schemaName, tableName, data_dictionary, tc);
            }
            if (defragmentRows) {
                OnlineCompress.defragmentRows(schemaName, tableName, data_dictionary, tc);
            }
            if (truncateEnd) {
                OnlineCompress.truncateEnd(schemaName, tableName, data_dictionary, tc);
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    /*
     * Exception decompiling
     */
    private static void defragmentRows(String schemaName, String tableName, DataDictionary data_dictionary, TransactionController tc) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void purgeRows(String schemaName, String tableName, DataDictionary data_dictionary, TransactionController tc) throws StandardException {
        SchemaDescriptor sd = data_dictionary.getSchemaDescriptor(schemaName, tc, true);
        TableDescriptor td = data_dictionary.getTableDescriptor(tableName, sd, tc);
        if (td == null) {
            throw StandardException.newException("42X05", schemaName + "." + tableName);
        }
        switch (td.getTableType()) {
            case 2: 
            case 5: {
                break;
            }
            default: {
                ConglomerateDescriptor[] conglom_descriptors = td.getConglomerateDescriptors();
                for (int cd_idx = 0; cd_idx < conglom_descriptors.length; ++cd_idx) {
                    ConglomerateDescriptor cd = conglom_descriptors[cd_idx];
                    tc.purgeConglomerate(cd.getConglomerateNumber());
                }
            }
        }
    }

    private static void truncateEnd(String schemaName, String tableName, DataDictionary data_dictionary, TransactionController tc) throws StandardException {
        SchemaDescriptor sd = data_dictionary.getSchemaDescriptor(schemaName, tc, true);
        TableDescriptor td = data_dictionary.getTableDescriptor(tableName, sd, tc);
        if (td == null) {
            throw StandardException.newException("42X05", schemaName + "." + tableName);
        }
        switch (td.getTableType()) {
            case 2: 
            case 5: {
                break;
            }
            default: {
                ConglomerateDescriptor[] conglom_descriptors = td.getConglomerateDescriptors();
                for (int cd_idx = 0; cd_idx < conglom_descriptors.length; ++cd_idx) {
                    ConglomerateDescriptor cd = conglom_descriptors[cd_idx];
                    tc.compressConglomerate(cd.getConglomerateNumber());
                }
            }
        }
    }

    private static void setup_indexes(TransactionController tc, TableDescriptor td, int[][] index_col_map, ScanController[] index_scan, ConglomerateController[] index_cc, DataValueDescriptor[][] index_row) throws StandardException {
        ConglomerateDescriptor[] conglom_descriptors = td.getConglomerateDescriptors();
        int index_idx = 0;
        for (int cd_idx = 0; cd_idx < conglom_descriptors.length; ++cd_idx) {
            ConglomerateDescriptor index_cd = conglom_descriptors[cd_idx];
            if (!index_cd.isIndex()) continue;
            index_scan[index_idx] = tc.openScan(index_cd.getConglomerateNumber(), true, 4, 7, 5, null, null, 0, null, null, 0, null);
            index_cc[index_idx] = tc.openConglomerate(index_cd.getConglomerateNumber(), true, 4, 7, 5);
            int[] baseColumnPositions = index_cd.getIndexDescriptor().baseColumnPositions();
            int[] zero_based_map = new int[baseColumnPositions.length];
            for (int i = 0; i < baseColumnPositions.length; ++i) {
                zero_based_map[i] = baseColumnPositions[i] - 1;
            }
            index_col_map[index_idx] = zero_based_map;
            index_row[index_idx] = new DataValueDescriptor[baseColumnPositions.length + 1];
            ++index_idx;
        }
    }

    private static void fixIndex(DataValueDescriptor[] base_row, DataValueDescriptor[] index_row, RowLocation old_row_loc, RowLocation new_row_loc, ConglomerateController index_cc, ScanController index_scan, int[] index_col_map) throws StandardException {
        SanityManager.ASSERT((index_col_map != null ? 1 : 0) != 0);
        SanityManager.ASSERT((index_row != null ? 1 : 0) != 0);
        SanityManager.ASSERT((index_col_map.length == index_row.length - 1 ? 1 : 0) != 0);
        for (int index = 0; index < index_col_map.length; ++index) {
            index_row[index] = base_row[index_col_map[index]];
        }
        index_row[index_row.length - 1] = old_row_loc;
        index_scan.reopenScan(index_row, 1, null, index_row, -1, null);
        if (index_scan.next()) {
            index_scan.delete();
        } else {
            SanityManager.THROWASSERT((String)("Did not find row to delete.base_row = " + RowUtil.toString(base_row) + "index_row = " + RowUtil.toString(index_row)));
        }
        index_row[index_row.length - 1] = new_row_loc;
        index_cc.insert(index_row);
    }
}

