/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.internal.shared.ClientSharedData;
import com.pivotal.gemfirexd.callbacks.TableMetaData;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.NonUpdatableRowsResultSet;
import com.pivotal.gemfirexd.internal.engine.store.ProjectionMetaData;
import com.pivotal.gemfirexd.internal.engine.store.ResultWasNull;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.io.NewByteArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.StreamStorable;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.HarmonySerialBlob;
import com.pivotal.gemfirexd.internal.iapi.types.HarmonySerialClob;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDecimal;
import com.pivotal.gemfirexd.internal.impl.jdbc.ReaderToAscii;
import com.pivotal.gemfirexd.internal.impl.jdbc.TransactionResourceImpl;
import com.pivotal.gemfirexd.internal.impl.jdbc.UTF8Reader;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.sql.GenericParameterValueSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class DVDStoreResultSet
extends NonUpdatableRowsResultSet
implements ResultSet,
ResultWasNull {
    protected DataValueDescriptor[] currentRowDVDs;
    private GenericParameterValueSet pvs;
    private final int numColumns;
    private final RowFormatter formatter;
    private final FormatableBitSet changedColumns;
    private TableMetaData metadata;
    private GregorianCalendar cal;
    private boolean nextCalledOnce = false;

    public DVDStoreResultSet(DataValueDescriptor[] row, int numColumns, RowFormatter rf, FormatableBitSet changedColumns, TableMetaData metadata) {
        this.metadata = metadata;
        this.formatter = rf;
        if (changedColumns != null) {
            this.changedColumns = changedColumns;
            this.numColumns = changedColumns.getNumBitsSet();
            this.currentRowDVDs = new DataValueDescriptor[this.numColumns];
            int index = 0;
            int pos = changedColumns.anySetBit();
            while (pos != -1) {
                this.currentRowDVDs[index++] = row[pos];
                pos = changedColumns.anySetBit(pos);
            }
        } else {
            this.changedColumns = null;
            this.currentRowDVDs = row;
            this.numColumns = numColumns;
        }
    }

    public DVDStoreResultSet(GenericParameterValueSet pvs, TableMetaData metadata) {
        this.pvs = pvs;
        this.metadata = metadata;
        this.formatter = null;
        this.changedColumns = null;
        this.numColumns = this.pvs.getParameterCount();
    }

    @Override
    public boolean next() throws SQLException {
        boolean prevVal = this.nextCalledOnce;
        if (prevVal) {
            this.currentRowDVDs = null;
        }
        this.nextCalledOnce = true;
        return !prevVal && this.currentRowDVDs != null;
    }

    @Override
    public void close() throws SQLException {
        this.currentRowDVDs = null;
        this.pvs = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.currentRowDVDs == null && this.pvs == null;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null) {
                    String result = dvd.getString();
                    this.wasNull = result == null;
                    return result;
                }
                this.wasNull = true;
                return null;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null) {
                    Object result = dvd.getObject();
                    this.wasNull = result == null;
                    return result;
                }
                this.wasNull = true;
                return null;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null && !dvd.isNull()) {
                    this.wasNull = false;
                    return dvd.getBoolean();
                }
                this.wasNull = true;
                return false;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null && !dvd.isNull()) {
                    this.wasNull = false;
                    return dvd.getByte();
                }
                this.wasNull = true;
                return 0;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null && !dvd.isNull()) {
                    this.wasNull = false;
                    return dvd.getShort();
                }
                this.wasNull = true;
                return 0;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null && !dvd.isNull()) {
                    this.wasNull = false;
                    return dvd.getInt();
                }
                this.wasNull = true;
                return 0;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null && !dvd.isNull()) {
                    this.wasNull = false;
                    return dvd.getLong();
                }
                this.wasNull = true;
                return 0L;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null && !dvd.isNull()) {
                    this.wasNull = false;
                    return dvd.getFloat();
                }
                this.wasNull = true;
                return 0.0f;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null && !dvd.isNull()) {
                    this.wasNull = false;
                    return dvd.getDouble();
                }
                this.wasNull = true;
                return 0.0;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal ret = this.getBigDecimal(columnIndex);
        if (ret != null) {
            return ret.setScale(scale, 5);
        }
        return null;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null && !dvd.isNull()) {
                    this.wasNull = false;
                    return dvd.getBytes();
                }
                this.wasNull = true;
                return null;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null && !dvd.isNull()) {
                    this.wasNull = false;
                    return dvd.getDate(this.getCal());
                }
                this.wasNull = true;
                return null;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null && !dvd.isNull()) {
                    this.wasNull = false;
                    return dvd.getTime(this.getCal());
                }
                this.wasNull = true;
                return null;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null && !dvd.isNull()) {
                    this.wasNull = false;
                    return dvd.getTimestamp(this.getCal());
                }
                this.wasNull = true;
                return null;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null && !dvd.isNull()) {
                    this.wasNull = false;
                    return SQLDecimal.getBigDecimal(dvd);
                }
                this.wasNull = true;
                return null;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null && !dvd.isNull()) {
                    this.wasNull = false;
                    if (cal == null) {
                        cal = this.getCal();
                    }
                    return dvd.getDate(cal);
                }
                this.wasNull = true;
                return null;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null && !dvd.isNull()) {
                    this.wasNull = false;
                    if (cal == null) {
                        cal = this.getCal();
                    }
                    return dvd.getTime(cal);
                }
                this.wasNull = true;
                return null;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null && !dvd.isNull()) {
                    this.wasNull = false;
                    if (cal == null) {
                        cal = this.getCal();
                    }
                    return dvd.getTimestamp(cal);
                }
                this.wasNull = true;
                return null;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            TableMetaData metadata = this.getMetaData();
            int colType = metadata.getColumnType(columnIndex);
            switch (colType) {
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 4002: {
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    return this.getBinaryStream(columnIndex);
                }
                default: {
                    throw this.dataConversionException(metadata.getColumnTypeName(columnIndex), "InputStream(ASCII)", columnIndex);
                }
            }
            Reader reader = this.getCharacterStream(columnIndex);
            if (reader != null) {
                return new ReaderToAscii(reader);
            }
            return null;
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw Util.notImplemented("getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            TableMetaData metadata = this.getMetaData();
            int columnType = metadata.getColumnType(columnIndex);
            switch (columnType) {
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    break;
                }
                default: {
                    throw this.dataConversionException(metadata.getColumnTypeName(columnIndex), "InputStream(BINARY)", columnIndex);
                }
            }
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null && !dvd.isNull()) {
                    this.wasNull = false;
                    StreamStorable ss = (StreamStorable)((Object)dvd);
                    InputStream stream = ss.returnStream();
                    if (stream != null) {
                        return stream;
                    }
                } else {
                    this.wasNull = true;
                    return null;
                }
                byte[] bytes = dvd.getBytes();
                if (bytes != null) {
                    return new NewByteArrayInputStream(bytes);
                }
                return null;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            TableMetaData metadata = this.getMetaData();
            int colType = metadata.getColumnType(columnIndex);
            switch (colType) {
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    InputStream is = this.getBinaryStream(columnIndex);
                    if (is != null) {
                        try {
                            return new InputStreamReader(is, "UTF-16BE");
                        }
                        catch (UnsupportedEncodingException uee) {
                            throw TransactionResourceImpl.wrapInSQLException(uee);
                        }
                    }
                    return null;
                }
                default: {
                    throw this.dataConversionException(metadata.getColumnTypeName(columnIndex), "Reader", columnIndex);
                }
            }
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null && !dvd.isNull()) {
                    this.wasNull = false;
                    StreamStorable ss = (StreamStorable)((Object)dvd);
                    InputStream is = ss.returnStream();
                    if (is != null) {
                        return new UTF8Reader(is, 0L, null, is);
                    }
                } else {
                    this.wasNull = true;
                    return null;
                }
                String str = dvd.getString();
                if (str != null) {
                    return new StringReader(str);
                }
                return null;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
            catch (IOException ioe) {
                throw TransactionResourceImpl.wrapInSQLException(ioe);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            TableMetaData metadata = this.getMetaData();
            if (metadata.getColumnType(columnIndex) != 2004) {
                throw this.dataConversionException(metadata.getColumnTypeName(columnIndex), "Blob", columnIndex);
            }
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null && !dvd.isNull()) {
                    this.wasNull = false;
                    return HarmonySerialBlob.wrapBytes(dvd.getBytes());
                }
                this.wasNull = true;
                return null;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.numColumns) {
            TableMetaData metadata = this.getMetaData();
            if (metadata.getColumnType(columnIndex) != 2005) {
                throw this.dataConversionException(metadata.getColumnTypeName(columnIndex), "Clob", columnIndex);
            }
            try {
                DataValueDescriptor dvd;
                if (this.currentRowDVDs != null) {
                    dvd = this.currentRowDVDs[columnIndex - 1];
                } else if (this.pvs != null) {
                    dvd = this.pvs.getParameter(columnIndex - 1);
                } else {
                    throw this.noCurrentRow();
                }
                if (dvd != null && !dvd.isNull()) {
                    this.wasNull = false;
                    return HarmonySerialClob.wrapChars(((SQLChar)dvd).getCharArray(true));
                }
                this.wasNull = true;
                return null;
            }
            catch (StandardException se) {
                throw Util.generateCsSQLException(se);
            }
        }
        throw this.invalidColumnException(columnIndex);
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.getMetaData().getColumnPosition(columnLabel);
    }

    @Override
    public TableMetaData getMetaData() throws SQLException {
        if (this.metadata != null) {
            return this.metadata;
        }
        if (this.formatter != null) {
            if (this.changedColumns == null) {
                this.metadata = this.formatter.getMetaData();
                return this.metadata;
            }
            int[] changedCols = new int[this.numColumns];
            int index = 0;
            int colPos = this.changedColumns.anySetBit();
            while (colPos != -1) {
                changedCols[index++] = colPos + 1;
                colPos = this.changedColumns.anySetBit(colPos);
            }
            this.metadata = new ProjectionMetaData(this.formatter.getMetaData(), changedCols);
            return this.metadata;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("DVDResultSet{");
        for (int i = 1; i <= this.numColumns; ++i) {
            try {
                sb.append(this.getObject(i)).append(',');
                continue;
            }
            catch (SQLException sqle) {
                throw GemFireXDRuntimeException.newRuntimeException(null, sqle);
            }
        }
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    private GregorianCalendar getCal() {
        GregorianCalendar cal = this.cal;
        if (cal != null) {
            cal.clear();
            return cal;
        }
        this.cal = ClientSharedData.getDefaultCleanCalendar();
        return this.cal;
    }
}

