/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.internal;

import com.pivotal.gemfirexd.internal.engine.jayway.jsonpath.spi.compiler.Path;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class Cache {
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<String, Path> map = new ConcurrentHashMap<String, Path>();
    private final Deque<String> queue = new LinkedList<String>();
    private final int limit;

    public Cache(int limit) {
        this.limit = limit;
    }

    public void put(String key, Path value) {
        Path oldValue = this.map.put(key, value);
        if (oldValue != null) {
            this.removeThenAddKey(key);
        } else {
            this.addKey(key);
        }
        if (this.map.size() > this.limit) {
            this.map.remove(this.removeLast());
        }
    }

    public Path get(String key) {
        this.removeThenAddKey(key);
        return this.map.get(key);
    }

    private void addKey(String key) {
        this.lock.lock();
        try {
            this.queue.addFirst(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    private String removeLast() {
        this.lock.lock();
        try {
            String removedKey;
            String string = removedKey = this.queue.removeLast();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removeThenAddKey(String key) {
        this.lock.lock();
        try {
            this.queue.removeFirstOccurrence(key);
            this.queue.addFirst(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void removeFirstOccurrence(String key) {
        this.lock.lock();
        try {
            this.queue.removeFirstOccurrence(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Path getSilent(String key) {
        return this.map.get(key);
    }

    public void remove(String key) {
        this.removeFirstOccurrence(key);
        this.map.remove(key);
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }
}

