/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.AbstractRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractConditionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ComparisonQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ConstantConditionsWrapperQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ParameterizedConditionsWrapperQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoConstants;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ValueQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.util.Set;

public class RangeQueryInfo
extends AbstractConditionQueryInfo {
    private DataValueDescriptor lowerBound;
    private int lowerBoundOperator;
    private DataValueDescriptor upperBound;
    private int upperBoundOperator;
    private final String columnName;
    private final Region region;
    private QueryInfo runTimePruner = null;

    RangeQueryInfo(DataValueDescriptor lowerBound, int lowerBndOp, DataValueDescriptor upperBound, int upperBndOp, String colName, Region region) {
        this.lowerBound = lowerBound;
        this.lowerBoundOperator = lowerBndOp;
        this.upperBound = upperBound;
        this.upperBoundOperator = upperBndOp;
        this.columnName = colName;
        this.region = region;
    }

    @Override
    AbstractConditionQueryInfo createOrAddToGroup(AbstractConditionQueryInfo operand, boolean createConstantConditionsWrapper, Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
        if (activation == null && operand.isWhereClauseDynamic()) {
            return new ParameterizedConditionsWrapperQueryInfo(operand, this);
        }
        return this.mergeInRangeQueryInfoIfPossible((ComparisonQueryInfo)operand, activation, createConstantConditionsWrapper);
    }

    private AbstractConditionQueryInfo mergeInRangeQueryInfoIfPossible(ComparisonQueryInfo cqi, Activation activation, boolean createConstantConditionsWrapper) throws StandardException {
        AbstractConditionQueryInfo retVal = null;
        int opType = cqi.getRelationalOperator();
        if (opType == 1 || opType == 2) {
            if (createConstantConditionsWrapper) {
                retVal = new ConstantConditionsWrapperQueryInfo(cqi, this);
            }
        } else {
            DataValueDescriptor const1 = ((ValueQueryInfo)cqi.rightOperand).evaluateToGetDataValueDescriptor(activation);
            boolean satisfiesLowerBound = RangeQueryInfo.isConditionSatisfied(const1, this.lowerBound, this.lowerBoundOperator);
            boolean satisfiesUpperBound = RangeQueryInfo.isConditionSatisfied(const1, this.upperBound, this.upperBoundOperator);
            switch (opType) {
                case 3: 
                case 4: {
                    if (satisfiesLowerBound && satisfiesUpperBound) {
                        this.lowerBound = const1;
                        this.lowerBoundOperator = opType;
                        retVal = this;
                        break;
                    }
                    if (satisfiesUpperBound) {
                        retVal = this;
                        break;
                    }
                    if (!createConstantConditionsWrapper) break;
                    retVal = new ConstantConditionsWrapperQueryInfo(cqi, this);
                    break;
                }
                case 5: 
                case 6: {
                    if (satisfiesLowerBound && satisfiesUpperBound) {
                        this.upperBound = const1;
                        this.upperBoundOperator = opType;
                        retVal = this;
                        break;
                    }
                    if (satisfiesLowerBound) {
                        retVal = this;
                        break;
                    }
                    if (!createConstantConditionsWrapper) break;
                    retVal = new ConstantConditionsWrapperQueryInfo(cqi, this);
                    break;
                }
                default: {
                    throw new IllegalStateException("This case of operator type = " + opType + " should not have arisen");
                }
            }
        }
        return retVal;
    }

    DataValueDescriptor getLowerBound() {
        return this.lowerBound;
    }

    int getLowerBoundOperator() {
        return this.lowerBoundOperator;
    }

    DataValueDescriptor getUpperBound() {
        return this.upperBound;
    }

    int getUpperBoundOperator() {
        return this.upperBoundOperator;
    }

    public String toString() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("lower bound = ");
        sbuff.append(this.lowerBound);
        sbuff.append("; lower bound operator = ");
        sbuff.append(this.lowerBoundOperator);
        sbuff.append(" ;upper bound = ");
        sbuff.append(this.upperBound);
        sbuff.append("; upper bound operator = ");
        sbuff.append(this.upperBoundOperator);
        return sbuff.toString();
    }

    @Override
    boolean isWhereClauseDynamic() {
        return false;
    }

    @Override
    QueryInfo getRuntimeNodesPruner(boolean forSingleHopPreparePhase) {
        if (this.runTimePruner == null) {
            this.runTimePruner = this.createRuntimeNodesPruner();
        }
        return this.runTimePruner;
    }

    private QueryInfo createRuntimeNodesPruner() {
        final LogWriter logger = Misc.getCacheLogWriter();
        QueryInfo pruner = null;
        if (this.region.getAttributes().getDataPolicy().withPartitioning()) {
            assert (this.region instanceof PartitionedRegion);
            PartitionedRegion pr = (PartitionedRegion)this.region;
            final GfxdPartitionResolver rslvr = GemFireXDUtils.getResolver((AbstractRegion)pr);
            String[] rslvrColNames = null;
            pruner = rslvr != null && (rslvrColNames = rslvr.getColumnNames()).length == 1 && rslvrColNames[0].equals(this.columnName) ? new AbstractQueryInfo(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void computeNodes(Set<Object> routingKeysToExecute, Activation activation, boolean forSingleHopPreparePhase) throws StandardException {
                    try {
                        Object[] routingObjects;
                        if (logger.fineEnabled()) {
                            logger.fine("RangeQueryInfo::computeNodes: Resolver =" + rslvr.toString());
                            logger.fine("RangeQueryInfo::computeNodes: lower =" + RangeQueryInfo.this.lowerBound + " boolean = " + (RangeQueryInfo.this.lowerBoundOperator == 4) + " Upper bound = " + RangeQueryInfo.this.upperBound + " boolean = " + (RangeQueryInfo.this.upperBoundOperator == 6) + " forSingleHopPreparePhase = " + forSingleHopPreparePhase);
                        }
                        if ((routingObjects = rslvr.getRoutingObjectsForRange(RangeQueryInfo.this.lowerBound, RangeQueryInfo.this.lowerBoundOperator == 4, RangeQueryInfo.this.upperBound, RangeQueryInfo.this.upperBoundOperator == 6)) != null) {
                            routingKeysToExecute.remove(ResolverUtils.TOK_ALL_NODES);
                            for (Object key : routingObjects) {
                                routingKeysToExecute.add(key);
                            }
                        }
                    }
                    finally {
                        if (logger.fineEnabled()) {
                            logger.fine("RangeQueryInfo::computeNodes: After prunning nodes size is" + routingKeysToExecute.size());
                            logger.fine("RangeQueryInfo::computeNodes: After prunning nodes are" + routingKeysToExecute);
                        }
                    }
                }
            } : QueryInfoConstants.NON_PRUNABLE;
        } else {
            pruner = QueryInfoConstants.NON_PRUNABLE;
        }
        return pruner;
    }
}

