/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.diag;

import com.gemstone.gemfire.internal.cache.ExternalTableMetaData;
import com.pivotal.gemfirexd.internal.catalog.ExternalCatalog;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplate;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplateNoAllNodesRoute;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTablesVTI
extends GfxdVTITemplate
implements GfxdVTITemplateNoAllNodesRoute {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private Iterator<ExternalTableMetaData> tableMetas;
    private ExternalTableMetaData currentTableMeta;
    private ListIterator<ExternalTableMetaData.Column> currentTableColumns;
    private ExternalTableMetaData.Column currentTableColumn;
    public static final String SCHEMA = "SCHEMANAME";
    public static final String TABLE = "TABLENAME";
    public static final String TYPE = "TABLETYPE";
    public static final String PROVIDER = "PROVIDER";
    public static final String COLUMN = "COLUMNNAME";
    public static final String TYPEID = "TYPEID";
    public static final String TYPENAME = "TYPENAME";
    public static final String ORDINAL = "ORDINAL";
    public static final String PRECISION = "PRECISION";
    public static final String SCALE = "SCALE";
    public static final String MAXWIDTH = "MAXWIDTH";
    public static final String NULLABLE = "NULLABLE";
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("SCHEMANAME", 12, false, 512), EmbedResultSetMetaData.getResultColumnDescriptor("TABLENAME", 12, false, 512), EmbedResultSetMetaData.getResultColumnDescriptor("TABLETYPE", 12, false, 64), EmbedResultSetMetaData.getResultColumnDescriptor("PROVIDER", 12, false, 8192), EmbedResultSetMetaData.getResultColumnDescriptor("COLUMNNAME", 12, false, 512), EmbedResultSetMetaData.getResultColumnDescriptor("TYPEID", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("TYPENAME", 12, false, 512), EmbedResultSetMetaData.getResultColumnDescriptor("ORDINAL", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("PRECISION", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("SCALE", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("MAXWIDTH", 4, false), EmbedResultSetMetaData.getResultColumnDescriptor("NULLABLE", 16, false)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return metadata;
    }

    @Override
    public boolean next() {
        if (this.tableMetas == null) {
            ExternalCatalog hiveCatalog = Misc.getMemStore().getExternalCatalog();
            if (hiveCatalog != null) {
                try {
                    this.tableMetas = hiveCatalog.getHiveTables(true).iterator();
                }
                catch (Exception e) {
                    this.logger.warn("ERROR in retrieving Hive tables: " + e.toString());
                    this.tableMetas = Collections.emptyIterator();
                }
            } else {
                this.tableMetas = Collections.emptyIterator();
            }
            this.currentTableColumns = Collections.emptyListIterator();
        }
        while (true) {
            if (this.currentTableColumns.hasNext()) {
                this.currentTableColumn = this.currentTableColumns.next();
                this.wasNull = false;
                return true;
            }
            if (!this.tableMetas.hasNext()) break;
            this.currentTableMeta = this.tableMetas.next();
            this.currentTableColumns = this.currentTableMeta.columns.listIterator();
        }
        this.currentTableMeta = null;
        this.currentTableColumn = null;
        return false;
    }

    @Override
    protected Object getObjectForColumn(int columnNumber) throws SQLException {
        switch (columnNumber) {
            case 1: {
                return this.currentTableMeta.schema;
            }
            case 2: {
                return this.currentTableMeta.entityName;
            }
            case 3: {
                return this.currentTableMeta.tableType;
            }
            case 4: {
                return this.currentTableMeta.provider;
            }
            case 5: {
                return this.currentTableColumn.name;
            }
            case 6: {
                return this.currentTableColumn.typeId;
            }
            case 7: {
                return this.currentTableColumn.typeName;
            }
            case 8: {
                return this.currentTableColumns.nextIndex();
            }
            case 9: {
                return this.currentTableColumn.precision;
            }
            case 10: {
                return this.currentTableColumn.scale;
            }
            case 11: {
                return this.currentTableColumn.maxWidth;
            }
            case 12: {
                return this.currentTableColumn.nullable;
            }
        }
        throw new GemFireXDRuntimeException("unexpected column=" + columnNumber + " for HiveTablesVTI");
    }
}

