/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.wan;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.cache.AbstractRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventErrorHandler;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.WrappedCallbackArgument;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.pivotal.gemfirexd.callbacks.AsyncEventHelper;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionByExpressionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.messages.GfxdCBArgForSynchPrms;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdCallbackArgument;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public final class GfxdBulkDMLCommand
extends BaseCommand {
    private static final AsyncEventHelper helper = AsyncEventHelper.newInstance();

    public static void dummy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processBulkDML(Part statementPart, Part callbackPart) {
        GfxdCBArgForSynchPrms stmtEvent = null;
        LanguageConnectionContext lcc = null;
        Statement stmt = null;
        try {
            int numRows;
            stmtEvent = (GfxdCBArgForSynchPrms)callbackPart.getObject();
            if (SanityManager.isFineEnabled) {
                SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("GfxdBulkDMLOp: CallbackPart = " + callbackPart + "; CallbackArg = " + stmtEvent));
            }
            String dmlString = stmtEvent.getDMLString();
            String schema = stmtEvent.getSchemaName();
            if (GemFireXDUtils.TraceDBSynchronizer) {
                SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("GfxdBulkDMLCommand::execute: Statement event obtained = " + stmtEvent));
            }
            EmbedConnection conn = GemFireXDUtils.getTSSConnection(false, false, false);
            lcc = conn.getLanguageConnectionContext();
            lcc.setGatewaySenderEventCallbackArg(stmtEvent);
            lcc.setPossibleDuplicate(stmtEvent.isPossibleDuplicate());
            conn.setTransactionIsolation(0);
            conn.setAutoCommit(false);
            conn.setDefaultSchema(schema);
            if (stmtEvent.hasParameters()) {
                EmbedPreparedStatement ps = (EmbedPreparedStatement)conn.prepareStatement(dmlString);
                stmt = ps;
                if (stmtEvent.isBulkInsert()) {
                    GemFireContainer container = stmtEvent.getContainer();
                    ArrayList<Object> bulkInsertRows = stmtEvent.getRawBulkInsertRows();
                    container.insertMultipleRows(bulkInsertRows, null, lcc, false, stmtEvent.isPutDML());
                    if (container.getRegion().isSerialWanEnabled()) {
                        ps.getActivation().distributeBulkOpToDBSynchronizer(container.getRegion(), true, (GemFireTransaction)lcc.getTransactionExecute(), lcc.isSkipListeners(), bulkInsertRows);
                    }
                    numRows = bulkInsertRows.size();
                } else if (helper.setParamsInBulkPreparedStatement(stmtEvent, stmtEvent.getType(), ps, null, null)) {
                    numRows = 0;
                    for (int n : ps.executeBatch()) {
                        numRows += n;
                    }
                } else {
                    numRows = ps.executeUpdate();
                }
            } else {
                stmt = conn.createStatement();
                numRows = stmt.executeUpdate(dmlString);
            }
            if (GemFireXDUtils.TraceDBSynchronizer) {
                SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("GfxdBulkDMLCommand::execute: Successfully executed. Num rows affected = " + numRows));
            }
        }
        catch (Throwable t) {
            Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(t);
            LogWriterI18n logger = Misc.getI18NLogWriter();
            if (logger != null && logger.warningEnabled()) {
                logger.warning(LocalizedStrings.Gfxd_GATEWAY_SYNCHRONIZER__1, (Object)stmtEvent, t);
            }
        }
        finally {
            block35: {
                block34: {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(t);
                            LogWriterI18n logger = Misc.getI18NLogWriter();
                            if (logger == null || !logger.warningEnabled()) break block34;
                            logger.warning(LocalizedStrings.Gfxd_GATEWAY_SYNCHRONIZER__1, (Object)stmtEvent, t);
                        }
                    }
                }
                if (lcc != null) {
                    lcc.setGatewaySenderEventCallbackArg(null);
                    lcc.setPossibleDuplicate(false);
                    TransactionController tc = lcc.getTransactionExecute();
                    if (tc != null) {
                        lcc.setSkipLocks(false);
                        lcc.setIsConnectionForRemote(false);
                        try {
                            if (!tc.isTransactional()) {
                                tc.releaseAllLocks(true, true);
                            }
                        }
                        catch (Throwable t) {
                            Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(t);
                            LogWriterI18n logger = Misc.getI18NLogWriter();
                            if (logger == null || !logger.warningEnabled()) break block35;
                            logger.warning(LocalizedStrings.Gfxd_GATEWAY_SYNCHRONIZER__1, (Object)stmtEvent, t);
                        }
                    }
                }
            }
        }
    }

    public void cmdExecute(Message msg, ServerConnection servConn, long start) {
    }

    public Object regenerateKeyConditionally(Object oldKey, LocalRegion region) {
        GemFireContainer gfc = (GemFireContainer)region.getUserAttribute();
        if (gfc.isPrimaryKeyBased()) {
            return oldKey;
        }
        return gfc.newUUIDForRegionKey();
    }

    public Object regenerateCallbackConditionally(Object key, Object oldCallbackArg, LocalRegion region) {
        GemFireContainer gfc = (GemFireContainer)region.getUserAttribute();
        GfxdPartitionResolver resolver = GemFireXDUtils.getResolver((AbstractRegion)region);
        boolean isPartitioningKeyThePrimaryKey = false;
        if (resolver != null) {
            isPartitioningKeyThePrimaryKey = resolver.isPartitioningKeyThePrimaryKey();
        }
        if (gfc.isPrimaryKeyBased() || !isPartitioningKeyThePrimaryKey) {
            return oldCallbackArg;
        }
        Object callbackArg = oldCallbackArg;
        WrappedCallbackArgument wca = null;
        while (callbackArg instanceof WrappedCallbackArgument) {
            wca = (WrappedCallbackArgument)callbackArg;
            callbackArg = wca.getOriginalCallbackArg();
        }
        if (callbackArg instanceof GfxdCallbackArgument) {
            GfxdCallbackArgument sca = (GfxdCallbackArgument)callbackArg;
            if (!sca.isFixedInstance()) {
                sca.setRoutingObject(GfxdPartitionByExpressionResolver.getGeneratedKeyRoutingObject(key));
            }
            return oldCallbackArg;
        }
        if (callbackArg instanceof Integer) {
            if (wca != null) {
                wca.setOriginalCallbackArgument((Object)GfxdPartitionByExpressionResolver.getGeneratedKeyRoutingObject(key));
                return oldCallbackArg;
            }
            return GfxdPartitionByExpressionResolver.getGeneratedKeyRoutingObject(key);
        }
        return oldCallbackArg;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beforeOperationCallback(LocalRegion rgn, int actionType) {
        EmbedConnection conn = null;
        boolean contextSet = false;
        if (GemFireXDUtils.TraceDBSynchronizer) {
            SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)"GfxdBulkDMLCommand::beforeOperationCallback:entering ..");
        }
        try {
            conn = GemFireXDUtils.getTSSConnection(false, false, false);
            conn.getTR().setupContextStack();
            contextSet = true;
            LanguageConnectionContext lcc = conn.getLanguageConnectionContext();
            GemFireTransaction tran = (GemFireTransaction)lcc.getTransactionExecute();
            GemFireContainer container = (GemFireContainer)rgn.getUserAttribute();
            container.open(tran, 8);
            AbstractGemFireResultSet.openOrCloseFKContainers(container, tran, false, false);
            GfxdIndexManager sqim = (GfxdIndexManager)rgn.getIndexUpdater();
            if (sqim == null) return;
            switch (actionType) {
                case 0: {
                    sqim.fireStatementTriggers(0, lcc, tran, null);
                    return;
                }
                case 1: {
                    sqim.fireStatementTriggers(2, lcc, tran, null);
                    return;
                }
                case 2: {
                    sqim.fireStatementTriggers(1, lcc, tran, null);
                    return;
                }
            }
            return;
        }
        catch (StandardException se) {
            throw new GemFireXDRuntimeException(se);
        }
        finally {
            if (contextSet) {
                conn.getTR().restoreContextStack();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void afterOperationCallback(LocalRegion rgn, int actionType) {
        EmbedConnection conn = null;
        GemFireTransaction tran = null;
        boolean contextSet = false;
        if (GemFireXDUtils.TraceDBSynchronizer) {
            SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)"GfxdBulkDMLCommand::afterOperationCallback:entering ..");
        }
        GemFireContainer container = (GemFireContainer)rgn.getUserAttribute();
        try {
            conn = GemFireXDUtils.getTSSConnection(false, false, false);
            conn.getTR().setupContextStack();
            contextSet = true;
            LanguageConnectionContext lcc = conn.getLanguageConnectionContext();
            tran = (GemFireTransaction)lcc.getTransactionExecute();
            GfxdIndexManager sqim = (GfxdIndexManager)rgn.getIndexUpdater();
            if (sqim != null) {
                switch (actionType) {
                    case 0: {
                        sqim.fireStatementTriggers(3, lcc, tran, null);
                        break;
                    }
                    case 1: {
                        sqim.fireStatementTriggers(5, lcc, tran, null);
                        break;
                    }
                    case 2: {
                        sqim.fireStatementTriggers(4, lcc, tran, null);
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (StandardException se) {
            try {
                throw new GemFireXDRuntimeException(se);
            }
            catch (Throwable throwable) {
                try {
                    if (tran != null) {
                        if (GemFireXDUtils.TraceDBSynchronizer) {
                            SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("GfxdBulkDMLCommand::afterOperationCallback:finally block. skip locks=" + tran.skipLocks()));
                        }
                        AbstractGemFireResultSet.openOrCloseFKContainers(container, tran, true, false);
                        container.closeForEndTransaction(tran, false);
                    }
                    if (!contextSet) throw throwable;
                    conn.getTR().restoreContextStack();
                    throw throwable;
                }
                catch (StandardException se2) {
                    SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("GfxdBulkDMLCommand::afterOperationCallback: exception in finally block: " + se2), (Throwable)se2);
                }
                throw throwable;
            }
        }
        try {
            if (tran != null) {
                if (GemFireXDUtils.TraceDBSynchronizer) {
                    SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("GfxdBulkDMLCommand::afterOperationCallback:finally block. skip locks=" + tran.skipLocks()));
                }
                AbstractGemFireResultSet.openOrCloseFKContainers(container, tran, true, false);
                container.closeForEndTransaction(tran, false);
            }
            if (!contextSet) return;
            conn.getTR().restoreContextStack();
            return;
        }
        catch (StandardException se) {
            SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)("GfxdBulkDMLCommand::afterOperationCallback: exception in finally block: " + se), (Throwable)se);
            return;
        }
    }

    public void processRuntimeException(RuntimeException e, String servConnName, String regionName, Object key, Object valuePart, Object callbackArg, EntryEventImpl eventForErrorLog) {
        Throwable cause = e.getCause();
        boolean logWarning = false;
        if (cause != null) {
            if (cause instanceof StandardException) {
                if (((StandardException)cause).getSQLState().startsWith("23")) {
                    logWarning = true;
                }
            } else if (cause instanceof SQLException && ((SQLException)cause).getSQLState().startsWith("23")) {
                logWarning = true;
            }
        }
        if (logWarning) {
            LogWriterI18n logger = Misc.getI18NLogWriter();
            EventErrorHandler handler = GemFireCacheImpl.getExisting().getEventErrorHandler();
            if (handler != null) {
                handler.onError((EntryEvent)eventForErrorLog, (Exception)e);
            }
            if (logger != null && logger.warningEnabled()) {
                logger.warning(LocalizedStrings.Gfxd_GATEWAY_SYNCHRONIZER__1, (Object)String.format("{ServerConnection=%s, table=%s, key=%s, valuePart=%s, callbackArg=%s}", servConnName, Misc.getFullTableNameFromRegionPath(regionName), String.valueOf(key), String.valueOf(valuePart), String.valueOf(callbackArg)), (Throwable)e);
            }
        } else {
            if (GemFireXDUtils.TraceDBSynchronizer) {
                SanityManager.DEBUG_PRINT((String)"TraceDBSynchronizer", (String)String.format("Exception in processing gateway event {ServerConnection=%s, table=%s, key=%s, valuePart=%s, callbackArg=%s}", servConnName, Misc.getFullTableNameFromRegionPath(regionName), String.valueOf(key), String.valueOf(valuePart), String.valueOf(callbackArg)), (Throwable)e);
            }
            throw e;
        }
    }
}

