/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.resolver;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.EntryOperation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.cache.BucketAdvisor;
import com.gemstone.gemfire.internal.cache.CacheMap;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EntryOperationImpl;
import com.gemstone.gemfire.internal.cache.InternalPartitionResolver;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.WrappedCallbackArgument;
import com.gemstone.gemfire.internal.cache.partitioned.RegionAdvisor;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GlobalRowLocation;
import com.pivotal.gemfirexd.internal.engine.distributed.FunctionExecutionException;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdCallbackArgument;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdSingleResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.sql.execute.FunctionUtils;
import com.pivotal.gemfirexd.internal.engine.store.CompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.shared.common.SingleHopInformation;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public abstract class GfxdPartitionResolver
implements InternalPartitionResolver<Object, Object>,
Cloneable {
    protected String tableName;
    protected String schemaName;
    protected String masterTable;
    protected GemFireContainer gfContainer;
    protected int numBuckets;
    protected GfxdPartitionResolver masterResolver;
    protected String[] partitionColumnNames;
    protected volatile GemFireContainer globalIndexContainer;
    protected boolean isPrimaryKeyPartitioningKey;
    protected final LogWriterI18n gflogger = GemFireStore.getBootedInstance() != null ? Misc.getI18NLogWriter() : null;

    protected GfxdPartitionResolver() {
    }

    public final void init(Properties props) {
        throw new AssertionError((Object)"GfxdPartitionResolver#init: not expected to be invoked");
    }

    public abstract void bindExpression(FromList var1, SubqueryList var2, Vector<?> var3) throws StandardException;

    public void close() {
    }

    public abstract Object getRoutingObject(Object var1, Object var2, Region<?, ?> var3);

    public final Object getRoutingObject(Object key, Object val, Object callbackArg, Region<?, ?> region) {
        if (callbackArg != null) {
            GfxdCallbackArgument ca;
            if (callbackArg instanceof WrappedCallbackArgument) {
                callbackArg = ((WrappedCallbackArgument)callbackArg).getOriginalCallbackArg();
            }
            if (callbackArg instanceof GfxdCallbackArgument && (ca = (GfxdCallbackArgument)callbackArg).isRoutingObjectSet()) {
                return ca.getRoutingObject();
            }
        }
        return this.getRoutingObject(key, val, region);
    }

    protected abstract boolean isPartitioningSubsetOfKey();

    public Serializable getRoutingObject(EntryOperation<Object, Object> opDetails) {
        GfxdCallbackArgument sca = null;
        Object callbackArg = opDetails.getCallbackArgument();
        boolean finerEnabled = this.gflogger.fineEnabled();
        if (finerEnabled) {
            this.gflogger.finer(this.getClass().getName() + ".getRoutingObject: callback arg=" + callbackArg + "; operation=" + opDetails);
        }
        if (callbackArg != null) {
            if (callbackArg instanceof GfxdCallbackArgument) {
                sca = (GfxdCallbackArgument)callbackArg;
                if (sca.isRoutingObjectSet()) {
                    return sca.getRoutingObject();
                }
            } else {
                return (Serializable)callbackArg;
            }
        }
        boolean isEntryEventImpl = opDetails instanceof EntryEventImpl;
        EntryEventImpl eeImpl = null;
        EntryOperationImpl deOp = null;
        if (!isEntryEventImpl) {
            deOp = (EntryOperationImpl)opDetails;
        } else {
            eeImpl = (EntryEventImpl)opDetails;
        }
        Object val = null;
        if (!this.isPartitioningSubsetOfKey()) {
            val = isEntryEventImpl ? eeImpl.getRawNewValue() : deOp.getNewValue();
        }
        Object key = opDetails.getKey();
        Object routingObject = this.getRoutingObject(key, val, opDetails.getRegion());
        GfxdPartitionResolver.setRoutingObjectInCallbackArg(routingObject, key, eeImpl, deOp, isEntryEventImpl, sca);
        if (finerEnabled) {
            this.gflogger.finer(this.getClass().getName() + " routingObject returned is " + routingObject);
        }
        return (Serializable)routingObject;
    }

    public abstract Object getRoutingKeyForColumn(DataValueDescriptor var1);

    public abstract Object[] getRoutingObjectsForRange(DataValueDescriptor var1, boolean var2, DataValueDescriptor var3, boolean var4);

    public Object getRoutingObjectForExpression(DataValueDescriptor expressionValue) {
        throw new UnsupportedOperationException("GfxdPartitionResolver::getRoutingObjectForExpression: should not have been invoked");
    }

    public String getCanonicalizedExpression() {
        return null;
    }

    public abstract String getDDLString();

    public abstract Serializable getRoutingObjectFromDvdArray(DataValueDescriptor[] var1);

    public abstract Object[] getRoutingObjectsForList(DataValueDescriptor[] var1);

    public abstract Object getRoutingObjectsForPartitioningColumns(DataValueDescriptor[] var1);

    public abstract String[] getColumnNames();

    public final String getTableName() {
        return this.tableName;
    }

    public final String getSchemaName() {
        return this.schemaName;
    }

    protected final String getQualifiedTableName() {
        return this.schemaName + '.' + this.tableName;
    }

    public final void setTableDetails(TableDescriptor td, GemFireContainer container) {
        this.schemaName = td.getSchemaName();
        this.tableName = td.getName();
        this.gfContainer = container != null ? container : (GemFireContainer)Misc.getRegionForTableByPath(Misc.getFullTableName(td, null), true).getUserAttribute();
        this.numBuckets = this.gfContainer.getRegionAttributes().getPartitionAttributes().getTotalNumBuckets();
    }

    public abstract void setColumnInfo(TableDescriptor var1, Activation var2) throws StandardException;

    public final void setMasterTable(String masterTable) {
        this.masterTable = masterTable;
        if (this.masterTable != null) {
            Region masterRegion = Misc.getRegionByPath(this.masterTable, true);
            this.masterResolver = (GfxdPartitionResolver)masterRegion.getAttributes().getPartitionAttributes().getPartitionResolver();
        }
    }

    public final String getMasterTable(boolean rootMaster) {
        if (this.masterTable == null) {
            this.masterTable = Misc.getRegionPath(this.schemaName, this.tableName, null);
            return this.masterTable;
        }
        if (rootMaster) {
            return this.masterResolver != null ? this.masterResolver.getMasterTable(rootMaster) : this.masterTable;
        }
        return this.masterTable;
    }

    public abstract GfxdPartitionResolver cloneObject();

    public final GfxdPartitionResolver cloneForColocation(String[] newPartitioningColumns, String[] refPartitioningColumns, String masterTable) {
        GfxdPartitionResolver resolver = this.cloneObject();
        resolver.setPartitionColumns(newPartitioningColumns, refPartitioningColumns);
        resolver.setMasterTable(masterTable);
        return resolver;
    }

    public abstract boolean okForColocation(GfxdPartitionResolver var1);

    protected abstract void setPartitionColumns(String[] var1, String[] var2);

    public abstract boolean isUsedInPartitioning(String var1);

    public abstract int getPartitioningColumnIndex(String var1);

    public void updateDistributionDescriptor(DistributionDescriptor desc) {
    }

    public int getPartitioningColumnsCount() {
        return 1;
    }

    public final boolean isPartitioningKeyThePrimaryKey() {
        return this.isPrimaryKeyPartitioningKey;
    }

    public GemFireContainer getGlobalIndexContainer() {
        return this.globalIndexContainer;
    }

    public abstract boolean requiresGlobalIndex();

    public boolean requiresConnectionContext() {
        return false;
    }

    public abstract void setResolverInfoInSingleHopInfoObject(SingleHopInformation var1) throws StandardException;

    public static GemFireContainer getContainerOfGlobalIndex(TableDescriptor td, Map<String, Integer> pkMap) {
        ConglomerateDescriptorList cdl = td.getConglomerateDescriptorList();
        Iterator itr = cdl.iterator();
        GemFireContainer globalIndexContainer = null;
        LogWriterI18n logger = Misc.getI18NLogWriter();
        block0: while (itr.hasNext()) {
            int[] baseColPos;
            IndexRowGenerator id;
            ConglomerateDescriptor cd = (ConglomerateDescriptor)itr.next();
            if (!cd.isIndex() && !cd.isConstraint() || !(id = cd.getIndexDescriptor()).indexType().equals("GLOBALHASH") || (baseColPos = id.baseColumnPositions()).length != pkMap.size()) continue;
            int cnt = 0;
            for (int colPos : baseColPos) {
                ++cnt;
                boolean found = false;
                for (Integer idx : pkMap.values()) {
                    if (idx != colPos) continue;
                    found = true;
                    break;
                }
                if (!found) continue block0;
                if (cnt != baseColPos.length) continue;
                globalIndexContainer = Misc.getMemStore().getContainer(ContainerKey.valueOf(0L, cd.getConglomerateNumber()));
                if (!logger.fineEnabled()) continue;
                logger.fine("conglomerate name = " + cd.getConglomerateName() + " and conglomeratedescriptor name = " + cd.getDescriptorName());
            }
        }
        return globalIndexContainer;
    }

    protected void setGlobalIndexCaching(GemFireContainer globalIndexContainer) throws StandardException {
        GemFireContainer basecontainer = globalIndexContainer.getBaseContainer();
        basecontainer.setGlobalIndexCaching();
    }

    protected void updateGlobalIndexCache(RegionKey gfKey, Object routingObject) {
        if (this.globalIndexContainer.getBaseContainer().getGlobalIndexCache() != null) {
            RegionKey globalIndexKey;
            int size = gfKey.nCols();
            if (size == 1) {
                globalIndexKey = gfKey.getKeyColumn(0);
            } else {
                DataValueDescriptor[] dvds = new DataValueDescriptor[size];
                gfKey.getKeyColumns(dvds);
                globalIndexKey = new CompositeRegionKey(dvds);
            }
            this.globalIndexContainer.getBaseContainer().updateCache(globalIndexKey, routingObject);
            GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
            if (observer != null) {
                observer.afterPuttingInCached(globalIndexKey, routingObject);
            }
        }
    }

    protected static Object getRoutingObjectFromGlobalIndex(GemFireContainer globalIndexContainer, RegionKey gfKey) {
        RegionKey globalIndexKey;
        LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
        if (lcc == null) {
            Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(null);
        }
        GemFireContainer baseContainer = globalIndexContainer.getBaseContainer();
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        boolean possibleDuplicate = lcc != null ? lcc.isPossibleDuplicate() : false;
        Object result = null;
        PartitionedRegion globalIndxRgn = (PartitionedRegion)globalIndexContainer.getRegion();
        int size = gfKey.nCols();
        if (size == 1) {
            globalIndexKey = gfKey.getKeyColumn(0);
        } else {
            DataValueDescriptor[] dvds = new DataValueDescriptor[size];
            gfKey.getKeyColumns(dvds);
            globalIndexKey = new CompositeRegionKey(dvds);
        }
        CacheMap globalIndexCache = null;
        try {
            if (observer != null) {
                observer.beforeGlobalIndexLookup(lcc, globalIndxRgn, globalIndexKey);
            }
            if (baseContainer.cachesGlobalIndex()) {
                globalIndexCache = baseContainer.getGlobalIndexCache();
                Object cachedVal = globalIndexCache.get((Object)globalIndexKey);
                if (observer != null) {
                    observer.beforeReturningCachedVal(globalIndexKey, cachedVal);
                }
                if (cachedVal != null) {
                    return cachedVal;
                }
            }
            Integer globalIndexRoutingObject = PartitionedRegionHelper.getHashKey((PartitionedRegion)globalIndxRgn, (Object)globalIndexKey);
            GfxdSingleResultCollector rc = new GfxdSingleResultCollector();
            result = FunctionUtils.executeFunctionOnRegionWithArgs(globalIndxRgn, globalIndexKey, globalIndxRgn.includeHDFSResults() ? "hdfs-GlobalIndexLookupFunction" : "gfxd-GlobalIndexLookupFunction", rc, false, possibleDuplicate, true, null, Collections.singleton(globalIndexRoutingObject));
        }
        catch (StandardException ex) {
            throw GemFireXDRuntimeException.newRuntimeException("Exception while looking up global index", ex);
        }
        if (observer != null) {
            observer.afterGlobalIndexLookup(lcc, globalIndxRgn, globalIndexKey, result);
        }
        if (result == null) {
            throw new EntryNotFoundException("No global index entry for: " + globalIndexKey);
        }
        if (globalIndexCache != null) {
            globalIndexCache.put((Object)globalIndexKey, result);
            if (observer != null) {
                observer.afterPuttingInCached(globalIndexKey, result);
            }
        }
        return result;
    }

    protected static int getIndexInPrimaryKey(Map<String, Integer> pkMap, int partitioningColIdxInPKey) {
        int[] pseudoPKIndexes = new int[pkMap.size()];
        int index = 0;
        for (Integer idx : pkMap.values()) {
            pseudoPKIndexes[index++] = idx;
        }
        Arrays.sort(pseudoPKIndexes);
        int ret = -1;
        for (index = 0; index < pseudoPKIndexes.length; ++index) {
            if (partitioningColIdxInPKey != pseudoPKIndexes[index]) continue;
            ret = index;
            break;
        }
        return ret;
    }

    protected static List<Integer> getIndexesInPrimaryKey(Map<String, Integer> pkMap, String[] partitionColumnNames) {
        TreeMap pkIndexes = new TreeMap();
        for (Integer n : pkMap.values()) {
            pkIndexes.put(n, null);
        }
        int index = 0;
        for (Map.Entry entry : pkIndexes.entrySet()) {
            entry.setValue(index++);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(partitionColumnNames.length);
        for (String colName : partitionColumnNames) {
            Integer idx = pkMap.get(colName);
            if (idx == null) {
                throw new AssertionError((Object)("Expected to find index for column name " + colName));
            }
            Integer pkIdx = (Integer)pkIndexes.get(idx);
            assert (pkIdx != null) : "Expected to find index for column index " + idx;
            arrayList.add(pkIdx);
        }
        return arrayList;
    }

    protected static boolean checkIfArrayContainsSameStrings(String[] arr1, String[] arr2) {
        if (arr1 == null && arr2 == null) {
            return true;
        }
        if (arr1 == null || arr2 == null) {
            return false;
        }
        if (arr1.length != arr2.length) {
            return false;
        }
        for (int i = 0; i < arr1.length; ++i) {
            boolean found = false;
            String tmpStrFromDD = arr1[i];
            for (int j = 0; j < arr2.length; ++j) {
                if (!arr2[j].equalsIgnoreCase(tmpStrFromDD)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    protected static boolean checkIfArray1SubsetOfArray2(String[] arr1, String[] arr2) {
        if (arr1 == null && arr2 == null) {
            return true;
        }
        if (arr1 == null || arr2 == null) {
            return false;
        }
        if (arr1.length > arr2.length) {
            return false;
        }
        for (int i = 0; i < arr1.length; ++i) {
            boolean found = false;
            String tmpStrFromDD = arr1[i];
            for (int j = 0; j < arr2.length; ++j) {
                if (!arr2[j].equalsIgnoreCase(tmpStrFromDD)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    protected static void setRoutingObjectInCallbackArg(Object routingObject, Object key, EntryEventImpl eeImpl, EntryOperationImpl deOp, boolean isEntryEventImpl, GfxdCallbackArgument sca) {
        if (routingObject == null) {
            throw new InternalGemFireError("routing object should have been determined by now for key: " + key);
        }
        if (sca != null) {
            if (sca.isFixedInstance()) {
                sca = GemFireXDUtils.wrapCallbackArgs(routingObject, null, false, true, sca.isCacheLoaded(), true, false, false, false);
                if (isEntryEventImpl) {
                    eeImpl.setCallbackArgument((Object)sca);
                } else {
                    deOp.setCallbackArgument((Object)sca);
                }
            } else {
                sca.setRoutingObject((Integer)routingObject);
            }
        } else if (isEntryEventImpl) {
            eeImpl.setCallbackArgument(routingObject);
        } else {
            deOp.setCallbackArgument(routingObject);
        }
    }

    protected static DataValueDescriptor getDVDFromConstantNode(ConstantNode node, ColumnReference colRef) throws StandardException {
        if (node == null) {
            return null;
        }
        DataValueDescriptor val = node.getValue();
        if (val == null || val.isNull()) {
            return null;
        }
        DataTypeDescriptor dtd = colRef.getTypeServices();
        if (val.getTypeFormatId() != dtd.getDVDTypeFormatId()) {
            DataValueDescriptor dvd = dtd.getNull();
            dvd.setValue(val);
            return dvd;
        }
        return val;
    }

    protected boolean isValidTypeForSingleHop(int[] typeFormatId, SingleHopInformation sinfo) throws StandardException {
        assert (sinfo != null);
        boolean allSupportedTypes = this.checkIfAllTypesSupported(typeFormatId);
        if (allSupportedTypes) {
            Map<InternalDistributedMember, String> mbrToServerMap = GemFireXDUtils.getGfxdAdvisor().getAllNetServersWithMembers();
            PartitionedRegion region = (PartitionedRegion)this.gfContainer.getRegion();
            int numBuckets = this.numBuckets;
            int redundancy = region.getPartitionAttributes().getRedundantCopies();
            RegionAdvisor rAdvisor = region.getRegionAdvisor();
            ArrayList<SingleHopInformation.BucketAndNetServerInfo> bansiList = new ArrayList<SingleHopInformation.BucketAndNetServerInfo>();
            for (int bid = 0; bid < numBuckets; ++bid) {
                BucketAdvisor ba = rAdvisor.getBucketAdvisor(bid);
                InternalDistributedMember pmbr = ba.getPrimary();
                Set bOwners = ba.getProxyBucketRegion().getBucketOwners();
                bOwners.remove(pmbr);
                String primaryServer = mbrToServerMap.get(pmbr);
                if (primaryServer == null) {
                    if (SanityManager.TraceSingleHop) {
                        SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("GfxdPartitionResolver::isValidTypeForSingleHop server location of primary bucket server corresponding to bucketId=" + bid + " for table=" + this.tableName + " not available"));
                    }
                    primaryServer = "";
                }
                String[] secondaryServers = null;
                secondaryServers = new String[redundancy];
                for (int i = 0; i < redundancy; ++i) {
                    secondaryServers[i] = "";
                }
                int idx = 0;
                for (InternalDistributedMember mbr : bOwners) {
                    String secServer = mbrToServerMap.get(mbr);
                    if (secServer == null) {
                        secServer = "";
                    }
                    secondaryServers[idx] = secServer;
                    ++idx;
                }
                SingleHopInformation.BucketAndNetServerInfo bansi = new SingleHopInformation.BucketAndNetServerInfo(Integer.valueOf(bid), primaryServer, secondaryServers);
                bansiList.add(bansi);
            }
            sinfo.setBucketAndNetworkServerInfoList(bansiList);
            sinfo.setTotalNumberOfBuckets(region.getTotalNumberOfBuckets());
            region.getTotalNumberOfBuckets();
            return true;
        }
        return false;
    }

    private boolean checkIfAllTypesSupported(int[] typeFormatId) {
        assert (typeFormatId != null);
        boolean allSupported = true;
        for (int i = 0; i < typeFormatId.length; ++i) {
            if (SingleHopInformation.isSupportedTypeForSingleHop((int)typeFormatId[i])) continue;
            allSupported = false;
            break;
        }
        return allSupported;
    }

    public static final class HdfsGlobalIndexLookupFunction
    extends GlobalIndexLookupFunction {
        private static final String ID = "hdfs-GlobalIndexLookupFunction";

        @Override
        public void execute(FunctionContext context) {
            this.isQueryHdfs = true;
            super.execute(context);
        }

        @Override
        public boolean optimizeForWrite() {
            return true;
        }

        @Override
        public String getId() {
            return ID;
        }
    }

    public static class GlobalIndexLookupFunction
    implements Function,
    Declarable {
        private static final String ID = "gfxd-GlobalIndexLookupFunction";
        protected transient boolean isQueryHdfs = false;

        public final void init(Properties props) {
        }

        public void execute(FunctionContext context) {
            assert (context instanceof RegionFunctionContext);
            RegionFunctionContext prContext = (RegionFunctionContext)context;
            PartitionedRegion region = (PartitionedRegion)prContext.getDataSet();
            Object indexKey = prContext.getArguments();
            Serializable routingObject = null;
            try {
                int bucketId = PartitionedRegionHelper.getHashKey((PartitionedRegion)region, (Object)indexKey);
                Object obj = region.getDataView().getLocally(indexKey, null, bucketId, (LocalRegion)region, false, true, null, null, false, region.includeHDFSResults() || this.isQueryHdfs);
                if (obj != null && !Token.isInvalid((Object)obj)) {
                    routingObject = ((GlobalRowLocation)obj).getRoutingObject();
                }
            }
            catch (Exception ex) {
                throw new FunctionExecutionException(ex);
            }
            context.getResultSender().lastResult(routingObject);
        }

        public String getId() {
            return ID;
        }

        public final boolean hasResult() {
            return true;
        }

        public boolean optimizeForWrite() {
            return false;
        }

        public final boolean isHA() {
            return true;
        }
    }
}

