/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.gemstone.gemfire.internal.concurrent.ConcurrentSkipListMap;
import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.operations.SortedMap2IndexDeleteOperation;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.ExtractingIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;

public class SortedMap2IndexRefreshIndexKeyOperation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doMe(GemFireTransaction tran, GemFireContainer container, ExtractingIndexKey indexKey, RowLocation modifiedRow, Object oldValue, boolean isLoadedFromHDFS, boolean isSuccess) throws StandardException {
        ConcurrentSkipListMap<Object, Object> skipListMap = container.getSkipListMap();
        modifiedRow.markDeleteFromIndexInProgress();
        try {
            boolean bl;
            oldValue = SortedMap2IndexDeleteOperation.getRowByteSource(oldValue);
            Object newValue = SortedMap2IndexDeleteOperation.getRowLocationByteSource(modifiedRow);
            try {
                Object replacementValue;
                Object valueBeingReplaced;
                if (isSuccess) {
                    valueBeingReplaced = oldValue;
                    replacementValue = newValue;
                } else {
                    valueBeingReplaced = newValue;
                    replacementValue = oldValue;
                }
                bl = SortedMap2IndexRefreshIndexKeyOperation.basicRefreshIndexKey(indexKey, modifiedRow, valueBeingReplaced, replacementValue, isLoadedFromHDFS, skipListMap, isSuccess);
            }
            catch (Throwable throwable) {
                OffHeapHelper.release((Object)newValue);
                throw throwable;
            }
            OffHeapHelper.release((Object)newValue);
            return bl;
        }
        finally {
            modifiedRow.unmarkDeleteFromIndexInProgress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean basicRefreshIndexKey(ExtractingIndexKey indexKey, RowLocation modifiedRow, Object valueBeingReplaced, Object replacementValue, boolean isLoadedFromHDFS, ConcurrentSkipListMap<Object, Object> skipListMap, boolean isSuccess) {
        if (skipListMap.containsKey((Object)indexKey)) {
            CompactCompositeIndexKey ccik = indexKey.getFoundKey();
            Object vbs = ccik.getValueByteSource();
            try {
                if (valueBeingReplaced != null && SortedMap2IndexRefreshIndexKeyOperation.bytesSameAsCCIKBytes(valueBeingReplaced, vbs) || valueBeingReplaced == null) {
                    if (replacementValue != null && valueBeingReplaced != null) {
                        ccik.update(replacementValue, valueBeingReplaced);
                    } else if (replacementValue != null) {
                        ccik.setValueBytes(replacementValue);
                    }
                }
            }
            finally {
                ccik.releaseValueByteSource(vbs);
            }
            return true;
        }
        if (valueBeingReplaced instanceof SimpleMemoryAllocatorImpl.Chunk && !isLoadedFromHDFS && isSuccess) {
            ((SimpleMemoryAllocatorImpl.Chunk)valueBeingReplaced).retain();
            SanityManager.DEBUG_PRINT((String)"Refresh Index key failed", (String)("Refresh of index key for unmodified index failed. Retaining the value bytes = " + valueBeingReplaced + "; This will produce an orphan"));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean forceSnapShotIndexKey(GemFireContainer container, ExtractingIndexKey indexKey, RowLocation rowLocation, Object deletedBytes) throws StandardException {
        ConcurrentSkipListMap<Object, Object> skipListMap = container.getSkipListMap();
        if (skipListMap.containsKey((Object)indexKey)) {
            rowLocation.markDeleteFromIndexInProgress();
            CompactCompositeIndexKey ccik = indexKey.getFoundKey();
            Object indexBytes = ccik.getValueByteSource();
            try {
                if (deletedBytes != null && SortedMap2IndexRefreshIndexKeyOperation.bytesSameAsCCIKBytes(deletedBytes, indexBytes)) {
                    ccik.snapshotKeyFromValue();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                ccik.releaseValueByteSource(indexBytes);
                rowLocation.unmarkDeleteFromIndexInProgress();
            }
        }
        return false;
    }

    public static boolean bytesSameAsCCIKBytes(Object deletedBytes, Object ccikBytes) {
        if (deletedBytes == ccikBytes) {
            return true;
        }
        if (deletedBytes instanceof OffHeapByteSource && ccikBytes instanceof OffHeapByteSource) {
            return deletedBytes.equals(ccikBytes);
        }
        return false;
    }
}

