/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemRawPutOperation;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import java.io.IOException;

public final class MemUpdateOperation
extends MemOperation {
    private final RegionEntry entry;
    private final Object key;
    private final DataValueDescriptor[] changedRow;
    private final FormatableBitSet validColumns;
    private final int bucketId;
    private Object rawOldValue;
    private final Object callbackArg;

    public MemUpdateOperation(GemFireContainer container, DataValueDescriptor[] row, RegionEntry entry, Object key, FormatableBitSet validColumns, int bucketId, Object callbackArg) {
        super(container);
        this.entry = entry;
        this.key = key;
        this.changedRow = row;
        this.validColumns = validColumns;
        this.bucketId = bucketId;
        this.callbackArg = callbackArg;
        LogWriterI18n logger = Misc.getI18NLogWriter();
        if (logger.fineEnabled()) {
            logger.fine("MemUpdateOperation::Constructor: Entry=" + entry + ". bucket ID = " + bucketId + " for region =" + container.getRegion().getFullPath());
        }
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        LanguageConnectionContext lcc = ((GemFireTransaction)xact).getLanguageConnectionContext();
        if (this.entry != null) {
            this.rawOldValue = this.memcontainer.replacePartialRow(this.entry, this.validColumns, this.changedRow, this.bucketId, null, null, lcc);
        } else {
            assert (this.callbackArg != null);
            this.rawOldValue = this.memcontainer.replacePartialRow(this.key, this.validColumns, this.changedRow, this.callbackArg, null, null, lcc, null, false);
        }
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        return new MemRawPutOperation(this.memcontainer, this.key, this.rawOldValue);
    }

    @Override
    public Object getKeyToConflate() {
        return this.entry.getKey();
    }

    public Object getOldValue() {
        return this.rawOldValue;
    }
}

