/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.index.key;

import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.pivotal.gemfirexd.internal.engine.access.index.key.IndexKeyComparator;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraInfo;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.ExtractingIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.RegionEntryUtils;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeUtilities;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;

public class OffHeapIndexKeyComparator
extends IndexKeyComparator {
    private static final long serialVersionUID = 2728235215718814912L;

    public OffHeapIndexKeyComparator(int nCols, boolean[] columnOrders, boolean caseSensitive) {
        super(nCols, columnOrders, caseSensitive);
    }

    @Override
    public int compare(Object key, Object mapKey) {
        int rowLength;
        DataValueDescriptor[] dvds1;
        DataValueDescriptor dvd1;
        CompactCompositeIndexKey ccik1;
        DataValueDescriptor[] dvds2;
        DataValueDescriptor dvd2;
        CompactCompositeIndexKey ccik2;
        if (key == mapKey) {
            return 0;
        }
        int cmpLen = this.nCols;
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        Class<?> keyClass = key.getClass();
        Class<?> mapKeyClass = mapKey.getClass();
        OffHeapRow ccik1BS = null;
        OffHeapByteSource ccik2BS = null;
        if (mapKeyClass == CompactCompositeIndexKey.class) {
            ccik2 = (CompactCompositeIndexKey)mapKey;
            dvd2 = null;
            dvds2 = null;
            if (keyClass == CompactCompositeIndexKey.class || keyClass == ExtractingIndexKey.class) {
                ccik1 = (CompactCompositeIndexKey)key;
                dvd1 = null;
                dvds1 = null;
            } else if (keyClass == DataValueDescriptor[].class) {
                ccik1 = null;
                dvd1 = null;
                dvds1 = (DataValueDescriptor[])key;
                rowLength = dvds1.length;
                if (rowLength < cmpLen) {
                    cmpLen = rowLength;
                }
            } else {
                ccik1 = null;
                dvd1 = (DataValueDescriptor)key;
                dvds1 = null;
                cmpLen = 1;
            }
        } else if (keyClass == CompactCompositeIndexKey.class || keyClass == ExtractingIndexKey.class) {
            ccik1 = (CompactCompositeIndexKey)key;
            dvd1 = null;
            dvds1 = null;
            if (mapKeyClass == DataValueDescriptor[].class) {
                ccik2 = null;
                dvd2 = null;
                dvds2 = (DataValueDescriptor[])mapKey;
                rowLength = dvds2.length;
                if (rowLength < cmpLen || cmpLen <= 0) {
                    cmpLen = rowLength;
                }
            } else {
                ccik2 = null;
                dvd2 = (DataValueDescriptor)mapKey;
                dvds2 = null;
                cmpLen = 1;
            }
        } else {
            ccik1 = null;
            ccik2 = null;
            if (keyClass == DataValueDescriptor[].class) {
                dvd1 = null;
                dvds1 = (DataValueDescriptor[])key;
                rowLength = dvds1.length;
                if (rowLength < cmpLen || cmpLen <= 0) {
                    cmpLen = rowLength;
                }
            } else {
                dvd1 = (DataValueDescriptor)key;
                dvds1 = null;
                cmpLen = 1;
            }
            if (mapKeyClass == DataValueDescriptor[].class) {
                dvd2 = null;
                dvds2 = (DataValueDescriptor[])mapKey;
                rowLength = dvds2.length;
                if (rowLength < cmpLen) {
                    cmpLen = rowLength;
                }
            } else {
                dvd2 = (DataValueDescriptor)mapKey;
                dvds2 = null;
                cmpLen = 1;
            }
        }
        try {
            int[] key2Positions;
            int[] key1Positions;
            RowFormatter ccik2RF;
            RowFormatter ccik1RF;
            int ccik2BSLen;
            int ccik1BSLen;
            long ccik2MemAddr;
            long ccik1MemAddr;
            byte[] ccik2Bytes;
            byte[] ccik1Bytes;
            block61: {
                OffHeapByteSource ohrow;
                Class<?> vclass;
                Object vbytes;
                byte[] kbytes;
                int tries;
                ExtraInfo indexInfo;
                block60: {
                    ccik1Bytes = null;
                    ccik2Bytes = null;
                    ccik1MemAddr = 0L;
                    ccik2MemAddr = 0L;
                    ccik1BSLen = -1;
                    ccik2BSLen = -1;
                    ccik1RF = null;
                    ccik2RF = null;
                    key1Positions = null;
                    key2Positions = null;
                    if (ccik1 != null) {
                        indexInfo = ccik1.tableInfo;
                        if (indexInfo == null) {
                            throw RegionEntryUtils.checkCacheForNullTableInfo("IndexKeyComparator#compare");
                        }
                        tries = 1;
                        do {
                            if ((kbytes = ccik1.getKeyBytes()) != null) {
                                ccik1Bytes = kbytes;
                                ccik1RF = indexInfo.getPrimaryKeyFormatter();
                                key1Positions = this.keySnapshotPositions;
                                break block60;
                            }
                            SimpleMemoryAllocatorImpl.skipRefCountTracking();
                            vbytes = ccik1.getValueByteSource();
                            SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                            if (vbytes != null) {
                                vclass = vbytes.getClass();
                                if (vclass == OffHeapRow.class) {
                                    ohrow = (OffHeapRow)((Object)vbytes);
                                    ccik1BS = ohrow;
                                    ccik1BSLen = ohrow.getLength();
                                    ccik1MemAddr = ohrow.getUnsafeAddress(0, ccik1BSLen);
                                    ccik1RF = indexInfo.getRowFormatter(ccik1MemAddr, ohrow);
                                } else if (vclass == OffHeapRowWithLobs.class) {
                                    ohrow = (OffHeapRowWithLobs)((Object)vbytes);
                                    ccik1BS = ohrow;
                                    ccik1BSLen = ((OffHeapRowWithLobs)ohrow).getLength();
                                    ccik1MemAddr = ((OffHeapRowWithLobs)ohrow).getUnsafeAddress(0, ccik1BSLen);
                                    ccik1RF = indexInfo.getRowFormatter(ccik1MemAddr, ohrow);
                                } else {
                                    ccik1Bytes = kbytes = (byte[])vbytes;
                                    ccik1RF = indexInfo.getRowFormatter(kbytes);
                                }
                                key1Positions = indexInfo.getPrimaryKeyColumns();
                                break block60;
                            }
                            if (tries++ % 1000 != 0) continue;
                            Thread.yield();
                        } while (tries <= 10000000);
                        throw RegionEntryUtils.checkCacheForNullKeyValue("IndexKeyComparator#compare");
                    }
                }
                if (ccik2 != null) {
                    indexInfo = ccik2.tableInfo;
                    if (indexInfo == null) {
                        throw RegionEntryUtils.checkCacheForNullTableInfo("IndexKeyComparator#compare");
                    }
                    tries = 1;
                    do {
                        if ((kbytes = ccik2.getKeyBytes()) != null) {
                            ccik2Bytes = kbytes;
                            ccik2RF = indexInfo.getPrimaryKeyFormatter();
                            key2Positions = this.keySnapshotPositions;
                            break block61;
                        }
                        SimpleMemoryAllocatorImpl.skipRefCountTracking();
                        vbytes = ccik2.getValueByteSource();
                        SimpleMemoryAllocatorImpl.unskipRefCountTracking();
                        if (vbytes != null) {
                            vclass = vbytes.getClass();
                            if (vclass == OffHeapRow.class) {
                                ccik2BS = ohrow = (OffHeapRow)((Object)vbytes);
                                ccik2BSLen = ohrow.getLength();
                                ccik2MemAddr = ohrow.getUnsafeAddress(0, ccik2BSLen);
                                ccik2RF = indexInfo.getRowFormatter(ccik2MemAddr, ohrow);
                            } else if (vclass == OffHeapRowWithLobs.class) {
                                ccik2BS = ohrow = (OffHeapRowWithLobs)((Object)vbytes);
                                ccik2BSLen = ((OffHeapRowWithLobs)ohrow).getLength();
                                ccik2MemAddr = ((OffHeapRowWithLobs)ohrow).getUnsafeAddress(0, ccik2BSLen);
                                ccik2RF = indexInfo.getRowFormatter(ccik2MemAddr, ohrow);
                            } else {
                                ccik2Bytes = kbytes = (byte[])vbytes;
                                ccik2RF = indexInfo.getRowFormatter(kbytes);
                            }
                            key2Positions = indexInfo.getPrimaryKeyColumns();
                            break block61;
                        }
                        if (tries++ % 1000 != 0) continue;
                        Thread.yield();
                    } while (tries <= 10000000);
                    throw RegionEntryUtils.checkCacheForNullKeyValue("IndexKeyComparator#compare");
                }
            }
            for (int i = 0; i < cmpLen; ++i) {
                int cmp;
                ColumnDescriptor cd;
                if (ccik1 != null) {
                    long offsetWidth1;
                    void rfPos1 = key1Positions[i];
                    void rfIndex1 = rfPos1 - true;
                    cd = ccik1RF.getColumnDescriptor((int)rfIndex1);
                    long l = offsetWidth1 = ccik1MemAddr != 0L ? ccik1RF.getOffsetAndWidth((int)rfIndex1, unsafe, ccik1MemAddr, ccik1BSLen, cd) : ccik1RF.getOffsetAndWidth((int)rfPos1, ccik1Bytes, cd);
                    if (ccik2 == null) {
                        if (dvds2 != null) {
                            dvd2 = dvds2[i];
                        }
                        if ((cmp = DataTypeUtilities.compare(unsafe, dvd2, ccik1Bytes, ccik1MemAddr, ccik1BS, offsetWidth1, false, this.caseSensitive, cd)) < 0) {
                            int n = this.columnOrders[i];
                            return n;
                        }
                        if (cmp <= 0) continue;
                        int n = -this.columnOrders[i];
                        return n;
                    }
                    long offsetWidth2 = ccik2MemAddr != 0L ? ccik2RF.getOffsetAndWidth(key2Positions[i] - 1, unsafe, ccik2MemAddr, ccik2BSLen, cd) : ccik2RF.getOffsetAndWidth(key2Positions[i], ccik2Bytes, cd);
                    cmp = DataTypeUtilities.compare(unsafe, ccik1Bytes, ccik1MemAddr, ccik1BS, ccik2Bytes, ccik2MemAddr, ccik2BS, offsetWidth1, offsetWidth2, false, this.caseSensitive, cd);
                } else {
                    if (dvds1 != null) {
                        dvd1 = dvds1[i];
                    }
                    if (ccik2 != null) {
                        void rfPos2 = key2Positions[i];
                        void rfIndex2 = rfPos2 - true;
                        cd = ccik2RF.getColumnDescriptor((int)rfIndex2);
                        long offsetWidth2 = ccik2MemAddr != 0L ? ccik2RF.getOffsetAndWidth((int)rfIndex2, unsafe, ccik2MemAddr, ccik2BSLen, cd) : ccik2RF.getOffsetAndWidth((int)rfPos2, ccik2Bytes, cd);
                        cmp = DataTypeUtilities.compare(unsafe, dvd1, ccik2Bytes, ccik2MemAddr, ccik2BS, offsetWidth2, false, this.caseSensitive, cd);
                    } else {
                        if (dvds2 != null) {
                            dvd2 = dvds2[i];
                        }
                        cmp = this.caseSensitive || !(dvd1 instanceof SQLChar) ? dvd1.compare(dvd2) : ((SQLChar)dvd1).compareIgnoreCase(dvd2);
                    }
                }
                if (cmp < 0) {
                    int n = -this.columnOrders[i];
                    return n;
                }
                if (cmp <= 0) continue;
                int n = this.columnOrders[i];
                return n;
            }
            if (ccik1 != null && keyClass == ExtractingIndexKey.class && ccik2 != null) {
                ((ExtractingIndexKey)key).afterCompareWith(ccik2);
            }
            int n = 0;
            return n;
        }
        catch (StandardException se) {
            throw GemFireXDRuntimeException.newRuntimeException("IndexKeyComparator#compare: unexpected exception", se);
        }
        finally {
            if (ccik1BS != null) {
                SimpleMemoryAllocatorImpl.skipRefCountTracking();
                ccik1BS.release();
                SimpleMemoryAllocatorImpl.unskipRefCountTracking();
            }
            if (ccik2BS != null) {
                SimpleMemoryAllocatorImpl.skipRefCountTracking();
                ccik2BS.release();
                SimpleMemoryAllocatorImpl.unskipRefCountTracking();
            }
        }
    }
}

