/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.heap;

import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerateController;
import com.pivotal.gemfirexd.internal.engine.access.heap.MemHeap;
import com.pivotal.gemfirexd.internal.engine.access.heap.MemHeapScanController;
import com.pivotal.gemfirexd.internal.engine.access.index.GlobalExecRowLocation;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapResourceHolder;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowLocationRetRowSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.SpaceInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.SpaceInformation;
import java.util.Properties;

public final class MemHeapController
implements MemConglomerateController {
    private GemFireTransaction tran;
    private TXStateInterface txState;
    private GemFireContainer gfContainer;
    private int openMode;

    @Override
    public void init(GemFireTransaction tran, MemConglomerate conglomerate, int openMode, int lockLevel, LockingPolicy locking) throws StandardException {
        this.tran = tran;
        this.gfContainer = conglomerate.getGemFireContainer();
        assert (this.gfContainer != null);
        conglomerate.openContainer(tran, openMode, lockLevel, locking);
        this.openMode = openMode;
        this.txState = this.gfContainer.getActiveTXState(this.tran);
    }

    @Override
    public boolean isClosed() {
        return this.tran == null;
    }

    @Override
    public boolean delete(RowLocation loc) throws StandardException {
        RegionEntry entry = loc.getRegionEntry();
        return MemHeapScanController.delete(this.tran, this.txState, this.gfContainer, entry, loc.getBucketID());
    }

    @Override
    public RowLocation fetch(RowLocation loc, DataValueDescriptor[] destRow, FormatableBitSet validColumns, boolean faultIn) throws StandardException {
        ValueRow vrow = new ValueRow(destRow.length);
        vrow.setRowArray(destRow);
        return this.fetch(loc, vrow, validColumns, faultIn);
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public RowLocation fetch(RowLocation loc, ExecRow destRow, FormatableBitSet validColumns, boolean faultIn) throws StandardException {
        return RowUtil.fetch(loc, destRow, validColumns, faultIn, this.gfContainer, null, null, 0, this.tran);
    }

    @Override
    public RowLocation fetch(RowLocation loc, ExecRow destRow, FormatableBitSet validColumns, boolean faultIn, OffHeapResourceHolder offheapOwner) throws StandardException {
        return RowUtil.fetch(loc, destRow, validColumns, faultIn, this.gfContainer, null, null, 0, offheapOwner);
    }

    @Override
    public RowLocation fetch(RowLocation loc, DataValueDescriptor[] row, FormatableBitSet validColumns, boolean waitForLock, boolean faultIn) {
        throw new AssertionError((Object)"not expected to be called");
    }

    @Override
    public boolean replace(RowLocation loc, DataValueDescriptor[] row, FormatableBitSet validColumns) throws StandardException {
        RowLocation memloc = loc;
        boolean updated = true;
        if (GemFireXDUtils.TraceConglomUpdate) {
            SanityManager.DEBUG_PRINT((String)"TraceConglomUpdate", (String)("MemHeapController::replace: ExecRowLocation=" + memloc + " entry=" + memloc.getRegionEntry() + " bucketId=" + memloc.getBucketID()));
        }
        try {
            this.gfContainer.replacePartialRow(memloc.getRegionEntry(), validColumns, row, memloc.getBucketID(), this.tran, this.txState, this.tran.getLanguageConnectionContext());
        }
        catch (EntryDestroyedException ede) {
            updated = false;
        }
        catch (EntryNotFoundException enfe) {
            updated = false;
        }
        return updated;
    }

    private Object doInsert(DataValueDescriptor[] row) throws StandardException {
        return this.gfContainer.insertRow(row, this.tran, this.txState, this.tran.getLanguageConnectionContext(), false);
    }

    protected long load(TransactionManager xact_manager, MemHeap heap, boolean createConglom, RowLocationRetRowSource rowSource) throws StandardException {
        return 0L;
    }

    @Override
    public int insert(DataValueDescriptor[] row) throws StandardException {
        this.doInsert(row);
        return 0;
    }

    @Override
    public RowLocation insertAndFetchLocation(DataValueDescriptor[] row, RowLocation templateRowLocation) throws StandardException {
        Object regionKey = this.doInsert(row);
        RegionAttributes<?, ?> attrs = this.gfContainer.getRegionAttributes();
        if (attrs.getScope().isLocal() && attrs.getDataPolicy().withStorage()) {
            RegionEntry entry = ((LocalRegion.NonTXEntry)this.gfContainer.getRegion().getEntry(regionKey)).getRegionEntry();
            if (templateRowLocation instanceof GlobalExecRowLocation) {
                ((GlobalExecRowLocation)templateRowLocation).setFrom(entry);
            } else {
                templateRowLocation = (RowLocation)entry;
            }
            return templateRowLocation;
        }
        return null;
    }

    @Override
    public boolean lockRow(RowLocation loc, int lock_operation, boolean wait, int lock_duration) throws StandardException {
        throw new AssertionError((Object)"not expected to be called");
    }

    @Override
    public void unlockRowAfterRead(RowLocation loc, boolean forUpdate, boolean row_qualified) throws StandardException {
        throw new AssertionError((Object)"not expected to be called");
    }

    @Override
    public boolean lockRow(long page_num, int record_id, int lock_operation, boolean wait, int lock_duration) throws StandardException {
        throw new AssertionError((Object)"not expected to be called");
    }

    @Override
    public void checkConsistency() throws StandardException {
    }

    @Override
    public void debugConglomerate() throws StandardException {
    }

    @Override
    public SpaceInfo getSpaceInfo() throws StandardException {
        SpaceInformation spaceInfo = new SpaceInformation(0L, 0L, 0L);
        return spaceInfo;
    }

    @Override
    public Properties getInternalTablePropertySet(Properties props) throws StandardException {
        if (props == null) {
            props = new Properties();
        }
        this.getTableProperties(props);
        return props;
    }

    @Override
    public void getTableProperties(Properties props) throws StandardException {
        this.gfContainer.getContainerProperties(props);
    }

    @Override
    public void close() throws StandardException {
        if (!this.isClosed()) {
            this.closeCC();
        }
    }

    @Override
    public boolean closeForEndTransaction(boolean closeHeldScan) throws StandardException {
        if (!this.isClosed() && closeHeldScan) {
            this.closeCC();
            return true;
        }
        return false;
    }

    private void closeCC() throws StandardException {
        this.tran.closeMe(this);
        this.tran = null;
    }

    @Override
    public boolean isKeyed() {
        return false;
    }

    @Override
    public RowLocation newRowLocationTemplate() throws StandardException {
        return MemHeapScanController.newRowLocationTemplate(this.gfContainer, this.openMode);
    }
}

