/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.catalog;

import com.gemstone.gemfire.internal.shared.ClientSharedData;
import com.pivotal.gemfirexd.internal.engine.ddl.catalog.GfxdSystemProcedures;
import com.pivotal.gemfirexd.internal.engine.ddl.catalog.messages.GfxdSystemProcedureMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.db.ConsistencyChecker;
import com.pivotal.gemfirexd.internal.iapi.db.Factory;
import com.pivotal.gemfirexd.internal.iapi.db.PropertyInfo;
import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.ConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.services.cache.CacheManager;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.ConnectionUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TablePermsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.RunTimeStatistics;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedDatabaseMetaData;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.load.Export;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINTableDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.JarUtil;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import com.pivotal.gemfirexd.load.Import;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;

public abstract class SystemProcedures {
    private static final int SQL_BEST_ROWID = 1;
    private static final int SQL_ROWVER = 2;
    private static final String DRIVER_TYPE_OPTION = "DATATYPE";
    private static final String ODBC_DRIVER_OPTION = "'ODBC'";
    public static boolean TEST_FAILURE_MODE;
    private static final double LOG10;

    public static void SQLCAMESSAGE(int sqlcode, short errmcLen, String sqlerrmc, String sqlerrp, int errd0, int errd1, int errd2, int errd3, int errd4, int errd5, String warn, String sqlState, String file, String localeStr, String[] msg, int[] rc) {
        int numMessages = 1;
        String serverInfo = null;
        int serverInfoIndex = sqlerrmc.indexOf(ClientSharedData.SQLERRMC_SERVER_DELIMITER);
        if (serverInfoIndex != -1) {
            serverInfo = sqlerrmc.substring(0, serverInfoIndex);
            sqlerrmc = sqlerrmc.substring(serverInfoIndex + ClientSharedData.SQLERRMC_SERVER_DELIMITER.length());
        }
        int index = 0;
        while (sqlerrmc.indexOf(ClientSharedData.SQLERRMC_MESSAGE_DELIMITER, index) != -1) {
            index = sqlerrmc.indexOf(ClientSharedData.SQLERRMC_MESSAGE_DELIMITER, index) + ClientSharedData.SQLERRMC_MESSAGE_DELIMITER.length();
            ++numMessages;
        }
        if (numMessages == 1) {
            MessageService.getLocalizedMessage(sqlcode, errmcLen, sqlerrmc, sqlerrp, errd0, errd1, errd2, errd3, errd4, errd5, warn, sqlState, file, localeStr, msg, rc);
        } else {
            int startIdx = 0;
            String[] errMsg = new String[2];
            for (int i = 0; i < numMessages; ++i) {
                int endIdx = sqlerrmc.indexOf(ClientSharedData.SQLERRMC_MESSAGE_DELIMITER, startIdx);
                String sqlError = i == numMessages - 1 ? sqlerrmc.substring(startIdx) : sqlerrmc.substring(startIdx, endIdx);
                if (i > 0) {
                    sqlState = sqlError.substring(0, 5);
                    sqlError = sqlError.substring(6);
                    msg[0] = msg[0] + " SQLSTATE: " + sqlState + ": ";
                }
                MessageService.getLocalizedMessage(sqlcode, (short)sqlError.length(), sqlError, sqlerrp, errd0, errd1, errd2, errd3, errd4, errd5, warn, sqlState, file, localeStr, errMsg, rc);
                if (rc[0] == 0) {
                    msg[0] = i == 0 ? errMsg[0] : msg[0] + errMsg[0];
                }
                startIdx = endIdx + ClientSharedData.SQLERRMC_MESSAGE_DELIMITER.length();
            }
        }
        if (serverInfo != null) {
            msg[0] = serverInfo + msg[0];
        }
    }

    private static Connection getDefaultConn() throws SQLException {
        Connection conn;
        InternalDriver id = InternalDriver.activeDriver();
        if (id != null && (conn = id.connect("jdbc:default:connection", null)) != null) {
            return conn;
        }
        throw Util.noCurrentConnection();
    }

    public static EmbedConnection getDefaultConnUnBound(LanguageConnectionContext lcc) throws SQLException {
        ConnectionContext cc = (ConnectionContext)((Object)lcc.getContextManager().getContext("JDBC_ConnectionContext"));
        return (EmbedConnection)cc.getNestedConnection(true);
    }

    private static DatabaseMetaData getDMD() throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        return conn.getMetaData();
    }

    public static void SQLPROCEDURES(String catalogName, String schemaName, String procName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getProceduresForODBC(catalogName, schemaName, procName) : SystemProcedures.getDMD().getProcedures(catalogName, schemaName, procName);
    }

    public static void SQLFUNCTIONS(String catalogName, String schemaName, String funcName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getFunctions(catalogName, schemaName, funcName);
    }

    public static void SQLTABLES(String catalogName, String schemaName, String tableName, String tableType, String options, ResultSet[] rs) throws SQLException {
        String optionValue = SystemProcedures.getOption("GETCATALOGS", options);
        if (optionValue != null && optionValue.trim().equals("1")) {
            rs[0] = SystemProcedures.getDMD().getCatalogs();
            return;
        }
        optionValue = SystemProcedures.getOption("GETTABLETYPES", options);
        if (optionValue != null && optionValue.trim().equals("1")) {
            rs[0] = SystemProcedures.getDMD().getTableTypes();
            return;
        }
        optionValue = SystemProcedures.getOption("GETSCHEMAS", options);
        if (optionValue != null) {
            if ((optionValue = optionValue.trim()).equals("1")) {
                rs[0] = SystemProcedures.getDMD().getSchemas();
                return;
            }
            if (optionValue.equals("2")) {
                EmbedDatabaseMetaData edmd = (EmbedDatabaseMetaData)SystemProcedures.getDMD();
                rs[0] = edmd.getSchemas(catalogName, schemaName);
                return;
            }
        }
        String[] typeArray = null;
        if (tableType != null) {
            StringTokenizer st = new StringTokenizer(tableType, "',");
            typeArray = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                typeArray[i] = st.nextToken();
                ++i;
            }
        }
        rs[0] = SystemProcedures.getDMD().getTables(catalogName, schemaName, tableName, typeArray);
    }

    public static void SQLFOREIGNKEYS(String pkCatalogName, String pkSchemaName, String pkTableName, String fkCatalogName, String fkSchemaName, String fkTableName, String options, ResultSet[] rs) throws SQLException {
        String exportedKeyProp = SystemProcedures.getOption("EXPORTEDKEY", options);
        String importedKeyProp = SystemProcedures.getOption("IMPORTEDKEY", options);
        rs[0] = importedKeyProp != null && importedKeyProp.trim().equals("1") ? SystemProcedures.getDMD().getImportedKeys(fkCatalogName, fkSchemaName, fkTableName) : (exportedKeyProp != null && exportedKeyProp.trim().equals("1") ? SystemProcedures.getDMD().getExportedKeys(pkCatalogName, pkSchemaName, pkTableName) : (SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getCrossReferenceForODBC(pkCatalogName, pkSchemaName, pkTableName, fkCatalogName, fkSchemaName, fkTableName) : SystemProcedures.getDMD().getCrossReference(pkCatalogName, pkSchemaName, pkTableName, fkCatalogName, fkSchemaName, fkTableName)));
    }

    private static String getOption(String pattern, String options) {
        if (options == null) {
            return null;
        }
        int start = options.lastIndexOf(pattern);
        if (start < 0) {
            return null;
        }
        int valueStart = options.indexOf(61, start);
        if (valueStart < 0) {
            return null;
        }
        int valueEnd = options.indexOf(59, valueStart);
        if (valueEnd < 0) {
            return options.substring(valueStart + 1);
        }
        return options.substring(valueStart + 1, valueEnd);
    }

    public static void SQLPROCEDURECOLS(String catalogName, String schemaName, String procName, String paramName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getProcedureColumnsForODBC(catalogName, schemaName, procName, paramName) : SystemProcedures.getDMD().getProcedureColumns(catalogName, schemaName, procName, paramName);
    }

    public static void SQLFUNCTIONPARAMS(String catalogName, String schemaName, String funcName, String paramName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getFunctionColumns(catalogName, schemaName, funcName, paramName);
    }

    public static void SQLCOLUMNS(String catalogName, String schemaName, String tableName, String columnName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getColumnsForODBC(catalogName, schemaName, tableName, columnName) : SystemProcedures.getDMD().getColumns(catalogName, schemaName, tableName, columnName);
    }

    public static void SQLCOLPRIVILEGES(String catalogName, String schemaName, String tableName, String columnName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.getDMD().getColumnPrivileges(catalogName, schemaName, tableName, columnName);
    }

    public static void SQLTABLEPRIVILEGES(String catalogName, String schemaName, String tableName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.getDMD().getTablePrivileges(catalogName, schemaName, tableName);
    }

    public static void SQLPRIMARYKEYS(String catalogName, String schemaName, String tableName, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.getDMD().getPrimaryKeys(catalogName, schemaName, tableName);
    }

    public static void SQLGETTYPEINFO(short dataType, String options, ResultSet[] rs) throws SQLException {
        rs[0] = SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getTypeInfoForODBC(dataType) : SystemProcedures.getDMD().getTypeInfo();
    }

    public static void SQLSTATISTICS(String catalogName, String schemaName, String tableName, short unique, short approximate, String options, ResultSet[] rs) throws SQLException {
        boolean boolUnique = unique == 0;
        boolean boolApproximate = approximate == 1;
        rs[0] = SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getIndexInfoForODBC(catalogName, schemaName, tableName, boolUnique, boolApproximate) : SystemProcedures.getDMD().getIndexInfo(catalogName, schemaName, tableName, boolUnique, boolApproximate);
    }

    public static void SQLSPECIALCOLUMNS(short colType, String catalogName, String schemaName, String tableName, short scope, short nullable, String options, ResultSet[] rs) throws SQLException {
        boolean boolNullable;
        boolean bl = boolNullable = nullable == 1;
        rs[0] = colType == 1 ? (SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getBestRowIdentifierForODBC(catalogName, schemaName, tableName, scope, boolNullable) : SystemProcedures.getDMD().getBestRowIdentifier(catalogName, schemaName, tableName, scope, boolNullable)) : (SystemProcedures.isForODBC(options) ? ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getVersionColumnsForODBC(catalogName, schemaName, tableName) : SystemProcedures.getDMD().getVersionColumns(catalogName, schemaName, tableName));
    }

    public static void SQLUDTS(String catalogName, String schemaPattern, String typeNamePattern, String udtTypes, String options, ResultSet[] rs) throws SQLException {
        int[] types = null;
        if (udtTypes != null && udtTypes.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(udtTypes, " \t\n\t,");
            int udtTypeCount = tokenizer.countTokens();
            types = new int[udtTypeCount];
            String udtType = "";
            try {
                for (int i = 0; i < udtTypeCount; ++i) {
                    udtType = tokenizer.nextToken();
                    types[i] = Integer.parseInt(udtType);
                }
            }
            catch (NumberFormatException nfe) {
                throw new SQLException("Invalid type, " + udtType + ", passed to getUDTs.");
            }
            catch (NoSuchElementException nsee) {
                throw new SQLException("Internal failure: NoSuchElementException in getUDTs.");
            }
        }
        rs[0] = SystemProcedures.getDMD().getUDTs(catalogName, schemaPattern, typeNamePattern, types);
    }

    public static void METADATA(ResultSet[] rs) throws SQLException {
        rs[0] = ((EmbedDatabaseMetaData)SystemProcedures.getDMD()).getClientCachedMetaData();
    }

    private static boolean isForODBC(String options) {
        String optionValue = SystemProcedures.getOption(DRIVER_TYPE_OPTION, options);
        return optionValue != null && optionValue.toUpperCase().equals(ODBC_DRIVER_OPTION);
    }

    public static void SET_DATABASE_PROPERTY(String key, String value) throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        TransactionController tc = lcc.getTransactionExecute();
        boolean ddLocked = false;
        try {
            ddLocked = lcc.getDataDictionary().lockForWriting(tc, false);
            PropertyInfo.setDatabaseProperty(key, value, true);
            GfxdSystemProcedures.publishMessage(new Object[]{key, value}, false, GfxdSystemProcedureMessage.SysProcMethod.setDatabaseProperty, true, true);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        finally {
            if (ddLocked) {
                try {
                    lcc.getDataDictionary().unlockAfterWriting(tc, false);
                }
                catch (StandardException se) {
                    throw PublicAPI.wrapStandardException(se);
                }
            }
        }
    }

    public static String GET_DATABASE_PROPERTY(String key) throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        try {
            return PropertyUtil.getDatabaseProperty(lcc.getTransactionExecute(), key);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void COMPRESS_TABLE(String schema, String tablename, int sequential) throws SQLException {
        String query = "alter table \"" + schema + "\".\"" + tablename + "\" compress" + (sequential != 0 ? " sequential" : "");
        Connection conn = SystemProcedures.getDefaultConn();
        PreparedStatement ps = conn.prepareStatement(query);
        ps.executeUpdate();
        ps.close();
        conn.close();
    }

    public static void FREEZE_DATABASE() throws SQLException {
        Factory.getDatabaseOfConnection().freeze();
    }

    public static void UNFREEZE_DATABASE() throws SQLException {
        Factory.getDatabaseOfConnection().unfreeze();
    }

    public static void CHECKPOINT_DATABASE() throws SQLException {
        Factory.getDatabaseOfConnection().checkpoint();
    }

    public static void BACKUP_DATABASE(String backupDir) throws SQLException {
        Factory.getDatabaseOfConnection().backup(backupDir, true);
    }

    public static void BACKUP_DATABASE_NOWAIT(String backupDir) throws SQLException {
        Factory.getDatabaseOfConnection().backup(backupDir, false);
    }

    public static void BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE(String backupDir, int deleteOnlineArchivedLogFiles) throws SQLException {
        Factory.getDatabaseOfConnection().backupAndEnableLogArchiveMode(backupDir, deleteOnlineArchivedLogFiles != 0, true);
    }

    public static void BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT(String backupDir, int deleteOnlineArchivedLogFiles) throws SQLException {
        Factory.getDatabaseOfConnection().backupAndEnableLogArchiveMode(backupDir, deleteOnlineArchivedLogFiles != 0, false);
    }

    public static void DISABLE_LOG_ARCHIVE_MODE(int deleteOnlineArchivedLogFiles) throws SQLException {
        Factory.getDatabaseOfConnection().disableLogArchiveMode(deleteOnlineArchivedLogFiles != 0);
    }

    public static void SET_RUNTIMESTATISTICS(int enable) throws SQLException {
        ConnectionUtil.getCurrentLCC().setRunTimeStatisticsMode(enable != 0, false);
    }

    public static void SET_STATISTICS_TIMING(int enable) throws SQLException {
        ConnectionUtil.getCurrentLCC().setStatisticsTiming(enable != 0);
    }

    public static int CHECK_TABLE(String schema, String tablename) throws SQLException {
        boolean ret_val = ConsistencyChecker.checkTable(schema, tablename);
        return ret_val ? 1 : 0;
    }

    public static void INPLACE_COMPRESS_TABLE(String schema, String tablename, int purgeRows, int defragementRows, int truncateEnd) throws SQLException {
        throw Util.notImplemented("Table Compression");
    }

    public static String GET_RUNTIMESTATISTICS() throws SQLException {
        RunTimeStatistics rts = ConnectionUtil.getCurrentLCC().getRunTimeStatisticsObject();
        if (rts == null) {
            return null;
        }
        return rts.toString();
    }

    public static void INSTALL_JAR(String url, String jar, int deploy) throws SQLException {
        try {
            String sqlName;
            String schemaName;
            if (url == null || jar == null) {
                throw StandardException.newException("XIE06.S");
            }
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            String[] st = IdUtil.parseMultiPartSQLIdentifier(jar.trim());
            if (st.length == 1) {
                schemaName = lcc.getCurrentSchemaName();
                sqlName = st[0];
            } else {
                schemaName = st[0];
                sqlName = st[1];
            }
            SystemProcedures.checkJarSQLName(sqlName);
            JarUtil.install(lcc, schemaName, sqlName, url);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void REPLACE_JAR(String url, String jar) throws SQLException {
        try {
            String sqlName;
            String schemaName;
            if (url == null || jar == null) {
                throw StandardException.newException("XIE06.S");
            }
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            String[] st = IdUtil.parseMultiPartSQLIdentifier(jar.trim());
            if (st.length == 1) {
                schemaName = lcc.getCurrentSchemaName();
                sqlName = st[0];
            } else {
                schemaName = st[0];
                sqlName = st[1];
            }
            SystemProcedures.checkJarSQLName(sqlName);
            JarUtil.replace(lcc, schemaName, sqlName, url);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void REMOVE_JAR(String jar, int undeploy) throws SQLException {
        try {
            String sqlName;
            String schemaName;
            if (jar == null) {
                throw StandardException.newException("XIE06.S");
            }
            LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
            String[] st = IdUtil.parseMultiPartSQLIdentifier(jar.trim());
            if (st.length == 1) {
                schemaName = lcc.getCurrentSchemaName();
                sqlName = st[0];
            } else {
                schemaName = st[0];
                sqlName = st[1];
            }
            SystemProcedures.checkJarSQLName(sqlName);
            JarUtil.drop(lcc, schemaName, sqlName);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void checkJarSQLName(String sqlName) throws StandardException {
        if (sqlName.length() == 0 || sqlName.indexOf(58) != -1) {
            throw StandardException.newException("XCXA0.S");
        }
    }

    public static void EXPORT_TABLE(String schemaName, String tableName, String fileName, String columnDelimiter, String characterDelimiter, String codeset) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        if (schemaName != null) {
            schemaName = StringUtil.SQLToUpperCase(schemaName);
        }
        if (tableName != null) {
            tableName = StringUtil.SQLToUpperCase(tableName);
        }
        Export.exportTable(conn, schemaName, tableName, fileName, columnDelimiter, characterDelimiter, codeset);
        conn.commit();
    }

    public static void EXPORT_TABLE_LOBS_TO_EXTFILE(String schemaName, String tableName, String fileName, String columnDelimiter, String characterDelimiter, String codeset, String lobsFileName) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        if (schemaName != null) {
            schemaName = StringUtil.SQLToUpperCase(schemaName);
        }
        if (tableName != null) {
            tableName = StringUtil.SQLToUpperCase(tableName);
        }
        Export.exportTable(conn, schemaName, tableName, fileName, columnDelimiter, characterDelimiter, codeset, lobsFileName);
        conn.commit();
    }

    public static void EXPORT_QUERY(String selectStatement, String fileName, String columnDelimiter, String characterDelimiter, String codeset) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        Export.exportQuery(conn, selectStatement, fileName, columnDelimiter, characterDelimiter, codeset);
        conn.commit();
    }

    public static void EXPORT_QUERY_LOBS_TO_EXTFILE(String selectStatement, String fileName, String columnDelimiter, String characterDelimiter, String codeset, String lobsFileName) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        Export.exportQuery(conn, selectStatement, fileName, columnDelimiter, characterDelimiter, codeset, lobsFileName);
        conn.commit();
    }

    public static void IMPORT_TABLE(String schemaName, String tableName, String fileName, String columnDelimiter, String characterDelimiter, String codeset, short replace) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        try {
            if (schemaName != null) {
                schemaName = StringUtil.SQLToUpperCase(schemaName);
            }
            if (tableName != null) {
                tableName = StringUtil.SQLToUpperCase(tableName);
            }
            Import.importTable(conn, schemaName, tableName, fileName, columnDelimiter, characterDelimiter, codeset, replace, true, 1, "com.pivotal.gemfirexd.load.Import", false, null);
        }
        catch (SQLException se) {
            SystemProcedures.rollBackAndThrowSQLException(conn, se);
        }
        conn.commit();
    }

    private static void rollBackAndThrowSQLException(Connection conn, SQLException se) throws SQLException {
        try {
            conn.rollback();
        }
        catch (SQLException e) {
            se.setNextException(e);
        }
        throw se;
    }

    public static void IMPORT_TABLE_LOBS_FROM_EXTFILE(String schemaName, String tableName, String fileName, String columnDelimiter, String characterDelimiter, String codeset, short replace) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        try {
            if (schemaName != null) {
                schemaName = StringUtil.SQLToUpperCase(schemaName);
            }
            if (tableName != null) {
                tableName = StringUtil.SQLToUpperCase(tableName);
            }
            Import.importTable(conn, schemaName, tableName, fileName, columnDelimiter, characterDelimiter, codeset, replace, true, 1, "com.pivotal.gemfirexd.load.Import", true, null);
        }
        catch (SQLException se) {
            SystemProcedures.rollBackAndThrowSQLException(conn, se);
        }
        conn.commit();
    }

    public static void IMPORT_DATA(String schemaName, String tableName, String insertColumnList, String columnIndexes, String fileName, String columnDelimiter, String characterDelimiter, String codeset, short replace) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        try {
            Import.importData(conn, schemaName, tableName, insertColumnList, columnIndexes, fileName, columnDelimiter, characterDelimiter, codeset, replace, true, 1, "com.pivotal.gemfirexd.load.Import", false, null);
        }
        catch (SQLException se) {
            SystemProcedures.rollBackAndThrowSQLException(conn, se);
        }
        conn.commit();
    }

    public static void IMPORT_DATA_LOBS_FROM_EXTFILE(String schemaName, String tableName, String insertColumnList, String columnIndexes, String fileName, String columnDelimiter, String characterDelimiter, String codeset, short replace) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        try {
            Import.importData(conn, schemaName, tableName, insertColumnList, columnIndexes, fileName, columnDelimiter, characterDelimiter, codeset, replace, true, 1, "com.pivotal.gemfirexd.load.Import", true, null);
        }
        catch (SQLException se) {
            SystemProcedures.rollBackAndThrowSQLException(conn, se);
        }
        conn.commit();
    }

    @SuppressWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    public static void BULK_INSERT(String schemaName, String tableName, String vtiName, String vtiArg) throws SQLException {
        Connection conn = SystemProcedures.getDefaultConn();
        String entityName = schemaName == null ? tableName : schemaName + "." + tableName;
        String binsertSql = "insert into " + entityName + " --GEMFIREXD-PROPERTIES insertMode=bulkInsert \nselect * from new " + vtiName + "('" + schemaName + "', '" + tableName + "', '" + vtiArg + "') as t";
        PreparedStatement ps = conn.prepareStatement(binsertSql);
        ps.executeUpdate();
        ps.close();
    }

    public static void RELOAD_SECURITY_POLICY() throws SQLException {
        if (System.getSecurityManager() == null) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Policy.getPolicy().refresh();
                    return null;
                }
            });
        }
        catch (SecurityException se) {
            throw Util.policyNotReloaded(se);
        }
    }

    public static double PI() {
        return Math.PI;
    }

    public static double LOG10(double value) {
        return StrictMath.log(value) / LOG10;
    }

    public static double COT(double value) {
        return 1.0 / StrictMath.tan(value);
    }

    public static double COSH(double value) {
        return (StrictMath.exp(value) + StrictMath.exp(-value)) / 2.0;
    }

    public static double SINH(double value) {
        return (StrictMath.exp(value) - StrictMath.exp(-value)) / 2.0;
    }

    public static double TANH(double value) {
        return (StrictMath.exp(value) - StrictMath.exp(-value)) / (StrictMath.exp(value) + StrictMath.exp(-value));
    }

    public static int SIGN(double value) {
        return value < 0.0 ? -1 : (value > 0.0 ? 1 : 0);
    }

    @SuppressWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"})
    public static double RAND(int seed) {
        return new Random(seed).nextDouble();
    }

    public static void SET_USER_ACCESS(String userName, String connectionPermission) throws SQLException {
        try {
            String addListProperty;
            if (userName == null) {
                throw StandardException.newException("28502", userName);
            }
            userName = IdUtil.getUserAuthorizationId(userName);
            if ("FULLACCESS".equals(connectionPermission)) {
                addListProperty = "authz-full-access-users";
            } else if ("READONLYACCESS".equals(connectionPermission)) {
                addListProperty = "authz-read-only-access-users";
            } else if (connectionPermission == null) {
                addListProperty = null;
            } else {
                throw StandardException.newException("XCZ00.S", connectionPermission);
            }
            SystemProcedures.removeFromAccessList("authz-full-access-users", userName);
            SystemProcedures.removeFromAccessList("authz-read-only-access-users", userName);
            if (addListProperty != null) {
                String addList = SystemProcedures.GET_DATABASE_PROPERTY(addListProperty);
                SystemProcedures.SET_DATABASE_PROPERTY(addListProperty, IdUtil.appendNormalToList(userName, addList));
                String string = SystemProcedures.GET_DATABASE_PROPERTY(addListProperty);
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    private static void removeFromAccessList(String listProperty, String userName) throws SQLException, StandardException {
        String removeList = SystemProcedures.GET_DATABASE_PROPERTY(listProperty);
        if (removeList != null) {
            SystemProcedures.SET_DATABASE_PROPERTY(listProperty, IdUtil.deleteId(userName, removeList));
        }
    }

    public static String GET_USER_ACCESS(String userName) throws SQLException {
        try {
            String fullUserList;
            if (userName == null) {
                throw StandardException.newException("28502", userName);
            }
            if (IdUtil.idOnList(userName = IdUtil.getUserAuthorizationId(userName), fullUserList = SystemProcedures.GET_DATABASE_PROPERTY("authz-full-access-users"))) {
                return "FULLACCESS";
            }
            String readOnlyUserList = SystemProcedures.GET_DATABASE_PROPERTY("authz-read-only-access-users");
            if (IdUtil.idOnList(userName, readOnlyUserList)) {
                return "READONLYACCESS";
            }
            String defaultAccess = PropertyUtil.getServiceProperty(ConnectionUtil.getCurrentLCC().getTransactionExecute(), "gemfirexd.authz-default-connection-mode");
            defaultAccess = defaultAccess != null ? StringUtil.SQLToUpperCase(defaultAccess) : "FULLACCESS";
            return defaultAccess;
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    public static void EMPTY_STATEMENT_CACHE() throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        CacheManager statementCache = lcc.getLanguageConnectionFactory().getStatementCache();
        if (statementCache != null) {
            statementCache.ageOut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void SET_EXPLAIN_SCHEMA(LanguageConnectionContext lcc) throws SQLException, StandardException {
        String schemaName = "SYSSTAT";
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)"setting schema SYSSTAT in explain mode ");
        }
        assert (lcc != null);
        if ("SYSSTAT".equals("SESSION")) {
            return;
        }
        boolean statsSave = lcc.getRunTimeStatisticsMode();
        lcc.setRunTimeStatisticsMode(false, true);
        ((GfxdDataDictionary)lcc.getDataDictionary()).startWriting(lcc, true);
        boolean connectionRemote = lcc.isConnectionForRemote();
        try {
            lcc.setIsConnectionForRemote(true);
            lcc.setExplainSchema(true);
            Iterator<XPLAINTableDescriptor> t = XPLAINTableDescriptor.getRegisteredDescriptors();
            while (t.hasNext()) {
                SystemProcedures.createExplainTable(lcc, "SYSSTAT", t.next());
            }
        }
        finally {
            lcc.setIsConnectionForRemote(connectionRemote);
            lcc.setRunTimeStatisticsMode(statsSave, true);
            lcc.setExplainSchema(false);
            lcc.internalCommit(true);
        }
    }

    private static boolean hasTable(EmbedConnection conn, String schemaName, String tableName) throws SQLException {
        LanguageConnectionContext lcc = conn.getLanguageConnectionContext();
        TransactionController tc = lcc.getTransactionExecute();
        TableDescriptor td = null;
        try {
            SchemaDescriptor sd = lcc.getDataDictionary().getSchemaDescriptor(schemaName, tc, true);
            td = lcc.getDataDictionary().getTableDescriptor(tableName, sd, tc);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        return td != null;
    }

    private static void createExplainTable(LanguageConnectionContext lcc, String schemaName, XPLAINTableDescriptor t) throws SQLException {
        String[] ddl = t.getTableDDL(schemaName);
        EmbedConnection conn = SystemProcedures.getDefaultConnUnBound(lcc);
        if (!SystemProcedures.hasTable(conn, schemaName, t.getCatalogName())) {
            if (GemFireXDUtils.TraceSysProcedures || GemFireXDUtils.TracePlanGeneration) {
                SanityManager.DEBUG_PRINT((String)"TraceSystemProcedures", (String)("creating explain table " + t.getCatalogName() + " in schema " + schemaName + " "));
            }
            Statement s = conn.createStatement();
            for (int i = 0; i < ddl.length; ++i) {
                if (ddl[i] == null || ddl[i].length() <= 0) continue;
                s.executeUpdate(ddl[i]);
                conn.commit();
            }
            s.close();
        }
        String ins = t.getTableInsert();
        conn.prepareStatement(ins).close();
        lcc.setExplainStatement(t.getCatalogName(), ins);
        if (!TEST_FAILURE_MODE) {
            DataDictionary dd = lcc.getDataDictionary();
            DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
            TransactionController tc = lcc.getTransactionExecute();
            String grantee = "PUBLIC";
            TableDescriptor td = null;
            try {
                td = dd.getTableDescriptor(t.getCatalogName(), dd.getSchemaDescriptor(schemaName, tc, false), tc);
                TablePermsDescriptor tablePermsDesc = ddg.newTablePermsDescriptor(td, "y", "y", "y", "y", "N", "N", "N", "PUBLIC");
                boolean result = dd.addRemovePermissionsDescriptor(true, tablePermsDesc, "PUBLIC", tc);
                if (GemFireXDUtils.TraceAuthentication) {
                    SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)((result ? " granted " : "not granted ") + schemaName + "." + t.getCatalogName() + " table permissions on " + td.getDescriptorName() + " grantee=" + "PUBLIC"));
                }
            }
            catch (StandardException se) {
                throw PublicAPI.wrapStandardException(se);
            }
        }
    }

    static {
        LOG10 = StrictMath.log(10.0);
    }
}

