/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.server;

import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gnu.trove.TObjectProcedure;
import com.pivotal.gemfirexd.NetworkInterface;
import com.pivotal.gemfirexd.internal.engine.diag.SessionsVTI;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import io.snappydata.thrift.LocatorService;
import io.snappydata.thrift.common.SocketParameters;
import io.snappydata.thrift.common.TBinaryProtocolDirect;
import io.snappydata.thrift.common.TCompactProtocolDirect;
import io.snappydata.thrift.common.ThriftUtils;
import io.snappydata.thrift.server.ConnectionHolder;
import io.snappydata.thrift.server.LocatorServiceImpl;
import io.snappydata.thrift.server.SnappyDataServiceImpl;
import io.snappydata.thrift.server.SnappyTSSLServerSocketFactory;
import io.snappydata.thrift.server.SnappyTServerSocket;
import io.snappydata.thrift.server.SnappyThriftServerSelector;
import io.snappydata.thrift.server.SnappyThriftServerThreadPool;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public final class SnappyThriftServer {
    private InetAddress thriftAddress;
    private int thriftPort;
    private LocatorServiceImpl service;
    private TServer thriftServer;
    private ThreadPoolExecutor thriftExecutor;
    private ThreadPoolExecutor thriftThreadPerConnExecutor;
    private Thread thriftMainThread;

    public InetAddress getThriftAddress() {
        return this.thriftAddress;
    }

    public int getThriftPort() {
        return this.thriftPort;
    }

    public synchronized void start(InetAddress thriftAddress, int thriftPort, int maxThreads, boolean isServer, boolean useBinaryProtocol, boolean useFramedTransport, boolean useSSL, SocketParameters socketParams, NetworkInterface.ConnectionListener listener) throws TTransportException {
        SnappyDataServiceImpl.Processor processor;
        LocatorServiceImpl service;
        InetSocketAddress bindAddress;
        this.thriftAddress = thriftAddress;
        this.thriftPort = thriftPort;
        if (this.isServing()) {
            throw GemFireXDRuntimeException.newRuntimeException("A thrift server is already running", null);
        }
        if (this.thriftAddress != null) {
            bindAddress = new InetSocketAddress(this.thriftAddress, this.thriftPort);
        } else {
            try {
                bindAddress = new InetSocketAddress(SocketCreator.getLocalHost(), this.thriftPort);
            }
            catch (UnknownHostException uhe) {
                throw new TTransportException("Could not determine localhost for default bind address.", (Throwable)uhe);
            }
        }
        Object serverTransport = useSSL ? SnappyTSSLServerSocketFactory.getServerSocket(bindAddress, socketParams) : new SnappyTServerSocket(bindAddress, false, true, true, socketParams);
        String hostAddress = bindAddress.getAddress().toString();
        if (isServer) {
            service = new SnappyDataServiceImpl(hostAddress, this.thriftPort);
            processor = new SnappyDataServiceImpl.Processor((SnappyDataServiceImpl)service);
            this.service = service;
        } else {
            service = new LocatorServiceImpl(hostAddress, this.thriftPort);
            processor = new LocatorService.Processor((LocatorService.Iface)service);
            this.service = service;
        }
        int parallelism = Math.max(Runtime.getRuntime().availableProcessors(), 4);
        if (!ThriftUtils.isThriftSelectorServer()) {
            SnappyThriftServerThreadPool.Args serverArgs = new SnappyThriftServerThreadPool.Args((TServerTransport)serverTransport);
            TBinaryProtocolDirect.Factory protocolFactory = useBinaryProtocol ? new TBinaryProtocolDirect.Factory(true) : new TCompactProtocolDirect.Factory(true);
            ((SnappyThriftServerThreadPool.Args)serverArgs.processor((TProcessor)processor)).protocolFactory((TProtocolFactory)protocolFactory);
            if (useFramedTransport) {
                serverArgs.transportFactory((TTransportFactory)new TFramedTransport.Factory());
            }
            this.thriftExecutor = new ThreadPoolExecutor(parallelism * 2, maxThreads, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            serverArgs.setExecutorService(this.thriftExecutor).setConnectionListener(listener);
            this.thriftServer = new SnappyThriftServerThreadPool(serverArgs);
        } else {
            SnappyThriftServerSelector.Args serverArgs = new SnappyThriftServerSelector.Args((TServerTransport)serverTransport);
            TBinaryProtocolDirect.Factory protocolFactory = useBinaryProtocol ? new TBinaryProtocolDirect.Factory(true) : new TCompactProtocolDirect.Factory(true);
            int numSelectors = parallelism * 2;
            int numThreads = parallelism * 2;
            ((SnappyThriftServerSelector.Args)((SnappyThriftServerSelector.Args)serverArgs.processor((TProcessor)processor)).protocolFactory((TProtocolFactory)protocolFactory)).setNumSelectors(numSelectors).setConnectionListener(listener);
            int executorThreads = Math.min(Math.max(64, numThreads * 2), maxThreads);
            int maxQueued = Math.min(Math.max(1024, numThreads * 16), maxThreads);
            this.thriftExecutor = new ThreadPoolExecutor(executorThreads, executorThreads, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(maxQueued));
            this.thriftExecutor.allowCoreThreadTimeOut(true);
            this.thriftThreadPerConnExecutor = new ThreadPoolExecutor(1, numThreads, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
            serverArgs.setExecutorService(this.thriftExecutor);
            serverArgs.setThreadPerConnExecutor(this.thriftThreadPerConnExecutor);
            this.thriftServer = new SnappyThriftServerSelector(serverArgs);
        }
        this.thriftMainThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SnappyThriftServer.this.thriftServer.serve();
            }
        }, "ThriftServerThread");
        this.thriftMainThread.setDaemon(true);
        this.thriftMainThread.start();
    }

    public synchronized void stop() {
        TServer thriftServer = this.thriftServer;
        if (thriftServer != null) {
            this.service.stop();
            thriftServer.stop();
            ThreadPoolExecutor connExecutor = this.thriftThreadPerConnExecutor;
            if (connExecutor != null) {
                connExecutor.shutdown();
            }
            this.thriftExecutor.shutdown();
            try {
                this.thriftMainThread.join(5000L);
                if (this.thriftMainThread.isAlive()) {
                    if (connExecutor != null) {
                        connExecutor.shutdownNow();
                    }
                    this.thriftExecutor.shutdownNow();
                    this.thriftMainThread.join();
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public final boolean isServing() {
        TServer thriftServer = this.thriftServer;
        return thriftServer != null && thriftServer.isServing();
    }

    public void collectStatisticsSample() {
    }

    public void getSessionInfo(final SessionsVTI.SessionInfo info) {
        LocatorServiceImpl service = this.service;
        if (service instanceof SnappyDataServiceImpl) {
            final SnappyDataServiceImpl dataService = (SnappyDataServiceImpl)service;
            dataService.recordStatementStartTime = true;
            dataService.connectionMap.forEachValue(new TObjectProcedure(){

                public boolean execute(Object holder) {
                    ConnectionHolder connHolder = (ConnectionHolder)holder;
                    SessionsVTI.SessionInfo.ClientSession cs = new SessionsVTI.SessionInfo.ClientSession();
                    cs.connNum = connHolder.getConnectionId();
                    cs.isActive = connHolder.getConnection().isActive();
                    cs.clientBindAddress = connHolder.getClientHostName() + ':' + connHolder.getClientID();
                    cs.clientBindPort = dataService.hostPort;
                    cs.hadConnectedOnce = dataService.clientTrackerMap.containsKey(connHolder.getClientHostId());
                    cs.isConnected = dataService.connectionMap.containsKeyPrimitive(connHolder.getConnectionId());
                    cs.userId = connHolder.getUserName();
                    cs.connectionBeginTimeStamp = new Timestamp(connHolder.getStartTime());
                    ConnectionHolder.StatementHolder activeStatement = connHolder.getActiveStatement();
                    if (activeStatement != null) {
                        Statement stmt = activeStatement.getStatement();
                        EmbedStatement estmt = stmt instanceof EmbedStatement ? (EmbedStatement)stmt : null;
                        cs.currentStatementUUID = estmt != null ? estmt.getStatementUUID() : "Statement@" + Integer.toHexString(System.identityHashCode(stmt));
                        cs.currentStatement = String.valueOf(activeStatement.getSQL());
                        cs.currentStatementStatus = activeStatement.getStatus();
                        long startTime = activeStatement.getStartTime();
                        if (startTime > 0L) {
                            cs.currentStatementElapsedTime = (double)Math.max(System.nanoTime() - startTime, 0L) / 1.0E9;
                        }
                        cs.currentStatementAccessFrequency = activeStatement.getAccessFrequency();
                        if (estmt != null) {
                            try {
                                cs.currentStatementEstimatedMemUsage = estmt.getEstimatedMemoryUsage();
                            }
                            catch (StandardException se) {
                                throw new GemFireXDRuntimeException(se);
                            }
                        }
                    }
                    info.addClientSession(cs);
                    return false;
                }
            });
        } else if (service != null) {
            SessionsVTI.SessionInfo.ClientSession cs = new SessionsVTI.SessionInfo.ClientSession();
            cs.isActive = service.isActive();
            cs.clientBindAddress = service.hostAddress;
            cs.clientBindPort = service.hostPort;
            cs.currentStatementStatus = "LOCATOR";
            info.addClientSession(cs);
        }
    }
}

