/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.snappy;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.engine.GfxdSerializable;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.conn.GenericLanguageConnectionContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class LeadNodeExecutionContext
implements GfxdSerializable {
    private long connId;
    private String username;
    private String authToken;

    public LeadNodeExecutionContext() {
        this.connId = 0L;
    }

    public LeadNodeExecutionContext(long connId) {
        this.connId = connId;
        LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
        if (lcc != null) {
            this.username = ((GenericLanguageConnectionContext)lcc).getUserName();
            this.authToken = ((GenericLanguageConnectionContext)lcc).getAuthToken();
        }
    }

    public long getConnId() {
        return this.connId;
    }

    public String getUserName() {
        return this.username;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public byte getGfxdID() {
        return 109;
    }

    public int getDSFID() {
        return -20;
    }

    public void toData(DataOutput out) throws IOException {
        out.writeLong(this.connId);
        DataSerializer.writeString((String)this.username, (DataOutput)out);
        DataSerializer.writeString((String)this.authToken, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.connId = in.readLong();
        this.username = DataSerializer.readString((DataInput)in);
        this.authToken = DataSerializer.readString((DataInput)in);
    }

    public Version[] getSerializationVersions() {
        return new Version[0];
    }
}

