/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.conn;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TransactionFlag;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.cache.Checkpoint;
import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackArgument;
import com.gemstone.gnu.trove.THashMap;
import com.pivotal.gemfirexd.internal.catalog.DependableFinder;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.GeneralizedStatement;
import com.pivotal.gemfirexd.internal.engine.sql.compile.Token;
import com.pivotal.gemfirexd.internal.engine.sql.execute.ConstantValueSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.ConstantValueSetImpl;
import com.pivotal.gemfirexd.internal.engine.sql.execute.DistributionObserver;
import com.pivotal.gemfirexd.internal.iapi.db.Database;
import com.pivotal.gemfirexd.internal.iapi.db.TriggerExecutionContext;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.CacheManager;
import com.pivotal.gemfirexd.internal.iapi.services.cache.Cacheable;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextImpl;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedClass;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.stream.HeaderPrintWriter;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.LanguageFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.PreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.Statement;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizerFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Parser;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompilerFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.Authorizer;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Dependent;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Provider;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TriggerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorActivation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionStmtValidator;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.RunTimeStatistics;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.access.XATransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericStatement;
import com.pivotal.gemfirexd.internal.impl.sql.StatementStats;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.XPLAINTableDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CompilerContextImpl;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.conn.CachedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.conn.GenericAuthorizer;
import com.pivotal.gemfirexd.internal.impl.sql.conn.GenericStatementContext;
import com.pivotal.gemfirexd.internal.impl.sql.conn.TempTableInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AutoincrementCounter;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.InternalTriggerExecutionContext;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class GenericLanguageConnectionContext
extends ContextImpl
implements LanguageConnectionContext {
    private static final int NON_XA = 0;
    private static final int XA_ONE_PHASE = 1;
    private static final int XA_TWO_PHASE = 2;
    private final ArrayList<Activation> acts;
    private final GeneralizedStatement GEN_STMT;
    private volatile boolean unusedActs = false;
    private int maxActsSize;
    protected int bindCount;
    private boolean ddWriteMode;
    private boolean runTimeStatisticsSetting;
    private boolean create_explain_schema_objects = false;
    private Map<String, String> explain_statements = new HashMap<String, String>();
    private ArrayList<TempTableInfo> allDeclaredGlobalTempTables;
    private int currentSavepointLevel = 0;
    protected long nextCursorId;
    protected int nextSavepointId;
    private RunTimeStatistics runTimeStatisticsObject;
    private StringBuilder sb;
    private Database db;
    private final int instanceNumber;
    private String drdaID;
    private String dbname;
    private TransactionController tran;
    private final long connectionId;
    private long statementId = -1L;
    private boolean runTimeStatisticsSettingExplicit;
    private boolean explainConnection;
    private TransactionController readOnlyNestedTransaction;
    private int queryNestingDepth;
    private ArrayList<Activation> callers = new ArrayList();
    protected DataValueFactory dataFactory;
    protected LanguageFactory langFactory;
    protected TypeCompilerFactory tcf;
    protected OptimizerFactory of;
    protected final LanguageConnectionFactory connFactory;
    private final StatementContext[] statementContexts = new StatementContext[2];
    private int statementDepth;
    protected int outermostTrigger = -1;
    protected Authorizer authorizer;
    protected String userName = null;
    private String authToken = null;
    protected String currentRole;
    protected SchemaDescriptor sd;
    private SchemaDescriptor cachedInitialDefaultSchemaDescr = null;
    private int defaultIsolationLevel = 0;
    private int currentStatementContext = -1;
    protected int isolationLevel = this.defaultIsolationLevel;
    private boolean isolationLevelExplicitlySet = false;
    private boolean isolationLevelSetUsingSQLorJDBC = false;
    protected int prepareIsolationLevel = 0;
    private boolean logStatementText;
    private boolean logQueryPlan;
    private HeaderPrintWriter istream;
    private int lockEscalationThreshold;
    private ArrayList stmtValidators;
    private ArrayList triggerExecutionContexts;
    private ArrayList triggerTables;
    private boolean optimizerTrace = GemFireXDUtils.getOptimizerTrace();
    private boolean optimizerTraceHtml;
    private String lastOptimizerTraceOutput;
    private StringBuilder optimizerTraceOutput;
    private HashMap autoincrementHT;
    private boolean autoincrementUpdate;
    private long identityVal;
    private boolean identityNotNull;
    private HashMap<String, AutoincrementCounter> autoincrementCacheHashtable;
    private ParameterValueSet constantValueSet;
    private static final int ENABLE_TIMESTATS = 1;
    private static final int CONNECTION_REMOTE = 2;
    private static final int CONNECTION_REMOTE_DDL = 4;
    private static final int SKIP_LOCKS = 8;
    private static final int POS_DUP_FN = 16;
    private static final int ENABLE_STREAMING = 32;
    private static final int ENABLE_STATS = 64;
    private static final int SKIP_REGION_INITIALIZATION = 128;
    private static final int SKIP_LISTENERS = 256;
    private static final int QUERY_HDFS = 512;
    private static final int TRIGGER_BODY = 1024;
    private static final int SKIP_CONSTRAINT_CHECKS = 2048;
    private static final int ENABLE_BULK_FK_CHECKS = 4096;
    private static final int ROUTE_QUERY = 8192;
    private static final int DEFAULT_PERSISTENT = 16384;
    private static final int BUCKET_RETENTION_FOR_LOCAL_EXECUTION = 32768;
    private static final int FLAGS_DEFAULT = 0;
    private static final int FLAGS_IMMUTABLE = 318;
    private int gfxdFlags = 0;
    private EnumSet<TransactionFlag> txFlags;
    private GemFireTransaction parentTran;
    private Object contextObject;
    private StatementStats activeStats;
    private transient StatementNode qt;
    private TXState.ArrayListAppend[] pendingReadLocks;
    private final ArrayList<BaseActivation> exprActivations = new ArrayList();
    private Collection<RowLocation> referencedKeyCheckRows;
    private Set<String> droppedFKConstraints;
    private TriggerActionPSMap triggerActionPrepStmntMap;
    private GatewaySenderEventCallbackArgument gatewaySenderCallbackArg;
    private transient boolean ignoreWhereCurrentOfUnsupportedException;
    private boolean sendSingleHopInfo;
    private Set<Integer> bucketIdsForLocalExecution;
    private Region<?, ?> bucketSetForRegion;
    private boolean dbSyncToBeDone;
    private Checkpoint chkPoint;
    private Object hdfsSplit;
    private long lastStatementQueryTimeOutMillis = 0L;
    private int defaultQueryTimeOutValue = 0;
    private int ncjBatchSize = 0;
    private int ncjCacheSize = 0;

    public GenericLanguageConnectionContext(ContextManager cm, TransactionController tranCtrl, LanguageFactory lf, LanguageConnectionFactory lcf, Database db, String userName, String authToken, int instanceNumber, String drdaID, long connId, boolean isRemote, String dbname) throws StandardException {
        super(cm, "LanguageConnectionContext");
        this.acts = new ArrayList();
        short execFlags = 0;
        execFlags = GemFireXDUtils.set(execFlags, (short)2);
        execFlags = GemFireXDUtils.set(execFlags, (short)1);
        execFlags = (byte)GemFireXDUtils.set(execFlags, (short)128);
        this.GEN_STMT = new GeneralizedStatement(null, "", execFlags, null);
        this.tran = tranCtrl;
        this.dataFactory = lcf.getDataValueFactory();
        this.tcf = lcf.getTypeCompilerFactory();
        this.of = lcf.getOptimizerFactory();
        this.langFactory = lf;
        this.connFactory = lcf;
        this.db = db;
        this.userName = userName;
        this.authToken = authToken;
        this.instanceNumber = instanceNumber;
        this.drdaID = drdaID;
        this.dbname = dbname;
        String logStatementProperty = PropertyUtil.getServiceProperty(this.getTransactionCompile(), "gemfirexd.language.logStatementText");
        this.logStatementText = Boolean.valueOf(logStatementProperty);
        String logQueryPlanProperty = PropertyUtil.getServiceProperty(this.getTransactionCompile(), "gemfirexd.language.logQueryPlan");
        this.logQueryPlan = Boolean.valueOf(logQueryPlanProperty);
        this.setRunTimeStatisticsMode(this.logQueryPlan, true);
        this.lockEscalationThreshold = PropertyUtil.getServiceInt(tranCtrl, "gemfirexd.locks.escalationThreshold", 100, Integer.MAX_VALUE, 5000);
        this.stmtValidators = new ArrayList();
        this.triggerExecutionContexts = new ArrayList();
        this.triggerTables = new ArrayList();
        tranCtrl.setLanguageConnectionContext(this);
        this.connectionId = connId;
        this.setIsConnectionForRemote(isRemote);
    }

    @Override
    public void initialize() throws StandardException {
        this.authorizer = new GenericAuthorizer(IdUtil.getUserAuthorizationId(this.userName), this);
        if (this.getAuthorizationId() == null) {
            SanityManager.THROWASSERT((String)"User name is null, check the connection manager to make sure it is set reasonably");
        }
        this.setDefaultSchema(this.initDefaultSchemaDescriptor());
    }

    protected SchemaDescriptor initDefaultSchemaDescriptor() throws StandardException {
        if (this.cachedInitialDefaultSchemaDescr == null) {
            String authorizationId;
            DataDictionary dd = this.getDataDictionary();
            SchemaDescriptor sd = dd.getSchemaDescriptor(authorizationId = this.getAuthorizationId(), this.getTransactionCompile(), false);
            if (sd == null) {
                sd = new SchemaDescriptor(dd, authorizationId, authorizationId, null, false);
            }
            this.cachedInitialDefaultSchemaDescr = sd;
        }
        return this.cachedInitialDefaultSchemaDescr;
    }

    private SchemaDescriptor getInitialDefaultSchemaDescriptor() {
        return this.cachedInitialDefaultSchemaDescr;
    }

    @Override
    public boolean getLogStatementText() {
        return this.logStatementText;
    }

    @Override
    public void setLogStatementText(boolean logStatementText) {
        this.logStatementText = logStatementText;
    }

    @Override
    public boolean getLogQueryPlan() {
        return this.logQueryPlan;
    }

    @Override
    public boolean usesSqlAuthorization() {
        return this.getDataDictionary().usesSqlAuthorization();
    }

    @Override
    public int getLockEscalationThreshold() {
        return this.lockEscalationThreshold;
    }

    @Override
    public void addActivation(Activation a) throws StandardException {
        this.acts.add(a);
        if (this.acts.size() > this.maxActsSize) {
            this.maxActsSize = this.acts.size();
        }
    }

    @Override
    public void closeUnusedActivations() throws StandardException {
        if (this.unusedActs && this.acts.size() > 10) {
            this.unusedActs = false;
            for (int i = this.acts.size() - 1; i >= 0; --i) {
                Activation a1;
                if (i >= this.acts.size() || (a1 = this.acts.get(i)).isInUse()) continue;
                a1.close();
            }
        }
        if (SanityManager.TraceMemoryLeak && this.acts.size() > 10) {
            System.out.println("TraceMemoryLeak:GenericLanguageContext:activations " + this.acts.size());
        }
    }

    @Override
    public void notifyUnusedActivation() {
        this.unusedActs = true;
    }

    @Override
    public boolean checkIfAnyDeclaredGlobalTempTablesForThisConnection() {
        return this.allDeclaredGlobalTempTables != null;
    }

    @Override
    public void addDeclaredGlobalTempTable(TableDescriptor td, long conglomId) throws StandardException {
        if (this.findDeclaredGlobalTempTable(td.getName()) != null) {
            throw StandardException.newException("X0Y32.S", "Declared global temporary table", (Object)td.getName(), (Object)"Schema", (Object)"SESSION");
        }
        TempTableInfo tempTableInfo = new TempTableInfo(td, this.currentSavepointLevel, ((GemFireTransaction)this.tran).findExistingConglomerate(conglomId));
        if (this.allDeclaredGlobalTempTables == null) {
            this.allDeclaredGlobalTempTables = new ArrayList();
        }
        this.allDeclaredGlobalTempTables.add(tempTableInfo);
    }

    @Override
    public boolean dropDeclaredGlobalTempTable(String tableName) {
        TempTableInfo tempTableInfo = this.findDeclaredGlobalTempTable(tableName);
        if (tempTableInfo != null) {
            if (tempTableInfo.getDeclaredInSavepointLevel() > this.currentSavepointLevel) {
                SanityManager.THROWASSERT((String)"declared in savepoint level can not be higher than the current savepoint level");
            }
            if (tempTableInfo.getDeclaredInSavepointLevel() == this.currentSavepointLevel) {
                this.allDeclaredGlobalTempTables.remove(this.allDeclaredGlobalTempTables.indexOf(tempTableInfo));
                if (this.allDeclaredGlobalTempTables.size() == 0) {
                    this.allDeclaredGlobalTempTables = null;
                }
            } else {
                tempTableInfo.setDroppedInSavepointLevel(this.currentSavepointLevel);
            }
            return true;
        }
        return false;
    }

    private void tempTablesReleaseSavepointLevels() {
        for (int i = 0; i < this.allDeclaredGlobalTempTables.size(); ++i) {
            TempTableInfo tempTableInfo = this.allDeclaredGlobalTempTables.get(i);
            if (tempTableInfo.getDroppedInSavepointLevel() > this.currentSavepointLevel) {
                tempTableInfo.setDroppedInSavepointLevel(this.currentSavepointLevel);
            }
            if (tempTableInfo.getDeclaredInSavepointLevel() > this.currentSavepointLevel) {
                tempTableInfo.setDeclaredInSavepointLevel(this.currentSavepointLevel);
            }
            if (tempTableInfo.getModifiedInSavepointLevel() <= this.currentSavepointLevel) continue;
            tempTableInfo.setModifiedInSavepointLevel(this.currentSavepointLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tempTablesAndCommit(boolean in_xa_transaction) throws StandardException {
        for (int i = this.allDeclaredGlobalTempTables.size() - 1; i >= 0; --i) {
            TempTableInfo tempTableInfo = this.allDeclaredGlobalTempTables.get(i);
            if (tempTableInfo.getDroppedInSavepointLevel() != -1) {
                this.allDeclaredGlobalTempTables.remove(i);
                continue;
            }
            tempTableInfo.setDeclaredInSavepointLevel(-1);
            tempTableInfo.setModifiedInSavepointLevel(-1);
        }
        TransactionController xa_tran = null;
        TransactionController tran_for_drop = in_xa_transaction ? null : this.getTransactionExecute();
        try {
            for (int i = 0; i < this.allDeclaredGlobalTempTables.size(); ++i) {
                TableDescriptor td = this.allDeclaredGlobalTempTables.get(i).getTableDescriptor();
                if (!td.isOnCommitDeleteRows() || this.checkIfAnyActivationHasHoldCursor(td.getName())) continue;
                this.getDataDictionary().getDependencyManager().invalidateFor(td, 1, this);
                if (in_xa_transaction && xa_tran == null) {
                    tran_for_drop = xa_tran = this.getTransactionExecute().startNestedUserTransaction(false);
                }
                this.cleanupTempTableOnCommitOrRollback(tran_for_drop, td, true);
            }
        }
        finally {
            if (xa_tran != null) {
                xa_tran.destroy();
            }
        }
    }

    @Override
    public void resetFromPool() throws StandardException {
        this.identityNotNull = false;
        this.dropAllDeclaredGlobalTempTables();
        this.setDefaultSchema(null);
    }

    private void dropAllDeclaredGlobalTempTables() throws StandardException {
        if (this.allDeclaredGlobalTempTables == null) {
            return;
        }
        DependencyManager dm = this.getDataDictionary().getDependencyManager();
        StandardException topLevelStandardException = null;
        for (int i = 0; i < this.allDeclaredGlobalTempTables.size(); ++i) {
            try {
                TempTableInfo tempTableInfo = this.allDeclaredGlobalTempTables.get(i);
                TableDescriptor td = tempTableInfo.getTableDescriptor();
                dm.invalidateFor(td, 1, this);
                this.tran.dropConglomerate(td.getHeapConglomerateId());
                continue;
            }
            catch (StandardException e) {
                if (topLevelStandardException == null) {
                    topLevelStandardException = e;
                    continue;
                }
                try {
                    e.initCause(topLevelStandardException);
                    topLevelStandardException = e;
                    continue;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
        this.allDeclaredGlobalTempTables = null;
        try {
            this.internalCommit(true);
        }
        catch (StandardException e) {
            if (topLevelStandardException == null) {
                topLevelStandardException = e;
            }
            try {
                e.initCause(topLevelStandardException);
                topLevelStandardException = e;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (topLevelStandardException != null) {
            throw topLevelStandardException;
        }
    }

    private void tempTablesAndRollback() throws StandardException {
        for (int i = this.allDeclaredGlobalTempTables.size() - 1; i >= 0; --i) {
            TableDescriptor td;
            TempTableInfo tempTableInfo = this.allDeclaredGlobalTempTables.get(i);
            if (tempTableInfo.getDeclaredInSavepointLevel() >= this.currentSavepointLevel) {
                if (tempTableInfo.getDroppedInSavepointLevel() == -1) {
                    td = tempTableInfo.getTableDescriptor();
                    this.tran.dropConglomerate(td.getHeapConglomerateId());
                    this.allDeclaredGlobalTempTables.remove(i);
                    continue;
                }
                if (tempTableInfo.getDroppedInSavepointLevel() < this.currentSavepointLevel) continue;
                this.allDeclaredGlobalTempTables.remove(i);
                continue;
            }
            if (tempTableInfo.getDroppedInSavepointLevel() >= this.currentSavepointLevel) {
                td = tempTableInfo.getTableDescriptor();
                td = this.cleanupTempTableOnCommitOrRollback(this.getTransactionExecute(), td, false);
                tempTableInfo.setTableDescriptor(td, this.tran);
                tempTableInfo.setDroppedInSavepointLevel(-1);
                tempTableInfo.setModifiedInSavepointLevel(-1);
                this.allDeclaredGlobalTempTables.set(i, tempTableInfo);
                continue;
            }
            if (tempTableInfo.getModifiedInSavepointLevel() < this.currentSavepointLevel) continue;
            tempTableInfo.setModifiedInSavepointLevel(-1);
            td = tempTableInfo.getTableDescriptor();
            this.getDataDictionary().getDependencyManager().invalidateFor(td, 1, this);
            this.cleanupTempTableOnCommitOrRollback(this.getTransactionExecute(), td, true);
        }
        if (this.allDeclaredGlobalTempTables.size() == 0) {
            this.allDeclaredGlobalTempTables = null;
        }
    }

    private void replaceDeclaredGlobalTempTable(String tableName, TableDescriptor td) {
        TempTableInfo tempTableInfo = this.findDeclaredGlobalTempTable(tableName);
        tempTableInfo.setDroppedInSavepointLevel(-1);
        tempTableInfo.setDeclaredInSavepointLevel(-1);
        tempTableInfo.setTableDescriptor(td, this.tran);
        this.allDeclaredGlobalTempTables.set(this.allDeclaredGlobalTempTables.indexOf(tempTableInfo), tempTableInfo);
    }

    @Override
    public TableDescriptor getTableDescriptorForDeclaredGlobalTempTable(String tableName) {
        TempTableInfo tempTableInfo = this.findDeclaredGlobalTempTable(tableName);
        if (tempTableInfo == null) {
            return null;
        }
        return tempTableInfo.getTableDescriptor();
    }

    private TempTableInfo findDeclaredGlobalTempTable(String tableName) {
        if (this.allDeclaredGlobalTempTables == null) {
            return null;
        }
        for (int i = 0; i < this.allDeclaredGlobalTempTables.size(); ++i) {
            if (!this.allDeclaredGlobalTempTables.get(i).matches(tableName)) continue;
            return this.allDeclaredGlobalTempTables.get(i);
        }
        return null;
    }

    @Override
    public void markTempTableAsModifiedInUnitOfWork(String tableName) {
        TempTableInfo tempTableInfo = this.findDeclaredGlobalTempTable(tableName);
        tempTableInfo.setModifiedInSavepointLevel(this.currentSavepointLevel);
    }

    @Override
    public PreparedStatement prepareInternalStatement(SchemaDescriptor compilationSchema, String sqlText, boolean forMetaData, short execFlags, CompilerContext cc, THashMap ncjMetaData) throws StandardException {
        if (forMetaData) {
            compilationSchema = this.getDataDictionary().getSystemSchemaDescriptor();
        }
        boolean createGeneralizedStatement = cc != null;
        return this.connFactory.getStatement(compilationSchema, sqlText, execFlags, createGeneralizedStatement, ncjMetaData).prepare(this, forMetaData);
    }

    @Override
    public PreparedStatement prepareInternalStatement(String sqlText, short execFlags) throws StandardException {
        execFlags = GemFireXDUtils.set(execFlags, (short)1);
        execFlags = GemFireXDUtils.set(execFlags, (short)16);
        return this.connFactory.getStatement(this.getDefaultSchema(), sqlText, execFlags, false, null).prepare(this);
    }

    @Override
    public void removeActivation(Activation a) {
        SanityManager.ASSERT((boolean)a.isClosed(), (String)"Activation is not closed");
        this.acts.remove(a);
        if (this.maxActsSize > 20 && this.maxActsSize > 2 * this.acts.size()) {
            this.acts.trimToSize();
            this.maxActsSize = this.acts.size();
        }
    }

    @Override
    public int getActivationCount() {
        return this.acts.size();
    }

    @Override
    public CursorActivation lookupCursorActivation(String cursorName) {
        int size = this.acts.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                ResultSet rs;
                String executingCursorName;
                Activation a = this.acts.get(i);
                if (!a.isInUse() || !cursorName.equals(executingCursorName = a.getCursorName()) || (rs = a.getResultSet()) == null || rs.isClosed()) continue;
                return (CursorActivation)a;
            }
        }
        return null;
    }

    public void removeStatement(GenericStatement statement) throws StandardException {
        CacheManager statementCache = this.getLanguageConnectionFactory().getStatementCache();
        if (statementCache == null) {
            return;
        }
        Cacheable cachedItem = statementCache.findCached(statement);
        if (cachedItem != null) {
            CachedStatement cs = (CachedStatement)cachedItem;
            if (statement.getPreparedStatement() != cs.getPreparedStatement()) {
                statementCache.release(cachedItem);
            } else {
                statementCache.remove(cachedItem);
            }
        }
    }

    public PreparedStatement lookupStatement(GenericStatement statement) throws StandardException {
        GeneratedClass ac;
        CacheManager statementCache = this.getLanguageConnectionFactory().getStatementCache();
        if (statementCache == null) {
            return null;
        }
        if (this.dataDictionaryInWriteMode()) {
            return null;
        }
        Cacheable cachedItem = statementCache.find(statement);
        CachedStatement cs = (CachedStatement)cachedItem;
        GenericPreparedStatement ps = cs.getPreparedStatement();
        if (ps.upToDate() && (ac = ps.getActivationClass()) != null) {
            int currentClasses = this.getLanguageConnectionFactory().getClassFactory().getClassLoaderVersion();
            if (ac.getClassLoaderVersion() != currentClasses) {
                ps.makeInvalid(23, this);
            }
        }
        statementCache.release(cachedItem);
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompilerContext lookupGeneralizedStatement(SchemaDescriptor compilationSchema, String sqlText, short execFlags) throws StandardException {
        CompilerContext cc = this.pushCompilerContext(compilationSchema, false);
        boolean isSuccess = false;
        boolean createQueryInfo = GemFireXDUtils.isSet(execFlags, (short)2);
        long beginTime = this.getCurrentTimeMillis();
        long parseTime = 0L;
        Timestamp beginTimestamp = null;
        Timestamp endTimestamp = null;
        if (beginTime != 0L) {
            beginTimestamp = new Timestamp(beginTime);
        }
        try {
            if (createQueryInfo) {
                Parser m = cc.getMatcher();
                int result = m.matchStatement(sqlText, null);
                if (this.getRunTimeStatisticsMode()) {
                    parseTime = this.getCurrentTimeMillis();
                }
                ArrayList<Token> constantTokenList = cc.getConstantTokenLists();
                if (result < 0 || constantTokenList == null || constantTokenList.size() <= 0) {
                    CompilerContext compilerContext = null;
                    return compilerContext;
                }
                sqlText = GeneralizedStatement.generalizedStatement(sqlText, constantTokenList);
                this.constantValueSet = new ConstantValueSetImpl(null, constantTokenList, cc.getOriginalParameterTypeCompilers());
            } else {
                if (this.constantValueSet == null || this.constantValueSet.getParameterCount() <= 0) {
                    if (GemFireXDUtils.TraceStatementMatching) {
                        SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)("DataNode: Returning as there aren't any constants in query " + sqlText + " " + this.constantValueSet));
                    }
                    CompilerContext m = null;
                    return m;
                }
                assert (this.constantValueSet instanceof ConstantValueSet);
                if (GemFireXDUtils.TraceStatementMatching) {
                    SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)("DataNode: Received ConstantValueSet " + this.constantValueSet + " for " + sqlText + " to seek in statement cache"));
                }
                ((ConstantValueSet)this.constantValueSet).validate();
            }
            this.GEN_STMT.setSource(sqlText, createQueryInfo, compilationSchema, cc);
            cc.setGeneralizedQueryString(sqlText);
            GenericPreparedStatement cacheablePrepStmt = this.seekGenericPreparedStatement(this.GEN_STMT);
            if (cacheablePrepStmt != null && cacheablePrepStmt.upToDate()) {
                cc.setPreparedStatement(cacheablePrepStmt);
            }
            isSuccess = true;
        }
        finally {
            if (this.runTimeStatisticsSetting && isSuccess) {
                GenericPreparedStatement gps;
                if (parseTime != 0L) {
                    endTimestamp = new Timestamp(parseTime);
                }
                if (GemFireXDUtils.TraceStatementMatching) {
                    SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)(sqlText + " parseTime=" + parseTime + " compileTime=0 bind/optimize=0/0 beginTime=" + beginTimestamp + " endTimeStamp=" + endTimestamp));
                }
                if ((gps = cc.getPreparedStatement()) != null) {
                    gps.setCompileTimeMillis(parseTime - beginTime, -1L, -1L, -1L, -1L, this.getCurrentTimeMillis() - beginTime, beginTimestamp, endTimestamp);
                }
            }
            if (!isSuccess) {
                this.popCompilerContext(cc);
            }
            this.GEN_STMT.reset();
        }
        return cc;
    }

    @Override
    public final GenericPreparedStatement seekGenericPreparedStatement(GenericStatement statement) throws StandardException {
        Cacheable cachedItem;
        CacheManager statementCache = this.getLanguageConnectionFactory().getStatementCache();
        if (statementCache == null) {
            return null;
        }
        if (this.dataDictionaryInWriteMode()) {
            return null;
        }
        if (GemFireXDUtils.TraceStatementMatching) {
            SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)("Seeking GenericPreparedStatement " + statement + " in statement cache."));
        }
        if ((cachedItem = statementCache.findCached(statement)) == null) {
            return null;
        }
        CachedStatement cs = (CachedStatement)cachedItem;
        GenericPreparedStatement ps = cs.getPreparedStatement();
        statementCache.release(cachedItem);
        return ps;
    }

    private long getCurrentTimeMillis() {
        if (this.timeStatsEnabled()) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    @Override
    public String getUniqueCursorName() {
        return this.getNameString("SQLCUR", this.nextCursorId++);
    }

    @Override
    public String getUniqueSavepointName() {
        return this.getNameString("SAVEPT", this.nextSavepointId++);
    }

    @Override
    public int getUniqueSavepointID() {
        return this.nextSavepointId - 1;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    private String getNameString(String prefix, long number) {
        if (this.sb != null) {
            this.sb.setLength(0);
        } else {
            this.sb = new StringBuilder();
        }
        this.sb.append(prefix).append(number);
        return this.sb.toString();
    }

    @Override
    public void internalCommit(boolean commitStore) throws StandardException {
        this.doCommit(commitStore, true, 0, false, false);
    }

    @Override
    public void userCommit() throws StandardException {
        this.doCommit(true, true, 0, false, true);
    }

    @Override
    public final void internalCommitNoSync(int commitflag) throws StandardException {
        this.doCommit(true, false, commitflag, false, false);
        if (this.readOnlyNestedTransaction != null) {
            this.readOnlyNestedTransaction.commit();
        }
    }

    @Override
    public final void xaCommit(boolean onePhase) throws StandardException {
        this.doCommit(true, true, onePhase ? 1 : 2, false, true);
    }

    protected void doCommit(boolean commitStore, boolean sync, int commitflag, boolean settingIsolationLevel, boolean requestedByUser) throws StandardException {
        TransactionController tc;
        StatementContext statementContext = this.getStatementContext();
        if (requestedByUser && statementContext != null && statementContext.inUse() && statementContext.isAtomic()) {
            throw StandardException.newException("X0Y66.S", statementContext.getStatementText());
        }
        if (this.logStatementText) {
            if (this.istream == null) {
                this.istream = Monitor.getStream();
            }
            String xactId = this.tran.getTransactionIdString();
            this.istream.printlnWithHeader("(XID = " + xactId + "), " + "(SESSIONID = " + this.instanceNumber + "), " + "(DATABASE = " + this.dbname + "), " + "(DRDAID = " + this.drdaID + "), Committing");
        }
        StandardException failure = null;
        if (!requestedByUser) {
            try {
                this.endTransactionActivationHandling(false);
            }
            catch (StandardException se) {
                failure = se;
            }
        } else {
            this.endTransactionActivationHandling(false);
        }
        if (this.allDeclaredGlobalTempTables != null) {
            if (!requestedByUser) {
                try {
                    this.tempTablesAndCommit(commitflag != 0);
                }
                catch (StandardException se) {
                    failure = se;
                }
            } else {
                this.tempTablesAndCommit(commitflag != 0);
            }
        }
        this.currentSavepointLevel = 0;
        if (sync) {
            if (!requestedByUser) {
                try {
                    this.finishDDTransaction();
                }
                catch (StandardException se) {
                    failure = se;
                }
            } else {
                this.finishDDTransaction();
            }
        }
        if (this.readOnlyNestedTransaction != null) {
            SanityManager.THROWASSERT((String)"Nested transaction active!");
        }
        if ((tc = this.getTransactionExecute()) != null && commitStore) {
            try {
                if (sync) {
                    if (commitflag == 0) {
                        if (settingIsolationLevel) {
                            tc.commitForSetIsolationLevel();
                        } else {
                            tc.commit();
                        }
                    } else {
                        SanityManager.ASSERT((commitflag == 1 || commitflag == 2 ? 1 : 0) != 0, (String)"invalid commit flag");
                        ((XATransactionController)tc).xa_commit(commitflag == 1);
                    }
                } else {
                    tc.commitNoSync(commitflag);
                }
            }
            catch (StandardException se) {
                if (requestedByUser) {
                    throw se;
                }
                failure = se;
            }
            if (!requestedByUser) {
                try {
                    this.resetSavepoints();
                }
                catch (StandardException se) {
                    failure = se;
                }
            } else {
                this.resetSavepoints();
            }
        }
        for (Activation act : this.acts) {
            act.setFunctionContext(null);
        }
        if (failure != null) {
            throw failure;
        }
    }

    private TableDescriptor cleanupTempTableOnCommitOrRollback(TransactionController tc, TableDescriptor td, boolean dropAndRedeclare) throws StandardException {
        Properties properties = new Properties();
        properties.setProperty(GfxdConstants.PROPERTY_SCHEMA_NAME, "SESSION");
        properties.setProperty(GfxdConstants.PROPERTY_TABLE_NAME, "temp_{id}");
        long conglomId = tc.createConglomerate("heap", td.getEmptyExecRow().getRowArray(), null, td.getColumnCollationIds(), properties, 3);
        long cid = td.getHeapConglomerateId();
        ConglomerateDescriptor cgd = td.getConglomerateDescriptor(cid);
        td.getConglomerateDescriptorList().dropConglomerateDescriptorByUUID(cgd.getUUID());
        cgd = this.getDataDictionary().getDataDescriptorGenerator().newConglomerateDescriptor(conglomId, null, false, null, false, null, td.getUUID(), td.getSchemaDescriptor().getUUID());
        ConglomerateDescriptorList conglomList = td.getConglomerateDescriptorList();
        conglomList.add(cgd);
        td.resetHeapConglomNumber();
        if (dropAndRedeclare) {
            tc.dropConglomerate(cid);
            this.replaceDeclaredGlobalTempTable(td.getName(), td);
        }
        return td;
    }

    @Override
    public void internalRollback() throws StandardException {
        this.doRollback(false, false);
    }

    @Override
    public void userRollback() throws StandardException {
        this.doRollback(false, true);
    }

    @Override
    public void xaRollback() throws StandardException {
        this.doRollback(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRollback(boolean xa, boolean requestedByUser) throws StandardException {
        TransactionController tc;
        GemFireTransaction tran;
        StatementContext statementContext = this.getStatementContext();
        if (requestedByUser && statementContext != null && statementContext.inUse() && statementContext.isAtomic()) {
            throw StandardException.newException("X0Y67.S");
        }
        if (this.logStatementText) {
            if (this.istream == null) {
                this.istream = Monitor.getStream();
            }
            String xactId = this.tran.getTransactionIdString();
            this.istream.printlnWithHeader("(XID = " + xactId + "), " + "(SESSIONID = " + this.instanceNumber + "), " + "(DATABASE = " + this.dbname + "), " + "(DRDAID = " + this.drdaID + "), Rolling back");
        }
        StandardException failure = null;
        if (!requestedByUser) {
            try {
                this.endTransactionActivationHandling(true);
            }
            catch (StandardException se) {
                failure = se;
            }
        } else {
            this.endTransactionActivationHandling(true);
        }
        this.currentSavepointLevel = 0;
        if (this.allDeclaredGlobalTempTables != null) {
            try {
                this.tempTablesAndRollback();
            }
            catch (StandardException se) {
                if (requestedByUser) {
                    throw se;
                }
                failure = se;
            }
        }
        if (!requestedByUser) {
            try {
                this.finishDDTransaction();
            }
            catch (StandardException se) {
                failure = se;
            }
        } else {
            this.finishDDTransaction();
        }
        if (this.readOnlyNestedTransaction != null) {
            this.readOnlyNestedTransaction.destroy();
            this.readOnlyNestedTransaction = null;
            this.queryNestingDepth = 0;
        }
        if ((tran = (GemFireTransaction)(tc = this.getTransactionExecute())) != null) {
            try {
                try {
                    if (xa) {
                        tran.xa_rollback();
                    } else {
                        tran.abort(requestedByUser || this.parentTran == null);
                    }
                }
                catch (StandardException se) {
                    if (requestedByUser) {
                        throw se;
                    }
                    failure = se;
                }
                this.resetSavepoints();
            }
            catch (StandardException se) {
                if (requestedByUser) {
                    throw se;
                }
                failure = se;
            }
            finally {
                if (requestedByUser) {
                    this.cleanupNestedTransactionExecute();
                }
            }
        }
        for (Activation act : this.acts) {
            act.setFunctionContext(null);
        }
        if (failure != null) {
            throw failure;
        }
    }

    private void resetSavepoints() throws StandardException {
        ContextManager cm = this.getContextManager();
        List stmts = cm.getContextStack("StatementContext");
        int end = stmts.size();
        for (int i = 0; i < end; ++i) {
            ((StatementContext)stmts.get(i)).resetSavePoint();
        }
    }

    @Override
    public void internalRollbackToSavepoint(String savepointName, boolean refreshStyle, Object kindOfSavepoint) throws StandardException {
        TransactionController tc = this.getTransactionExecute();
        if (tc != null) {
            boolean closeConglomerates;
            if (refreshStyle) {
                closeConglomerates = true;
                this.endTransactionActivationHandling(true);
            } else {
                closeConglomerates = false;
            }
            this.currentSavepointLevel = tc.rollbackToSavePoint(savepointName, closeConglomerates, kindOfSavepoint);
        }
        if (tc != null && refreshStyle && this.allDeclaredGlobalTempTables != null) {
            this.tempTablesAndRollback();
        }
    }

    @Override
    public void releaseSavePoint(String savepointName, Object kindOfSavepoint) throws StandardException {
        TransactionController tc = this.getTransactionExecute();
        if (tc != null) {
            this.currentSavepointLevel = tc.releaseSavePoint(savepointName, kindOfSavepoint);
            if (this.allDeclaredGlobalTempTables != null) {
                this.tempTablesReleaseSavepointLevels();
            }
        }
    }

    @Override
    public void languageSetSavePoint(String savepointName, Object kindOfSavepoint) throws StandardException {
        TransactionController tc = this.getTransactionExecute();
        if (tc != null) {
            this.currentSavepointLevel = tc.setSavePoint(savepointName, kindOfSavepoint);
        }
    }

    @Override
    public void beginNestedTransaction(boolean readOnly) throws StandardException {
        if (this.readOnlyNestedTransaction == null) {
            this.readOnlyNestedTransaction = this.tran.startNestedUserTransaction(readOnly);
        }
        ++this.queryNestingDepth;
    }

    @Override
    public void commitNestedTransaction() throws StandardException {
        if (--this.queryNestingDepth == 0) {
            this.readOnlyNestedTransaction.commit();
            this.readOnlyNestedTransaction.destroy();
            this.readOnlyNestedTransaction = null;
        }
    }

    @Override
    public TransactionController getTransactionCompile() {
        return this.readOnlyNestedTransaction != null ? this.readOnlyNestedTransaction : this.tran;
    }

    @Override
    public TransactionController getTransactionExecute() {
        return this.tran;
    }

    @Override
    public DataValueFactory getDataValueFactory() {
        return this.dataFactory;
    }

    @Override
    public LanguageFactory getLanguageFactory() {
        return this.langFactory;
    }

    @Override
    public OptimizerFactory getOptimizerFactory() {
        return this.of;
    }

    @Override
    public final LanguageConnectionFactory getLanguageConnectionFactory() {
        return this.connFactory;
    }

    private boolean checkIfAnyActivationHasHoldCursor(String tableName) throws StandardException {
        for (int i = this.acts.size() - 1; i >= 0; --i) {
            Activation a = this.acts.get(i);
            if (!a.checkIfThisActivationHasHoldCursor(tableName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean verifyAllHeldResultSetsAreClosed() throws StandardException {
        ResultSet rs;
        Activation a;
        int i;
        boolean seenOpenResultSets = false;
        for (i = this.acts.size() - 1; i >= 0; --i) {
            a = this.acts.get(i);
            SanityManager.ASSERT((boolean)(a instanceof CursorActivation), (String)"a is not a CursorActivation");
            if (!a.isInUse() || !a.getResultSetHoldability() || (rs = ((CursorActivation)a).getResultSet()) == null || rs.isClosed() || !rs.returnsRows()) continue;
            seenOpenResultSets = true;
            break;
        }
        if (!seenOpenResultSets) {
            return true;
        }
        for (i = this.acts.size() - 1; i >= 0; --i) {
            a = this.acts.get(i);
            SanityManager.ASSERT((boolean)(a instanceof CursorActivation), (String)"a is not a CursorActivation");
            if (!a.isInUse() || !a.getResultSetHoldability() || (rs = ((CursorActivation)a).getResultSet()) == null || rs.isClosed() || !rs.returnsRows()) continue;
            return false;
        }
        return true;
    }

    @Override
    @SuppressWarnings(value={"DM_GC"})
    public boolean verifyNoOpenResultSets(PreparedStatement pStmt, Provider provider, int action) throws StandardException {
        ResultSet rs;
        Activation a;
        int i;
        boolean seenOpenResultSets = false;
        for (i = this.acts.size() - 1; i >= 0; --i) {
            a = this.acts.get(i);
            if (!a.isInUse() || pStmt != null && pStmt != a.getPreparedStatement() || (rs = a.getResultSet()) == null || rs.isClosed() || !rs.returnsRows()) continue;
            seenOpenResultSets = true;
            break;
        }
        if (!seenOpenResultSets) {
            return false;
        }
        System.gc();
        System.runFinalization();
        for (i = this.acts.size() - 1; i >= 0; --i) {
            ExecPreparedStatement ps;
            a = this.acts.get(i);
            if (!a.isInUse() || pStmt != null && pStmt != a.getPreparedStatement() || (rs = a.getResultSet()) == null || rs.isClosed() || provider == null || !rs.returnsRows()) continue;
            DependencyManager dmgr = this.getDataDictionary().getDependencyManager();
            if (action != 12) {
                GemFireTransaction tc;
                GemFireTransaction gemFireTransaction = tc = this.parentTran != null ? this.parentTran : (GemFireTransaction)this.tran;
                if (tc != null && tc.getLockSpace() != null && tc.getLockSpace().getNumRefs() == 0) {
                    return false;
                }
            }
            if (pStmt == null && ((ps = a.getPreparedStatement()) == null || !dmgr.isDependent(provider, ps))) continue;
            throw StandardException.newException("X0X95.S", (Object)dmgr.getActionString(action), (Object)provider.getObjectName());
        }
        return false;
    }

    @Override
    public String getAuthorizationId() {
        return this.authorizer.getAuthorizationId();
    }

    @Override
    public SchemaDescriptor getDefaultSchema() {
        return this.sd;
    }

    @Override
    public String getCurrentSchemaName() {
        if (null == this.sd) {
            return null;
        }
        return this.sd.getSchemaName();
    }

    @Override
    public void setDefaultSchema(SchemaDescriptor sd) throws StandardException {
        if (sd == null) {
            sd = this.getInitialDefaultSchemaDescriptor();
        }
        this.sd = sd;
    }

    @Override
    public boolean isInitialDefaultSchema(String schemaName) {
        return this.cachedInitialDefaultSchemaDescr.getSchemaName().equals(schemaName);
    }

    @Override
    public Long getIdentityValue() {
        return this.identityNotNull ? Long.valueOf(this.identityVal) : null;
    }

    @Override
    public void setIdentityValue(long val) {
        this.identityVal = val;
        this.identityNotNull = true;
    }

    @Override
    public final CompilerContext pushCompilerContext() {
        return this.pushCompilerContext(null, true);
    }

    @Override
    public CompilerContext pushCompilerContext(SchemaDescriptor sd, boolean isCompiling) {
        boolean firstCompilerContext = false;
        CompilerContext cc = (CompilerContext)this.getContextManager().getContext("CompilerContext");
        if (cc == null) {
            firstCompilerContext = true;
        }
        if (cc == null || cc.getInUse()) {
            cc = new CompilerContextImpl(this.getContextManager(), this, this.tcf);
            if (firstCompilerContext) {
                cc.firstOnStack();
            }
        } else {
            cc.resetContext();
        }
        cc.setInUse(true);
        StatementContext sc = this.getStatementContext();
        if (sc != null && sc.getSystemCode()) {
            cc.setReliability(0);
        }
        if (sd != null && sd.getUUID() != null) {
            cc.setCompilationSchema(sd);
        }
        return cc;
    }

    @Override
    public void popCompilerContext(CompilerContext cc) {
        cc.setCurrentDependent(null);
        cc.setInUse(false);
        if (!cc.isFirstOnStack()) {
            cc.popMe();
        } else {
            cc.setCompilationSchema(null);
        }
        cc.resetContext();
    }

    @Override
    public StatementContext pushStatementContext(boolean isAtomic, boolean isForReadOnly, String stmtText, ParameterValueSet pvs, boolean rollbackParentContext, long timeoutMillis) {
        return this.pushStatementContext(isAtomic, isForReadOnly, stmtText, pvs, rollbackParentContext, timeoutMillis, false);
    }

    @Override
    public StatementContext pushStatementContext(boolean isAtomic, boolean isForReadOnly, String stmtText, ParameterValueSet pvs, boolean rollbackParentContext, long timeoutMillis, boolean isLightWeight) {
        int parentStatementDepth = this.statementDepth;
        boolean inTrigger = false;
        boolean parentIsAtomic = false;
        StatementContext statementContext = this.statementContexts[0];
        if (statementContext == null) {
            statementContext = this.statementContexts[0] = new GenericStatementContext(this);
            this.currentStatementContext = 0;
        } else if (this.statementDepth > 0) {
            StatementContext parentStatementContext;
            if (this.statementDepth == 1) {
                statementContext = this.statementContexts[1];
                if (statementContext == null) {
                    statementContext = this.statementContexts[1] = new GenericStatementContext(this);
                } else {
                    statementContext.pushMe();
                }
                parentStatementContext = this.statementContexts[0];
                this.currentStatementContext = 1;
            } else {
                parentStatementContext = this.getStatementContext();
                statementContext = new GenericStatementContext(this);
                ++this.currentStatementContext;
            }
            inTrigger = parentStatementContext.inTrigger() || this.outermostTrigger == parentStatementDepth;
            parentIsAtomic = parentStatementContext.isAtomic();
            statementContext.setSQLAllowed(parentStatementContext.getSQLAllowed(), false);
            if (parentStatementContext.getSystemCode()) {
                statementContext.setSystemCode();
            }
        } else {
            this.currentStatementContext = 0;
        }
        this.incrementStatementDepth();
        statementContext.setInUse(inTrigger, isAtomic || parentIsAtomic, isForReadOnly, stmtText, pvs, timeoutMillis);
        if (rollbackParentContext) {
            statementContext.setParentRollback();
        }
        if (isLightWeight) {
            statementContext.setLightWeight();
        }
        return statementContext;
    }

    @Override
    public void popStatementContext(StatementContext statementContext, Throwable error) {
        if (statementContext != null) {
            if (!statementContext.inUse()) {
                return;
            }
            statementContext.clearInUse();
        }
        this.decrementStatementDepth();
        if (this.statementDepth == -1) {
            int severity = error instanceof StandardException ? ((StandardException)error).getSeverity() : 0;
            SanityManager.ASSERT((error != null ? 1 : 0) != 0, (String)"Must have error to try popStatementContext with 0 depth");
            SanityManager.ASSERT((severity == 40000 ? 1 : 0) != 0, (String)"Must have session severity error to try popStatementContext with 0 depth");
            SanityManager.ASSERT((statementContext == this.statementContexts[0] ? 1 : 0) != 0, (String)"statementContext is expected to equal statementContexts[0]");
            this.resetStatementDepth();
        } else if (this.statementDepth == 0) {
            int severity;
            int n = severity = error instanceof StandardException ? ((StandardException)error).getSeverity() : 0;
            if (error == null || severity != 40000) {
                SanityManager.ASSERT((statementContext == this.statementContexts[0] ? 1 : 0) != 0, (String)"statementContext is expected to equal statementContexts[0]");
            }
        } else {
            SanityManager.ASSERT((statementContext != this.statementContexts[0] ? 1 : 0) != 0, (String)"statementContext is not expected to equal statementContexts[0]");
            if (this.statementDepth <= 0) {
                SanityManager.THROWASSERT((String)("statement depth expected to be >0, was " + this.statementDepth));
            }
            if (this.getContextManager().getContext(statementContext.getIdName()) != statementContext) {
                SanityManager.THROWASSERT((String)"trying to pop statement context from middle of stack");
            }
            statementContext.popMe();
            --this.currentStatementContext;
        }
    }

    @Override
    public void pushExecutionStmtValidator(ExecutionStmtValidator validator) {
        this.stmtValidators.add(validator);
    }

    @Override
    public void popExecutionStmtValidator(ExecutionStmtValidator validator) throws StandardException {
        boolean foundElement = this.stmtValidators.remove(validator);
        if (!foundElement) {
            SanityManager.THROWASSERT((String)("statement validator " + validator + " not found"));
        }
    }

    @Override
    public void pushTriggerExecutionContext(TriggerExecutionContext tec) throws StandardException {
        if (this.outermostTrigger == -1) {
            this.outermostTrigger = this.statementDepth;
        }
        if (this.triggerExecutionContexts.size() >= 16) {
            throw StandardException.newException("54038");
        }
        this.triggerExecutionContexts.add(tec);
    }

    @Override
    public void popTriggerExecutionContext(TriggerExecutionContext tec) throws StandardException {
        boolean foundElement;
        if (this.outermostTrigger == this.statementDepth) {
            this.outermostTrigger = -1;
        }
        if (!(foundElement = this.triggerExecutionContexts.remove(tec))) {
            SanityManager.THROWASSERT((String)("trigger execution context " + tec + " not found"));
        }
    }

    @Override
    public TriggerExecutionContext getTriggerExecutionContext() {
        return this.triggerExecutionContexts.size() == 0 ? (TriggerExecutionContext)null : (TriggerExecutionContext)this.triggerExecutionContexts.get(this.triggerExecutionContexts.size() - 1);
    }

    @Override
    public void validateStmtExecution(ConstantAction constantAction) throws StandardException {
        SanityManager.ASSERT((constantAction != null ? 1 : 0) != 0, (String)"constantAction is null");
        if (this.stmtValidators.size() > 0) {
            Iterator it = this.stmtValidators.iterator();
            while (it.hasNext()) {
                ((ExecutionStmtValidator)it.next()).validateStatement(constantAction);
            }
        }
    }

    @Override
    public void pushTriggerTable(TableDescriptor td) {
        this.triggerTables.add(td);
    }

    @Override
    public void popTriggerTable(TableDescriptor td) {
        boolean foundElement = this.triggerTables.remove(td);
        if (!foundElement) {
            SanityManager.THROWASSERT((String)("trigger table not found: " + td));
        }
    }

    @Override
    public TableDescriptor getTriggerTable() {
        return this.triggerTables.size() == 0 ? (TableDescriptor)null : (TableDescriptor)this.triggerTables.get(this.triggerTables.size() - 1);
    }

    @Override
    public Database getDatabase() {
        return this.db;
    }

    @Override
    public int incrementBindCount() {
        ++this.bindCount;
        return this.bindCount;
    }

    @Override
    public int decrementBindCount() {
        --this.bindCount;
        if (this.bindCount < 0) {
            SanityManager.THROWASSERT((String)("Level of nested binding == " + this.bindCount));
        }
        return this.bindCount;
    }

    @Override
    public int getBindCount() {
        return this.bindCount;
    }

    @Override
    public final void setDataDictionaryWriteMode() {
        this.ddWriteMode = true;
    }

    @Override
    public final void clearDataDictionaryWriteMode() {
        this.ddWriteMode = false;
    }

    @Override
    public final boolean dataDictionaryInWriteMode() {
        return this.ddWriteMode;
    }

    @Override
    public final void setRunTimeStatisticsMode(boolean onOrOff, boolean force) {
        if (force) {
            this.runTimeStatisticsSetting = onOrOff;
        } else if (onOrOff && !this.runTimeStatisticsSetting) {
            this.runTimeStatisticsSetting = onOrOff;
            DistributionObserver.setObserver();
            Iterator<XPLAINTableDescriptor> it = XPLAINTableDescriptor.getRegisteredDescriptors();
            while (it.hasNext()) {
                XPLAINTableDescriptor t = it.next();
                this.setExplainStatement(t.getCatalogName(), t.getTableInsert());
            }
        } else if (!onOrOff && this.runTimeStatisticsSetting && !this.statsEnabled() && !this.explainConnection()) {
            this.runTimeStatisticsSetting = onOrOff;
            DistributionObserver.unsetObserver();
        }
        this.runTimeStatisticsSettingExplicit = onOrOff;
    }

    @Override
    public final boolean getRunTimeStatisticsMode() {
        return this.runTimeStatisticsSetting;
    }

    @Override
    public final void setStatisticsTiming(boolean onOrOff) {
        this.gfxdFlags = GemFireXDUtils.set(this.gfxdFlags, 1, onOrOff);
    }

    @Override
    public final boolean getStatisticsTiming() {
        return GemFireXDUtils.isSet(this.gfxdFlags, 1) | this.explainConnection();
    }

    @Override
    public void setRunTimeStatisticsObject(RunTimeStatistics runTimeStatisticsObject) {
        this.runTimeStatisticsObject = runTimeStatisticsObject;
    }

    @Override
    public RunTimeStatistics getRunTimeStatisticsObject() {
        return this.runTimeStatisticsObject;
    }

    @Override
    public int getStatementDepth() {
        return this.statementDepth;
    }

    @Override
    public boolean isIsolationLevelSetUsingSQLorJDBC() {
        return this.isolationLevelSetUsingSQLorJDBC;
    }

    @Override
    public void resetIsolationLevelFlagUsedForSQLandJDBC() {
        this.isolationLevelSetUsingSQLorJDBC = false;
    }

    @Override
    public void setIsolationLevel(int isolationLevel) throws StandardException {
        StatementContext stmtCtxt = this.getStatementContext();
        if (stmtCtxt != null && stmtCtxt.inTrigger()) {
            throw StandardException.newException("X0Y71.S", this.getTriggerExecutionContext().toString());
        }
        if (this.isolationLevel != 0 && this.isolationLevel != isolationLevel && !this.verifyAllHeldResultSetsAreClosed()) {
            throw StandardException.newException("X0X03.S");
        }
        TransactionController tc = this.getTransactionExecute();
        boolean forRemote = this.isConnectionForRemote();
        if (!tc.isIdle()) {
            if (tc.isGlobal()) {
                throw StandardException.newException("X0Y77.S");
            }
            this.doCommit(true, true, 0, true, !forRemote);
        }
        this.isolationLevel = isolationLevel;
        this.isolationLevelExplicitlySet = true;
        this.isolationLevelSetUsingSQLorJDBC = true;
        if (!forRemote) {
            int jdbcIsolationLevel = ExecutionContext.CS_TO_JDBC_ISOLATION_LEVEL_MAP[isolationLevel];
            tc.beginTransaction(GemFireXDUtils.getIsolationLevel(jdbcIsolationLevel, this.txFlags));
        }
    }

    @Override
    public int getCurrentIsolationLevel() {
        return this.isolationLevel == 0 ? this.defaultIsolationLevel : this.isolationLevel;
    }

    @Override
    public String getCurrentIsolationLevelStr() {
        if (this.isolationLevel >= 0 && this.isolationLevel < ExecutionContext.CS_TO_SQL_ISOLATION_MAP.length) {
            return ExecutionContext.CS_TO_SQL_ISOLATION_MAP[this.isolationLevel][0];
        }
        return ExecutionContext.CS_TO_SQL_ISOLATION_MAP[0][0];
    }

    @Override
    public void setPrepareIsolationLevel(int level) {
        this.prepareIsolationLevel = level;
    }

    @Override
    public int getPrepareIsolationLevel() {
        if (!this.isolationLevelExplicitlySet) {
            return this.prepareIsolationLevel;
        }
        return 0;
    }

    @Override
    public final StatementContext getStatementContext() {
        switch (this.currentStatementContext) {
            case 0: {
                return this.statementContexts[0];
            }
            case 1: {
                return this.statementContexts[1];
            }
        }
        return (StatementContext)this.getContextManager().getContext("StatementContext");
    }

    @Override
    public boolean setOptimizerTrace(boolean onOrOff) {
        if (this.of == null) {
            return false;
        }
        if (!this.of.supportsOptimizerTrace()) {
            return false;
        }
        this.optimizerTrace = onOrOff;
        return true;
    }

    @Override
    public boolean getOptimizerTrace() {
        return this.optimizerTrace;
    }

    @Override
    public boolean setOptimizerTraceHtml(boolean onOrOff) {
        if (this.of == null) {
            return false;
        }
        if (!this.of.supportsOptimizerTrace()) {
            return false;
        }
        this.optimizerTraceHtml = onOrOff;
        return true;
    }

    @Override
    public boolean getOptimizerTraceHtml() {
        return this.optimizerTraceHtml;
    }

    @Override
    public void setOptimizerTraceOutput(String startingText) {
        this.optimizerTraceOutput = new StringBuilder(startingText);
    }

    @Override
    public void appendOptimizerTraceOutput(String output) {
        this.optimizerTraceOutput = this.optimizerTraceOutput != null ? this.optimizerTraceOutput.append(output) : new StringBuilder(output);
    }

    @Override
    public String getOptimizerTraceOutput() {
        return this.optimizerTraceOutput != null ? this.optimizerTraceOutput.toString() : null;
    }

    @Override
    public boolean isTransactionPristine() {
        return this.getTransactionExecute().isPristine();
    }

    @Override
    public void cleanupOnError(Throwable error) throws StandardException {
        int severity;
        int n = severity = error instanceof StandardException ? ((StandardException)error).getSeverity() : 40000;
        if (this.statementContexts[0] != null) {
            this.statementContexts[0].clearInUse();
            if (severity >= 40000) {
                this.statementContexts[0].popMe();
                this.currentStatementContext = -1;
            }
        }
        if (this.statementContexts[1] != null) {
            this.statementContexts[1].clearInUse();
        }
        if (severity >= 40000) {
            for (int i = this.acts.size() - 1; i >= 0; --i) {
                if (i >= this.acts.size()) continue;
                Activation a = this.acts.get(i);
                a.reset(true);
                a.close();
            }
            this.popMe();
        } else if (severity >= 30000) {
            this.internalRollback();
        }
        GemFireTransaction tran = (GemFireTransaction)this.getTransactionExecute();
        if (tran != null) {
            tran.release();
        }
    }

    @Override
    public boolean isLastHandler(int severity) {
        return false;
    }

    private void endTransactionActivationHandling(boolean forRollback) throws StandardException {
        for (int i = this.acts.size() - 1; i >= 0; --i) {
            boolean resultsetReturnsRows;
            if (i >= this.acts.size()) continue;
            Activation a = this.acts.get(i);
            if (!a.isInUse()) {
                a.close();
                continue;
            }
            ResultSet activationResultSet = a.getResultSet();
            boolean bl = resultsetReturnsRows = activationResultSet != null && activationResultSet.returnsRows();
            if (forRollback) {
                ExecPreparedStatement ps;
                if (resultsetReturnsRows) {
                    a.reset(false);
                }
                if (!this.dataDictionaryInWriteMode() || (ps = a.getPreparedStatement()) == null) continue;
                ps.makeInvalid(4, this);
                continue;
            }
            if (resultsetReturnsRows) {
                if (!a.getResultSetHoldability()) {
                    activationResultSet.close(false);
                } else {
                    activationResultSet.clearCurrentRow();
                }
            }
            a.clearHeapConglomerateController();
        }
    }

    private void finishDDTransaction() throws StandardException {
        if (this.ddWriteMode) {
            DataDictionary dd = this.getDataDictionary();
            dd.transactionFinished();
            this.ddWriteMode = false;
        }
    }

    private void incrementStatementDepth() {
        ++this.statementDepth;
    }

    private void decrementStatementDepth() {
        --this.statementDepth;
    }

    protected void resetStatementDepth() {
        this.statementDepth = 0;
    }

    @Override
    public DataDictionary getDataDictionary() {
        return this.getDatabase().getDataDictionary();
    }

    @Override
    public void setReadOnly(boolean on) throws StandardException {
        if (!this.tran.isPristine()) {
            throw StandardException.newException("25501");
        }
        this.authorizer.setReadOnlyConnection(on, true);
    }

    @Override
    public boolean isReadOnly() {
        return this.authorizer.isReadOnlyConnection();
    }

    @Override
    public Authorizer getAuthorizer() {
        return this.authorizer;
    }

    @Override
    public Long lastAutoincrementValue(String schemaName, String tableName, String columnName) {
        String aiKey = AutoincrementCounter.makeIdentity(schemaName, tableName, columnName);
        int size = this.triggerExecutionContexts.size();
        for (int i = size - 1; i >= 0; --i) {
            InternalTriggerExecutionContext itec = (InternalTriggerExecutionContext)this.triggerExecutionContexts.get(i);
            Long value = itec.getAutoincrementValue(aiKey);
            if (value == null) continue;
            return value;
        }
        if (this.autoincrementHT == null) {
            return null;
        }
        return (Long)this.autoincrementHT.get(aiKey);
    }

    @Override
    public void setAutoincrementUpdate(boolean flag) {
        this.autoincrementUpdate = flag;
    }

    @Override
    public boolean getAutoincrementUpdate() {
        return this.autoincrementUpdate;
    }

    @Override
    public void autoincrementCreateCounter(String s, String t, String c, Long initialValue, long increment, int position) {
        AutoincrementCounter aic;
        String key = AutoincrementCounter.makeIdentity(s, t, c);
        if (this.autoincrementCacheHashtable == null) {
            this.autoincrementCacheHashtable = new HashMap();
        }
        if ((aic = this.autoincrementCacheHashtable.get(key)) != null) {
            SanityManager.THROWASSERT((String)("Autoincrement Counter already exists:" + key));
            return;
        }
        aic = new AutoincrementCounter(initialValue, increment, 0L, s, t, c, position);
        this.autoincrementCacheHashtable.put(key, aic);
    }

    @Override
    public long nextAutoincrementValue(String schemaName, String tableName, String columnName) throws StandardException {
        String key = AutoincrementCounter.makeIdentity(schemaName, tableName, columnName);
        AutoincrementCounter aic = this.autoincrementCacheHashtable.get(key);
        if (aic == null) {
            SanityManager.THROWASSERT((String)("counter doesn't exist:" + key));
            return 0L;
        }
        return aic.update();
    }

    @Override
    public void autoincrementFlushCache(UUID tableUUID) throws StandardException {
        if (this.autoincrementCacheHashtable == null) {
            return;
        }
        if (this.autoincrementHT == null) {
            this.autoincrementHT = new HashMap();
        }
        DataDictionary dd = this.getDataDictionary();
        for (String key : this.autoincrementCacheHashtable.keySet()) {
            AutoincrementCounter aic = this.autoincrementCacheHashtable.get(key);
            Long value = aic.getCurrentValue();
            aic.flushToDisk(this.getTransactionExecute(), dd, tableUUID);
            if (value == null) continue;
            this.autoincrementHT.put(key, value);
        }
        this.autoincrementCacheHashtable.clear();
    }

    @Override
    public void copyHashtableToAIHT(Map from) {
        if (from.isEmpty()) {
            return;
        }
        if (this.autoincrementHT == null) {
            this.autoincrementHT = new HashMap();
        }
        this.autoincrementHT.putAll(from);
    }

    @Override
    public int getInstanceNumber() {
        return this.instanceNumber;
    }

    @Override
    public String getDrdaID() {
        return this.drdaID;
    }

    @Override
    public void setDrdaID(String drdaID) {
        this.drdaID = drdaID;
    }

    @Override
    public String getDbname() {
        return this.dbname;
    }

    @Override
    public Activation getLastActivation() {
        return this.acts.get(this.acts.size() - 1);
    }

    @Override
    public StringBuilder appendErrorInfo() {
        TransactionController tc = this.getTransactionExecute();
        if (tc == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(200);
        sb.append("(XID = ");
        sb.append(tc.getTransactionIdString());
        sb.append("), ");
        sb.append("(SESSIONID = ");
        sb.append(Integer.toString(this.getInstanceNumber()));
        sb.append("), ");
        sb.append("(DATABASE = ");
        sb.append(this.getDbname());
        sb.append("), ");
        sb.append("(DRDAID = ");
        sb.append(this.getDrdaID());
        sb.append("), ");
        return sb;
    }

    @Override
    public void pushCaller(Activation a) {
        this.callers.add(a);
    }

    @Override
    public void popCaller() {
        this.callers.remove(this.callers.size() - 1);
    }

    @Override
    public Activation getCaller() {
        if (this.callers.isEmpty()) {
            return null;
        }
        return this.callers.get(this.callers.size() - 1);
    }

    @Override
    public void setCurrentRole(Activation a, String role) {
        Activation caller = a.getCallActivation();
        if (caller != null) {
            caller.setNestedCurrentRole(role);
        } else {
            this.currentRole = role;
        }
    }

    @Override
    public String getCurrentRoleId(Activation a) {
        Activation caller = a.getCallActivation();
        if (caller != null) {
            return caller.getNestedCurrentRole();
        }
        return this.currentRole;
    }

    @Override
    public final boolean explainConnection() {
        return this.explainConnection;
    }

    @Override
    public final void setExplainConnection(boolean onOrOff) {
        this.explainConnection = onOrOff;
    }

    @Override
    public final boolean getExplainSchema() {
        return this.create_explain_schema_objects;
    }

    @Override
    public void setExplainSchema(boolean s) {
        this.create_explain_schema_objects = s;
    }

    @Override
    public void setExplainStatement(String key, String stmt) {
        this.explain_statements.put(key, stmt);
    }

    @Override
    public String getExplainStatement(String key) {
        return this.explain_statements.get(key);
    }

    @Override
    public boolean explainStatementsExists() {
        for (Map.Entry<String, String> e : this.explain_statements.entrySet()) {
            if (e.getValue() != null) continue;
            SanityManager.THROWASSERT((String)("explain statements missing for " + e.getKey()));
        }
        return this.explain_statements.size() > 0;
    }

    @Override
    public void setContextObject(Object ctx) {
        this.contextObject = ctx;
    }

    @Override
    public Object getContextObject() {
        return this.contextObject;
    }

    @Override
    public final long getIdentityVal() {
        return this.identityVal;
    }

    @Override
    public boolean getRunTimeStatisticsModeExplicit() {
        return this.runTimeStatisticsSettingExplicit;
    }

    @Override
    public TXState.ArrayListAppend[] getPendingReadLocks() {
        if (this.pendingReadLocks != null) {
            return this.pendingReadLocks;
        }
        this.pendingReadLocks = new TXState.ArrayListAppend[3];
        return this.pendingReadLocks;
    }

    @Override
    public boolean isConnectionForRemote() {
        return GemFireXDUtils.isSet(this.gfxdFlags, 2);
    }

    @Override
    public final void setIsConnectionForRemote(boolean forRemote) {
        this.gfxdFlags = GemFireXDUtils.set(this.gfxdFlags, 2, forRemote);
    }

    @Override
    public boolean isConnectionForRemoteDDL() {
        return GemFireXDUtils.isSet(this.gfxdFlags, 4);
    }

    @Override
    public void setIsConnectionForRemoteDDL(boolean forRemoteDDL) {
        this.gfxdFlags = GemFireXDUtils.set(this.gfxdFlags, 4, forRemoteDDL);
    }

    @Override
    public boolean skipLocks() {
        return GemFireXDUtils.isSet(this.gfxdFlags, 8);
    }

    @Override
    public void setSkipLocks(boolean skip) {
        this.gfxdFlags = GemFireXDUtils.set(this.gfxdFlags, 8, skip);
        if (this.readOnlyNestedTransaction != null) {
            this.readOnlyNestedTransaction.setSkipLocks(skip);
        }
        this.tran.setSkipLocks(skip);
    }

    @Override
    public void setSkipLocksForConnection(boolean skip) throws StandardException {
        if (skip) {
            String authId = IdUtil.getUserAuthorizationId(this.userName);
            if (!this.getDataDictionary().getAuthorizationDatabaseOwner().equals(authId)) {
                throw StandardException.newException("08004", "administrator access required for skip-locks");
            }
        }
        if (this.readOnlyNestedTransaction != null) {
            this.readOnlyNestedTransaction.setSkipLocksForConnection(skip);
        }
        this.tran.setSkipLocksForConnection(skip);
    }

    @Override
    public boolean isPossibleDuplicate() {
        return GemFireXDUtils.isSet(this.gfxdFlags, 16);
    }

    @Override
    public void setPossibleDuplicate(boolean dup) {
        if (SanityManager.TraceClientHA | DistributionManager.VERBOSE | GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"TraceClientHA", (String)("setting posDup=" + dup + " for " + this));
        }
        this.gfxdFlags = GemFireXDUtils.set(this.gfxdFlags, 16, dup);
    }

    @Override
    public final long getConnectionId() {
        return this.connectionId;
    }

    @Override
    public void setStatementId(long id) {
        this.statementId = id;
    }

    @Override
    public long getStatementId() {
        return this.statementId;
    }

    @Override
    public void beginNestedTransactionExecute(boolean readOnly, boolean transactional, String opLogName) throws StandardException {
        if (this.parentTran != null) {
            throw StandardException.newException("XSTA2.S");
        }
        this.parentTran = (GemFireTransaction)this.tran;
        if (!transactional) {
            this.parentTran.suspendTransaction();
        }
        this.tran = this.parentTran.startNestedUserTransaction(readOnly);
    }

    @Override
    public GemFireTransaction getParentOfNestedTransactionExecute() {
        return this.parentTran;
    }

    @Override
    public void commitNestedTransactionExecute() throws StandardException {
        try {
            this.finishDDTransaction();
            this.tran.commit();
        }
        finally {
            this.cleanupNestedTransactionExecute();
        }
    }

    @Override
    public void abortNestedTransactionExecute() throws StandardException {
        this.finishDDTransaction();
        ((GemFireTransaction)this.tran).abort(false);
    }

    @Override
    public void cleanupNestedTransactionExecute() {
        if (this.parentTran != null) {
            try {
                this.tran.destroy();
            }
            finally {
                GemFireTransaction pt = this.parentTran;
                if (pt != null) {
                    this.tran = pt;
                    this.parentTran = null;
                    pt.resumeTransactionIfSuspended();
                }
            }
        }
    }

    @Override
    public final void internalCleanup() throws StandardException {
        TransactionController tc;
        this.finishDDTransaction();
        if (this.readOnlyNestedTransaction != null) {
            this.readOnlyNestedTransaction.destroy();
            this.readOnlyNestedTransaction = null;
            this.queryNestingDepth = 0;
        }
        if ((tc = this.getTransactionExecute()) != null) {
            ((GemFireTransaction)tc).internalCleanup();
            this.resetSavepoints();
        }
    }

    @Override
    public void setEnableStreaming(boolean enableStreaming) {
        this.gfxdFlags = GemFireXDUtils.set(this.gfxdFlags, 32, enableStreaming);
    }

    @Override
    public boolean streamingEnabled() {
        return GemFireXDUtils.isSet(this.gfxdFlags, 32);
    }

    @Override
    public void setSkipListeners() {
        this.gfxdFlags = GemFireXDUtils.set(this.gfxdFlags, 256);
    }

    @Override
    public boolean isSkipListeners() {
        return GemFireXDUtils.isSet(this.gfxdFlags, 256);
    }

    @Override
    public void setTXFlags(EnumSet<TransactionFlag> flags) {
        this.txFlags = flags;
    }

    @Override
    public EnumSet<TransactionFlag> getTXFlags() {
        return this.txFlags;
    }

    @Override
    public void setActiveStats(StatementStats stats) {
        this.activeStats = stats;
    }

    @Override
    public StatementStats getActiveStats() {
        return this.activeStats;
    }

    @Override
    public final void setStatsEnabled(boolean enableStats, boolean enableTimeStats, boolean explainConnection) {
        if (!enableStats) {
            if (this.statsEnabled()) {
                this.gfxdFlags = GemFireXDUtils.clear(this.gfxdFlags, 65);
                this.activeStats = null;
            }
        } else {
            this.gfxdFlags = GemFireXDUtils.set(this.gfxdFlags, 64);
            this.gfxdFlags = GemFireXDUtils.set(this.gfxdFlags, 1, enableTimeStats);
        }
        if (explainConnection) {
            this.setExplainConnection(true);
        } else {
            this.setExplainConnection(false);
        }
        this.setRunTimeStatisticsMode(enableStats || explainConnection, false);
    }

    @Override
    public final boolean statsEnabled() {
        return GemFireXDUtils.isSet(this.gfxdFlags, 64);
    }

    @Override
    public final boolean timeStatsEnabled() {
        return GemFireXDUtils.isSet(this.gfxdFlags, 1) | this.explainConnection();
    }

    @Override
    public void setEnableBulkFkChecks(boolean enableBulkFkChecks) {
        this.gfxdFlags = GemFireXDUtils.set(this.gfxdFlags, 4096, enableBulkFkChecks);
    }

    @Override
    public boolean bulkFkChecksEnabled() {
        return GemFireXDUtils.isSet(this.gfxdFlags, 4096);
    }

    @Override
    public ArrayList<Activation> getAllActivations() {
        return this.acts;
    }

    @Override
    public Statement createGenericStatement(String sqlText) {
        short execFlags = 0;
        execFlags = GemFireXDUtils.set(execFlags, (short)1);
        execFlags = GemFireXDUtils.set(execFlags, (short)16);
        return this.connFactory.getStatement(this.getDefaultSchema(), sqlText, execFlags, false, null);
    }

    public void setBucketRetentionForLocalExecution(boolean bucketRetentionForLocalExecution) {
        this.gfxdFlags = GemFireXDUtils.set(this.gfxdFlags, 32768, bucketRetentionForLocalExecution);
    }

    @Override
    public PreparedStatement getTriggerActionPrepStmnt(TriggerDescriptor td, String actionText) throws StandardException {
        PreparedStatement ps = null;
        if (this.triggerActionPrepStmntMap == null) {
            UUID id = this.getDataDictionary().getUUIDFactory().createUUID();
            this.triggerActionPrepStmntMap = new TriggerActionPSMap(id);
        } else {
            ps = this.triggerActionPrepStmntMap.get(td);
        }
        if (ps == null) {
            this.getDataDictionary().getDependencyManager().addDependency(this.triggerActionPrepStmntMap, td, this.getContextManager());
            ps = this.makePreparedStatement(td, actionText);
        }
        return ps;
    }

    private PreparedStatement makePreparedStatement(TriggerDescriptor td, String actionText) throws StandardException {
        short execFlags = 0;
        execFlags = GemFireXDUtils.set(execFlags, (short)2);
        PreparedStatement ps = this.prepareInternalStatement(actionText, execFlags);
        if (GemFireXDUtils.TraceTrigger) {
            Activation act = ps.getActivation(this, false, null);
            SanityManager.DEBUG_PRINT((String)"TraceTrigger", (String)("GfxdIndexManager#fireTriggers: making trigger prepared statement for table: " + td.getTableDescriptor().getName() + " event type: " + td.getTriggerDefinition() + " activation: " + act + " and paramatervalueset: " + act.getParameterValueSet() + " actionTxt: " + actionText));
            act.close();
        }
        this.triggerActionPrepStmntMap.put(td, ps);
        return ps;
    }

    @Override
    public void setConstantValueSet(CompilerContext cc, ParameterValueSet constantValues) {
        if (cc == null) {
            this.constantValueSet = constantValues;
            if (GemFireXDUtils.TraceStatementMatching) {
                SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)("LCC: set constantValueSet " + this.constantValueSet));
            }
            return;
        }
        DataTypeDescriptor[] constantDescriptors = cc.getParameterTypes();
        ArrayList<Token> constantTokenList = cc.getConstantTokenLists();
        if (constantTokenList != null && constantTokenList.size() > 0) {
            assert (constantValues == null);
            this.constantValueSet = new ConstantValueSetImpl(null, constantTokenList, cc.getOriginalParameterTypeCompilers());
        } else if (this.constantValueSet != null) {
            assert (this.constantValueSet instanceof ConstantValueSet) : this.constantValueSet.toString();
            ((ConstantValueSet)this.constantValueSet).refreshTypes(constantDescriptors);
        }
        if (GemFireXDUtils.TraceStatementMatching) {
            SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)("LCC: set constantValueSet " + this.constantValueSet));
        }
    }

    @Override
    public ParameterValueSet getConstantValueSet(Activation activation) {
        if (this.constantValueSet == null || this.constantValueSet.getParameterCount() <= 0) {
            return null;
        }
        if (activation != null) {
            assert (this.constantValueSet instanceof ConstantValueSet);
            ((ConstantValueSet)this.constantValueSet).setActivation(activation);
        }
        if (GemFireXDUtils.TraceStatementMatching) {
            SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)("LCC: returning constantValueSet " + this.constantValueSet));
        }
        return this.constantValueSet;
    }

    @Override
    public void unlinkConstantValueSet() {
        if (GemFireXDUtils.TraceStatementMatching) {
            SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)("LCC: clearing constantValueSet " + this.constantValueSet));
        }
        this.constantValueSet = null;
    }

    @Override
    public void setGatewaySenderEventCallbackArg(GatewaySenderEventCallbackArgument arg) {
        this.gatewaySenderCallbackArg = arg;
    }

    @Override
    public GatewaySenderEventCallbackArgument getGatewaySenderEventCallbackArg() {
        return this.gatewaySenderCallbackArg;
    }

    @Override
    public BaseActivation getExpressionActivation(GeneratedClass gc, int resolverId) throws StandardException {
        BaseActivation act = null;
        int size = this.exprActivations.size();
        if (resolverId >= size) {
            this.exprActivations.ensureCapacity(resolverId + 1);
            for (int index = size; index <= resolverId; ++index) {
                this.exprActivations.add(null);
            }
        } else {
            act = this.exprActivations.get(resolverId);
        }
        if (act == null) {
            act = (BaseActivation)gc.newInstance(this, true, null);
            this.exprActivations.set(resolverId, act);
        }
        return act;
    }

    @Override
    public MemConglomerate getConglomerateForDeclaredGlobalTempTable(long conglomId) {
        if (this.allDeclaredGlobalTempTables == null) {
            return null;
        }
        for (TempTableInfo tabInfo : this.allDeclaredGlobalTempTables) {
            if (!tabInfo.matches(conglomId)) continue;
            return tabInfo.getConglom();
        }
        return null;
    }

    @Override
    public void setReferencedKeyCheckRows(Collection<RowLocation> rows) {
        this.referencedKeyCheckRows = rows;
    }

    @Override
    public Collection<RowLocation> getReferencedKeyCheckRows() {
        return this.referencedKeyCheckRows;
    }

    @Override
    public final void setTransientStatementNode(StatementNode qt) {
        this.qt = qt;
    }

    @Override
    public final StatementNode getTransientStatementNode() {
        return this.qt;
    }

    @Override
    public void setLastStatementQueryTimeOut(long timeOutMillis) {
        this.lastStatementQueryTimeOutMillis = timeOutMillis;
    }

    @Override
    public long getQueryTimeOutForLastUsedStatement() {
        return this.lastStatementQueryTimeOutMillis;
    }

    @Override
    public void setDefaultQueryTimeOut(int timeout) {
        this.defaultQueryTimeOutValue = timeout;
    }

    @Override
    public int getDeafultQueryTimeOut() {
        return this.defaultQueryTimeOutValue;
    }

    @Override
    public void setNcjBatchSize(int batchSize) {
        this.ncjBatchSize = batchSize;
    }

    @Override
    public int getNcjBatchSize() {
        return this.ncjBatchSize;
    }

    @Override
    public void setNcjCacheSize(int cacheSize) {
        this.ncjCacheSize = cacheSize;
    }

    @Override
    public int getNcjCacheSize() {
        return this.ncjCacheSize;
    }

    @Override
    public void setIgnoreWhereCurrentOfUnsupportedException(boolean b) {
        this.ignoreWhereCurrentOfUnsupportedException = b;
    }

    @Override
    public int getFlags() {
        return this.gfxdFlags;
    }

    @Override
    public void setFlags(int flags) {
        int immutableFlags = this.gfxdFlags & 0x13E;
        this.gfxdFlags = flags & 0xFFFFFEC1;
        this.gfxdFlags |= immutableFlags;
    }

    @Override
    public boolean ignoreWhereCurrentOfUnsupportedException() {
        return this.ignoreWhereCurrentOfUnsupportedException;
    }

    @Override
    public void setSendSingleHopInformation(boolean b) {
        this.sendSingleHopInfo = b;
    }

    @Override
    public boolean getSendSingleHopInformation() {
        return this.sendSingleHopInfo;
    }

    @Override
    public void setExecuteLocally(Set<Integer> bucketIds, Region<?, ?> region, boolean dbSync, Checkpoint cp) {
        if (bucketIds == null && GemFireXDUtils.isSet(this.gfxdFlags, 32768)) {
            return;
        }
        this.forceSetExecuteLocally(bucketIds, region, dbSync, cp);
    }

    private void forceSetExecuteLocally(Set<Integer> bucketIds, Region<?, ?> region, boolean dbSync, Checkpoint cp) {
        if (SanityManager.TraceSingleHop) {
            SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("GenericLanguageConnectionContext::setExecuteLocally setting bucketSet in lcc: " + this + " to: " + bucketIds));
        }
        this.bucketIdsForLocalExecution = bucketIds;
        this.bucketSetForRegion = region;
        this.dbSyncToBeDone = dbSync;
        this.chkPoint = cp;
    }

    @Override
    public void clearExecuteLocally() {
        this.forceSetExecuteLocally(null, null, false, null);
    }

    @Override
    public Set<Integer> getBucketIdsForLocalExecution() {
        return this.bucketIdsForLocalExecution;
    }

    @Override
    public Region<?, ?> getRegionForBucketSet() {
        return this.bucketSetForRegion;
    }

    @Override
    public void setSkipRegionInitialization(boolean flag) {
        this.gfxdFlags = GemFireXDUtils.set(this.gfxdFlags, 128, flag);
    }

    @Override
    public boolean skipRegionInitialization() {
        return GemFireXDUtils.isSet(this.gfxdFlags, 128);
    }

    @Override
    public boolean dbSyncToBeDone() {
        return this.dbSyncToBeDone;
    }

    @Override
    public void setQueryHDFS(boolean queryHDFS) {
        this.gfxdFlags = queryHDFS ? GemFireXDUtils.set(this.gfxdFlags, 512) : GemFireXDUtils.clear(this.gfxdFlags, 512);
    }

    @Override
    public boolean getQueryHDFS() {
        return GemFireXDUtils.isSet(this.gfxdFlags, 512);
    }

    @Override
    public void setSkipConstraintChecks(boolean skipConstraints) {
        this.gfxdFlags = skipConstraints ? GemFireXDUtils.set(this.gfxdFlags, 2048) : GemFireXDUtils.clear(this.gfxdFlags, 2048);
    }

    @Override
    public boolean isSkipConstraintChecks() {
        return GemFireXDUtils.isSet(this.gfxdFlags, 2048);
    }

    @Override
    public void setHDFSSplit(Object split) {
        this.hdfsSplit = split;
    }

    @Override
    public boolean isTriggerBody() {
        return GemFireXDUtils.isSet(this.gfxdFlags, 1024);
    }

    @Override
    public void setTriggerBody(boolean flag) {
        this.gfxdFlags = GemFireXDUtils.set(this.gfxdFlags, 1024, flag);
    }

    @Override
    public Object getHDFSSplit() {
        return this.hdfsSplit;
    }

    @Override
    public void setDroppedFKConstraints(Set<String> s) {
        this.droppedFKConstraints = s;
    }

    @Override
    public Set<String> getDroppedFKConstraints() {
        return this.droppedFKConstraints;
    }

    @Override
    public void setQueryRouting(boolean routeQuery) {
        this.gfxdFlags = GemFireXDUtils.set(this.gfxdFlags, 8192, routeQuery);
    }

    @Override
    public boolean isQueryRoutingEnabled() {
        return GemFireXDUtils.isSet(this.gfxdFlags, 8192);
    }

    @Override
    public void setDefaultPersistent(boolean b) {
        this.gfxdFlags = GemFireXDUtils.set(this.gfxdFlags, 16384, b);
    }

    @Override
    public boolean isDefaultPersistent() {
        return GemFireXDUtils.isSet(this.gfxdFlags, 16384);
    }

    @Override
    public Checkpoint getCheckpoint() {
        return this.chkPoint;
    }

    public static class TriggerActionPSMap
    implements Dependent {
        private final HashMap<TriggerDescriptor, PreparedStatement> map = new HashMap();
        private final UUID oid;

        TriggerActionPSMap(UUID id) {
            this.oid = id;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        }

        @Override
        public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
            assert (p instanceof TriggerDescriptor);
            TriggerDescriptor td = (TriggerDescriptor)p;
            this.map.remove(td);
        }

        @Override
        public String getClassType() {
            return "TriggerMap";
        }

        @Override
        public DependableFinder getDependableFinder() {
            return null;
        }

        @Override
        public UUID getObjectID() {
            return this.oid;
        }

        @Override
        public String getObjectName() {
            return null;
        }

        @Override
        public boolean isDescriptorPersistent() {
            return false;
        }

        public PreparedStatement get(TriggerDescriptor td) {
            return this.map.get(td);
        }

        public void put(TriggerDescriptor td, PreparedStatement ps) {
            this.map.put(td, ps);
        }

        public void remove(TriggerDescriptor td) {
            this.map.remove(td);
        }
    }
}

