/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.gemstone.gnu.trove.TIntArrayList;
import com.pivotal.gemfirexd.internal.catalog.types.ReferencedColumnsDescriptorImpl;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.AccessPath;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RequiredRowOrdering;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VirtualColumnNode;
import java.util.Vector;

public class IndexToBaseRowNode
extends FromTable {
    protected FromBaseTable source;
    protected ConglomerateDescriptor baseCD;
    protected boolean cursorTargetTable;
    protected PredicateList restrictionList;
    protected boolean forUpdate;
    private FormatableBitSet heapReferencedCols;
    private FormatableBitSet indexReferencedCols;
    private FormatableBitSet allReferencedCols;
    private FormatableBitSet heapOnlyReferencedCols;
    private boolean delayScanOpening = false;

    @Override
    public void init(Object source, Object baseCD, Object resultColumns, Object cursorTargetTable, Object heapReferencedCols, Object indexReferencedCols, Object restrictionList, Object forUpdate, Object tableProperties) {
        super.init(null, tableProperties);
        this.source = (FromBaseTable)source;
        this.baseCD = (ConglomerateDescriptor)baseCD;
        this.resultColumns = (ResultColumnList)resultColumns;
        this.cursorTargetTable = (Boolean)cursorTargetTable;
        this.restrictionList = (PredicateList)restrictionList;
        this.forUpdate = (Boolean)forUpdate;
        this.heapReferencedCols = (FormatableBitSet)heapReferencedCols;
        this.indexReferencedCols = (FormatableBitSet)indexReferencedCols;
        if (this.indexReferencedCols == null) {
            this.allReferencedCols = this.heapReferencedCols;
            this.heapOnlyReferencedCols = this.heapReferencedCols;
        } else {
            this.allReferencedCols = new FormatableBitSet(this.heapReferencedCols);
            this.allReferencedCols.or(this.indexReferencedCols);
            this.heapOnlyReferencedCols = new FormatableBitSet(this.allReferencedCols);
            this.heapOnlyReferencedCols.xor(this.indexReferencedCols);
        }
    }

    @Override
    public boolean forUpdate() {
        return this.source.forUpdate();
    }

    @Override
    public AccessPath getTrulyTheBestAccessPath() {
        return this.source.getTrulyTheBestAccessPath();
    }

    @Override
    public CostEstimate getCostEstimate() {
        return this.source.getTrulyTheBestAccessPath().getCostEstimate();
    }

    @Override
    public CostEstimate getFinalCostEstimate() {
        return this.source.getFinalCostEstimate();
    }

    @Override
    boolean isOrderedOn(ColumnReference[] crs, boolean permuteOrdering, Vector fbtVector) throws StandardException {
        return this.source.isOrderedOn(crs, permuteOrdering, fbtVector);
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.assignResultSetNumber();
        int heapColRefItem = -1;
        if (this.heapReferencedCols != null) {
            heapColRefItem = acb.addItem(this.heapReferencedCols);
        }
        int allColRefItem = -1;
        if (this.allReferencedCols != null) {
            allColRefItem = acb.addItem(this.allReferencedCols);
        }
        int heapOnlyColRefItem = -1;
        if (this.heapOnlyReferencedCols != null) {
            heapOnlyColRefItem = acb.addItem(this.heapOnlyReferencedCols);
        }
        if (this.source.isGFEResultSet()) {
            GemFireContainer container;
            RowFormatter rf;
            acb.pushGetResultSetFactoryExpression(mb);
            acb.pushThisAsActivation(mb);
            MethodBuilder resultRowAllocator = this.resultColumns.generateHolderMethod(acb, this.allReferencedCols, null);
            acb.pushMethodReference(mb, resultRowAllocator);
            mb.push(this.resultSetNumber);
            int rowFormatterItem = -1;
            int fixedColsItem = -1;
            int varColsItem = -1;
            int lobColsItem = -1;
            int allColsItem = -1;
            int allColsWithLobsItem = -1;
            if (this.allReferencedCols != null && (rf = (container = Misc.getMemStore().getContainer(ContainerKey.valueOf(0L, this.baseCD.getConglomerateNumber()))).getRowFormatter(this.allReferencedCols)) != null) {
                TIntArrayList fixedCols = new TIntArrayList();
                TIntArrayList varCols = new TIntArrayList();
                TIntArrayList lobCols = new TIntArrayList();
                TIntArrayList allCols = new TIntArrayList();
                TIntArrayList allColsWithLobs = new TIntArrayList();
                rf.getColumnPositions(fixedCols, varCols, lobCols, allCols, allColsWithLobs);
                rowFormatterItem = acb.addItem(rf);
                if (fixedCols.size() > 0) {
                    fixedColsItem = acb.addItem(fixedCols.toNativeArray());
                }
                if (varCols.size() > 0) {
                    varColsItem = acb.addItem(varCols.toNativeArray());
                }
                if (lobCols.size() > 0) {
                    lobColsItem = acb.addItem(lobCols.toNativeArray());
                }
                if (allCols.size() > 0) {
                    allColsItem = acb.addItem(allCols.toNativeArray());
                }
                assert (allColsWithLobs.size() > 0);
                allColsWithLobsItem = acb.addItem(allColsWithLobs.toNativeArray());
            }
            mb.push(rowFormatterItem);
            mb.push(fixedColsItem);
            mb.push(varColsItem);
            mb.push(lobColsItem);
            mb.push(allColsItem);
            mb.push(allColsWithLobsItem);
            mb.push(this.getCompilerContext().getScanIsolationLevel());
            mb.push(this.forUpdate);
            mb.push(acb.addItem(this.source.getQueryInfo()));
            mb.callMethod((short)185, null, "getGFEResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 12);
            return;
        }
        ValueNode restriction = null;
        this.costEstimate = this.getFinalCostEstimate();
        if (this.restrictionList != null) {
            restriction = this.restrictionList.restorePredicates();
            this.restrictionList = null;
        }
        int indexColMapItem = acb.addItem(new ReferencedColumnsDescriptorImpl(this.getIndexColMapping()));
        long heapConglomNumber = this.baseCD.getConglomerateNumber();
        StaticCompiledOpenConglomInfo scoci = this.getLanguageConnectionContext().getTransactionCompile().getStaticCompiledConglomInfo(heapConglomNumber);
        acb.pushGetResultSetFactoryExpression(mb);
        mb.push(heapConglomNumber);
        mb.push(acb.addItem(scoci));
        this.source.generate(acb, mb);
        mb.upCast("com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet");
        this.resultColumns.generateHolder(acb, mb, this.heapReferencedCols, this.indexReferencedCols);
        mb.push(this.resultSetNumber);
        mb.push(this.source.getBaseTableName());
        mb.push(heapColRefItem);
        mb.push(allColRefItem);
        mb.push(heapOnlyColRefItem);
        mb.push(indexColMapItem);
        if (restriction == null) {
            mb.pushNull("com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder userExprFun = acb.newUserExprFun();
            restriction.generate(acb, userExprFun);
            userExprFun.methodReturn();
            userExprFun.complete();
            acb.pushMethodReference(mb, userExprFun);
        }
        mb.push(this.forUpdate);
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.push(this.delayScanOpening);
        mb.callMethod((short)185, null, "getIndexRowToBaseRowResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 15);
        if (this.cursorTargetTable) {
            acb.rememberCursorTarget(mb);
        }
    }

    @Override
    public boolean isOneRowResultSet() throws StandardException {
        return this.source.isOneRowResultSet();
    }

    @Override
    public boolean isNotExists() {
        return this.source.isNotExists();
    }

    @Override
    void decrementLevel(int decrement) {
        this.source.decrementLevel(decrement);
    }

    @Override
    public int updateTargetLockMode() {
        return this.source.updateTargetLockMode();
    }

    @Override
    void adjustForSortElimination() {
        this.source.disableBulkFetch();
    }

    @Override
    void adjustForSortElimination(RequiredRowOrdering rowOrdering) throws StandardException {
        this.adjustForSortElimination();
        this.source.adjustForSortElimination(rowOrdering);
    }

    private int[] getIndexColMapping() {
        int rclSize = this.resultColumns.size();
        int[] indexColMapping = new int[rclSize];
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(index);
            if (this.indexReferencedCols != null && rc.getExpression() instanceof VirtualColumnNode) {
                VirtualColumnNode vcn = (VirtualColumnNode)rc.getExpression();
                indexColMapping[index] = vcn.getSourceColumn().getVirtualColumnId() - 1;
                continue;
            }
            indexColMapping[index] = -1;
        }
        return indexColMapping;
    }

    public FromBaseTable getSource() {
        return this.source;
    }

    public ReferencedColumnsDescriptorImpl getRefColDescImpl() {
        return new ReferencedColumnsDescriptorImpl(this.getIndexColMapping());
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.source != null) {
            this.printLabel(depth, "source: \n");
            this.source.printSubNodes(depth + 1);
        }
        if (this.restrictionList != null) {
            this.printLabel(depth, "restrictionList: ");
            this.restrictionList.treePrint(depth);
        }
    }

    @Override
    public void delayScanOpening(boolean delay) {
        this.delayScanOpening = delay;
    }

    @Override
    protected void optimizeForOffHeap(boolean shouldOptimize) {
        shouldOptimize = shouldOptimize || !this.isWholeRowNeeded();
        this.source.optimizeForOffHeap(shouldOptimize);
    }

    private boolean isWholeRowNeeded() {
        TableDescriptor td = this.source.tableDescriptor;
        boolean getWholeRow = false;
        if (td != null) {
            int numCols = td.getNumberOfColumns();
            getWholeRow = true;
            if (this.allReferencedCols != null) {
                for (int i = 0; i < numCols; ++i) {
                    if (this.allReferencedCols.isSet(i)) continue;
                    getWholeRow = false;
                    break;
                }
            }
        }
        if (getWholeRow) {
            getWholeRow = this.allReferencedCols == null && this.heapReferencedCols == null || this.allReferencedCols != null && this.allReferencedCols.equals(this.heapReferencedCols);
        }
        return getWholeRow;
    }

    @Override
    protected FromBaseTable ncjGetOnlyOneFBTNode() throws StandardException {
        return this.getSource();
    }
}

