/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.ProviderList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableElementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Properties;

public class ConstraintDefinitionNode
extends TableElementNode {
    private TableName constraintName;
    protected int constraintType;
    protected Properties properties;
    ProviderList apl;
    UUIDFactory uuidFactory;
    String backingIndexName;
    UUID backingIndexUUID;
    int[] checkColumnReferences;
    ResultColumnList columnList;
    String constraintText;
    ValueNode checkCondition;
    private int behavior;
    private int verifyType = 5;

    @Override
    public void init(Object constraintName, Object constraintType, Object rcl, Object properties, Object checkCondition, Object constraintText, Object behavior) {
        this.constraintName = (TableName)constraintName;
        super.init(null);
        if (this.constraintName != null) {
            this.name = this.constraintName.getTableName();
        }
        this.constraintType = (Integer)constraintType;
        this.properties = (Properties)properties;
        this.columnList = (ResultColumnList)rcl;
        this.checkCondition = (ValueNode)checkCondition;
        this.constraintText = (String)constraintText;
        this.behavior = (Integer)behavior;
    }

    @Override
    public void init(Object constraintName, Object constraintType, Object rcl, Object properties, Object checkCondition, Object constraintText) {
        this.init(constraintName, constraintType, rcl, properties, checkCondition, constraintText, ReuseFactory.getInteger(2));
    }

    @Override
    public void init(Object constraintName, Object constraintType, Object rcl, Object properties, Object checkCondition, Object constraintText, Object behavior, Object verifyType) {
        this.init(constraintName, constraintType, rcl, properties, checkCondition, constraintText, behavior);
        this.verifyType = (Integer)verifyType;
    }

    @Override
    public String toString() {
        return "constraintName: " + (this.constraintName != null ? this.constraintName.toString() : "null") + "\nconstraintType: " + this.constraintType + "\nproperties: " + (this.properties != null ? this.properties.toString() : "null") + "\n" + super.toString();
    }

    protected void bind(DDLStatementNode ddlNode, DataDictionary dd) throws StandardException {
        if (this.constraintType == 5) {
            return;
        }
        if (this.constraintName != null) {
            String constraintSchema = this.constraintName.getSchemaName();
            if (constraintSchema != null) {
                TableName tableName = ddlNode.getObjectName();
                String tableSchema = tableName.getSchemaName();
                if (tableSchema == null) {
                    tableSchema = this.getSchemaDescriptor(null).getSchemaName();
                    tableName.setSchemaName(tableSchema);
                }
                if (!constraintSchema.equals(tableSchema)) {
                    throw StandardException.newException("42X85", (Object)this.constraintName, (Object)tableName);
                }
            }
        } else {
            this.name = this.getBackingIndexName(dd);
        }
    }

    String getConstraintMoniker() {
        return this.name;
    }

    String getDropSchemaName() {
        if (this.constraintName != null) {
            return this.constraintName.getSchemaName();
        }
        return null;
    }

    UUID getBackingIndexUUID() {
        if (this.backingIndexUUID == null) {
            this.backingIndexUUID = this.getUUIDFactory().createUUID();
        }
        return this.backingIndexUUID;
    }

    String getBackingIndexName(DataDictionary dd) {
        if (this.backingIndexName == null) {
            this.backingIndexName = dd.getSystemSQLName();
        }
        return this.backingIndexName;
    }

    void setAuxiliaryProviderList(ProviderList apl) {
        this.apl = apl;
    }

    public ProviderList getAuxiliaryProviderList() {
        return this.apl;
    }

    @Override
    boolean hasPrimaryKeyConstraint() {
        return this.constraintType == 2;
    }

    @Override
    boolean hasUniqueKeyConstraint() {
        return this.constraintType == 3;
    }

    @Override
    boolean hasForeignKeyConstraint() {
        return this.constraintType == 6;
    }

    @Override
    boolean hasCheckConstraint() {
        return this.constraintType == 4;
    }

    @Override
    boolean hasConstraint() {
        return true;
    }

    boolean requiresBackingIndex() {
        switch (this.constraintType) {
            case 2: 
            case 3: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    boolean requiresUniqueIndex() {
        switch (this.constraintType) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public int getConstraintType() {
        return this.constraintType;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean isReferenced() {
        return false;
    }

    public int getReferenceCount() {
        return 0;
    }

    public boolean isEnabled() {
        return true;
    }

    public ResultColumnList getColumnList() {
        return this.columnList;
    }

    public void setColumnList(ResultColumnList columnList) {
        this.columnList = columnList;
    }

    public ValueNode getCheckCondition() {
        return this.checkCondition;
    }

    public void setCheckCondition(ValueNode checkCondition) {
        this.checkCondition = checkCondition;
    }

    public String getConstraintText() {
        return this.constraintText;
    }

    public int[] getCheckColumnReferences() {
        return this.checkColumnReferences;
    }

    public void setCheckColumnReferences(int[] checkColumnReferences) {
        this.checkColumnReferences = checkColumnReferences;
    }

    int getDropBehavior() {
        return this.behavior;
    }

    int getVerifyType() {
        return this.verifyType;
    }

    private UUIDFactory getUUIDFactory() {
        if (this.uuidFactory == null) {
            this.uuidFactory = Monitor.getMonitor().getUUIDFactory();
        }
        return this.uuidFactory;
    }
}

