/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.pivotal.gemfirexd.callbacks.EventErrorFileToDBWriter;
import com.pivotal.gemfirexd.callbacks.impl.GatewayEventImpl;
import com.pivotal.gemfirexd.internal.catalog.TypeDescriptor;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.catalog.types.RoutineAliasInfo;
import com.pivotal.gemfirexd.internal.engine.GfxdJarHandler;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplateNoAllNodesRoute;
import com.pivotal.gemfirexd.internal.engine.IndexInfo;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.OplogIndexReader;
import com.pivotal.gemfirexd.internal.engine.UpdateVTITemplate;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.ddl.callbacks.CallbackProcedures;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.WanProcedures;
import com.pivotal.gemfirexd.internal.engine.diag.DiagProcedures;
import com.pivotal.gemfirexd.internal.engine.diag.HdfsProcedures;
import com.pivotal.gemfirexd.internal.engine.diag.HiveTablesVTI;
import com.pivotal.gemfirexd.internal.engine.diag.JSONProcedures;
import com.pivotal.gemfirexd.internal.engine.diag.SortedCSVProcedures;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GfxdShutdownAllRequest;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.locks.DefaultGfxdLockable;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdDRWLockService;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockSet;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockable;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.AliasDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DataDictionaryImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.TabInfoImpl;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CreateAsyncEventListenerNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CreateGatewayReceiverNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CreateGatewaySenderNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DropAsyncEventListenerNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DropDiskStoreNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DropGatewayReceiverNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DropGatewaySenderNode;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;

public final class GfxdDataDictionary
extends DataDictionaryImpl {
    private static final HashSet<String> sysSchemaSet;
    private final HashMap<String, SYSFUNEntry> sysFunMap = new HashMap();
    private final DefaultGfxdLockable ddLockObject = new DefaultGfxdLockable("GfxdDataDictionary", "TraceLock_DD");
    private static final String[][] GFXD_FUNCTIONS;
    private static final String[][] SYSFUN_PNAMES;
    private static final int SYSFUN_MODE = 1;
    private static final int[][] SYSFUN_PMODES;
    public static final ThreadLocal<Boolean> SKIP_LOCKS;
    private static final String PROC_CLASSNAME = "com.pivotal.gemfirexd.internal.engine.ddl.wan.WanProcedures";
    private static final String CALLBACK_CLASSNAME = "com.pivotal.gemfirexd.internal.engine.ddl.callbacks.CallbackProcedures";
    private static final String DIAG_CLASSNAME = "com.pivotal.gemfirexd.internal.engine.diag.DiagProcedures";
    private static final String GFXD_SYS_PROC_CLASSNAME = "com.pivotal.gemfirexd.internal.engine.ddl.catalog.GfxdSystemProcedures";
    private static final String HDFS_PROC_CLASSNAME = "com.pivotal.gemfirexd.internal.engine.diag.HdfsProcedures";
    public static final String DIAG_MEMBERS_TABLENAME = "MEMBERS";
    public static final String DIAG_QUERYSTATS_TABLENAME = "QUERYSTATS";
    public static final String DIAG_MEMORYANALYTICS_TABLENAME = "MEMORYANALYTICS";
    public static final String DIAG_STATEMENT_PLANS = "STATEMENTPLANS";
    public static final String JAR_INSTALL_TABLENAME = "JARS";
    public static final String INDEX_INFO_TABLENAME = "INDEXES";
    public static final String SESSIONS_TABLENAME = "SESSIONS";
    public static final String HIVETABLES_TABLENAME = "HIVETABLES";
    private static final String[][] VTI_TABLE_CLASSES;
    private final HashMap<String, TableDescriptor> diagVTIMap = new HashMap();
    private final HashMap<String, String> diagVTINames = new HashMap();

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        super.boot(create, startParams);
        this.sysFunMap.clear();
        for (String[] details : SYSFUN_FUNCTIONS) {
            this.sysFunMap.put(details[0], new SYSFUNEntry(details));
        }
        for (String[] details : GFXD_FUNCTIONS) {
            this.sysFunMap.put(details[0], new SYSFUNEntry(details));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startReading(LanguageConnectionContext lcc) throws StandardException {
        TransactionController tc;
        int localCacheMode;
        int bindCount = lcc.incrementBindCount();
        boolean readLockDD = false;
        GfxdDataDictionary gfxdDataDictionary = this;
        synchronized (gfxdDataDictionary) {
            localCacheMode = this.getCacheMode();
            if (bindCount == 1) {
                readLockDD = true;
                if (localCacheMode != 0) {
                    ++this.readersInDDLMode;
                }
            }
        }
        if (this.ddLockObject.traceLock()) {
            SanityManager.DEBUG_PRINT((String)"TraceLock_DD", (String)("GfxdDataDictionary#startReading: with bindCount=" + bindCount + " localCacheMode=" + localCacheMode + " acquiring read lock is " + readLockDD));
        }
        if (readLockDD && !this.lockForReadingNoThrow(tc = lcc.getTransactionExecute(), GfxdLockSet.MAX_LOCKWAIT_VAL)) {
            lcc.decrementBindCount();
            throw Misc.getMemStore().getDDLLockService().getLockTimeoutException(this, tc.getLockSpace().getOwner(), true);
        }
        return localCacheMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doneReading(int mode, LanguageConnectionContext lcc) throws StandardException {
        int bindCount = lcc.decrementBindCount();
        if (bindCount == 0) {
            this.unlockAfterReading(lcc.getTransactionExecute());
            if (mode != 0) {
                GfxdDataDictionary gfxdDataDictionary = this;
                synchronized (gfxdDataDictionary) {
                    --this.readersInDDLMode;
                    if (this.ddlUsers == 0 && this.readersInDDLMode == 0) {
                        this.clearCaches();
                        this.setCacheMode(0);
                    }
                    SanityManager.ASSERT((this.readersInDDLMode >= 0 ? 1 : 0) != 0, (String)"readersInDDLMode is invalid -- should never be < 0");
                }
            }
        }
        if (this.ddLockObject.traceLock()) {
            SanityManager.DEBUG_PRINT((String)"TraceLock_DD", (String)("GfxdDataDictionary#endReading: with bindCount=" + bindCount + " mode=" + mode));
        }
    }

    public final void lockForReadingRT(TransactionController tc) throws TimeoutException {
        GemFireStore memStore = Misc.getMemStoreBooting();
        if (!memStore.initialDDLReplayDone()) {
            this.lockForReadingInDDLReplay(memStore);
            return;
        }
        if (!this.lockForReadingNoThrow(tc, GfxdLockSet.MAX_LOCKWAIT_VAL)) {
            GfxdDRWLockService lockService = memStore.getDDLLockService();
            throw lockService.getLockTimeoutRuntimeException(this, null, true);
        }
    }

    @Override
    public final void lockForReading(TransactionController tc) throws StandardException {
        if (!this.lockForReadingNoThrow(tc, GfxdLockSet.MAX_LOCKWAIT_VAL)) {
            GfxdDRWLockService lockService = Misc.getMemStoreBooting().getDDLLockService();
            throw lockService.getLockTimeoutException(this, tc.getLockSpace().getOwner(), true);
        }
    }

    public final boolean lockForReadingNoThrow(TransactionController tc, long maxWaitMillis) {
        try {
            return SKIP_LOCKS.get() != false || GemFireXDUtils.lockObjectNoThrow(this.ddLockObject, null, false, false, tc, maxWaitMillis) != 0;
        }
        catch (StandardException se) {
            throw GemFireXDRuntimeException.newRuntimeException("unexpected exception while acquire DataDictionary read lock", se);
        }
    }

    public final void lockForReadingInDDLReplay(GemFireStore memStore) {
        if (!this.lockForReadingInDDLReplayNoThrow(memStore, 0x3FFFFFFFFFFFFFFFL, false)) {
            GfxdDRWLockService lockService = memStore.getDDLLockService();
            throw lockService.getLockTimeoutRuntimeException(this, null, true);
        }
    }

    public final boolean lockForReadingInDDLReplayNoThrow(GemFireStore store, long maxWaitMillis, boolean checkForDDLReplayWaiting) {
        long loopMillis = Math.min(500L, maxWaitMillis);
        if (this.lockForReadingNoThrow(null, loopMillis)) {
            return true;
        }
        while (!((maxWaitMillis -= loopMillis) <= 0L || checkForDDLReplayWaiting && store.initialDDLReplayWaiting())) {
            if (!this.lockForReadingNoThrow(null, loopMillis)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean unlockAfterReading(TransactionController tc) {
        if (!SKIP_LOCKS.get().booleanValue()) {
            return GemFireXDUtils.unlockObject(this.ddLockObject, null, false, false, tc);
        }
        return false;
    }

    @Override
    public void startWriting(LanguageConnectionContext lcc) throws StandardException {
        this.startWriting(lcc, false);
    }

    private void checkForPendingTxChanges(LanguageConnectionContext lcc) throws StandardException {
        TXStateInterface tx;
        GemFireTransaction parentTran;
        ConstantAction constantAction;
        ArrayList<Activation> activations = lcc.getAllActivations();
        Activation activation = null;
        if (activations != null && activations.size() > 0) {
            activation = activations.get(activations.size() - 1);
        }
        if (activation != null && (constantAction = activation.getConstantAction()) != null && constantAction instanceof DDLConstantAction && (parentTran = lcc.getParentOfNestedTransactionExecute()) != null && (tx = parentTran.getSuspendedTXState()) != null && tx.getProxy().isDirty()) {
            throw StandardException.newException("0A000.S", "Cannot execute DDL statements in the middle of transaction that has data changes (commit or rollback the transaction first) " + tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startWriting(LanguageConnectionContext lcc, boolean localOnly) throws StandardException {
        boolean status;
        this.checkForPendingTxChanges(lcc);
        if (lcc.getBindCount() != 0) {
            throw StandardException.newException("XCL21.S");
        }
        if (!lcc.dataDictionaryInWriteMode()) {
            status = this.lockForWriting(lcc.getTransactionExecute(), localOnly);
            GfxdDataDictionary gfxdDataDictionary = this;
            synchronized (gfxdDataDictionary) {
                int localCacheMode = this.getCacheMode();
                if (localCacheMode == 0) {
                    this.clearCaches();
                    this.setCacheMode(1);
                }
                ++this.ddlUsers;
            }
            lcc.setDataDictionaryWriteMode();
        } else {
            int localCacheMode;
            status = this.lockForWriting(lcc.getTransactionExecute(), localOnly);
            GfxdDataDictionary gfxdDataDictionary = this;
            synchronized (gfxdDataDictionary) {
                localCacheMode = this.getCacheMode();
            }
            if (localCacheMode != 1) {
                SanityManager.THROWASSERT((String)"lcc.getDictionaryInWriteMode() but DataDictionary is in COMPILE_MODE");
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transactionFinished() throws StandardException {
        GfxdDataDictionary gfxdDataDictionary = this;
        synchronized (gfxdDataDictionary) {
            SanityManager.ASSERT((this.ddlUsers > 0 ? 1 : 0) != 0, (String)"Number of DDL Users is <= 0 when finishing a transaction");
            SanityManager.ASSERT((this.getCacheMode() == 1 ? 1 : 0) != 0, (String)"transactionFinished called when not in DDL_MODE");
            --this.ddlUsers;
            if (this.ddlUsers == 0 && this.readersInDDLMode == 0) {
                this.clearCaches();
                this.setCacheMode(0);
            }
        }
    }

    @Override
    public final boolean lockForWriting(TransactionController tc, boolean localOnly) throws StandardException {
        return SKIP_LOCKS.get() != false || GemFireXDUtils.lockObject(this.ddLockObject, null, true, localOnly, tc, GfxdLockSet.MAX_LOCKWAIT_VAL);
    }

    @Override
    public final GfxdLockSet.LockType getLockType(TransactionController tc) {
        if (tc != null) {
            return ((GemFireTransaction)tc).getLockSpace().getLockType(this.ddLockObject);
        }
        return null;
    }

    public final GfxdLockable getLockObject() {
        return this.ddLockObject;
    }

    @Override
    public final void unlockAfterWriting(TransactionController tc, boolean localOnly) {
        if (!SKIP_LOCKS.get().booleanValue()) {
            GemFireXDUtils.unlockObject(this.ddLockObject, null, true, localOnly, tc);
        }
    }

    @Override
    public ArrayList<Object> getRoutineList(String schemaID, String routineName, char nameSpace) throws StandardException {
        ArrayList<Object> list = new ArrayList<Object>();
        if ("c013800d-00fb-2642-07ec-000000134f30".equals(schemaID) && nameSpace == 'F') {
            SYSFUNEntry entry = this.sysFunMap.get(routineName);
            if (entry != null) {
                String[] details = entry.details;
                if (entry.ad == null) {
                    TypeDescriptor[] pt;
                    int[] paramModes;
                    String[] paramNames;
                    int paramCount;
                    TypeDescriptor rt = DataTypeDescriptor.getBuiltInDataTypeDescriptor(details[1]).getCatalogType();
                    String paramType = details[4];
                    if (paramType != null) {
                        paramCount = details.length - 4;
                        paramNames = SYSFUN_PNAMES[paramCount];
                        paramModes = SYSFUN_PMODES[paramCount];
                        pt = new TypeDescriptor[paramCount];
                        pt[0] = DataTypeDescriptor.getBuiltInDataTypeDescriptor(paramType).getCatalogType();
                        for (int index = 5; index < details.length; ++index) {
                            paramType = details[index];
                            pt[index - 4] = DataTypeDescriptor.getBuiltInDataTypeDescriptor(paramType).getCatalogType();
                        }
                    } else {
                        paramCount = 0;
                        paramNames = null;
                        paramModes = null;
                        pt = null;
                    }
                    RoutineAliasInfo ai = new RoutineAliasInfo(details[3], paramCount, paramNames, pt, paramModes, 0, 0, 3, false, rt);
                    entry.ad = new AliasDescriptor(this, this.uuidFactory.createUUID(), routineName, this.uuidFactory.recreateUUID(schemaID), details[2], 'F', 'F', true, ai, null);
                }
                list.add(entry.ad);
            }
            return list;
        }
        AliasDescriptor ad = this.getAliasDescriptor(schemaID, routineName, nameSpace);
        if (ad != null) {
            list.add(ad);
        }
        return list;
    }

    @Override
    public boolean isSystemSchemaName(String name) throws StandardException {
        return name != null && sysSchemaSet.contains(name);
    }

    public static boolean isSystemSchema(String name) {
        return name != null && sysSchemaSet.contains(name);
    }

    @Override
    protected final void debugGenerateInfo(StringBuilder strbuf, TransactionController tc, ConglomerateController heapCC, TabInfoImpl ti, int indexId) {
        SanityManager.DEBUG_PRINT((String)"DataDictionary DEBUG", (String)strbuf.toString());
        GfxdDRWLockService ddlService = Misc.getMemStore().getDDLLockService();
        ddlService.dumpAllRWLocks("LOCK TABLE at the time of failure", true, false, true);
    }

    public String toString() {
        return this.ddLockObject.toString();
    }

    @Override
    void createGfxdSchemaAndInbuiltProcedures(TransactionController tc, HashSet newlyCreatedRoutines) throws StandardException {
        CreateGatewaySenderNode.dummy();
        CreateGatewayReceiverNode.dummy();
        CreateAsyncEventListenerNode.dummy();
        DropGatewaySenderNode.dummy();
        DropAsyncEventListenerNode.dummy();
        DropGatewayReceiverNode.dummy();
        DropDiskStoreNode.dummy();
        WanProcedures.dummy();
        CallbackProcedures.dummy();
        DiagProcedures.dummy();
        HdfsProcedures.dummy();
        SortedCSVProcedures.dummy();
        GfxdJarHandler.dummy();
        IndexInfo.dummy();
        JSONProcedures.dummy();
        GfxdShutdownAllRequest.dummy();
        GatewayEventImpl.dummy();
        EventErrorFileToDBWriter.dummy();
        OplogIndexReader.init();
        this.createGfxdDiagTables(tc);
        this.createStartAsyncQueueProcedure(tc, newlyCreatedRoutines);
        this.createStopAsyncQueueProcedure(tc, newlyCreatedRoutines);
        this.createStartGatewaySenderProcedure(tc, newlyCreatedRoutines);
        this.createStopGatewaySendereProcedure(tc, newlyCreatedRoutines);
        this.createAddListenerProcedure(tc, newlyCreatedRoutines);
        this.createAddWriterProcedure(tc, newlyCreatedRoutines);
        this.createRemoveListenerProcedure(tc, newlyCreatedRoutines);
        this.createRemoveWriterProcedure(tc, newlyCreatedRoutines);
        this.createAddLoaderProcedure(tc, newlyCreatedRoutines);
        this.createRemoveLoaderProcedure(tc, newlyCreatedRoutines);
        this.createSetQueryStatsProcedure(tc, newlyCreatedRoutines);
        this.createAddGatewayConflictResolverProcedure(tc, newlyCreatedRoutines);
        this.createRemoveGatewayConflictResolverProcedure(tc, newlyCreatedRoutines);
        this.createAddGatewayEventErrorHandlerProcedure(tc, newlyCreatedRoutines);
        this.createRemoveGatewayEventErrorHandlerProcedure(tc, newlyCreatedRoutines);
        this.createHDFSProcedures(tc, newlyCreatedRoutines);
        this.createGfxdSystemProcedures(tc, newlyCreatedRoutines);
    }

    private void createGfxdDiagTables(TransactionController tc) throws StandardException {
        SchemaDescriptor sysSchema = this.getSystemSchemaDescriptor();
        for (String[] vtiEntry : VTI_TABLE_CLASSES) {
            String tableName = vtiEntry[0];
            String className = vtiEntry[1];
            this.diagVTINames.put(tableName, className);
            TableDescriptor td = new TableDescriptor(this, tableName, sysSchema, 5, 'R');
            td.setUUID(this.getUUIDFactory().createUUID());
            long conglomId = Misc.getMemStore().getNextConglomId();
            ConglomerateDescriptor cd = this.getDataDescriptorGenerator().newConglomerateDescriptor(conglomId, null, false, null, false, null, td.getUUID(), sysSchema.getUUID());
            td.getConglomerateDescriptorList().add(cd);
            try {
                Object obj = Class.forName(className).newInstance();
                if (obj instanceof UpdateVTITemplate) {
                    ((UpdateVTITemplate)obj).setColumnDescriptorList(td);
                }
                td.setRouteQueryToAllNodes(!(obj instanceof GfxdVTITemplateNoAllNodesRoute));
            }
            catch (Exception ex) {
                throw StandardException.newException("42X05", (Throwable)ex, (Object)td.getQualifiedName());
            }
            this.diagVTIMap.put(tableName, td);
        }
    }

    private void createStartAsyncQueueProcedure(TransactionController tc, HashSet<?> newlyCreatedRoutines) throws StandardException {
        String[] arg_names = new String[]{"ID"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 128)};
        String methodName = "startAsyncQueue(java.lang.String)";
        String aliasName = "START_ASYNC_EVENT_LISTENER";
        this.createGfxdProcedure(methodName, this.getSystemSchemaDescriptor().getUUID(), arg_names, arg_types, 0, 0, (short)3, null, tc, aliasName, PROC_CLASSNAME, newlyCreatedRoutines, true);
    }

    private void createStopAsyncQueueProcedure(TransactionController tc, HashSet<?> newlyCreatedRoutines) throws StandardException {
        String[] arg_names = new String[]{"ID"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 128)};
        String methodName = "stopAsyncQueue(java.lang.String)";
        String aliasName = "STOP_ASYNC_EVENT_LISTENER";
        this.createGfxdProcedure(methodName, this.getSystemSchemaDescriptor().getUUID(), arg_names, arg_types, 0, 0, (short)3, null, tc, aliasName, PROC_CLASSNAME, newlyCreatedRoutines, true);
    }

    private void createStartGatewaySenderProcedure(TransactionController tc, HashSet<?> newlyCreatedRoutines) throws StandardException {
        String[] arg_names = new String[]{"ID"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 128)};
        String methodName = "startGatewaySender(java.lang.String)";
        String aliasName = "START_GATEWAYSENDER";
        this.createGfxdProcedure(methodName, this.getSystemSchemaDescriptor().getUUID(), arg_names, arg_types, 0, 0, (short)3, null, tc, aliasName, PROC_CLASSNAME, newlyCreatedRoutines, true);
    }

    private void createStopGatewaySendereProcedure(TransactionController tc, HashSet<?> newlyCreatedRoutines) throws StandardException {
        String[] arg_names = new String[]{"ID"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 128)};
        String methodName = "stopGatewaySender(java.lang.String)";
        String aliasName = "STOP_GATEWAYSENDER";
        this.createGfxdProcedure(methodName, this.getSystemSchemaDescriptor().getUUID(), arg_names, arg_types, 0, 0, (short)3, null, tc, aliasName, PROC_CLASSNAME, newlyCreatedRoutines, true);
    }

    private void createAddListenerProcedure(TransactionController tc, HashSet<?> newlyCreatedRoutines) throws StandardException {
        String[] arg_names = new String[]{"ID", "SCHEMA_NAME", "TABLE_NAME", "FUNCTION_STR", "INIT_INFO_STR", "SERVER_GROUPS"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 128), DataTypeDescriptor.getCatalogType(12, 128), DataTypeDescriptor.getCatalogType(12, 128), DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(12, 32672)};
        String methodName = "addGfxdCacheListener(java.lang.String,java.lang.String,java.lang.String,java.lang.String,java.lang.String,java.lang.String)";
        String aliasName = "ADD_LISTENER";
        this.createGfxdProcedure(methodName, this.getSystemSchemaDescriptor().getUUID(), arg_names, arg_types, 0, 0, (short)3, null, tc, aliasName, CALLBACK_CLASSNAME, newlyCreatedRoutines, true);
    }

    private void createAddWriterProcedure(TransactionController tc, HashSet<?> newlyCreatedRoutines) throws StandardException {
        String[] arg_names = new String[]{"SCHEMA_NAME", "TABLE_NAME", "FUNCTION_STR", "INIT_INFO_STR", "SERVER_GROUPS"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 128), DataTypeDescriptor.getCatalogType(12, 128), DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(12, 32672)};
        String methodName = "addGfxdCacheWriter(java.lang.String,java.lang.String,java.lang.String,java.lang.String,java.lang.String)";
        String aliasName = "ATTACH_WRITER";
        this.createGfxdProcedure(methodName, this.getSystemSchemaDescriptor().getUUID(), arg_names, arg_types, 0, 0, (short)3, null, tc, aliasName, CALLBACK_CLASSNAME, newlyCreatedRoutines, true);
    }

    private void createRemoveListenerProcedure(TransactionController tc, HashSet<?> newlyCreatedRoutines) throws StandardException {
        String[] arg_names = new String[]{"ID", "SCHEMA_NAME", "TABLE_NAME"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 128), DataTypeDescriptor.getCatalogType(12, 128), DataTypeDescriptor.getCatalogType(12, 128)};
        String methodName = "removeGfxdCacheListener(java.lang.String,java.lang.String,java.lang.String)";
        String aliasName = "REMOVE_LISTENER";
        this.createGfxdProcedure(methodName, this.getSystemSchemaDescriptor().getUUID(), arg_names, arg_types, 0, 0, (short)3, null, tc, aliasName, CALLBACK_CLASSNAME, newlyCreatedRoutines, true);
    }

    private void createRemoveWriterProcedure(TransactionController tc, HashSet<?> newlyCreatedRoutines) throws StandardException {
        String[] arg_names = new String[]{"SCHEMA_NAME", "TABLE_NAME"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 128), DataTypeDescriptor.getCatalogType(12, 128)};
        String methodName = "removeGfxdCacheWriter(java.lang.String,java.lang.String)";
        String aliasName = "REMOVE_WRITER";
        this.createGfxdProcedure(methodName, this.getSystemSchemaDescriptor().getUUID(), arg_names, arg_types, 0, 0, (short)3, null, tc, aliasName, CALLBACK_CLASSNAME, newlyCreatedRoutines, true);
    }

    private void createAddLoaderProcedure(TransactionController tc, HashSet<?> newlyCreatedRoutines) throws StandardException {
        String[] arg_names = new String[]{"SCHEMA_NAME", "TABLE_NAME", "FUNCTION_STR", "INIT_INFO_STR"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 128), DataTypeDescriptor.getCatalogType(12, 128), DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(12, 32672)};
        String methodName = "addGfxdCacheLoader(java.lang.String, java.lang.String, java.lang.String, java.lang.String)";
        String aliasName = "ATTACH_LOADER";
        this.createGfxdProcedure(methodName, this.getSystemSchemaDescriptor().getUUID(), arg_names, arg_types, 0, 0, (short)3, null, tc, aliasName, CALLBACK_CLASSNAME, newlyCreatedRoutines, true);
    }

    private void createAddGatewayConflictResolverProcedure(TransactionController tc, HashSet<?> newlyCreatedRoutines) throws StandardException {
        String[] arg_names = new String[]{"FUNCTION_STR", "INIT_INFO_STR"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(12, 32672)};
        String methodName = "addGfxdGatewayConflictResolver(java.lang.String, java.lang.String)";
        String aliasName = "ATTACH_GATEWAY_CONFLICT_RESOLVER";
        this.createGfxdProcedure(methodName, this.getSystemSchemaDescriptor().getUUID(), arg_names, arg_types, 0, 0, (short)3, null, tc, aliasName, CALLBACK_CLASSNAME, newlyCreatedRoutines, true);
    }

    private void createAddGatewayEventErrorHandlerProcedure(TransactionController tc, HashSet<?> newlyCreatedRoutines) throws StandardException {
        String[] arg_names = new String[]{"FUNCTION_STR", "INIT_INFO_STR"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(12, 32672)};
        String methodName = "addGfxdGatewayEventErrorHandler(java.lang.String, java.lang.String)";
        String aliasName = "ATTACH_GATEWAY_EVENT_ERROR_HANDLER";
        this.createGfxdProcedure(methodName, this.getSystemSchemaDescriptor().getUUID(), arg_names, arg_types, 0, 0, (short)3, null, tc, aliasName, CALLBACK_CLASSNAME, newlyCreatedRoutines, true);
    }

    private void createRemoveGatewayConflictResolverProcedure(TransactionController tc, HashSet<?> newlyCreatedRoutines) throws StandardException {
        String[] arg_names = new String[]{};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{};
        String methodName = "removeGfxdGatewayConflictResolver()";
        String aliasName = "REMOVE_GATEWAY_CONFLICT_RESOLVER";
        this.createGfxdProcedure(methodName, this.getSystemSchemaDescriptor().getUUID(), arg_names, arg_types, 0, 0, (short)3, null, tc, aliasName, CALLBACK_CLASSNAME, newlyCreatedRoutines, true);
    }

    private void createRemoveGatewayEventErrorHandlerProcedure(TransactionController tc, HashSet<?> newlyCreatedRoutines) throws StandardException {
        String[] arg_names = new String[]{};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{};
        String methodName = "removeGfxdGatewayEventErrorHandler()";
        String aliasName = "REMOVE_GATEWAY_EVENT_ERROR_HANDLER";
        this.createGfxdProcedure(methodName, this.getSystemSchemaDescriptor().getUUID(), arg_names, arg_types, 0, 0, (short)3, null, tc, aliasName, CALLBACK_CLASSNAME, newlyCreatedRoutines, true);
    }

    private void createRemoveLoaderProcedure(TransactionController tc, HashSet<?> newlyCreatedRoutines) throws StandardException {
        String[] arg_names = new String[]{"SCHEMA_NAME", "TABLE_NAME"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 128), DataTypeDescriptor.getCatalogType(12, 128)};
        String methodName = "removeGfxdCacheLoader(java.lang.String, java.lang.String)";
        String aliasName = "REMOVE_LOADER";
        this.createGfxdProcedure(methodName, this.getSystemSchemaDescriptor().getUUID(), arg_names, arg_types, 0, 0, (short)3, null, tc, aliasName, CALLBACK_CLASSNAME, newlyCreatedRoutines, true);
    }

    private void createSetQueryStatsProcedure(TransactionController tc, HashSet<?> newlyCreatedRoutines) throws StandardException {
        String[] arg_names = new String[]{"ENABLE"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(16)};
        String methodName = "setQueryStats(java.lang.Boolean)";
        String aliasName = "SET_QUERYSTATS";
        this.createGfxdProcedure(methodName, this.getSystemSchemaDescriptor().getUUID(), arg_names, arg_types, 0, 0, (short)3, null, tc, aliasName, DIAG_CLASSNAME, newlyCreatedRoutines, true);
    }

    private void createHDFSProcedures(TransactionController tc, HashSet<?> newlyCreatedRoutines) throws StandardException {
        String[] argNames = new String[]{"FQTN", "MAX_WAIT_TIME"};
        TypeDescriptor[] argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 128), DataTypeDescriptor.getCatalogType(4)};
        String methodName = "forceCompaction(java.lang.String, java.lang.Integer)";
        String aliasName = "HDFS_FORCE_COMPACTION";
        this.createGfxdProcedure(methodName, this.getSystemSchemaDescriptor().getUUID(), argNames, argTypes, 0, 0, (short)3, null, tc, aliasName, HDFS_PROC_CLASSNAME, newlyCreatedRoutines, true);
        argNames = new String[]{"FQTN", "MAX_WAIT_TIME"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 128), DataTypeDescriptor.getCatalogType(4)};
        methodName = "flushQueue(java.lang.String, java.lang.Integer)";
        aliasName = "HDFS_FLUSH_QUEUE";
        this.createGfxdProcedure(methodName, this.getSystemSchemaDescriptor().getUUID(), argNames, argTypes, 0, 0, (short)3, null, tc, aliasName, HDFS_PROC_CLASSNAME, newlyCreatedRoutines, true);
        argNames = new String[]{"FQTN"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 128)};
        String aliasName2 = "HDFS_LAST_MAJOR_COMPACTION";
        TypeDescriptor returnType = DataTypeDescriptor.getCatalogType(93);
        super.createSystemProcedureOrFunction(aliasName2, this.getSystemSchemaDescriptor().getUUID(), argNames, argTypes, 0, 0, (short)2, returnType, newlyCreatedRoutines, tc, HDFS_PROC_CLASSNAME, false);
        argNames = new String[]{"FQTN", "MIN_SIZE_FOR_ROLLOVER"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 256), DataTypeDescriptor.getCatalogType(4)};
        super.createSystemProcedureOrFunction("HDFS_FORCE_WRITEONLY_FILEROLLOVER", this.getSystemSchemaDescriptor().getUUID(), argNames, argTypes, 0, 0, (short)3, null, newlyCreatedRoutines, tc, HDFS_PROC_CLASSNAME, false);
    }

    private void createGfxdSystemProcedures(TransactionController tc, HashSet<?> newlyCreatedRoutines) throws StandardException {
        UUID sysUUID = this.getSystemSchemaDescriptor().getUUID();
        UUID sqlJUUID = this.getSchemaDescriptor("SQLJ", tc, true).getUUID();
        String[] arg_names = new String[]{"USER_ID", "PASSWORD"};
        TypeDescriptor[] arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 32672)};
        super.createSystemProcedureOrFunction("CREATE_USER", sysUUID, arg_names, arg_types, 0, 0, (short)0, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        arg_names = new String[]{"USER_ID", "OLDPASSWORD", "NEWPASSWORD"};
        arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(12, 32672)};
        UUID routineUUID = super.createSystemProcedureOrFunction("CHANGE_PASSWORD", sysUUID, arg_names, arg_types, 0, 0, (short)0, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        this.addBypassRoutine(routineUUID);
        arg_names = new String[]{"USER_ID"};
        arg_types = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER};
        super.createSystemProcedureOrFunction("DROP_USER", sysUUID, arg_names, arg_types, 0, 0, (short)0, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        super.createSystemProcedureOrFunction("SHOW_USERS", sysUUID, null, null, 0, 1, (short)3, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        arg_names = new String[]{"SCHEMA", "TABLE"};
        TypeDescriptor[] argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(12)};
        super.createSystemProcedureOrFunction("CHECK_TABLE_EX", sysUUID, arg_names, argTypes, 0, 0, (short)3, DataTypeDescriptor.getCatalogType(4), newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        arg_names = new String[]{"HEAP_PERCENTAGE"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(7)};
        super.createSystemProcedureOrFunction("SET_CRITICAL_HEAP_PERCENTAGE", sysUUID, arg_names, arg_types, 0, 0, (short)0, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        arg_names = new String[]{"OFFHEAP_PERCENTAGE"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(7)};
        super.createSystemProcedureOrFunction("SET_CRITICAL_OFFHEAP_PERCENTAGE", sysUUID, arg_names, arg_types, 0, 0, (short)0, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        arg_names = new String[]{"HEAP_PERCENTAGE", "SERVER_GROUPS"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(7), DataTypeDescriptor.getCatalogType(12, 32672)};
        super.createSystemProcedureOrFunction("SET_CRITICAL_HEAP_PERCENTAGE_SG", sysUUID, arg_names, arg_types, 0, 0, (short)0, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        arg_names = new String[]{"OFFHEAP_PERCENTAGE", "SERVER_GROUPS"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(7), DataTypeDescriptor.getCatalogType(12, 32672)};
        super.createSystemProcedureOrFunction("SET_CRITICAL_OFFHEAP_PERCENTAGE_SG", sysUUID, arg_names, arg_types, 0, 0, (short)0, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        super.createSystemProcedureOrFunction("GET_CRITICAL_HEAP_PERCENTAGE", sysUUID, null, null, 0, 0, (short)2, DataTypeDescriptor.getCatalogType(7), newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        super.createSystemProcedureOrFunction("GET_CRITICAL_OFFHEAP_PERCENTAGE", sysUUID, null, null, 0, 0, (short)2, DataTypeDescriptor.getCatalogType(7), newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        arg_names = new String[]{"HEAP_PERCENTAGE"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(7)};
        super.createSystemProcedureOrFunction("SET_EVICTION_HEAP_PERCENTAGE", sysUUID, arg_names, arg_types, 0, 0, (short)0, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        arg_names = new String[]{"OFFHEAP_PERCENTAGE"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(7)};
        super.createSystemProcedureOrFunction("SET_EVICTION_OFFHEAP_PERCENTAGE", sysUUID, arg_names, arg_types, 0, 0, (short)0, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        arg_names = new String[]{"HEAP_PERCENTAGE", "SERVER_GROUPS"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(7), DataTypeDescriptor.getCatalogType(12, 32672)};
        super.createSystemProcedureOrFunction("SET_EVICTION_HEAP_PERCENTAGE_SG", sysUUID, arg_names, arg_types, 0, 0, (short)0, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        arg_names = new String[]{"OFFHEAP_PERCENTAGE", "SERVER_GROUPS"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(7), DataTypeDescriptor.getCatalogType(12, 32672)};
        super.createSystemProcedureOrFunction("SET_EVICTION_OFFHEAP_PERCENTAGE_SG", sysUUID, arg_names, arg_types, 0, 0, (short)0, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        super.createSystemProcedureOrFunction("GET_EVICTION_HEAP_PERCENTAGE", sysUUID, null, null, 0, 0, (short)2, DataTypeDescriptor.getCatalogType(7), newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        super.createSystemProcedureOrFunction("GET_EVICTION_OFFHEAP_PERCENTAGE", sysUUID, null, null, 0, 0, (short)2, DataTypeDescriptor.getCatalogType(7), newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        arg_names = new String[]{"EXCLUDED_SERVERS", "PREFERRED_SERVER_NAME", "PREFERRED_SERVER_PORT", "ALL_NETSERVERS"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(-1), DataTypeDescriptor.getCatalogType(12, 256), DataTypeDescriptor.getCatalogType(4), DataTypeDescriptor.getCatalogType(-1)};
        super.createSystemProcedureOrFunction("GET_ALLSERVERS_AND_PREFSERVER", sysUUID, arg_names, arg_types, 3, 0, (short)1, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        arg_names = new String[]{"EXCLUDED_SERVERS", "PREFERRED_SERVER_NAME", "PREFERRED_SERVER_PORT", "ALL_NETSERVERS"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(-1), DataTypeDescriptor.getCatalogType(12, 256), DataTypeDescriptor.getCatalogType(4), DataTypeDescriptor.getCatalogType(2005)};
        super.createSystemProcedureOrFunction("GET_ALLSERVERS_AND_PREFSERVER2", sysUUID, arg_names, arg_types, 3, 0, (short)1, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        arg_names = new String[]{"EXCLUDED_SERVERS", "PREFERRED_SERVER_NAME", "PREFERRED_SERVER_PORT"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(-1), DataTypeDescriptor.getCatalogType(12, 256), DataTypeDescriptor.getCatalogType(4)};
        super.createSystemProcedureOrFunction("GET_PREFSERVER", sysUUID, arg_names, arg_types, 2, 0, (short)1, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        String[] argNames = new String[]{"EXPORT_ALL"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(16)};
        super.createSystemProcedureOrFunction("EXPORT_DDLS", sysUUID, argNames, argTypes, 0, 1, (short)3, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        argNames = new String[]{"TRACE_FLAG", "ON"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 256), DataTypeDescriptor.getCatalogType(16)};
        super.createSystemProcedureOrFunction("SET_TRACE_FLAG", sysUUID, argNames, argTypes, 0, 0, (short)3, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        argNames = new String[]{"ID", "IS_ASYNCLISTENER", "MAX_WAIT_TIME"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 256), DataTypeDescriptor.getCatalogType(16), DataTypeDescriptor.getCatalogType(4)};
        super.createSystemProcedureOrFunction("WAIT_FOR_SENDER_QUEUE_FLUSH", sysUUID, argNames, argTypes, 0, 0, (short)3, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        argNames = new String[]{"ON"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(16)};
        super.createSystemProcedureOrFunction("SET_GATEWAY_FK_CHECKS", sysUUID, argNames, argTypes, 0, 0, (short)3, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        argNames = new String[]{"SCHEMANAME", "TABLENAME"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 128), DataTypeDescriptor.getCatalogType(12, 128)};
        super.createSystemProcedureOrFunction("GET_TABLE_VERSION", sysUUID, argNames, argTypes, 0, 0, (short)3, DataTypeDescriptor.getCatalogType(4), newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        argNames = new String[]{"SCHEMANAME", "TABLENAME", "INCREMENT"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 128), DataTypeDescriptor.getCatalogType(12, 128), DataTypeDescriptor.getCatalogType(4)};
        super.createSystemProcedureOrFunction("INCREMENT_TABLE_VERSION", sysUUID, argNames, argTypes, 0, 0, (short)0, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        argNames = new String[]{"GROUPNAME"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 128)};
        super.createSystemProcedureOrFunction("REFRESH_LDAP_GROUP", sysUUID, argNames, argTypes, 0, 0, (short)0, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        argNames = new String[]{"DISKSTORENAME"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 128)};
        super.createSystemProcedureOrFunction("DISKSTORE_FSYNC", sysUUID, argNames, argTypes, 0, 0, (short)3, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        argNames = new String[]{"ENABLE_STATS", "ENABLE_TIMESTATS"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(16), DataTypeDescriptor.getCatalogType(16)};
        super.createSystemProcedureOrFunction("SET_GLOBAL_STATEMENT_STATISTICS", sysUUID, argNames, argTypes, 0, 0, (short)3, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        argNames = new String[]{"ALL"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(16)};
        super.createSystemProcedureOrFunction("DUMP_STACKS", sysUUID, argNames, argTypes, 0, 0, (short)3, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        argNames = new String[]{"TABLE_NAME", "BUCKETS", "RELATION_DESTROY_VERSIONS"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(4)};
        super.createSystemProcedureOrFunction("SET_BUCKETS_FOR_LOCAL_EXECUTION", sysUUID, argNames, argTypes, 0, 0, (short)3, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        argNames = new String[]{"JAR_BYTES", "JAR_NAME"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(2004), CATALOG_TYPE_SYSTEM_IDENTIFIER};
        super.createSystemProcedureOrFunction("INSTALL_JAR_BYTES", sqlJUUID, argNames, argTypes, 0, 0, (short)0, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        argNames = new String[]{"JAR_BYTES", "JAR_NAME"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(2004), CATALOG_TYPE_SYSTEM_IDENTIFIER};
        super.createSystemProcedureOrFunction("REPLACE_JAR_BYTES", sqlJUUID, argNames, argTypes, 0, 0, (short)0, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        super.createSystemProcedureOrFunction("REBALANCE_ALL_BUCKETS", sysUUID, null, null, 0, 0, (short)3, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        arg_names = new String[]{"TABLENAME"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(-1)};
        super.createSystemProcedureOrFunction("CREATE_ALL_BUCKETS", sysUUID, arg_names, arg_types, 0, 0, (short)3, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        argNames = new String[]{"txId"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12)};
        super.createSystemProcedureOrFunction("START_SNAPSHOT_TXID", sysUUID, argNames, argTypes, 1, 0, (short)3, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        argNames = new String[]{"txId"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12)};
        super.createSystemProcedureOrFunction("COMMIT_SNAPSHOT_TXID", sysUUID, argNames, argTypes, 0, 0, (short)3, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        argNames = new String[]{"txId"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12)};
        super.createSystemProcedureOrFunction("ROLLBACK_SNAPSHOT_TXID", sysUUID, argNames, argTypes, 0, 0, (short)3, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        argNames = new String[]{"txId"};
        argTypes = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12)};
        super.createSystemProcedureOrFunction("USE_SNAPSHOT_TXID", sysUUID, argNames, argTypes, 0, 0, (short)3, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        super.createSystemProcedureOrFunction("GET_SNAPSHOT_TXID", sysUUID, null, null, 0, 0, (short)1, DataTypeDescriptor.getCatalogType(12), newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        arg_names = new String[]{"TABLE_NAME", "TABLE_OBJECT", "BUCKET_COUNT", "PARTITIONING_COLUMNS", "INDEX_COLUMNS", "BUCKET_TO_SERVER_MAPPING", "RELATION_DESTROY_VERSION", "PK_COLUMNS"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(2004), DataTypeDescriptor.getCatalogType(4), DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(2005), DataTypeDescriptor.getCatalogType(4), DataTypeDescriptor.getCatalogType(12)};
        super.createSystemProcedureOrFunction("GET_TABLE_METADATA", sysUUID, arg_names, arg_types, 7, 0, (short)1, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        arg_names = new String[]{"TABLE_IDENT", "PROVIDER", "USER_SCHEMA", "SCHEMA_DDL", "MODE", "OPTIONS", "IS_BUILTIN"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(2004), DataTypeDescriptor.getCatalogType(2004), DataTypeDescriptor.getCatalogType(16)};
        super.createSystemProcedureOrFunction("CREATE_SNAPPY_TABLE", sysUUID, arg_names, arg_types, 0, 0, (short)1, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        arg_names = new String[]{"TABLE_IDENT", "IF_EXISTS"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(16)};
        super.createSystemProcedureOrFunction("DROP_SNAPPY_TABLE", sysUUID, arg_names, arg_types, 0, 0, (short)1, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        arg_names = new String[]{"INDEX_IDENT", "TABLE_IDENT", "INDEX_COLUMNS", "OPTIONS"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(2004), DataTypeDescriptor.getCatalogType(2004)};
        super.createSystemProcedureOrFunction("CREATE_SNAPPY_INDEX", sysUUID, arg_names, arg_types, 0, 0, (short)1, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        arg_names = new String[]{"INDEX_IDENT", "IF_EXISTS"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(16)};
        super.createSystemProcedureOrFunction("DROP_SNAPPY_INDEX", sysUUID, arg_names, arg_types, 0, 0, (short)1, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        arg_names = new String[]{"DB", "FUNCTION_NAME", "CLASS_NAME", "JAR_URI"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(12)};
        super.createSystemProcedureOrFunction("CREATE_SNAPPY_UDF", sysUUID, arg_names, arg_types, 0, 0, (short)1, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        arg_names = new String[]{"DB", "FUNCTION_NAME"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(12)};
        super.createSystemProcedureOrFunction("DROP_SNAPPY_UDF", sysUUID, arg_names, arg_types, 0, 0, (short)1, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        arg_names = new String[]{"TABLE_IDENT", "IS_ADD_COL", "COL_NAME", "COL_DATATYPE", "COL_IS_NULLABLE"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(16), DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(16)};
        super.createSystemProcedureOrFunction("ALTER_SNAPPY_TABLE", sysUUID, arg_names, arg_types, 0, 0, (short)1, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        arg_names = new String[]{"STATS_OBJECT"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(2004)};
        super.createSystemProcedureOrFunction("GET_SNAPPY_TABLE_STATS", sysUUID, arg_names, arg_types, 1, 0, (short)1, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        arg_names = new String[]{"FQTN", "BKT_TO_SERVER_MAPPING"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(12)};
        super.createSystemProcedureOrFunction("GET_BUCKET_TO_SERVER_MAPPING", sysUUID, arg_names, arg_types, 1, 0, (short)1, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        arg_names = new String[]{"FQTN", "BKT_TO_SERVER_MAPPING"};
        arg_types = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(2005)};
        super.createSystemProcedureOrFunction("GET_BUCKET_TO_SERVER_MAPPING2", sysUUID, arg_names, arg_types, 1, 0, (short)1, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        TypeDescriptor varchar32672Type = DataTypeDescriptor.getCatalogType(12, 32672);
        UUID sysUtilUUID = this.getSystemUtilSchemaDescriptor().getUUID();
        String[] argNames2 = new String[]{"schemaName", "tableName", "fileName", "columnDelimiter", "characterDelimiter", "codeset", "replace", "lockTable", "numThreads", "caseSensitiveNames", "importClassName", "errorFile"};
        TypeDescriptor[] argTypes2 = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, varchar32672Type, DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT, TypeDescriptor.SMALLINT, TypeDescriptor.INTEGER, TypeDescriptor.SMALLINT, varchar32672Type, varchar32672Type};
        super.createSystemProcedureOrFunction("IMPORT_TABLE_EX", sysUtilUUID, argNames2, argTypes2, 0, 0, (short)0, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        argNames2 = new String[]{"schemaName", "tableName", "insertColumnList", "columnIndexes", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "replace", "lockTable", "numThreads", "caseSensitiveNames", "importClassName", "errorFile"};
        argTypes2 = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, varchar32672Type, varchar32672Type, varchar32672Type, DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT, TypeDescriptor.SMALLINT, TypeDescriptor.INTEGER, TypeDescriptor.SMALLINT, varchar32672Type, varchar32672Type};
        super.createSystemProcedureOrFunction("IMPORT_DATA_EX", sysUtilUUID, argNames2, argTypes2, 0, 0, (short)0, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        argNames2 = new String[]{"schemaName", "tableName", "fileName", "columnDelimiter", "characterDelimiter", "codeset", "replace", "lockTable", "numThreads", "caseSensitiveNames", "importClassName", "errorFile"};
        argTypes2 = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT, TypeDescriptor.SMALLINT, TypeDescriptor.INTEGER, TypeDescriptor.SMALLINT, varchar32672Type, varchar32672Type};
        super.createSystemProcedureOrFunction("IMPORT_TABLE_LOBS_FROM_EXTFILE", sysUtilUUID, argNames2, argTypes2, 0, 0, (short)0, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        argNames2 = new String[]{"schemaName", "tableName", "insertColumnList", "columnIndexes", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "replace", "lockTable", "numThreads", "caseSensitiveNames", "importClassName", "errorFile"};
        argTypes2 = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT, TypeDescriptor.SMALLINT, TypeDescriptor.INTEGER, TypeDescriptor.SMALLINT, varchar32672Type, varchar32672Type};
        super.createSystemProcedureOrFunction("IMPORT_DATA_LOBS_FROM_EXTFILE", sysUtilUUID, argNames2, argTypes2, 0, 0, (short)0, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        super.createSystemProcedureOrFunction("REPAIR_CATALOG", sysUUID, null, null, 0, 0, (short)1, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        argNames2 = new String[]{"STATEMENTUUID"};
        argTypes2 = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12)};
        super.createSystemProcedureOrFunction("CANCEL_STATEMENT", sysUUID, argNames2, argTypes2, 0, 0, (short)3, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        argNames2 = new String[]{"useNativeTimer", "nativeTimerType"};
        argTypes2 = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(16), DataTypeDescriptor.getCatalogType(12)};
        super.createSystemProcedureOrFunction("SET_NANOTIMER_TYPE", sysUUID, argNames2, argTypes2, 0, 0, (short)3, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, true);
        super.createSystemProcedureOrFunction("GET_IS_NATIVE_NANOTIMER", sysUUID, null, null, 0, 0, (short)2, DataTypeDescriptor.getCatalogType(16), newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        super.createSystemProcedureOrFunction("GET_NATIVE_NANOTIMER_TYPE", sysUUID, null, null, 0, 0, (short)2, DataTypeDescriptor.getCatalogType(12), newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
        String[] arg_names2 = new String[]{"SCHEMA", "TABLE", "SCHEMA_AS_JSON"};
        TypeDescriptor[] arg_types2 = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(2005)};
        super.createSystemProcedureOrFunction("GET_COLUMN_TABLE_SCHEMA", sysUUID, arg_names2, arg_types2, 1, 0, (short)1, null, newlyCreatedRoutines, tc, GFXD_SYS_PROC_CLASSNAME, false);
    }

    private final void createGfxdProcedure(String routineName, UUID schemaID, String[] argNames, TypeDescriptor[] argTypes, int numOutParams, int numResultSets, short routineSQLControl, TypeDescriptor return_type, TransactionController tc, String aliasName, String procClass, HashSet newlyCreatedRoutines, boolean isRestricted) throws StandardException {
        int num_args = 0;
        if (argNames != null) {
            num_args = argNames.length;
        }
        if (num_args != 0) {
            SanityManager.ASSERT((argNames != null ? 1 : 0) != 0);
            SanityManager.ASSERT((argTypes != null ? 1 : 0) != 0);
            SanityManager.ASSERT((argNames.length == argTypes.length ? 1 : 0) != 0);
        }
        int[] arg_modes = null;
        if (num_args != 0) {
            int i;
            arg_modes = new int[num_args];
            int num_in_param = num_args - numOutParams;
            for (i = 0; i < num_in_param; ++i) {
                arg_modes[i] = 1;
            }
            for (i = 0; i < numOutParams; ++i) {
                arg_modes[num_in_param + i] = 4;
            }
        }
        RoutineAliasInfo routine_alias_info = new RoutineAliasInfo(routineName, num_args, argNames, argTypes, arg_modes, numResultSets, 0, routineSQLControl, true, return_type);
        UUID routineID = this.getUUIDFactory().createUUID();
        AliasDescriptor ads = new AliasDescriptor(this, routineID, aliasName, schemaID, procClass, 'P', 'P', false, routine_alias_info, null);
        this.addDescriptor(ads, null, 7, false, tc);
        newlyCreatedRoutines.add(aliasName);
        if (isRestricted) {
            super.addRestrictedRoutine(routineID);
        }
    }

    @Override
    public String getBuiltinVTIClass(TableDescriptor td, boolean asTableFunction) throws StandardException {
        String className;
        if ("SYS".equals(td.getSchemaName()) && (className = this.diagVTINames.get(td.getDescriptorName())) != null) {
            return className;
        }
        return super.getBuiltinVTIClass(td, asTableFunction);
    }

    @Override
    public String getBuiltinVTIClass(String schemaName, String tableName) throws StandardException {
        String className;
        if ("SYS".equals(schemaName) && (className = this.diagVTINames.get(tableName)) != null) {
            return className;
        }
        return super.getBuiltinVTIClass(schemaName, tableName);
    }

    @Override
    public String getVTIClass(TableDescriptor td, boolean asTableFunction) throws StandardException {
        if ("SYS".equals(td.getSchemaName())) {
            return this.getBuiltinVTIClass(td, asTableFunction);
        }
        return super.getVTIClass(td, asTableFunction);
    }

    @Override
    public TableDescriptor getTableDescriptor(String tableName, SchemaDescriptor schema, TransactionController tc) throws StandardException {
        TableDescriptor td;
        SchemaDescriptor sd;
        SchemaDescriptor schemaDescriptor = sd = schema != null ? schema : this.getSystemSchemaDescriptor();
        if ("SYS".equals(sd.getSchemaName()) && (td = this.diagVTIMap.get(tableName)) != null) {
            return td;
        }
        return super.getTableDescriptor(tableName, schema, tc);
    }

    @Override
    public final void updateSystemSchemaAuthorization(String aid, TransactionController tc) throws StandardException {
        super.updateSystemSchemaAuthorization(aid, tc);
    }

    static {
        GFXD_FUNCTIONS = new String[][]{{"GROUPS", "VARCHAR", DIAG_CLASSNAME, "getServerGroups()", null}, {"DSID", "VARCHAR", DIAG_CLASSNAME, "getDistributedMemberId()", null}, {"GROUPSINTERSECTION", "VARCHAR", "com.pivotal.gemfirexd.internal.engine.diag.SortedCSVProcedures", "groupsIntersection(java.lang.String,java.lang.String)", "VARCHAR", "VARCHAR"}, {"GROUPSINTERSECT", "BOOLEAN", "com.pivotal.gemfirexd.internal.engine.diag.SortedCSVProcedures", "groupsIntersect(java.lang.String,java.lang.String)", "VARCHAR", "VARCHAR"}, {"GROUPSUNION", "VARCHAR", "com.pivotal.gemfirexd.internal.engine.diag.SortedCSVProcedures", "groupsUnion(java.lang.String,java.lang.String)", "VARCHAR", "VARCHAR"}, {"COUNT_ESTIMATE", "BIGINT", HDFS_PROC_CLASSNAME, "countEstimate(java.lang.String)", "VARCHAR"}, {"JSON_EVALPATH", "VARCHAR", "com.pivotal.gemfirexd.internal.engine.diag.JSONProcedures", "json_evalPath(com.pivotal.gemfirexd.internal.iapi.types.JSON, java.lang.String)", "JSON", "VARCHAR"}};
        SYSFUN_PNAMES = new String[][]{null, {"P1"}, {"P1", "P2"}, {"P1", "P2", "P3"}, {"P1", "P2", "P3", "P4"}};
        SYSFUN_PMODES = new int[][]{null, {1}, {1, 1}, {1, 1, 1}, {1, 1, 1, 1}};
        SKIP_LOCKS = new ThreadLocal<Boolean>(){

            @Override
            public Boolean initialValue() {
                return Boolean.FALSE;
            }
        };
        sysSchemaSet = new HashSet(systemSchemaNames.length * 2);
        for (String sysSchema : systemSchemaNames) {
            sysSchemaSet.add(sysSchema);
        }
        VTI_TABLE_CLASSES = new String[][]{{DIAG_MEMBERS_TABLENAME, "com.pivotal.gemfirexd.internal.engine.diag.DistributedMembers"}, {DIAG_QUERYSTATS_TABLENAME, "com.pivotal.gemfirexd.internal.engine.diag.QueryStatisticsVTI"}, {DIAG_MEMORYANALYTICS_TABLENAME, "com.pivotal.gemfirexd.internal.engine.diag.MemoryAnalyticsVTI"}, {DIAG_STATEMENT_PLANS, "com.pivotal.gemfirexd.internal.engine.diag.StatementPlansVTI"}, {JAR_INSTALL_TABLENAME, "com.pivotal.gemfirexd.internal.engine.GfxdJarHandler"}, {INDEX_INFO_TABLENAME, "com.pivotal.gemfirexd.internal.engine.IndexInfo"}, {SESSIONS_TABLENAME, "com.pivotal.gemfirexd.internal.engine.diag.SessionsVTI"}, {HIVETABLES_TABLENAME, HiveTablesVTI.class.getName()}};
    }

    private static final class SYSFUNEntry {
        private final String[] details;
        private AliasDescriptor ad;

        SYSFUNEntry(String[] details) {
            this.details = details;
            this.ad = null;
        }
    }
}

