/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.cache;

import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.services.cache.Cacheable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.services.cache.ReplacementPolicy;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public final class CacheEntry {
    private final ReentrantLock mutex = new ReentrantLock();
    private Cacheable cacheable;
    private int keepCount;
    private Condition forRemove;
    private Condition settingIdentity;
    private ReplacementPolicy.Callback callback;

    CacheEntry() {
        this.settingIdentity = this.mutex.newCondition();
    }

    CacheEntry(boolean noCondition) {
        this.settingIdentity = null;
    }

    void lock() {
        SanityManager.ASSERT((!this.mutex.isHeldByCurrentThread() ? 1 : 0) != 0);
        this.mutex.lock();
    }

    void waitUntilIdentityIsSet() {
        while (this.settingIdentity != null) {
            Misc.awaitForCondition(this.settingIdentity);
        }
    }

    void unlock() {
        this.mutex.unlock();
    }

    void settingIdentityComplete() {
        SanityManager.ASSERT((boolean)this.mutex.isHeldByCurrentThread());
        this.settingIdentity.signalAll();
        this.settingIdentity = null;
    }

    void keep(boolean accessed) {
        ReplacementPolicy.Callback temp;
        SanityManager.ASSERT((boolean)this.mutex.isHeldByCurrentThread());
        ++this.keepCount;
        if (accessed && (temp = this.callback) != null) {
            temp.access();
        }
    }

    void unkeep() {
        SanityManager.ASSERT((boolean)this.isKept());
        --this.keepCount;
        if (this.forRemove != null && this.keepCount == 1) {
            this.forRemove.signal();
        }
    }

    boolean isKept() {
        SanityManager.ASSERT((boolean)this.mutex.isHeldByCurrentThread());
        SanityManager.ASSERT((this.keepCount >= 0 ? 1 : 0) != 0);
        return this.keepCount > 0;
    }

    void unkeepForRemove() {
        SanityManager.ASSERT((boolean)this.isKept());
        SanityManager.ASSERT((this.forRemove == null ? 1 : 0) != 0);
        if (this.keepCount > 1) {
            this.forRemove = this.mutex.newCondition();
            while (this.keepCount > 1) {
                Misc.awaitForCondition(this.forRemove);
            }
            this.forRemove = null;
        }
        --this.keepCount;
    }

    void setCacheable(Cacheable c) {
        this.cacheable = c;
    }

    Cacheable getCacheable() {
        return this.cacheable;
    }

    boolean isValid() {
        SanityManager.ASSERT((boolean)this.mutex.isHeldByCurrentThread());
        return this.settingIdentity == null && this.cacheable != null;
    }

    void setCallback(ReplacementPolicy.Callback cb) {
        SanityManager.ASSERT((boolean)this.mutex.isHeldByCurrentThread());
        this.callback = cb;
    }

    void free() {
        SanityManager.ASSERT((boolean)this.mutex.isHeldByCurrentThread());
        ReplacementPolicy.Callback temp = this.callback;
        if (temp != null) {
            temp.free();
        }
        this.cacheable = null;
    }
}

