/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.impl.jdbc.TemporaryClob;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;

final class ClobUtf8Writer
extends Writer {
    private TemporaryClob control;
    private long pos;
    private boolean closed;

    ClobUtf8Writer(TemporaryClob control, long pos) {
        this.control = control;
        this.pos = pos;
        this.closed = false;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("XCL53"));
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("XCL53"));
        }
        try {
            long ret = this.control.insertString(String.copyValueOf(cbuf, off, len), this.pos);
            if (ret > 0L) {
                this.pos += ret;
            }
        }
        catch (SQLException e) {
            throw Util.newIOException(e);
        }
    }
}

