/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.RegionAndKey;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.ResultWasNull;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeUtilities;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDecimal;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import org.apache.spark.unsafe.types.UTF8String;

public abstract class AbstractCompactExecRow
extends GfxdDataSerializable
implements ExecRow,
Serializable {
    protected DataValueDescriptor[] deserializedCache;
    private int deserializedCacheLen;
    protected RowFormatter formatter;
    public static final int BYTE_BASE_MEMORY_USAGE = ClassSize.estimateAndCatalogBase(Byte.TYPE);
    protected TreeSet<RegionAndKey> setOfKeys;

    protected AbstractCompactExecRow() {
    }

    public AbstractCompactExecRow(RowFormatter rf) {
        assert (rf != null) : "RowFormatter must not be null";
        this.formatter = rf;
    }

    public AbstractCompactExecRow(RowFormatter rf, DataValueDescriptor[] row, int size, boolean doClone) {
        this(rf);
        this.deserializedCache = new DataValueDescriptor[rf.getNumColumns()];
        for (int index = 0; index < row.length; ++index) {
            if (row[index] == null) continue;
            this.deserializedCache[index] = doClone ? row[index].getClone() : row[index];
        }
        this.deserializedCacheLen = size;
    }

    @Override
    public final void setColumns(FormatableBitSet columns, DataValueDescriptor[] values) throws StandardException {
        this.basicSetColumns(columns, values);
        this.setCachedColumns(columns, values);
    }

    public final void setCompactColumns(FormatableBitSet columns, DataValueDescriptor[] values, int[] baseColumnMap) throws StandardException {
        int nCols = values.length;
        if (nCols > 0) {
            this.basicSetCompactColumns(columns, values);
            DataValueDescriptor[] cache = this.getDeserializedCache();
            int colIndex = columns.anySetBit();
            int index = 0;
            while (colIndex != -1 && colIndex < nCols) {
                if (cache[index] == null) {
                    ++this.deserializedCacheLen;
                }
                cache[index] = values[colIndex];
                if (baseColumnMap != null) {
                    baseColumnMap[index] = colIndex;
                }
                colIndex = columns.anySetBit(colIndex);
                ++index;
            }
        } else assert (this.formatter.getNumColumns() == 0) : "if none of the values are set such a condition can happen when DTD is also nothing";
    }

    public final void setColumns(int nCols, DataValueDescriptor[] values) throws StandardException {
        this.basicSetColumns(nCols, values);
        this.setCachedColumns(nCols, values);
    }

    @Override
    public final DataValueDescriptor getColumn(int position) throws StandardException {
        DataValueDescriptor[] cache = this.getDeserializedCache();
        DataValueDescriptor dvd = cache[position - 1];
        if (dvd == null) {
            ++this.deserializedCacheLen;
            try {
                DataValueDescriptor dataValueDescriptor = this.basicGetColumn(position);
                cache[position - 1] = dataValueDescriptor;
                return dataValueDescriptor;
            }
            catch (RuntimeException e) {
                Object byteSource = this.getByteSource();
                if (byteSource instanceof OffHeapByteSource) {
                    throw new RuntimeException("OffHeapByteSource of the corrupted row is" + byteSource, e);
                }
                throw e;
            }
        }
        return dvd;
    }

    @Override
    public final DataValueDescriptor getLastColumn() throws StandardException {
        return this.getColumn(this.formatter.getNumColumns());
    }

    @Override
    public final void resetRowArray() {
        this.basicResetRowArray();
        this.clearCachedRow();
    }

    protected final void clearCachedRow() {
        if (this.deserializedCache != null) {
            this.deserializedCache = null;
            this.deserializedCacheLen = 0;
        }
    }

    @Override
    public final DataValueDescriptor[] getRowArrayClone() {
        if (this.deserializedCacheLen == 0) {
            return this.basicGetRowArray();
        }
        DataValueDescriptor[] dvds = new DataValueDescriptor[this.formatter.getNumColumns()];
        int index = 0;
        for (DataValueDescriptor dvd : this.deserializedCache) {
            if (dvd == null) {
                try {
                    dvds[index] = this.basicGetColumn(index + 1);
                }
                catch (StandardException se) {
                    throw GemFireXDRuntimeException.newRuntimeException("unexpected exception in AbstractCompactExecRow#getRowArrayClone()", se);
                }
            } else {
                dvds[index] = dvd.getClone();
            }
            ++index;
        }
        return dvds;
    }

    @Override
    public final DataValueDescriptor[] getRowArray() {
        int rowLen = this.formatter.getNumColumns();
        if (this.deserializedCacheLen != rowLen || rowLen == 0) {
            DataValueDescriptor[] cache = this.getDeserializedCache();
            try {
                for (int index = 0; index < rowLen; ++index) {
                    if (cache[index] != null) continue;
                    cache[index] = this.basicGetColumn(index + 1);
                }
            }
            catch (StandardException e) {
                throw GemFireXDRuntimeException.newRuntimeException("AbstractCompactExecRow#getRowArray: unexpected exception", e);
            }
            this.deserializedCacheLen = rowLen;
            return cache;
        }
        return this.deserializedCache;
    }

    @Override
    public final void setRowArray(ExecRow otherRow) {
        this.basicSetRowArray(otherRow);
        this.clearCachedRow();
    }

    @Override
    public final void setValue(int columnIndex, DataValueDescriptor value) throws StandardException {
        DataValueDescriptor cached;
        this.basicSetColumn(columnIndex, value);
        if (this.deserializedCache != null && (cached = this.deserializedCache[columnIndex]) != null) {
            if (value != null && !value.isNull()) {
                cached.setValue(value);
            } else {
                cached.restoreToNull();
            }
        }
    }

    @Override
    public final void setValuesInto(int[] srcColumns, boolean zeroBased, ExecRow targetRow) throws StandardException {
        if (targetRow instanceof AbstractCompactExecRow) {
            ((AbstractCompactExecRow)targetRow).setColumns(srcColumns, zeroBased, this);
        } else {
            DataValueDescriptor[] dvds = targetRow.getRowArray();
            this.basicSetDVDValues(dvds, srcColumns, zeroBased);
        }
    }

    protected final void basicSetDVDValues(DataValueDescriptor[] dvds, int[] srcColumns, boolean zeroBased, byte[] source) throws StandardException {
        RowFormatter formatter = this.formatter;
        DataValueDescriptor[] cache = this.deserializedCache;
        int nsrcCols = srcColumns.length;
        for (int index = 0; index < nsrcCols; ++index) {
            DataValueDescriptor dvd = dvds[index];
            int srcIndex = srcColumns[index];
            if (!zeroBased) {
                --srcIndex;
            }
            if (srcIndex < 0) continue;
            if (dvd != null) {
                DataValueDescriptor srcDVD;
                if (cache == null || (srcDVD = cache[srcIndex]) == null) {
                    formatter.setDVDColumn(dvd, srcIndex, source);
                    continue;
                }
                dvd.setValue(srcDVD);
                continue;
            }
            dvds[index] = formatter.getColumn(srcIndex + 1, source);
        }
    }

    protected final void basicSetDVDValues(DataValueDescriptor[] dvds, int[] srcColumns, boolean zeroBased, byte[][] byteArrays) throws StandardException {
        RowFormatter formatter = this.formatter;
        DataValueDescriptor[] cache = this.deserializedCache;
        int nsrcCols = srcColumns.length;
        for (int index = 0; index < nsrcCols; ++index) {
            DataValueDescriptor dvd = dvds[index];
            int srcIndex = srcColumns[index];
            if (!zeroBased) {
                --srcIndex;
            }
            if (srcIndex < 0) continue;
            if (dvd != null) {
                DataValueDescriptor srcDVD;
                if (cache == null || (srcDVD = cache[srcIndex]) == null) {
                    formatter.setDVDColumn(dvd, srcIndex, this.getRowBytes(srcIndex + 1, byteArrays));
                    continue;
                }
                dvd.setValue(srcDVD);
                continue;
            }
            dvds[index] = formatter.getColumn(srcIndex + 1, byteArrays);
        }
    }

    protected final void basicSetDVDValues(DataValueDescriptor[] dvds, int[] srcColumns, boolean zeroBased, UnsafeWrapper unsafe, long memAddr, int bytesLen, OffHeapRow ohRow, OffHeapRowWithLobs ohLobRow) throws StandardException {
        RowFormatter formatter = this.formatter;
        DataValueDescriptor[] cache = this.deserializedCache;
        int nsrcCols = srcColumns.length;
        for (int index = 0; index < nsrcCols; ++index) {
            DataValueDescriptor dvd = dvds[index];
            int srcIndex = srcColumns[index];
            if (!zeroBased) {
                --srcIndex;
            }
            if (srcIndex < 0) continue;
            if (dvd != null) {
                DataValueDescriptor srcDVD;
                if (cache == null || (srcDVD = cache[srcIndex]) == null) {
                    if (ohRow != null) {
                        formatter.setDVDColumn(dvd, srcIndex, unsafe, memAddr, bytesLen, ohRow);
                        continue;
                    }
                    formatter.setDVDColumn(dvd, srcIndex, unsafe, memAddr, bytesLen, ohLobRow);
                    continue;
                }
                dvd.setValue(srcDVD);
                continue;
            }
            dvds[index] = ohRow != null ? formatter.getColumn(srcIndex + 1, unsafe, memAddr, bytesLen, ohRow) : formatter.getColumn(srcIndex + 1, unsafe, memAddr, bytesLen, ohLobRow);
        }
    }

    public final void setRowArray(AbstractCompactExecRow otherRow) {
        this.basicSetRowArray(otherRow);
        this.clearCachedRow();
    }

    protected final void setCachedColumns(FormatableBitSet columns, DataValueDescriptor[] values) {
        DataValueDescriptor[] cache = this.getDeserializedCache();
        if (columns != null) {
            int colIndex = columns.anySetBit();
            while (colIndex != -1) {
                if (cache[colIndex] == null) {
                    ++this.deserializedCacheLen;
                }
                cache[colIndex] = values[colIndex];
                colIndex = columns.anySetBit(colIndex);
            }
        } else {
            for (int colIndex = 0; colIndex < values.length; ++colIndex) {
                if (cache[colIndex] == null) {
                    ++this.deserializedCacheLen;
                }
                cache[colIndex] = values[colIndex];
            }
        }
    }

    protected final void setCachedColumns(int nCols, DataValueDescriptor[] values) {
        DataValueDescriptor[] cache = this.getDeserializedCache();
        for (int colIndex = 0; colIndex < nCols; ++colIndex) {
            if (cache[colIndex] == null) {
                ++this.deserializedCacheLen;
            }
            cache[colIndex] = values[colIndex];
        }
    }

    public final RowFormatter getRowFormatter() {
        return this.formatter;
    }

    public final void setRowFormatter(RowFormatter rf) {
        this.formatter = rf;
    }

    @Override
    public final void setColumns(FormatableBitSet columns, ExecRow srcRow) throws StandardException {
        if (srcRow instanceof AbstractCompactExecRow) {
            AbstractCompactExecRow srcCompactRow = (AbstractCompactExecRow)srcRow;
            if (columns == null) {
                int srcLen = srcCompactRow.nColumns();
                if (this.nColumns() == srcLen) {
                    this.basicSetRowArray(srcCompactRow);
                    this.clearCachedRow();
                } else {
                    this.basicSetColumns(srcLen, srcCompactRow);
                    if (this.deserializedCache != null) {
                        for (int index = 0; index < srcLen; ++index) {
                            if (this.deserializedCache[index] == null) continue;
                            this.deserializedCache[index] = null;
                            --this.deserializedCacheLen;
                        }
                    }
                }
            } else {
                this.basicSetColumns(columns, srcCompactRow, null);
                if (this.deserializedCache != null) {
                    int index = columns.anySetBit();
                    while (index != -1) {
                        if (this.deserializedCache[index] != null) {
                            this.deserializedCache[index] = null;
                            --this.deserializedCacheLen;
                        }
                        index = columns.anySetBit(index);
                    }
                }
            }
        } else {
            this.setColumns(columns, srcRow.getRowArray());
        }
    }

    @Override
    public final void setCompactColumns(FormatableBitSet columns, ExecRow row, int[] baseColumnMap, boolean copyColumns) throws StandardException {
        if (!copyColumns && baseColumnMap != null && columns != null) {
            int nSrcCols = row.nColumns();
            int nCols = this.nColumns();
            int i = columns.anySetBit();
            for (int pos = 0; i != -1 && i < nSrcCols && pos < nCols; ++pos) {
                baseColumnMap[pos] = i;
                i = columns.anySetBit(i);
            }
            return;
        }
        if (row instanceof AbstractCompactExecRow) {
            AbstractCompactExecRow srcCompactRow = (AbstractCompactExecRow)row;
            if (columns != null) {
                int nCols = columns.getNumBitsSet();
                if (nCols > 0) {
                    this.basicSetColumns(columns, srcCompactRow, baseColumnMap);
                    if (this.deserializedCache != null) {
                        int srcNCols = srcCompactRow.nColumns();
                        if (srcNCols < nCols) {
                            nCols = srcNCols;
                        }
                        for (int index = 0; index < nCols; ++index) {
                            if (this.deserializedCache[index] == null) continue;
                            this.deserializedCache[index] = null;
                            --this.deserializedCacheLen;
                        }
                    }
                } else assert (this.formatter.getNumColumns() == 0) : "if none of the values are set such a condition can happen when DTD is also nothing";
            } else {
                int srcLen = srcCompactRow.nColumns();
                if (this.nColumns() == srcLen) {
                    this.basicSetRowArray(srcCompactRow);
                    this.clearCachedRow();
                } else {
                    this.basicSetColumns(srcLen, srcCompactRow);
                    if (this.deserializedCache != null) {
                        for (int index = 0; index < srcLen; ++index) {
                            if (this.deserializedCache[index] == null) continue;
                            this.deserializedCache[index] = null;
                            --this.deserializedCacheLen;
                        }
                    }
                }
            }
        } else if (columns != null) {
            this.setCompactColumns(columns, row.getRowArray(), baseColumnMap);
        } else {
            this.setColumns(null, row.getRowArray());
        }
    }

    @Override
    public final void setColumns(int[] columns, boolean zeroBased, ExecRow srcRow) throws StandardException {
        block9: {
            block6: {
                AbstractCompactExecRow srcCompactRow;
                block7: {
                    int srcLen;
                    block8: {
                        if (!(srcRow instanceof AbstractCompactExecRow)) break block6;
                        srcCompactRow = (AbstractCompactExecRow)srcRow;
                        if (columns != null) break block7;
                        srcLen = srcCompactRow.nColumns();
                        if (this.nColumns() != srcLen) break block8;
                        this.basicSetRowArray(srcCompactRow);
                        this.clearCachedRow();
                        break block9;
                    }
                    this.basicSetColumns(srcLen, srcCompactRow);
                    if (this.deserializedCache == null) break block9;
                    for (int index = 0; index < srcLen; ++index) {
                        if (this.deserializedCache[index] == null) continue;
                        this.deserializedCache[index] = null;
                        --this.deserializedCacheLen;
                    }
                    break block9;
                }
                this.basicSetColumns(columns, zeroBased, srcCompactRow);
                if (this.deserializedCache == null) break block9;
                for (int index = 0; index < columns.length; ++index) {
                    if (this.deserializedCache[index] == null) continue;
                    this.deserializedCache[index] = null;
                    --this.deserializedCacheLen;
                }
                break block9;
            }
            DataValueDescriptor[] dvds = srcRow.getRowArray();
            if (zeroBased) {
                for (int index = 0; index < columns.length; ++index) {
                    this.setColumn(index + 1, dvds[columns[index]]);
                }
            } else {
                for (int index = 0; index < columns.length; ++index) {
                    this.setColumn(index + 1, dvds[columns[index] - 1]);
                }
            }
        }
    }

    @Override
    public final void setColumns(int nCols, ExecRow srcRow) throws StandardException {
        if (srcRow instanceof AbstractCompactExecRow) {
            AbstractCompactExecRow srcCompactRow = (AbstractCompactExecRow)srcRow;
            if (nCols == this.nColumns() && nCols == srcCompactRow.nColumns()) {
                this.basicSetRowArray(srcCompactRow);
                this.clearCachedRow();
            } else {
                this.basicSetColumns(nCols, srcCompactRow);
                if (this.deserializedCache != null) {
                    for (int index = 0; index < nCols; ++index) {
                        if (this.deserializedCache[index] == null) continue;
                        this.deserializedCache[index] = null;
                        --this.deserializedCacheLen;
                    }
                }
            }
        } else {
            this.setColumns(nCols, srcRow.getRowArray());
        }
    }

    public final void setRowArray(byte[] rowArray, RowFormatter formatter) {
        this.basicSetRowArray(rowArray, formatter);
        this.clearCachedRow();
    }

    public final void setRowArray(byte[][] rowArray, RowFormatter formatter) {
        this.basicSetRowArray(rowArray, formatter);
        this.clearCachedRow();
    }

    protected final DataValueDescriptor[] getDeserializedCache() {
        if (this.deserializedCache != null) {
            return this.deserializedCache;
        }
        this.deserializedCache = new DataValueDescriptor[this.formatter.getNumColumns()];
        return this.deserializedCache;
    }

    protected abstract void basicSetColumns(FormatableBitSet var1, DataValueDescriptor[] var2) throws StandardException;

    protected abstract void basicSetColumn(int var1, DataValueDescriptor var2) throws StandardException;

    protected abstract void basicSetCompactColumns(FormatableBitSet var1, DataValueDescriptor[] var2) throws StandardException;

    protected abstract void basicSetColumns(int var1, DataValueDescriptor[] var2) throws StandardException;

    protected abstract void basicSetColumns(FormatableBitSet var1, AbstractCompactExecRow var2, int[] var3) throws StandardException;

    protected abstract void basicSetColumns(int[] var1, boolean var2, AbstractCompactExecRow var3) throws StandardException;

    protected abstract void basicSetColumns(int var1, AbstractCompactExecRow var2) throws StandardException;

    protected abstract DataValueDescriptor basicGetColumn(int var1) throws StandardException;

    protected abstract void basicResetRowArray();

    protected abstract DataValueDescriptor[] basicGetRowArray();

    protected abstract void basicSetRowArray(ExecRow var1);

    protected abstract void basicSetRowArray(AbstractCompactExecRow var1);

    protected abstract void basicSetRowArray(byte[] var1, RowFormatter var2);

    protected abstract void basicSetRowArray(byte[][] var1, RowFormatter var2);

    protected abstract void basicSetDVDValues(DataValueDescriptor[] var1, int[] var2, boolean var3) throws StandardException;

    protected abstract byte[] getRowBytes();

    public abstract byte[] getRowBytes(int var1);

    protected abstract byte[][] getRowByteArrays();

    protected abstract byte[][] getRowByteArraysIfPresent();

    public abstract boolean hasByteArrays();

    protected final byte[] getRowBytes(int logicalPosition, byte[][] byteArrays) {
        if (!this.formatter.getColumnDescriptor((int)(logicalPosition - 1)).isLob) {
            if (byteArrays != null) {
                return byteArrays[0];
            }
            return null;
        }
        return this.formatter.getLob(byteArrays, logicalPosition);
    }

    protected final byte[] getRowBytes(int logicalPosition, OffHeapRowWithLobs byteArrays) {
        if (!this.formatter.getColumnDescriptor((int)(logicalPosition - 1)).isLob) {
            return byteArrays.getRowBytes();
        }
        return this.formatter.getLob(byteArrays, logicalPosition);
    }

    protected final byte[] getRowBytes(int logicalPosition, OffHeapRow bytes) {
        if (!this.formatter.getColumnDescriptor((int)(logicalPosition - 1)).isLob) {
            return bytes.getRowBytes();
        }
        return this.formatter.getLob((OffHeapRowWithLobs)null, logicalPosition);
    }

    @Override
    public final byte[] getRowBytes(RowFormatter formatter) {
        return this.getRowBytes();
    }

    @Override
    public final byte[][] getRowByteArrays(RowFormatter formatter) {
        return this.getRowByteArrays();
    }

    @Override
    public abstract Object getRawRowValue(boolean var1);

    abstract void basicSetByteSource(Object var1);

    @Override
    public final int nColumns() {
        return this.formatter.getNumColumns();
    }

    public final ColumnDescriptor getColumnDescriptor(int logicalPosition) {
        return this.formatter.columns[logicalPosition - 1];
    }

    @Override
    public final void setColumn(int position, DataValueDescriptor value) {
        throw new UnsupportedOperationException("Use setColumns instead");
    }

    @Override
    public abstract AbstractCompactExecRow getClone();

    @Override
    public abstract AbstractCompactExecRow getShallowClone();

    @Override
    public final AbstractCompactExecRow getClone(FormatableBitSet clonedCols) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public abstract AbstractCompactExecRow getNewNullRow();

    @Override
    public final DataValueDescriptor cloneColumn(int position) {
        try {
            DataValueDescriptor column;
            if (this.deserializedCache == null || (column = this.deserializedCache[position - 1]) == null) {
                return this.basicGetColumn(position);
            }
            return column.getClone();
        }
        catch (StandardException e) {
            throw GemFireXDRuntimeException.newRuntimeException("AbstractCompactExecRow#cloneColumn: unexpected exception", e);
        }
    }

    @Override
    public final void setRowArray(DataValueDescriptor[] rowArray) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public final void getNewObjectArray() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "@" + System.identityHashCode(this));
        if (this.formatter != null) {
            ArrayUtils.objectStringNonRecursive((Object)this.getRowArray(), (StringBuilder)sb);
        } else {
            sb.append("(NULL formatter) rawValue ");
            ArrayUtils.objectStringNonRecursive((Object)this.getRawRowValue(false), (StringBuilder)sb);
        }
        return sb.toString();
    }

    public final double getAsDouble(int position, ResultWasNull wasNull) throws StandardException {
        DataValueDescriptor dvd;
        if (this.deserializedCache == null || (dvd = this.deserializedCache[position - 1]) == null) {
            return this.getDouble(position, wasNull);
        }
        if (!dvd.isNull()) {
            return dvd.getDouble();
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0.0;
    }

    public final String getAsString(int position, ResultWasNull wasNull) throws StandardException {
        DataValueDescriptor dvd;
        if (this.deserializedCache == null || (dvd = this.deserializedCache[position - 1]) == null) {
            return this.getString(position, wasNull);
        }
        String result = dvd.getString();
        if (result != null) {
            return result;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    public final Object getAsObject(int position, ResultWasNull wasNull) throws StandardException {
        DataValueDescriptor dvd;
        if (this.deserializedCache == null || (dvd = this.deserializedCache[position - 1]) == null) {
            return this.getObject(position, wasNull);
        }
        Object result = dvd.getObject();
        if (result != null) {
            return result;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    public final boolean getAsBoolean(int position, ResultWasNull wasNull) throws StandardException {
        DataValueDescriptor dvd;
        if (this.deserializedCache == null || (dvd = this.deserializedCache[position - 1]) == null) {
            return this.getBoolean(position, wasNull);
        }
        if (!dvd.isNull()) {
            return dvd.getBoolean();
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return false;
    }

    public final byte getAsByte(int position, ResultWasNull wasNull) throws StandardException {
        DataValueDescriptor dvd;
        if (this.deserializedCache == null || (dvd = this.deserializedCache[position - 1]) == null) {
            return this.getByte(position, wasNull);
        }
        if (!dvd.isNull()) {
            return dvd.getByte();
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0;
    }

    public final short getAsShort(int position, ResultWasNull wasNull) throws StandardException {
        DataValueDescriptor dvd;
        if (this.deserializedCache == null || (dvd = this.deserializedCache[position - 1]) == null) {
            return this.getShort(position, wasNull);
        }
        if (!dvd.isNull()) {
            return dvd.getShort();
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0;
    }

    public final int getAsInt(int position, ResultWasNull wasNull) throws StandardException {
        DataValueDescriptor dvd;
        if (this.deserializedCache == null || (dvd = this.deserializedCache[position - 1]) == null) {
            return this.getInt(position, wasNull);
        }
        if (!dvd.isNull()) {
            return dvd.getInt();
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0;
    }

    public final long getAsLong(int position, ResultWasNull wasNull) throws StandardException {
        DataValueDescriptor dvd;
        if (this.deserializedCache == null || (dvd = this.deserializedCache[position - 1]) == null) {
            return this.getLong(position, wasNull);
        }
        if (!dvd.isNull()) {
            return dvd.getLong();
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0L;
    }

    public final float getAsFloat(int position, ResultWasNull wasNull) throws StandardException {
        DataValueDescriptor dvd;
        if (this.deserializedCache == null || (dvd = this.deserializedCache[position - 1]) == null) {
            return this.getFloat(position, wasNull);
        }
        if (!dvd.isNull()) {
            return dvd.getFloat();
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return 0.0f;
    }

    public final BigDecimal getAsBigDecimal(int position, ResultWasNull wasNull) throws StandardException {
        DataValueDescriptor dvd;
        if (this.deserializedCache == null || (dvd = this.deserializedCache[position - 1]) == null) {
            return this.getBigDecimal(position, wasNull);
        }
        if (!dvd.isNull()) {
            return SQLDecimal.getBigDecimal(dvd);
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    public final byte[] getAsBytes(int position, ResultWasNull wasNull) throws StandardException {
        DataValueDescriptor dvd;
        if (this.deserializedCache == null || (dvd = this.deserializedCache[position - 1]) == null) {
            return this.getBytes(position, wasNull);
        }
        byte[] result = dvd.getBytes();
        if (result != null) {
            return result;
        }
        if (wasNull != null) {
            wasNull.setWasNull();
        }
        return null;
    }

    public final Date getAsDate(int position, Calendar cal, ResultWasNull wasNull) throws StandardException {
        DataValueDescriptor dvd;
        if (this.deserializedCache == null || (dvd = this.deserializedCache[position - 1]) == null) {
            return this.getDate(position, cal, wasNull);
        }
        return dvd.getDate(cal);
    }

    public final Time getAsTime(int position, Calendar cal, ResultWasNull wasNull) throws StandardException {
        DataValueDescriptor dvd;
        if (this.deserializedCache == null || (dvd = this.deserializedCache[position - 1]) == null) {
            return this.getTime(position, cal, wasNull);
        }
        return dvd.getTime(cal);
    }

    public final Timestamp getAsTimestamp(int position, Calendar cal, ResultWasNull wasNull) throws StandardException {
        DataValueDescriptor dvd;
        if (this.deserializedCache == null || (dvd = this.deserializedCache[position - 1]) == null) {
            return this.getTimestamp(position, cal, wasNull);
        }
        return dvd.getTimestamp(cal);
    }

    public Blob getAsBlob(int position, ResultWasNull wasNull) throws StandardException {
        int index = position - 1;
        ColumnDescriptor cd = this.formatter.getColumnDescriptor(index);
        throw StandardException.newException("22005", (Object)"Blob", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    public Clob getAsClob(int position, ResultWasNull wasNull) throws StandardException {
        int index = position - 1;
        ColumnDescriptor cd = this.formatter.getColumnDescriptor(index);
        throw StandardException.newException("22005", (Object)"Clob", (Object)cd.getType().getFullSQLTypeName(), (Object)cd.getColumnName());
    }

    public abstract UTF8String getAsUTF8String(int var1) throws StandardException;

    protected abstract String getString(int var1, ResultWasNull var2) throws StandardException;

    protected abstract Object getObject(int var1, ResultWasNull var2) throws StandardException;

    protected abstract boolean getBoolean(int var1, ResultWasNull var2) throws StandardException;

    protected abstract byte getByte(int var1, ResultWasNull var2) throws StandardException;

    protected abstract short getShort(int var1, ResultWasNull var2) throws StandardException;

    protected abstract int getInt(int var1, ResultWasNull var2) throws StandardException;

    protected abstract long getLong(int var1, ResultWasNull var2) throws StandardException;

    protected abstract float getFloat(int var1, ResultWasNull var2) throws StandardException;

    protected abstract double getDouble(int var1, ResultWasNull var2) throws StandardException;

    protected abstract byte[] getBytes(int var1, ResultWasNull var2) throws StandardException;

    protected abstract BigDecimal getBigDecimal(int var1, ResultWasNull var2) throws StandardException;

    public abstract long getAsDateMillis(int var1, Calendar var2, ResultWasNull var3) throws StandardException;

    protected abstract Date getDate(int var1, Calendar var2, ResultWasNull var3) throws StandardException;

    protected abstract Time getTime(int var1, Calendar var2, ResultWasNull var3) throws StandardException;

    public abstract long getAsTimestampMicros(int var1, Calendar var2, ResultWasNull var3) throws StandardException;

    protected abstract Timestamp getTimestamp(int var1, Calendar var2, ResultWasNull var3) throws StandardException;

    @Override
    public final long estimateRowSize() throws StandardException {
        long sz = AbstractCompactExecRow.getRawRowSize(this.getBaseByteSource());
        TreeSet<RegionAndKey> setOfKeys = this.setOfKeys;
        if (setOfKeys != null && setOfKeys.size() > 0) {
            try {
                for (RegionAndKey rak : setOfKeys) {
                    sz += (long)ClassSize.refSize + rak.estimateMemoryUsage();
                }
            }
            catch (ConcurrentModificationException | NoSuchElementException runtimeException) {
                // empty catch block
            }
        }
        return sz;
    }

    public static final long getRawRowSize(Object row) {
        long sz = 0L;
        if (row != null) {
            Class<?> cls = row.getClass();
            if (cls == byte[].class) {
                sz = ClassSize.estimateArrayOverhead() + BYTE_BASE_MEMORY_USAGE + ClassSize.refSize + ((byte[])row).length;
            } else if (cls == byte[][].class) {
                byte[][] rowArr;
                sz = ClassSize.estimateArrayOverhead() + ClassSize.refSize;
                for (byte[] bytes : rowArr = (byte[][])row) {
                    if (bytes == null) continue;
                    sz += (long)bytes.length;
                }
                sz += (long)((BYTE_BASE_MEMORY_USAGE + ClassSize.refSize) * rowArr.length);
            } else {
                sz = 8L;
                sz += (long)((OffHeapByteSource)((Object)row)).getSizeInBytes();
            }
        }
        return sz;
    }

    @Override
    public final void addRegionAndKey(String regionName, Object key, boolean isReplicated) {
        this.getOrCreateRegionAndKeyInfo().add(new RegionAndKey(regionName, key, isReplicated));
    }

    @Override
    public final void addRegionAndKey(RegionAndKey rak) {
        if (rak != null) {
            this.getOrCreateRegionAndKeyInfo().add(rak);
        }
    }

    @Override
    public final void addAllKeys(TreeSet<RegionAndKey> allKeys) {
        if (allKeys != null) {
            this.getOrCreateRegionAndKeyInfo().addAll(allKeys);
        }
    }

    protected final TreeSet<RegionAndKey> getOrCreateRegionAndKeyInfo() {
        if (this.setOfKeys != null) {
            return this.setOfKeys;
        }
        this.setOfKeys = new TreeSet<RegionAndKey>();
        return this.setOfKeys;
    }

    @Override
    public final TreeSet<RegionAndKey> getAllRegionAndKeyInfo() {
        return this.setOfKeys;
    }

    @Override
    public final void setAllRegionAndKeyInfo(TreeSet<RegionAndKey> keys) {
        this.setOfKeys = keys;
    }

    @Override
    public final void clearAllRegionAndKeyInfo() {
        this.setOfKeys = null;
    }

    protected final int compare(ExecRow row, byte[] bytes, int logicalPosition, long thisOffsetWidth, boolean nullsOrderedLow) throws StandardException {
        if (row instanceof AbstractCompactExecRow) {
            AbstractCompactExecRow cRow = (AbstractCompactExecRow)row;
            RowFormatter rf = cRow.formatter;
            Object rhsBytes = cRow.getByteSource(logicalPosition);
            if (rhsBytes != null) {
                OffHeapByteSource rhs;
                long memAddr;
                int bytesLen;
                OffHeapByteSource rhsBS;
                Class<?> rhsClass = rhsBytes.getClass();
                if (rhsClass == byte[].class) {
                    byte[] rhs2 = (byte[])rhsBytes;
                    return DataTypeUtilities.compare(bytes, rhs2, thisOffsetWidth, rf.getOffsetAndWidth(logicalPosition, rhs2), nullsOrderedLow, true, rf.columns[logicalPosition - 1]);
                }
                UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
                if (rhsClass == OffHeapRow.class) {
                    rhsBS = (OffHeapRow)((Object)rhsBytes);
                    bytesLen = rhsBS.getLength();
                    memAddr = rhsBS.getUnsafeAddress(0, bytesLen);
                    rhs = rhsBS;
                } else {
                    rhsBS = (OffHeapRowWithLobs)((Object)rhsBytes);
                    bytesLen = ((OffHeapRowWithLobs)rhsBS).getLength();
                    memAddr = ((OffHeapRowWithLobs)rhsBS).getUnsafeAddress(0, bytesLen);
                    rhs = rhsBS;
                }
                long rhsOffsetWidth = rf.getOffsetAndWidth(logicalPosition, unsafe, memAddr, bytesLen);
                return DataTypeUtilities.compare(unsafe, bytes, 0L, null, null, memAddr, rhs, thisOffsetWidth, rhsOffsetWidth, nullsOrderedLow, true, rf.columns[logicalPosition - 1]);
            }
            return DataTypeUtilities.compare(bytes, null, thisOffsetWidth, -7L, nullsOrderedLow, true, rf.columns[logicalPosition - 1]);
        }
        return -Integer.signum(DataTypeUtilities.compare(row.getColumn(logicalPosition), bytes, thisOffsetWidth, nullsOrderedLow, true, this.formatter.columns[logicalPosition - 1]));
    }

    protected final int compare(ExecRow row, OffHeapByteSource bytes, int logicalPosition, long thisOffsetWidth, boolean nullsOrderedLow) throws StandardException {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        long thisAddr = bytes.getUnsafeAddress();
        if (row instanceof AbstractCompactExecRow) {
            AbstractCompactExecRow cRow = (AbstractCompactExecRow)row;
            RowFormatter rf = cRow.formatter;
            Object rhsBytes = cRow.getByteSource(logicalPosition);
            if (rhsBytes != null) {
                OffHeapByteSource rhs;
                long memAddr;
                int bytesLen;
                OffHeapByteSource rhsBS;
                Class<?> rhsClass = rhsBytes.getClass();
                if (rhsClass == byte[].class) {
                    byte[] rhs2 = (byte[])rhsBytes;
                    return DataTypeUtilities.compare(unsafe, null, thisAddr, bytes, rhs2, 0L, null, thisOffsetWidth, rf.getOffsetAndWidth(logicalPosition, rhs2), nullsOrderedLow, true, rf.columns[logicalPosition - 1]);
                }
                if (rhsClass == OffHeapRow.class) {
                    rhsBS = (OffHeapRow)((Object)rhsBytes);
                    bytesLen = rhsBS.getLength();
                    memAddr = rhsBS.getUnsafeAddress(0, bytesLen);
                    rhs = rhsBS;
                } else {
                    rhsBS = (OffHeapRowWithLobs)((Object)rhsBytes);
                    bytesLen = ((OffHeapRowWithLobs)rhsBS).getLength();
                    memAddr = ((OffHeapRowWithLobs)rhsBS).getUnsafeAddress(0, bytesLen);
                    rhs = rhsBS;
                }
                long rhsOffsetWidth = rf.getOffsetAndWidth(logicalPosition, unsafe, memAddr, bytesLen);
                return DataTypeUtilities.compare(unsafe, null, thisAddr, bytes, null, memAddr, rhs, thisOffsetWidth, rhsOffsetWidth, nullsOrderedLow, true, rf.columns[logicalPosition - 1]);
            }
            return DataTypeUtilities.compare(unsafe, null, thisAddr, bytes, null, 0L, null, thisOffsetWidth, -7L, nullsOrderedLow, true, rf.columns[logicalPosition - 1]);
        }
        return -Integer.signum(DataTypeUtilities.compare(unsafe, row.getColumn(logicalPosition), null, thisAddr, bytes, thisOffsetWidth, nullsOrderedLow, true, this.formatter.columns[logicalPosition - 1]));
    }

    public abstract Object getByteSource(int var1);

    public void setByteSource(Object source, RowFormatter rf) {
        this.setByteSource(source);
        this.formatter = rf;
    }

    public void setByteSource(Object source) {
        this.clearCachedRow();
        this.basicSetByteSource(source);
    }
}

