/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.execute.EmptyRegionFunctionException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.AbstractRegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gnu.trove.THashMap;
import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GlobalRowLocation;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdCacheLoader;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdCallbackArgument;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdListResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdSingleResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GetAllExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GetAllLocalIndexExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GetExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.ProjectionRow;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionMultiKeyExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionSingleKeyExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DynamicKey;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.FunctionUtils;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireDistributedResultSet;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TargetResultSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.impl.sql.StatementStats;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public final class GemFireResultSet
extends AbstractGemFireResultSet
implements NoPutResultSet {
    public static DataValueDescriptor DUMMY_PK = new SQLInteger(0);
    private final SelectQueryInfo selectQI;
    private final GemFireContainer gfContainer;
    private final boolean isOffHeap;
    private final GemFireContainer gfIndexContainer;
    private final StatementStats stats;
    private ExecRow candidate;
    private final RowFormatter projectionFormat;
    private final int[] projectionFixedColumns;
    private final int[] projectionVarColumns;
    private final int[] projectionLobColumns;
    private final int[] projectionAllColumnsWithLobs;
    private final int resultsetNumber;
    private final int isolationLevel;
    private final boolean forUpdate;
    private DataValueDescriptor[] cachedChangedRow;
    private Object[] gfKeys;
    private Object currentRoutingObject;
    private Map<Object, Integer> getAllKeysAndRoutingObjects;
    private int currPos;
    private boolean isTopResultSet;
    private boolean doGetAll;
    private boolean doGetAllOnLocalIndex;
    private boolean getAllDone;
    private boolean getAllOnGlobalIndexDone;
    private Iterator<?> getAllItr = null;
    private List<?> getAllResults = null;
    private Iterator<?> getAllResultsItr = null;
    private Iterator<?> getAllKeysItr = null;
    private DistributedMember currentMemberForGetAll;
    private RegionMultiKeyExecutorMessage getAllMsg = null;
    private final boolean isTheRegionReplicate;
    private final boolean isGlobalIndexCase;
    private boolean queryHDFS = false;
    public transient int rowsReturned;
    private final GetAllSingletonResult singletonResultGetAll = new GetAllSingletonResult();

    public GemFireResultSet(Activation activation, GeneratedMethod resultRowAllocator, int resultSetNumber, int formatterItem, int fixedColsItem, int varColsItem, int lobColsItem, int allColsItem, int allColsWithLobsItem, int isolationLevel, boolean forUpdate, SelectQueryInfo selectQI, StatementStats stats, boolean isGFEActivation, boolean queryHDFS) throws StandardException {
        super(activation);
        RowFormatter projectionFormat;
        if (isGFEActivation) {
            projectionFormat = selectQI.getRowFormatter();
            this.projectionFixedColumns = selectQI.getProjectionFixedColumns();
            this.projectionVarColumns = selectQI.getProjectionVarColumns();
            this.projectionLobColumns = selectQI.getProjectionLobColumns();
            this.projectionAllColumnsWithLobs = selectQI.getProjectionAllColumnsWithLobs();
        } else {
            ExecPreparedStatement ps = activation.getPreparedStatement();
            if (formatterItem != -1) {
                projectionFormat = (RowFormatter)activation.getSavedObject(formatterItem);
                this.projectionFixedColumns = (int[])(fixedColsItem != -1 ? (int[])activation.getSavedObject(fixedColsItem) : null);
                this.projectionVarColumns = (int[])(varColsItem != -1 ? (int[])activation.getSavedObject(varColsItem) : null);
                this.projectionLobColumns = (int[])(lobColsItem != -1 ? (int[])activation.getSavedObject(lobColsItem) : null);
                this.projectionAllColumnsWithLobs = (int[])activation.getSavedObject(allColsWithLobsItem);
            } else {
                projectionFormat = null;
                this.projectionFixedColumns = null;
                this.projectionVarColumns = null;
                this.projectionLobColumns = null;
                this.projectionAllColumnsWithLobs = null;
            }
        }
        this.resultsetNumber = resultSetNumber;
        this.isolationLevel = isolationLevel;
        this.forUpdate = forUpdate;
        LocalRegion region = selectQI.getRegion();
        this.gfContainer = (GemFireContainer)region.getUserAttribute();
        if (this.gfContainer != null) {
            if (projectionFormat == null) {
                projectionFormat = this.gfContainer.getCurrentRowFormatter();
            }
            this.isOffHeap = this.gfContainer.isOffHeap();
        } else {
            this.isOffHeap = false;
        }
        this.projectionFormat = projectionFormat;
        this.stats = stats;
        this.isGlobalIndexCase = GemFireXDUtils.isGlobalIndexCase((AbstractRegion)region);
        DataPolicy policy = region.getDataPolicy();
        this.isTheRegionReplicate = policy.withReplication() || !policy.withStorage();
        this.selectQI = selectQI;
        Object pk = selectQI.getPrimaryKey();
        Object fk = selectQI.getLocalIndexKey();
        assert (pk != null ^ fk != null);
        if (pk != null) {
            if (pk instanceof Object[]) {
                if (policy.withPartitioning()) {
                    this.doGetAll = true;
                    this.getAllKeysAndRoutingObjects = new THashMap();
                    if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                        SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GemFireResultSet: PK based Query would be executed using GetAll. isGlobalIndexCase = " + this.isGlobalIndexCase));
                    }
                    if (this.isGlobalIndexCase) assert (!selectQI.isPrimaryKeyComposite());
                } else if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"GemFireResultSet: PK based Query would Not be executed using GetAll, but Get would be called in loop since table is not partitioned");
                }
            }
            this.gfIndexContainer = null;
        } else if (fk != null) {
            assert (selectQI.getChosenLocalIndex() != null);
            this.doGetAllOnLocalIndex = true;
            this.gfIndexContainer = Misc.getMemStore().getContainer(ContainerKey.valueOf(0L, selectQI.getChosenLocalIndex().getConglomerateNumber()));
            if (this.gfIndexContainer == null) {
                SanityManager.THROWASSERT((String)("unexpected null container for index: " + selectQI.getChosenLocalIndex()));
            }
        } else {
            this.gfIndexContainer = null;
            SanityManager.THROWASSERT((String)"GemFireResultSet cannot handle this Query");
        }
        this.gfKeys = null;
        this.currPos = 0;
        if (this.observer != null) {
            this.observer.createdGemFireXDResultSet(this);
        }
        this.queryHDFS = queryHDFS;
    }

    private Object[] setGfKeysFromIndexKeys(Object localIndexKey) throws StandardException {
        Object[] indxKeys;
        if (localIndexKey instanceof Object[]) {
            if (this.selectQI.isWhereClauseDynamic()) {
                Object[] pks = (Object[])localIndexKey;
                int len = pks.length;
                indxKeys = new Object[len];
                for (int i = 0; i < len; ++i) {
                    if (pks[i] instanceof DynamicKey) {
                        DynamicKey dk = (DynamicKey)pks[i];
                        indxKeys[i] = dk.getEvaluatedIndexKey(this.activation);
                        continue;
                    }
                    indxKeys[i] = pks[i];
                }
                if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                    ParameterValueSet pvs = this.activation.getParameterValueSet();
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GemFireResultSet determined index based gfKeys=" + com.pivotal.gemfirexd.internal.impl.sql.execute.RowUtil.toString(indxKeys) + " from ParameterValueSet@" + Integer.toHexString(System.identityHashCode(pvs)) + pvs));
                }
            } else {
                indxKeys = (Object[])localIndexKey;
            }
        } else {
            indxKeys = new Object[1];
            if (this.selectQI.isWhereClauseDynamic()) {
                DynamicKey dk = (DynamicKey)localIndexKey;
                indxKeys[0] = dk.getEvaluatedIndexKey(this.activation);
            } else {
                indxKeys[0] = localIndexKey;
            }
        }
        SanityManager.ASSERT((indxKeys != null ? 1 : 0) != 0);
        return indxKeys;
    }

    @Override
    public void setGfKeysForNCJoin(ArrayList<DataValueDescriptor> keys) throws StandardException {
        int len = keys.size();
        this.gfKeys = new Object[len];
        for (int i = 0; i < len; ++i) {
            this.gfKeys[i] = GemFireXDUtils.convertIntoGemfireRegionKey(keys.get(i), this.gfContainer, false);
        }
    }

    private void ncjSetGfKeysFromPrimaryKeys(Object pk) throws StandardException {
        Object[] pKeys = this.setGfKeysFromIndexKeys(pk);
        SanityManager.ASSERT((pKeys.length == 1 ? 1 : 0) != 0);
        if (pKeys[0] instanceof DVDSet) {
            DataValueDescriptor[] values = ((DVDSet)pKeys[0]).getValues();
            int len = values.length;
            this.gfKeys = new Object[len];
            for (int i = 0; i < len; ++i) {
                DataValueDescriptor dvd = values[i];
                this.gfKeys[i] = GemFireXDUtils.convertIntoGemfireRegionKey(dvd, this.gfContainer, false);
            }
        } else {
            this.gfKeys = this.setGfKeysFromPrimaryKeys(pk);
        }
    }

    private void ncjSetGfKeysFromIndexKeys(Object fk) throws StandardException {
        Object[] fKeys = this.setGfKeysFromIndexKeys(fk);
        SanityManager.ASSERT((fKeys.length == 1 ? 1 : 0) != 0);
        if (fKeys[0] instanceof DVDSet) {
            DataValueDescriptor[] values = ((DVDSet)fKeys[0]).getValues();
            int len = values.length;
            this.gfKeys = new DataValueDescriptor[len];
            for (int i = 0; i < len; ++i) {
                DataValueDescriptor dvd = values[i];
                this.gfKeys[i] = dvd;
            }
        } else {
            this.gfKeys = this.setGfKeysFromIndexKeys(fk);
        }
    }

    private Object[] setGfKeysFromPrimaryKeys(Object pk) throws StandardException {
        Object[] pkKeys;
        if (pk instanceof Object[]) {
            if (this.selectQI.isWhereClauseDynamic()) {
                Object[] pks = (Object[])pk;
                int len = pks.length;
                pkKeys = new Object[len];
                for (int i = 0; i < len; ++i) {
                    if (pks[i] instanceof DynamicKey) {
                        DynamicKey dk = (DynamicKey)pks[i];
                        pkKeys[i] = dk.getEvaluatedPrimaryKey(this.activation, this.gfContainer, false);
                        continue;
                    }
                    pkKeys[i] = pks[i];
                }
            } else {
                pkKeys = (Object[])pk;
            }
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                ParameterValueSet pvs = this.activation.getParameterValueSet();
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GemFireResultSet determined pk based gfKeys=" + (pkKeys == null ? "null" : com.pivotal.gemfirexd.internal.impl.sql.execute.RowUtil.toString(pkKeys)) + " from ParameterValueSet@" + Integer.toHexString(System.identityHashCode(pvs)) + pvs));
            }
        } else {
            pkKeys = new Object[1];
            if (this.selectQI.isWhereClauseDynamic()) {
                DynamicKey dk = (DynamicKey)pk;
                pk = dk.getEvaluatedPrimaryKey(this.activation, this.gfContainer, false);
            }
            pkKeys[0] = pk;
        }
        SanityManager.ASSERT((pkKeys != null ? 1 : 0) != 0);
        return pkKeys;
    }

    public static boolean exceptionCanBeIgnored(StandardException ex) {
        for (Throwable t = ex; t != null; t = t.getCause()) {
            if (t instanceof EntryExistsException) {
                return true;
            }
            if (!(t instanceof StandardException) || !t.getSQLState().equals("23505")) continue;
            return true;
        }
        return false;
    }

    private ExecRow getResultRowFromFetchRow(ExecRow fetchRow) throws StandardException {
        if (this.projectionAllColumnsWithLobs != null && fetchRow != null) {
            if (this.candidate == null) {
                this.candidate = this.gfContainer.newTemplateRow(this.projectionFormat, this.projectionAllColumnsWithLobs);
            }
            this.candidate.setColumns(this.projectionAllColumnsWithLobs, false, fetchRow);
        } else {
            this.candidate = fetchRow;
        }
        return this.candidate;
    }

    @Override
    public ExecRow getNextRow() throws StandardException {
        long beginTime = this.statisticsTimingOn ? XPLAINUtil.recordTiming(-1L) : 0L;
        try {
            Object bs;
            ExecRow next = this.fetchNext();
            if (next != null) {
                this.activation.setCurrentRow(next, this.resultsetNumber);
                ++this.rowsReturned;
                if (this.isOffHeap) {
                    bs = next.getByteSource();
                    if (bs instanceof OffHeapByteSource) {
                        this.tran.addByteSource((OffHeapByteSource)((Object)bs));
                    } else {
                        this.tran.addByteSource(null);
                    }
                }
            }
            bs = next;
            return bs;
        }
        catch (Exception ex) {
            this.close(true);
            LocalRegion region = this.gfContainer != null ? this.gfContainer.getRegion() : null;
            String method = "GemFireResultSet::getNextRow";
            GemFireXDUtils.processCancelException("GemFireResultSet::getNextRow", ex, null);
            if (ex instanceof StandardException) {
                throw (StandardException)ex;
            }
            throw Misc.processFunctionException("GemFireResultSet::getNextRow", ex, null, region);
        }
        catch (Error e) {
            throw StandardException.newException("38000", (Throwable)e, (Object)e.toString());
        }
        finally {
            if (beginTime != 0L) {
                this.nextTime += XPLAINUtil.recordTiming(beginTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private ExecRow fetchNext() throws StandardException {
        if (this.doGetAll || this.doGetAllOnLocalIndex) {
            if (this.getAllDone) {
                return this.doGetAll != false ? (ExecRow)GetAllSingletonResult.access$000(this.getNextFromGetAll(false)) : this.getNextFromGetAllOnLocalIndex();
            }
            return this.doGetAll != false ? this.executeGetAll() : this.executeGetAllOnLocalIndex();
        }
        numKeys = this.gfKeys.length;
        if (this.currPos >= numKeys) {
            return null;
        }
        fetchRow = null;
        isByteArrayStore = this.gfContainer.isByteArrayStore();
        region = this.gfContainer.getRegion();
        logger = region.getLogWriterI18n();
        hasLoader = this.gfContainer.getHasLoaderAnywhere();
        tx = this.gfContainer.getActiveTXState(this.tran);
        v0 = isTX = tx != null;
        while (this.currPos < numKeys) {
            retVal = null;
            didGoToServer = false;
            gfKey = this.gfKeys[this.currPos++];
            this.currentRoutingObject = null;
            begin = 0L;
            if (this.isGlobalIndexCase) {
                try {
                    this.currentRoutingObject = GemFireXDUtils.getRoutingObjectFromGlobalIndex(region, gfKey, null);
                }
                catch (EntryNotFoundException ex) {
                    if (!hasLoader) continue;
                    if (this.stats != null) {
                        this.stats.incNumGetsStartedByte();
                        begin = this.stats.getStatTime();
                    }
                    if ((result = this.loadOneRow(gfKey, region)) == null) continue;
                    retVal = result;
                    didGoToServer = true;
                    if (isTX && ((context = TXManagerImpl.currentTXContext()) == null || context.getTXState() == null)) {
                        context = TXManagerImpl.getOrCreateTXContext();
                        context.clearTXState();
                        context.setTXState(tx);
                    }
                    retVal = this.insertOneRow(gfKey, region, logger, tx, retVal);
                }
            }
            if (isByteArrayStore) {
                try {
                    rawRow = null;
                    if (!didGoToServer) {
                        if (this.stats != null) {
                            this.stats.incNumGetsStartedByte();
                            begin = this.stats.getStatTime();
                        }
                        if ((fetchRow = this.executeGetExecutorMessage(gfKey, region, logger, hasLoader, this.currentRoutingObject, tx)) != null) {
                            var15_15 = fetchRow;
                            return var15_15;
                        }
                    } else {
                        rawRow = retVal;
                    }
                    if (rawRow == null) ** GOTO lbl76
                    fetchRow = this.gfContainer.newExecRow(rawRow);
                }
                finally {
                    if (this.stats != null) {
                        this.stats.incNumGetsEndedByte();
                        this.stats.incGetNextCoreByteTime(begin);
                    }
                }
            } else {
                dvds = null;
                try {
                    if (!didGoToServer) {
                        if (this.stats != null) {
                            this.stats.incNumGetsStartedDvd();
                            begin = this.stats.getStatTime();
                        }
                        dvds = this.executeGetOnGFERegion(gfKey, region, logger, hasLoader, this.currentRoutingObject, isTX);
                    } else {
                        dvds = (DataValueDescriptor[])retVal;
                    }
                }
                finally {
                    if (this.stats != null) {
                        this.stats.incNumGetsEndedDvd();
                        this.stats.incGetNextCoreDvdTime(begin);
                    }
                }
                if (dvds != null) {
                    fetchRow = this.gfContainer.newValueRow(dvds);
                }
            }
lbl76:
            // 5 sources

            if (fetchRow == null) continue;
            if (!GemFireXDUtils.TraceRSIter) break;
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("GemFireResultSet.fetchNext: returning row [" + com.pivotal.gemfirexd.internal.impl.sql.execute.RowUtil.toString(fetchRow) + "] for key=" + gfKey.toString()));
            break;
        }
        return this.getResultRowFromFetchRow(fetchRow);
    }

    private Object loadOneRow(Object gfKey, LocalRegion region) throws StandardException {
        Object result;
        LanguageConnectionContext lcc = this.activation.getLanguageConnectionContext();
        GfxdCacheLoader.GetRowFunctionArgs args = new GfxdCacheLoader.GetRowFunctionArgs(this.gfContainer.getSchemaName(), this.gfContainer.getTableName(), gfKey);
        InternalDistributedSystem sys = region.getSystem();
        DistributionDescriptor dd = this.gfContainer.getDistributionDescriptor();
        SortedSet<String> serverGroups = dd.getServerGroups();
        ServerGroupUtils.GetServerGroupMembers members = new ServerGroupUtils.GetServerGroupMembers(serverGroups, true);
        members.setSelfPreference();
        members.setTableName(args.getTableName());
        GfxdSingleResultCollector rc = new GfxdSingleResultCollector();
        try {
            result = FunctionUtils.executeFunctionOnMembers((DistributedSystem)sys, members, args, "gfxd-GetRowFunction", rc, false, lcc != null ? lcc.isPossibleDuplicate() : false, true, false);
            if (result == null) {
                GemFireXDUtils.checkForInsufficientDataStore(region);
            }
        }
        catch (GemFireException gfeex) {
            throw Misc.processGemFireException(gfeex, gfeex, "execution of ResultSet.next()", true);
        }
        catch (StandardException se) {
            if ("X0Z04.S".equals(se.getMessageId())) {
                throw StandardException.newException("X0Z08.S", se.getCause(), (Object)"execution of ResultSet.next()");
            }
            throw se;
        }
        return result;
    }

    private Object insertOneRow(Object gfKey, LocalRegion region, LogWriterI18n logger, TXStateInterface tx, Object retVal) throws StandardException {
        block5: {
            boolean isTX = tx != null;
            try {
                Object key = gfKey;
                if (gfKey instanceof DataValueDescriptor) {
                    key = ((DataValueDescriptor)gfKey).getClone();
                }
                this.gfContainer.insert(key, retVal, true, this.tran, tx, this.lcc, true, false, false);
                if (isTX) {
                    ((BaseActivation)this.activation).distributeTxCacheLoaded(region, this.tran, key, retVal);
                }
            }
            catch (StandardException e) {
                if (logger.finerEnabled()) {
                    logger.finer("Got exception in doing insert in GemFireResultSet", (Throwable)e);
                }
                if (GemFireResultSet.exceptionCanBeIgnored(e)) break block5;
                throw e;
            }
        }
        return retVal;
    }

    private ExecRow processResultRow(Object key, LocalRegion region, boolean hasLoader, boolean hasProjection, boolean isTX, Object rawRow) throws StandardException {
        ExecRow fetchRow = null;
        assert (!(rawRow instanceof ProjectionRow) || hasLoader && isTX) : "unexpected rawRow " + rawRow + " with hasLoader=" + hasLoader + " isTX=" + isTX;
        if (hasLoader && isTX && rawRow instanceof ProjectionRow) {
            rawRow = ((ProjectionRow)rawRow).getRawValue();
            ((BaseActivation)this.activation).distributeTxCacheLoaded(region, this.tran, key, rawRow);
            fetchRow = hasProjection ? ProjectionRow.getCompactExecRow(rawRow, this.gfContainer, this.projectionFormat, this.projectionAllColumnsWithLobs, this.projectionLobColumns) : this.gfContainer.newExecRow(rawRow);
        }
        if (rawRow != null && fetchRow == null) {
            if (hasProjection) {
                AbstractCompactExecRow compactRow = (AbstractCompactExecRow)rawRow;
                compactRow.setRowFormatter(this.projectionFormat);
                fetchRow = compactRow;
            } else {
                fetchRow = this.gfContainer.newExecRow(rawRow);
            }
        }
        return fetchRow;
    }

    private List<?> callGetAllExecutorMessage() throws StandardException {
        LogWriterI18n logger = this.getAllMsg.getRegion().getLogWriterI18n();
        try {
            return (ArrayList)this.getAllMsg.executeFunction();
        }
        catch (GemFireXDRuntimeException ex) {
            if (logger.fineEnabled()) {
                logger.fine("Got GemFireXDRuntimeException exception", (Throwable)ex);
            }
            if (ex.getCause() instanceof StandardException) {
                if (!GemFireResultSet.exceptionCanBeIgnored((StandardException)ex.getCause())) {
                    throw (StandardException)ex.getCause();
                }
            }
            throw StandardException.newException("38000", (Throwable)ex, (Object)ex.getCause());
        }
        catch (EntryExistsException ex) {
            throw StandardException.newException("38000", (Throwable)ex, (Object)ex.toString());
        }
        catch (EmptyRegionFunctionException ignored) {
            if (logger.fineEnabled()) {
                logger.fine("Ignored EmptyRegionFunctionException exception", (Throwable)ignored);
            }
        }
        catch (GemFireException gfeex) {
            throw Misc.processGemFireException(gfeex, gfeex, "execution of ResultSet.next()", true);
        }
        catch (StandardException ex) {
            if (this.getAllMsg instanceof GetAllExecutorMessage && ((GetAllExecutorMessage)this.getAllMsg).hasLoader()) {
                if (!"23505".equals(ex.getSQLState()) && !"23503".equals(ex.getSQLState())) {
                    throw ex;
                }
            }
            throw ex;
        }
        catch (SQLException sqle) {
            throw Misc.processFunctionException("GemFireResultSet.executeGetAll", sqle, this.getAllMsg != null ? this.getAllMsg.getTarget() : null, this.getAllMsg.getRegion());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecRow executeGetAllOnGlobalIndex() throws StandardException {
        block10: {
            assert (this.isGlobalIndexCase);
            boolean doLog = DistributionManager.VERBOSE | GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ;
            LocalRegion region = this.gfContainer.getRegion();
            LogWriterI18n logger = region.getLogWriterI18n();
            boolean hasLoader = this.gfContainer.getHasLoaderAnywhere();
            TXStateInterface tx = this.gfContainer.getActiveTXState(this.tran);
            long begin = 0L;
            try {
                if (this.stats != null) {
                    this.stats.incNumGetsStartedByte();
                    begin = this.stats.getStatTime();
                }
                if (!this.getAllOnGlobalIndexDone) {
                    int giResultSize = this.callGetAllOnGlobalIndex(region, tx);
                    if (doLog) {
                        SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GemFireResultSet.executeGetAllOnGlobalIndex: Global Index returned [" + giResultSize + "] results for container=" + this.gfContainer));
                    }
                    this.getAllOnGlobalIndexDone = true;
                    this.resetGetAll();
                }
                if (!hasLoader) break block10;
                while (this.currPos < this.gfKeys.length) {
                    Object gfKey;
                    if (this.getAllKeysAndRoutingObjects.containsKey(gfKey = this.gfKeys[this.currPos++])) continue;
                    Object result = this.loadOneRow(gfKey, this.gfContainer.getRegion());
                    if (result == null) continue;
                    Object retVal = this.insertOneRow(gfKey, region, logger, tx, result);
                    if (retVal == null) continue;
                    ExecRow execRow = this.gfContainer.newExecRow(retVal);
                    return execRow;
                }
            }
            finally {
                if (this.stats != null) {
                    this.stats.incNumGetsEndedByte();
                    this.stats.incGetNextCoreByteTime(begin);
                }
            }
        }
        return null;
    }

    private int callGetAllOnGlobalIndex(LocalRegion region, TXStateInterface tx) throws StandardException {
        assert (this.isGlobalIndexCase);
        assert (!this.getAllOnGlobalIndexDone);
        boolean doLog = DistributionManager.VERBOSE | GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ;
        TableDescriptor td = ((GemFireContainer)region.getUserAttribute()).getTableDescriptor();
        Map<String, Integer> pkMap = GemFireXDUtils.getPrimaryKeyColumnNamesToIndexMap(td, this.lcc);
        GemFireContainer giContainer = GfxdPartitionResolver.getContainerOfGlobalIndex(td, pkMap);
        LocalRegion giRegion = giContainer.getRegion();
        assert (giRegion != null);
        THashMap giKeys = new THashMap();
        for (Object gfKey : this.gfKeys) {
            assert (gfKey instanceof CompactCompositeRegionKey);
            giKeys.put(((CompactCompositeRegionKey)gfKey).getKeyColumn(0), (CompactCompositeRegionKey)gfKey);
        }
        int numKeys = giKeys.size();
        if (this.observer != null) {
            this.observer.getAllGlobalIndexInvoked(numKeys);
        }
        if (doLog) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GemFireResultSet.callGetAllOnGlobalIndex: Started for container=" + giContainer + "; with Loader=" + giContainer.getHasLoaderAnywhere() + "; for keys[" + giKeys.keySet().size() + "] = " + com.pivotal.gemfirexd.internal.impl.sql.execute.RowUtil.toString(giKeys.keySet().toArray())));
        }
        this.getAllMsg = new GetAllExecutorMessage(giRegion, giKeys.keySet().toArray(), null, null, null, null, null, null, tx, this.lcc, this.forUpdate, this.queryHDFS);
        this.getAllResults = this.callGetAllExecutorMessage();
        if (doLog) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"GemFireResultSet.callGetAllOnGlobalIndex: Done.");
        }
        if (this.getAllResults != null) {
            this.getAllItr = this.getAllResults.iterator();
            GetAllSingletonResult result = null;
            while ((result = this.getNextFromGetAll(true)) != null && result.currentRowForGetAll != null) {
                this.getAllKeysAndRoutingObjects.put(giKeys.get(result.currentKeyForGetAll), (Integer)((GlobalRowLocation)result.currentRowForGetAll).getRoutingObject());
                if (!GemFireXDUtils.TraceRSIter) continue;
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("GemFireResultSet.callGetAllOnGlobalIndex: results key [" + result.currentKeyForGetAll + "] and row [" + ((GlobalRowLocation)result.currentRowForGetAll).getRoutingObject() + "]"));
            }
        } else if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)"GemFireResultSet.callGetAllOnGlobalIndex: Global Index returned null. No results would be given");
        }
        return this.getAllKeysAndRoutingObjects.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecRow executeGetAll() throws StandardException {
        assert (this.doGetAll);
        assert (!this.getAllDone);
        assert (!this.doGetAllOnLocalIndex);
        assert (this.gfContainer.isByteArrayStore());
        boolean doLog = DistributionManager.VERBOSE | GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ;
        if (this.gfKeys.length < 1) {
            if (doLog) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GemFireResultSet.executeGetAll: No keys for container=" + this.gfContainer));
            }
            if (this.observer != null) {
                this.observer.getAllInvoked(0);
            }
            return null;
        }
        if (doLog) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GemFireResultSet.executeGetAll: Called with key index [" + this.currPos + "] for " + this.gfKeys.length + " keys for container=" + this.gfContainer + " ; with Loader " + this.gfContainer.getHasLoaderAnywhere() + " ; with GlobalIndex " + this.isGlobalIndexCase));
        }
        Object[] getAllKeys = null;
        Object[] getAllRoutingObjects = null;
        if (this.isGlobalIndexCase) {
            assert (this.currPos <= this.gfKeys.length);
            ExecRow retVal = this.executeGetAllOnGlobalIndex();
            if (retVal != null) {
                return retVal;
            }
            int giResultSize = this.getAllKeysAndRoutingObjects.size();
            if (giResultSize < 1) {
                if (doLog) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GemFireResultSet.executeGetAll: returning Null since Global Index returned No keys for container=" + this.gfContainer));
                }
                return null;
            }
            getAllKeys = new Object[giResultSize];
            getAllRoutingObjects = new Integer[giResultSize];
            int index = 0;
            for (Map.Entry<Object, Integer> entry : this.getAllKeysAndRoutingObjects.entrySet()) {
                getAllKeys[index] = entry.getKey();
                getAllRoutingObjects[index] = entry.getValue();
                ++index;
            }
            assert (index == giResultSize);
        } else {
            THashSet keysSet = new THashSet();
            for (Object key : this.gfKeys) {
                keysSet.add(key);
            }
            getAllKeys = keysSet.toArray();
        }
        assert (getAllKeys != null);
        int numKeys = getAllKeys.length;
        assert (getAllRoutingObjects == null || numKeys == getAllRoutingObjects.length);
        if (this.observer != null) {
            this.observer.getAllInvoked(numKeys);
        }
        if (doLog) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GemFireResultSet.executeGetAll: GetAllExecutorMessage would be called for container=" + this.gfContainer + "; for keys[" + numKeys + "] = " + com.pivotal.gemfirexd.internal.impl.sql.execute.RowUtil.toString(getAllKeys) + "; for routingObjects[" + (getAllRoutingObjects == null ? 0 : getAllRoutingObjects.length) + "] = " + (getAllRoutingObjects == null ? "null" : com.pivotal.gemfirexd.internal.impl.sql.execute.RowUtil.toString(getAllRoutingObjects))));
        }
        long begin = 0L;
        try {
            if (this.stats != null) {
                this.stats.incNumGetsStartedByte();
                begin = this.stats.getStatTime();
            }
            TXStateInterface tx = this.tran != null ? this.gfContainer.getActiveTXState(this.tran) : null;
            this.getAllMsg = new GetAllExecutorMessage(this.gfContainer.getRegion(), getAllKeys, getAllRoutingObjects, this.projectionFormat, this.projectionFixedColumns, this.projectionVarColumns, this.projectionLobColumns, this.projectionAllColumnsWithLobs, tx, this.lcc, this.forUpdate, this.queryHDFS);
            this.getAllResults = this.callGetAllExecutorMessage();
        }
        finally {
            if (this.stats != null) {
                this.stats.incNumGetsEndedByte();
                this.stats.incGetNextCoreByteTime(begin);
            }
        }
        this.getAllDone = true;
        if (doLog) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"GemFireResultSet.executeGetAll: Done.");
        }
        if (this.getAllResults != null) {
            this.getAllItr = this.getAllResults.iterator();
            return (ExecRow)this.getNextFromGetAll(false).currentRowForGetAll;
        }
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)"GemFireResultSet.executeGetAll: returning null (last row)");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecRow executeGetAllOnLocalIndex() throws StandardException {
        assert (this.doGetAllOnLocalIndex);
        assert (!this.doGetAll);
        assert (!this.getAllDone);
        assert (this.gfContainer.isByteArrayStore());
        assert (this.gfKeys.length > 0);
        boolean doLog = DistributionManager.VERBOSE | GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ;
        LocalRegion region = this.gfContainer.getRegion();
        THashSet keysSet = new THashSet();
        for (Object key : this.gfKeys) {
            keysSet.add(key);
        }
        Object[] getAllKeys = keysSet.size() == this.gfKeys.length ? this.gfKeys : keysSet.toArray();
        if (this.observer != null) {
            this.observer.getAllLocalIndexExecuted();
        }
        if (doLog) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GemFireResultSet.executeGetAllOnLocalIndex: Call GetAllLocalIndexExecutorMessage with keys [" + getAllKeys.length + "] = " + com.pivotal.gemfirexd.internal.impl.sql.execute.RowUtil.toString(getAllKeys) + " at key index [" + this.currPos + "] for original incoming list of " + this.gfKeys.length + " keys for container=" + this.gfContainer));
        }
        long begin = 0L;
        try {
            if (this.stats != null) {
                this.stats.incNumGetsStartedByte();
                begin = this.stats.getStatTime();
            }
            TXStateInterface tx = this.gfContainer.getActiveTXState(this.tran);
            this.getAllMsg = new GetAllLocalIndexExecutorMessage(this.gfIndexContainer.getQualifiedTableName(), getAllKeys, region, this.lcc, this.activation.getConnectionID(), tx, this.projectionFormat, this.projectionFixedColumns, this.projectionVarColumns, this.projectionLobColumns, this.projectionAllColumnsWithLobs);
            this.getAllResults = this.callGetAllExecutorMessage();
        }
        finally {
            if (this.stats != null) {
                this.stats.incNumGetsEndedByte();
                this.stats.incGetNextCoreByteTime(begin);
            }
        }
        this.getAllDone = true;
        if (doLog) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"GemFireResultSet.executeGetAllOnLocalIndex: Done.");
        }
        if (this.getAllResults != null) {
            this.getAllItr = this.getAllResults.iterator();
            return this.getNextFromGetAllOnLocalIndex();
        }
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)"GemFireResultSet.executeGetAllOnLocalIndex: returning null (last row)");
        }
        return null;
    }

    private ExecRow executeGetExecutorMessage(Object gfKey, LocalRegion region, LogWriterI18n logger, boolean hasLoader, Object routingObject, TXStateInterface tx) throws StandardException {
        LanguageConnectionContext lcc = this.activation.getLanguageConnectionContext();
        boolean isTX = tx != null;
        ExecRow fetchRow = null;
        GfxdCallbackArgument callbackArg = null;
        RegionSingleKeyExecutorMessage getMsg = null;
        Object rawRow = null;
        try {
            Object key = gfKey;
            if (hasLoader) {
                if (!isTX) {
                    callbackArg = GemFireXDUtils.wrapCallbackArgs(routingObject, lcc, false, true, true, true, lcc.isSkipListeners(), false, lcc.isSkipConstraintChecks());
                }
                if (gfKey instanceof DataValueDescriptor) {
                    key = ((DataValueDescriptor)gfKey).getClone();
                }
            }
            if (logger.fineEnabled()) {
                logger.fine("GemFireResultSet::getNextRow:Loader present " + hasLoader + ";callbackArg=" + callbackArg + ";container=" + this.gfContainer);
            }
            getMsg = new GetExecutorMessage(region, key, callbackArg, routingObject, this.projectionFormat, this.projectionFixedColumns, this.projectionVarColumns, this.projectionLobColumns, this.projectionAllColumnsWithLobs, tx, lcc, this.forUpdate, this.queryHDFS);
            rawRow = getMsg.executeFunction();
            fetchRow = this.processResultRow(key, region, hasLoader, ((GetExecutorMessage)getMsg).hasProjection(), isTX, rawRow);
        }
        catch (CacheLoaderException ex) {
            boolean isItENFE = GemFireResultSet.checkIfENFE(ex);
            if (isItENFE) {
                if (logger.fineEnabled()) {
                    logger.fine("Got EntryNotFoundException wrapped in CacheLoaderException");
                }
                rawRow = null;
            }
            throw ex;
        }
        catch (EntryNotFoundException ex) {
            if (logger.fineEnabled()) {
                logger.fine("Got EntryNotFoundException exception", (Throwable)ex);
            }
            rawRow = null;
        }
        catch (GemFireXDRuntimeException ex) {
            if (logger.fineEnabled()) {
                logger.fine("Got GemFireXDRuntimeException exception", (Throwable)ex);
            }
            if (ex.getCause() instanceof StandardException) {
                if (!GemFireResultSet.exceptionCanBeIgnored((StandardException)ex.getCause())) {
                    throw (StandardException)ex.getCause();
                }
            }
            throw StandardException.newException("38000", (Throwable)ex, (Object)ex.getCause());
        }
        catch (EntryExistsException ex) {
            if (this.isTheRegionReplicate) {
                rawRow = ex.getOldValue();
            }
            throw StandardException.newException("38000", (Throwable)ex, (Object)ex.toString());
        }
        catch (GemFireException gfeex) {
            throw Misc.processGemFireException(gfeex, gfeex, "execution of ResultSet.next()", true);
        }
        catch (StandardException ex) {
            if (hasLoader) {
                if (!"23505".equals(ex.getSQLState()) && !"23503".equals(ex.getSQLState())) {
                    throw ex;
                }
            }
            throw ex;
        }
        catch (SQLException sqle) {
            throw Misc.processFunctionException("GemFireResultSet#getNextRow", sqle, getMsg != null ? getMsg.getTarget() : null, region);
        }
        return fetchRow;
    }

    private DataValueDescriptor[] executeGetOnGFERegion(Object gfKey, LocalRegion region, LogWriterI18n logger, boolean hasLoader, Object routingObject, boolean isTX) throws StandardException {
        Object key = gfKey;
        Object callbackArg = routingObject;
        DataValueDescriptor[] dvds = null;
        if (hasLoader) {
            if (!isTX) {
                callbackArg = GemFireXDUtils.wrapCallbackArgs(callbackArg, this.lcc, false, true, true, true, this.lcc.isSkipListeners(), false, this.lcc.isSkipConstraintChecks());
            }
            if (gfKey instanceof DataValueDescriptor) {
                key = ((DataValueDescriptor)gfKey).getClone();
            }
        }
        try {
            dvds = (DataValueDescriptor[])region.get(key, callbackArg);
            if (hasLoader && isTX) {
                Assert.fail((Object)("unexpected TX with loader in DVD[] store " + this.gfContainer));
            }
        }
        catch (CacheLoaderException ex) {
            boolean isItENFE = GemFireResultSet.checkIfENFE(ex);
            if (isItENFE) {
                if (logger.fineEnabled()) {
                    logger.fine("Got CacheLoaderException which had EntryNotFoundException within");
                }
                dvds = null;
            }
            throw ex;
        }
        catch (EntryNotFoundException ex) {
            if (logger.fineEnabled()) {
                logger.fine("Got EntryNotFoundException exception", (Throwable)ex);
            }
            dvds = null;
        }
        catch (GemFireXDRuntimeException ex) {
            if (logger.fineEnabled()) {
                logger.fine("Got GemFireXDRuntimeException exception", (Throwable)ex);
            }
            if (ex.getCause() instanceof StandardException) {
                throw (StandardException)ex.getCause();
            }
            throw StandardException.newException("38000", (Throwable)ex, (Object)ex.getCause());
        }
        catch (EntryExistsException ex) {
            if (this.isTheRegionReplicate) {
                dvds = (DataValueDescriptor[])ex.getOldValue();
            }
            throw StandardException.newException("38000", (Throwable)ex, (Object)ex.toString());
        }
        return dvds;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        ExecRow next = this.getNextRow();
        if (next != null) {
            this.setCurrentRow(next);
            return next;
        }
        return null;
    }

    public static boolean checkIfENFE(CacheLoaderException ex) {
        for (Throwable e = ex.getCause(); e != null; e = e.getCause()) {
            if (!(e instanceof EntryNotFoundException)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void openCore() throws StandardException {
        this.resetGetAll();
        this.resetGfeResultSet();
        Object pk = this.selectQI.getPrimaryKey();
        Object fk = this.selectQI.getLocalIndexKey();
        assert (pk != null ^ fk != null);
        if (pk != null) {
            if (this.selectQI.isNcjLevelTwoQueryWithVarIN()) {
                this.ncjSetGfKeysFromPrimaryKeys(pk);
            } else {
                this.gfKeys = this.setGfKeysFromPrimaryKeys(pk);
            }
        } else if (fk != null) {
            if (this.selectQI.isNcjLevelTwoQueryWithVarIN()) {
                this.ncjSetGfKeysFromIndexKeys(fk);
            } else {
                this.gfKeys = this.setGfKeysFromIndexKeys(fk);
            }
            if (this.observer != null) {
                this.observer.getAllLocalIndexInvoked(this.gfKeys.length);
            }
        }
        this.gfContainer.open(this.tran, 8);
    }

    @Override
    public void finishResultSet(boolean cleanupOnError) throws StandardException {
        if (this.subqueryTrackingArray != null) {
            if (this.isTopResultSet) {
                for (NoPutResultSet rs : this.subqueryTrackingArray) {
                    if (rs == null || rs.isClosed()) continue;
                    rs.close(cleanupOnError);
                }
            }
            this.subqueryTrackingArray = null;
        }
        this.gfContainer.closeForEndTransaction(this.tran, false);
    }

    @Override
    public boolean returnsRows() {
        return true;
    }

    @Override
    public void clearCurrentRow() {
        this.activation.clearCurrentRow(this.resultsetNumber);
    }

    @Override
    public double getEstimatedRowCount() {
        return this.gfKeys.length;
    }

    @Override
    public int getPointOfAttachment() {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public int getScanIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public final boolean isForUpdate() {
        return this.forUpdate;
    }

    @Override
    public final boolean canUpdateInPlace() {
        return this.forUpdate;
    }

    @Override
    public final void updateRow(ExecRow updateRow) throws StandardException {
        Object key = this.getKeyForUpdate();
        Object routingObject = this.getAllKeysAndRoutingObjects != null ? this.getAllKeysAndRoutingObjects.get(key) : this.currentRoutingObject;
        this.cachedChangedRow = GemFireDistributedResultSet.updateDirectly(key, routingObject, updateRow, ((BaseActivation)this.activation).getUpdatedColumns(), this.gfContainer, this.selectQI, this.tran, this.lcc, this.cachedChangedRow);
    }

    @Override
    public void deleteRowDirectly() throws StandardException {
        Object key = this.getKeyForUpdate();
        Object routingObject = this.getAllKeysAndRoutingObjects != null ? this.getAllKeysAndRoutingObjects.get(key) : this.currentRoutingObject;
        this.gfContainer.delete(key, routingObject, true, this.tran, this.gfContainer.getActiveTXState(this.tran), this.lcc, false);
    }

    private Object getKeyForUpdate() {
        if (this.doGetAll) {
            return this.singletonResultGetAll.currentKeyForGetAll;
        }
        if (!this.doGetAllOnLocalIndex) {
            int pos = this.currPos;
            if (pos > 0) {
                return this.gfKeys[pos - 1];
            }
            return null;
        }
        Assert.fail((Object)"unexpected call to getAllLocalIndex for SELECT FOR UPDATE");
        return null;
    }

    @Override
    public void markAsTopResultSet() {
        this.isTopResultSet = true;
    }

    @Override
    public TXState initLocalTXState() {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void upgradeReadLockToWrite(RowLocation rl, GemFireContainer container) throws StandardException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        ExecRow row = this.activation.getCurrentRow(this.resultsetNumber);
        if (row != null) {
            this.clearCurrentRow();
        }
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void positionScanAtRowLocation(RowLocation rLoc) throws StandardException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void reopenCore() throws StandardException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public boolean requiresRelocking() {
        return false;
    }

    @Override
    public int resultSetNumber() {
        return this.resultsetNumber;
    }

    @Override
    public void setCurrentRow(ExecRow row) {
        this.activation.setCurrentRow(row, this.resultsetNumber);
    }

    @Override
    public void setNeedsRowLocation(boolean needsRowLocation) {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void setTargetResultSet(TargetResultSet trs) {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public boolean needsRowLocation() {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void rowLocation(RowLocation rl) throws StandardException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void closeRowSource() {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public ExecRow getNextRowFromRowSource() throws StandardException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public FormatableBitSet getValidColumns() {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public boolean needsToClone() {
        return false;
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.setNumberOfChildren(0);
        visitor.visit(this);
    }

    public String getContainer() {
        return this.gfContainer.toString();
    }

    public GemFireContainer getGFContainer() {
        return this.gfContainer;
    }

    public RowFormatter getProjectionFormat() {
        return this.projectionFormat;
    }

    @Override
    public long estimateMemoryUsage() throws StandardException {
        long memory = 0L;
        if (this.candidate != null) {
            memory += this.candidate.estimateRowSize();
        }
        try {
            if (this.getAllMsg != null) {
                memory += this.getAllMsg.estimateMemoryUsage();
            }
            for (Object getAllVal : this.getAllResults) {
                ArrayList resultList = (ArrayList)((GfxdListResultCollector.ListResultCollectorValue)getAllVal).resultOfSingleExecution;
                if (resultList == null) continue;
                for (Object v : resultList) {
                    if (v == null) continue;
                    Class<?> cls = v.getClass();
                    if (cls == byte[].class) {
                        memory += (long)((byte[])v).length;
                        continue;
                    }
                    if (cls == byte[][].class) {
                        for (byte[] b : (byte[][])v) {
                            memory += (long)(b != null ? b.length : 0);
                        }
                        continue;
                    }
                    if (!(v instanceof DataValueDescriptor[])) continue;
                    for (DataValueDescriptor d : (DataValueDescriptor[])v) {
                        memory += (long)d.estimateMemoryUsage();
                    }
                }
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return memory;
    }

    public final boolean isGetAllPlan() {
        return this.doGetAll;
    }

    public final boolean isGetAllLocalIndexPlan() {
        return this.doGetAllOnLocalIndex;
    }

    @Override
    public int modifiedRowCount() {
        return this.rowsReturned;
    }

    @Override
    public boolean isDistributedResultSet() {
        return true;
    }

    private GetAllSingletonResult getNextFromGetAll(boolean isGlobalIndexCase) throws StandardException {
        this.singletonResultGetAll.reset();
        Object fetchRow = null;
        while (fetchRow == null && (this.getAllItr.hasNext() || this.getAllResultsItr != null && this.getAllResultsItr.hasNext())) {
            if (this.getAllResultsItr != null && this.getAllResultsItr.hasNext()) {
                assert (this.currentMemberForGetAll != null);
                fetchRow = this.singleResultGetAll(isGlobalIndexCase).currentRowForGetAll;
                continue;
            }
            assert (this.getAllItr.hasNext());
            GfxdListResultCollector.ListResultCollectorValue currVal = (GfxdListResultCollector.ListResultCollectorValue)this.getAllItr.next();
            assert (currVal.memberID != null);
            this.currentMemberForGetAll = currVal.memberID;
            List<Object> currKeyList = this.getAllMsg.getKeysPerMember(this.currentMemberForGetAll);
            this.getAllKeysItr = currKeyList.iterator();
            ArrayList results = (ArrayList)currVal.resultOfSingleExecution;
            SanityManager.ASSERT((currKeyList.size() == results.size() ? 1 : 0) != 0, (String)("Number of values returned [" + results.size() + "] are not equal to number of keys [" + currKeyList.size() + "] for member= " + this.currentMemberForGetAll));
            this.getAllResultsItr = results.iterator();
            fetchRow = this.singleResultGetAll(isGlobalIndexCase).currentRowForGetAll;
        }
        return this.singletonResultGetAll;
    }

    private GetAllSingletonResult singleResultGetAll(boolean isGlobalIndexCase) throws StandardException {
        assert (this.getAllResultsItr != null);
        assert (this.getAllKeysItr != null);
        this.singletonResultGetAll.reset();
        Object rawRow = null;
        while (rawRow == null && this.getAllResultsItr.hasNext()) {
            Object key = this.getAllKeysItr.next();
            rawRow = this.getAllResultsItr.next();
            if (rawRow != null) {
                if (isGlobalIndexCase) {
                    if (GemFireXDUtils.TraceRSIter) {
                        SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("GemFireResultSet.singleResultGetAll: GetAll returning row [" + rawRow.toString() + "] for key=" + key.toString() + "; isGlobalIndexCase=" + isGlobalIndexCase));
                    }
                    this.singletonResultGetAll.set(rawRow, key);
                } else {
                    ExecRow fetchRow = this.processResultRow(key, this.gfContainer.getRegion(), this.gfContainer.getHasLoaderAnywhere(), this.getAllMsg.hasProjection(), this.gfContainer.getActiveTXState(this.tran) != null, rawRow);
                    if (GemFireXDUtils.TraceRSIter) {
                        SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("GemFireResultSet.singleResultGetAll: GetAll returning row [" + com.pivotal.gemfirexd.internal.impl.sql.execute.RowUtil.toString(fetchRow) + "] for key=" + key.toString() + "; isGlobalIndexCase=" + isGlobalIndexCase));
                    }
                    this.singletonResultGetAll.set(fetchRow, key);
                }
                return this.singletonResultGetAll;
            }
            if (!GemFireXDUtils.TraceRSIter) continue;
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("GemFireResultSet.singleResultGetAll: GetAll returning row [null] for key=" + key.toString() + "; isGlobalIndexCase=" + isGlobalIndexCase));
        }
        return this.singletonResultGetAll;
    }

    private ExecRow getNextFromGetAllOnLocalIndex() throws StandardException {
        ExecRow fetchRow = null;
        while (fetchRow == null && (this.getAllItr != null && this.getAllItr.hasNext() || this.getAllResultsItr != null && this.getAllResultsItr.hasNext())) {
            if (this.getAllResultsItr == null || !this.getAllResultsItr.hasNext()) {
                assert (this.getAllItr.hasNext());
                ArrayList currList = (ArrayList)this.getAllItr.next();
                assert (currList != null);
                this.getAllResultsItr = currList.iterator();
            }
            fetchRow = this.singleResultGetAllOnLocalIndex();
        }
        return fetchRow;
    }

    private ExecRow singleResultGetAllOnLocalIndex() {
        assert (this.getAllResultsItr != null);
        ExecRow fetchRow = null;
        Object rawRow = null;
        while (rawRow == null && this.getAllResultsItr.hasNext()) {
            rawRow = this.getAllResultsItr.next();
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("GemFireResultSet.singleResultGetAllOnLocalIndex: raw row: class=" + rawRow.getClass()));
            }
            if (rawRow != null) {
                if (this.getAllMsg.hasProjection()) {
                    AbstractCompactExecRow compactRow = (AbstractCompactExecRow)rawRow;
                    compactRow.setRowFormatter(this.projectionFormat);
                    fetchRow = compactRow;
                } else {
                    fetchRow = this.gfContainer.newExecRow(rawRow);
                }
                if (!GemFireXDUtils.TraceRSIter) continue;
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("GemFireResultSet.singleResultGetAllOnLocalIndex: GetAll returning row [" + com.pivotal.gemfirexd.internal.impl.sql.execute.RowUtil.toString(fetchRow) + "]"));
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("GemFireResultSet.singleResultGetAllOnLocalIndex: fetch row class type =" + fetchRow.getClass() + " source =" + (fetchRow instanceof AbstractCompactExecRow ? ((AbstractCompactExecRow)fetchRow).getByteSource() : null)));
                continue;
            }
            if (!GemFireXDUtils.TraceRSIter) continue;
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)"GemFireResultSet.singleResultGetAllOnLocalIndex: GetAll returning row [null]");
        }
        return fetchRow;
    }

    private void resetGetAll() {
        this.getAllItr = null;
        this.getAllResults = null;
        this.getAllResultsItr = null;
        this.getAllKeysItr = null;
        this.currentMemberForGetAll = null;
        this.getAllMsg = null;
        this.singletonResultGetAll.reset();
    }

    private void resetGfeResultSet() {
        this.getAllDone = false;
        this.currPos = 0;
        this.currentRoutingObject = null;
        this.getAllOnGlobalIndexDone = false;
        if (this.getAllKeysAndRoutingObjects != null) {
            this.getAllKeysAndRoutingObjects.clear();
        }
    }

    @Override
    public void reset(GfxdResultCollector<?> rc) throws StandardException {
        super.reset(rc);
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        GemFireContainer gfc = this.getGFContainer();
        RowFormatter rf = this.getProjectionFormat();
        StringBuilder details = new StringBuilder(gfc.getSchemaName()).append(".").append(gfc.getTableName());
        if (rf != null) {
            boolean first = true;
            for (int inPosition = 0; inPosition < rf.getNumColumns(); ++inPosition) {
                ColumnDescriptor cd = rf.getColumnDescriptor(inPosition);
                if (cd == null) continue;
                if (!first) {
                    details.append(", ");
                } else {
                    first = false;
                    details.append(" ");
                }
                details.append(cd.getColumnName());
            }
        }
        PlanUtils.xmlAttribute(builder, "node_details", details);
        PlanUtils.xmlTermTag(builder, context, this.doGetAll ? "REGION-GETALL" : (this.doGetAllOnLocalIndex ? "INDEX-GETALL" : "REGION-GET"));
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public RowLocation fetch(RowLocation loc, ExecRow destRow, FormatableBitSet validColumns, boolean faultIn, GemFireContainer container) throws StandardException {
        return RowUtil.fetch(loc, destRow, validColumns, faultIn, container, null, null, 0, this.tran);
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        if (!this.isClosed) {
            ExecRow row = this.activation.getCurrentRow(this.resultsetNumber);
            this.clearCurrentRow();
            if ((this.doGetAll || this.doGetAllOnLocalIndex) && this.getAllDone) {
                while ((row = this.fetchNext()) != null) {
                    if (GemFireXDUtils.TraceRSIter) {
                        SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("GemFireResultSet.close: row = " + row + "being released"));
                    }
                    row.releaseByteSource();
                }
            }
            super.close(cleanupOnError);
        }
    }

    @Override
    public void releasePreviousByteSource() {
    }

    @Override
    public void setMaxSortingLimit(long limit) {
    }

    public static final class GetAllSingletonResult {
        private Object currentRowForGetAll = null;
        private Object currentKeyForGetAll = null;

        void set(Object currentRow, Object currentKey) {
            this.currentRowForGetAll = currentRow;
            this.currentKeyForGetAll = currentKey;
        }

        void reset() {
            this.currentRowForGetAll = null;
            this.currentKeyForGetAll = null;
        }
    }
}

