/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TargetResultSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;

public class GemFireRegionSizeResultSet
extends AbstractGemFireResultSet
implements NoPutResultSet {
    private final ExecRow candidate;
    private boolean returnedRow;
    private final GemFireContainer gfContainer;
    private final int resultSetNumber;
    private final Boolean withSecondaries;
    private int rows;

    public GemFireRegionSizeResultSet(Activation act, int resultSetNumber, GeneratedMethod resultRowAllocator, long conglomId, String tableName, String withSecondaries) throws StandardException {
        super(act);
        this.candidate = (ExecRow)resultRowAllocator.invoke(this.activation);
        this.resultSetNumber = resultSetNumber;
        this.withSecondaries = withSecondaries.length() > 0 ? Boolean.valueOf(Boolean.parseBoolean(withSecondaries)) : null;
        MemConglomerate conglom = this.tran.findExistingConglomerate(conglomId);
        GemFireContainer container = conglom.getGemFireContainer();
        if (container.isLocalIndex() || container.isGlobalIndex()) {
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("looked up index container from local/global index conglomId=" + conglomId + " : " + container));
            }
            container = container.getBaseContainer();
        }
        this.gfContainer = container;
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("looked up container with conglomId=" + conglomId + " (" + tableName + ") : " + this.gfContainer));
        }
        if (this.observer != null) {
            this.observer.createdGemFireXDResultSet(this);
        }
    }

    @Override
    public void finishResultSet(boolean cleanupOnError) throws StandardException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openCore() throws StandardException {
        this.returnedRow = false;
        this.gfContainer.open(this.tran, 8);
        try {
            FunctionContext fc = this.activation.getFunctionContext();
            Set<Integer> bucketIds = fc != null && this.withSecondaries == null ? ((RegionExecutorMessage)fc).getLocalBucketSet(this.gfContainer.getRegion()) : null;
            if (GemFireXDUtils.TraceAggreg) {
                SanityManager.DEBUG_PRINT((String)"TraceAggregation", (String)("Opening " + GemFireRegionSizeResultSet.class.getSimpleName() + " with bucketIds=" + bucketIds + " withSecondaries=" + this.withSecondaries));
            }
            boolean queryHDFS = false;
            if (this.lcc != null) {
                queryHDFS = this.lcc.getQueryHDFS();
            }
            if (this.activation != null && this.activation.getHasQueryHDFS()) {
                queryHDFS = this.activation.getQueryHDFS();
            }
            this.rows = this.gfContainer.getLocalNumRows(bucketIds, this.withSecondaries != null && this.withSecondaries != false, queryHDFS);
        }
        finally {
            this.gfContainer.closeForEndTransaction(this.tran, false);
        }
    }

    @Override
    public boolean canUpdateInPlace() {
        return false;
    }

    @Override
    public TXState initLocalTXState() {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void upgradeReadLockToWrite(RowLocation rl, GemFireContainer container) throws StandardException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
    }

    @Override
    public double getEstimatedRowCount() {
        return 1.0;
    }

    @Override
    public ExecRow getNextRow() throws StandardException {
        if (this.returnedRow) {
            this.clearCurrentRow();
            return null;
        }
        this.candidate.getColumn(1).setValue(this.rows);
        this.returnedRow = true;
        return this.candidate;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        return this.getNextRow();
    }

    @Override
    public final void clearCurrentRow() {
        this.activation.clearCurrentRow(this.resultSetNumber);
    }

    @Override
    public int getPointOfAttachment() {
        return 0;
    }

    @Override
    public int getScanIsolationLevel() {
        return 0;
    }

    @Override
    public boolean isForUpdate() {
        return false;
    }

    @Override
    public void markAsTopResultSet() {
    }

    @Override
    public boolean requiresRelocking() {
        return false;
    }

    @Override
    public int resultSetNumber() {
        return this.resultSetNumber;
    }

    @Override
    public boolean returnsRows() {
        return true;
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void positionScanAtRowLocation(RowLocation rLoc) throws StandardException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void reopenCore() throws StandardException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void setCurrentRow(ExecRow row) {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void setNeedsRowLocation(boolean needsRowLocation) {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void setTargetResultSet(TargetResultSet trs) {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void updateRow(ExecRow row) throws StandardException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void deleteRowDirectly() throws StandardException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.setNumberOfChildren(0);
        visitor.visit(this);
    }

    @Override
    public boolean needsRowLocation() {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void rowLocation(RowLocation rl) throws StandardException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void closeRowSource() {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public ExecRow getNextRowFromRowSource() throws StandardException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public FormatableBitSet getValidColumns() {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public boolean needsToClone() {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public long estimateMemoryUsage() throws StandardException {
        return 0L;
    }

    @Override
    public void setGfKeysForNCJoin(ArrayList<DataValueDescriptor> keys) throws StandardException {
        throw StandardException.newException("0A000.S", " Currently this method is not implemented or overridden for class " + this.getClass().getSimpleName());
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "AUTO-GEN-KEYS");
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public RowLocation fetch(RowLocation loc, ExecRow destRow, FormatableBitSet validColumns, boolean faultIn, GemFireContainer container) throws StandardException {
        return RowUtil.fetch(loc, destRow, validColumns, faultIn, container, null, null, 0, this.tran);
    }

    @Override
    public void releasePreviousByteSource() {
    }

    @Override
    public void setMaxSortingLimit(long limit) {
    }

    public static final class RegionSizeMessage
    extends RegionExecutorMessage<Object> {
        private String qualifiedTableName;

        public RegionSizeMessage() {
            super(true);
        }

        public RegionSizeMessage(String tableName, ResultCollector<Object, Object> collector, LocalRegion region, Set<Object> routingObjects, LanguageConnectionContext lcc) {
            super(collector, region, routingObjects, RegionSizeMessage.getCurrentTXState(lcc), RegionSizeMessage.getTimeStatsSettings(lcc), true);
            this.qualifiedTableName = tableName;
        }

        private RegionSizeMessage(RegionSizeMessage other) {
            super(other);
            this.qualifiedTableName = other.qualifiedTableName;
        }

        @Override
        protected RegionExecutorMessage<Object> clone() {
            return new RegionSizeMessage(this);
        }

        @Override
        protected void setArgsForMember(DistributedMember member, Set<DistributedMember> messageAwareMembers) {
        }

        @Override
        protected void execute() {
            Region r = Misc.getRegionByPath(this.qualifiedTableName, true);
            assert (!(r instanceof PartitionedRegion)) : "lets use PR.size for this .. ";
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("Calculating size for region " + this.qualifiedTableName));
            }
            this.lastResult(r != null ? r.size() : 0, false, false, true);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            long begintime = this.timeStatsEnabled ? XPLAINUtil.recordTiming(this.ser_deser_time == 0L ? (this.ser_deser_time = -1L) : -2L) : 0L;
            super.toData(out);
            DataSerializer.writeString((String)this.qualifiedTableName, (DataOutput)out);
            if (begintime != 0L) {
                this.ser_deser_time = XPLAINUtil.recordTiming(begintime);
            }
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.qualifiedTableName = DataSerializer.readString((DataInput)in);
            if (this.timeStatsEnabled) {
                this.ser_deser_time = XPLAINUtil.recordStdTiming(this.getTimestamp());
            }
        }

        @Override
        public boolean isHA() {
            return true;
        }

        @Override
        public boolean optimizeForWrite() {
            return true;
        }

        @Override
        public boolean withSecondaries() {
            return false;
        }

        @Override
        public byte getGfxdID() {
            return 36;
        }
    }
}

