/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdQueryStreamingResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.ResultHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ColumnQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.RegionAndKey;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SecondaryClauseQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireDistributionActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.IteratorStatisticsVisitor;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecAggregator;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TargetResultSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortController;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.UserDataValue;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AggregatorInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AggregatorInfoList;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BasicSortObserver;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GenericAggregator;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexColumnOrder;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.ArraySortScan;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.ArraySorter;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public final class GemFireDistributedResultSet
extends AbstractGemFireResultSet
implements NoPutResultSet {
    private static final ExecRow ROUND_COMPLETE = new ValueRow(0);
    protected final AbstractGemFireDistributionActivation act;
    protected Collection<?> resultHolderList;
    protected AbstractRSIterator iterator;
    protected final SelectQueryInfo qInfo;
    protected final boolean isForUpdate;
    private final RowFormatter rowFormatter;
    private final boolean objectStore;
    private DataTypeDescriptor distinctAggUnderlyingType;
    protected final ParameterValueSet pvs;
    private final List<GemFireContainer> gfContainers;
    private ExecRow currentRow;
    protected transient int rowsReturned;
    public static final int ORDERED = 1;
    public static final int DISTINCT = 2;
    public static final int FETCH_EARLY = 4;
    public static final int FETCH_ONDEMAND = 8;
    public static final int SEQUENTIAL = 16;
    private DataValueDescriptor[] cachedChangedRow;

    GemFireDistributedResultSet(Activation act) throws StandardException {
        super(act);
        this.act = (AbstractGemFireDistributionActivation)act;
        assert (this.act == this.activation) : "Activation instances cannot be different.";
        this.qInfo = (SelectQueryInfo)this.act.qInfo;
        ParameterValueSet _pvs = act.getParameterValueSet();
        this.pvs = _pvs != null && _pvs.getParameterCount() > 0 ? _pvs : null;
        this.rowFormatter = this.qInfo.getRowFormatter();
        this.objectStore = this.qInfo.isObjectStore();
        this.gfContainers = this.qInfo.getContainerList();
        this.isForUpdate = this.qInfo.isSelectForUpdateQuery();
        if (this.observer != null) {
            this.observer.createdGemFireXDResultSet(this);
        }
    }

    @Override
    public ExecRow getNextRow() throws StandardException {
        long beginTime = this.statisticsTimingOn ? XPLAINUtil.recordTiming(-1L) : 0L;
        try {
            super.checkCancellationFlag();
            this.currentRow = this.iterator.next();
            if (this.currentRow != null) {
                ++this.rowsReturned;
            }
            this.setCurrentRow(this.currentRow);
            ExecRow execRow = this.currentRow;
            return execRow;
        }
        catch (Exception ex) {
            this.iterator.finish();
            LocalRegion region = this.gfContainers.size() > 0 ? this.gfContainers.get(0).getRegion() : null;
            String method = "GemFireDistributedResultSet::getNextRow";
            GemFireXDUtils.processCancelException("GemFireDistributedResultSet::getNextRow", ex, null);
            if (ex instanceof StandardException) {
                throw (StandardException)ex;
            }
            throw Misc.processFunctionException("GemFireDistributedResultSet::getNextRow", ex, null, region);
        }
        catch (Error e) {
            throw StandardException.newException("38000", (Throwable)e, (Object)e.toString());
        }
        finally {
            if (beginTime != 0L) {
                this.nextTime += XPLAINUtil.recordTiming(beginTime);
            }
        }
    }

    @Override
    public final void openCore() throws StandardException {
        for (GemFireContainer container : this.gfContainers) {
            container.open(this.tran, 8);
        }
    }

    @Override
    public void setup(Object res, int numMembers) throws StandardException {
        Collection<Object> results;
        long beginTime;
        long l = beginTime = this.statisticsTimingOn ? XPLAINUtil.recordTiming(-1L) : 0L;
        if (res != null) {
            results = (Collection)res;
        } else {
            results = Collections.emptyList();
            this.tran.getLockSpace().rcEnd(null);
        }
        this.resultHolderList = results;
        this.iterator = this.getIterator(numMembers);
        if (this.observer != null) {
            this.observer.beforeORM(this.activation, this);
        }
        if (beginTime != 0L) {
            this.openTime += XPLAINUtil.recordTiming(beginTime);
        }
    }

    @Override
    public final void setupRC(GfxdResultCollector<?> rc) throws StandardException {
        long beginTime;
        assert (rc != null) : "expected non-null ResultCollector";
        long l = beginTime = this.statisticsTimingOn ? XPLAINUtil.recordTiming(-1L) : 0L;
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("setupRC: setting up ResultCollector " + rc));
        }
        rc.setupContainersToClose(this.gfContainers, this.tran);
        if (beginTime != 0L) {
            this.openTime += XPLAINUtil.recordTiming(beginTime);
        }
    }

    @Override
    public final void reset(GfxdResultCollector<?> rc) throws StandardException {
        if (rc != null) {
            this.closeContainers();
            this.setupRC(rc);
            this.openCore();
        }
    }

    @Override
    public void finishResultSet(boolean cleanupOnError) throws StandardException {
        try {
            this.closeContainers();
        }
        finally {
            if (this.iterator != null) {
                this.iterator.finish();
            }
            this.act.resetProjectionExecRow();
            if (this.observer != null) {
                this.observer.afterORM(this.activation, this);
            }
        }
    }

    private final void closeContainers() {
        for (GemFireContainer container : this.gfContainers) {
            container.closeForEndTransaction(this.tran, false);
        }
    }

    @Override
    public long getTimeSpent(int type, int timeType) {
        if (timeType == 0) {
            return PlanUtils.getTimeSpent(0L, this.openTime, this.nextTime, this.closeTime, timeType) - (this.iterator != null ? this.iterator.getTimeSpent(1) : 0L);
        }
        return PlanUtils.getTimeSpent(0L, this.openTime, this.nextTime, this.closeTime, timeType);
    }

    @Override
    public boolean returnsRows() {
        return true;
    }

    @Override
    public void clearCurrentRow() {
        this.currentRow = null;
    }

    final RowFormatter getRowFormatter() {
        assert (this.rowFormatter != null || this.objectStore || this.qInfo.isTableVTI());
        return this.rowFormatter;
    }

    final DataTypeDescriptor getDistinctAggUnderlyingType() {
        return this.distinctAggUnderlyingType;
    }

    private AbstractRSIterator getIterator(int numMembers) throws StandardException {
        AbstractRSIterator retIter = null;
        int queryType = this.qInfo.getQueryFlag();
        if (numMembers == 1) {
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"creating a single node optimized iterator");
            }
            if (this.allTablesReplicatedOnRemote) {
                if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"GemFireDistributedResultSet.getIterator - allTablesReplicatedOnRemote is True. Select Plain vanilla SequentialIterator");
                }
                return new SequentialIterator();
            }
            if (!this.qInfo.hasIntersectOrExceptNode() && (queryType & 0x82) == 0) {
                if ((queryType & 0x18) != 0) {
                    return new SequentialIterator(this.qInfo.getDistinctQI());
                }
                if ((queryType & 1) != 0) {
                    return new SequentialIterator(this.qInfo.getOrderByQI());
                }
                return new SequentialIterator();
            }
        }
        if ((queryType & 8) != 0) {
            retIter = new OrderedIterator(this.qInfo.getDistinctQI(), true, true, this.qInfo.isOuterJoinSpecialCase(), false);
        } else if ((queryType & 0x10) != 0) {
            retIter = new OrderedIterator(this.qInfo.getDistinctQI(), true, true, this.qInfo.isOuterJoinSpecialCase(), false);
        } else if ((queryType & 2) != 0) {
            this.distinctAggUnderlyingType = this.qInfo.getGroupByQI().getDistinctAggregateUnderlyingType();
            if (this.qInfo.getGroupByQI().doReGrouping()) {
                retIter = new GroupedIterator(new OrderedIterator(this.qInfo.getGroupByQI(), false, true, this.qInfo.isOuterJoinSpecialCase(), false));
            } else {
                AbstractRSIterator internalItr = this.qInfo.isOuterJoinSpecialCase() ? new SpecialCaseOuterJoinIterator(this.qInfo.getGroupByQI()) : new SequentialIterator(this.qInfo.getGroupByQI());
                retIter = new GroupedIterator(internalItr);
            }
        }
        if ((queryType & 1) != 0) {
            retIter = retIter != null ? new OrderedIterator(retIter, this.qInfo.getOrderByQI().getColumnOrdering(), false, true) : (this.qInfo.hasIntersectOrExceptNode() ? new SetOperatorIterator(new OrderedIterator(this.qInfo.getOrderByQI(), false, false, this.qInfo.isOuterJoinSpecialCase(), this.qInfo.hasIntersectOrExceptNode()), this.qInfo.getNameOfIntersectOrExceptOperator()) : new OrderedIterator(this.qInfo.getOrderByQI(), false, false, this.qInfo.isOuterJoinSpecialCase(), false));
        }
        if (retIter == null) {
            retIter = this.qInfo.isOuterJoinSpecialCase() ? new SpecialCaseOuterJoinIterator() : new SequentialIterator();
            SanityManager.ASSERT((!this.qInfo.hasIntersectOrExceptNode() ? 1 : 0) != 0, (String)"Intersection has by default 'Order By', so must have an iterator by now");
        }
        if ((queryType & 0x80) != 0) {
            assert (retIter != null);
            retIter = new RowCountIterator(retIter, this.qInfo.getRowCountOffSet(), this.qInfo.getRowCountFetchFirst(), this.qInfo.isDynamicOffset(), this.qInfo.isDyanmicFetchFirst());
        }
        ((AbstractRSIterator)retIter).initialize();
        return retIter;
    }

    public final boolean isIterator(int flag) {
        boolean retVal = false;
        if ((flag & 1) == 1) {
            boolean bl = retVal = this.iterator instanceof OrderedIterator;
            if (!retVal) {
                return retVal;
            }
            OrderedIterator iter = (OrderedIterator)this.iterator;
            if ((flag & 2) == 2) {
                boolean bl2 = retVal = retVal && iter.sortDistinct;
            }
            if ((flag & 4) == 4) {
                boolean bl3 = retVal = retVal && iter.fetchAllFirst;
            }
            if ((flag & 8) == 8) {
                retVal = retVal && !iter.fetchAllFirst;
            }
        } else if ((flag & 0x10) == 16) {
            boolean bl = retVal = this.iterator instanceof SequentialIterator;
            if (!retVal) {
                return retVal;
            }
        }
        return retVal;
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.setNumberOfChildren(0);
        visitor.visit(this);
    }

    @Override
    public final boolean isForUpdate() {
        return this.isForUpdate;
    }

    @Override
    public final boolean canUpdateInPlace() {
        return this.isForUpdate();
    }

    @Override
    public final void updateRow(ExecRow updateRow) throws StandardException {
        GemFireContainer gfContainer = this.qInfo.getGFContainer();
        Object key = this.getKeyForDirectModificationFromCurrentRow(gfContainer);
        this.cachedChangedRow = GemFireDistributedResultSet.updateDirectly(key, null, updateRow, this.act.getUpdatedColumns(), gfContainer, this.qInfo, this.tran, this.lcc, this.cachedChangedRow);
    }

    @Override
    public void deleteRowDirectly() throws StandardException {
        GemFireContainer gfContainer = this.qInfo.getGFContainer();
        Object key = this.getKeyForDirectModificationFromCurrentRow(gfContainer);
        gfContainer.delete(key, null, this.qInfo.isPrimaryKeyBased(), this.tran, gfContainer.getActiveTXState(this.tran), this.lcc, false);
    }

    private Object getKeyForDirectModificationFromCurrentRow(GemFireContainer gfContainer) throws StandardException {
        int[] pifk = this.qInfo.getProjectionIndexesForKey();
        Object key = null;
        if (pifk != null) {
            key = GemFireXDUtils.convertIntoGemFireRegionKey(this.currentRow, gfContainer, null, pifk);
        } else {
            key = this.getCurrentKey();
            if (key instanceof KeyWithRegionContext) {
                ((KeyWithRegionContext)key).setRegionContext(gfContainer.getRegion());
            }
        }
        return key;
    }

    public static DataValueDescriptor[] updateDirectly(Object key, Object callbackArg, ExecRow updateRow, boolean[] columnGotUpdated, GemFireContainer gfContainer, SelectQueryInfo qInfo, GemFireTransaction tran, LanguageConnectionContext lcc, DataValueDescriptor[] cachedChangedRow) throws StandardException {
        if (cachedChangedRow == null) {
            cachedChangedRow = new DataValueDescriptor[gfContainer.getTableDescriptor().getNumberOfColumns()];
        }
        for (int i = 0; i < cachedChangedRow.length; ++i) {
            cachedChangedRow[i] = null;
        }
        int len = updateRow.nColumns();
        ColumnQueryInfo[] colsToBeUpdatedInfo = new ColumnQueryInfo[len];
        ColumnQueryInfo[] colInfo = qInfo.getProjectionColumnQueryInfo();
        int numOfUpdateColumns = 0;
        for (int i = 0; i < len; ++i) {
            if (columnGotUpdated[i]) {
                DataValueDescriptor dvd = updateRow.getColumn(i + 1);
                int actualPosition = colInfo[i].getActualColumnPosition();
                cachedChangedRow[actualPosition - 1] = dvd;
                colsToBeUpdatedInfo[i] = colInfo[i];
                ++numOfUpdateColumns;
                continue;
            }
            colsToBeUpdatedInfo[i] = null;
        }
        FormatableBitSet changedColumnBitSet = new FormatableBitSet(numOfUpdateColumns);
        for (int i = 0; i < colsToBeUpdatedInfo.length; ++i) {
            ColumnQueryInfo cqi = colsToBeUpdatedInfo[i];
            if (cqi == null) continue;
            changedColumnBitSet.grow(cqi.getActualColumnPosition());
            changedColumnBitSet.set(cqi.getActualColumnPosition() - 1);
        }
        gfContainer.replacePartialRow(key, changedColumnBitSet, cachedChangedRow, null, tran, gfContainer.getActiveTXState(tran), lcc, null, false);
        return cachedChangedRow;
    }

    private Object getCurrentKey() {
        assert (this.currentRow.getAllRegionAndKeyInfo() != null);
        assert (this.qInfo.isSelectForUpdateCase());
        return this.currentRow.getAllRegionAndKeyInfo().iterator().next().getKey();
    }

    @Override
    public long estimateMemoryUsage() throws StandardException {
        long memory = 0L;
        if (this.iterator != null) {
            memory += this.iterator.estimateMemoryUsage();
        }
        if (this.cachedChangedRow != null && this.cachedChangedRow.length > 0) {
            for (DataValueDescriptor d : this.cachedChangedRow) {
                memory += (long)d.estimateMemoryUsage();
            }
        }
        return memory;
    }

    @Override
    public boolean needsRowLocation() {
        return false;
    }

    @Override
    public void rowLocation(RowLocation rl) throws StandardException {
    }

    @Override
    public ExecRow getNextRowFromRowSource() throws StandardException {
        return null;
    }

    @Override
    public boolean needsToClone() {
        return false;
    }

    @Override
    public FormatableBitSet getValidColumns() {
        return null;
    }

    @Override
    public void closeRowSource() {
    }

    @Override
    public void markAsTopResultSet() {
    }

    @Override
    public void reopenCore() throws StandardException {
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        return this.getNextRow();
    }

    @Override
    public int getPointOfAttachment() {
        return 0;
    }

    @Override
    public int getScanIsolationLevel() {
        return 0;
    }

    @Override
    public void setTargetResultSet(TargetResultSet trs) {
    }

    @Override
    public void setNeedsRowLocation(boolean needsRowLocation) {
    }

    @Override
    public double getEstimatedRowCount() {
        return 0.0;
    }

    @Override
    public int resultSetNumber() {
        return 0;
    }

    @Override
    public void setCurrentRow(ExecRow row) {
    }

    @Override
    public boolean requiresRelocking() {
        return false;
    }

    @Override
    public TXState initLocalTXState() {
        return null;
    }

    @Override
    public void upgradeReadLockToWrite(RowLocation rl, GemFireContainer container) throws StandardException {
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
    }

    @Override
    public void positionScanAtRowLocation(RowLocation rLoc) throws StandardException {
    }

    @Override
    public boolean isDistributedResultSet() {
        return true;
    }

    @Override
    public void setGfKeysForNCJoin(ArrayList<DataValueDescriptor> keys) throws StandardException {
        throw StandardException.newException("0A000.S", " Currently this method is not implemented or overridden for class " + this.getClass().getSimpleName());
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        if (this.resultHolderList != null) {
            for (ResultHolder holder : this.resultHolderList) {
                if (holder == null) continue;
                holder.buildResultSetString(builder);
            }
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public RowLocation fetch(RowLocation loc, ExecRow destRow, FormatableBitSet validColumns, boolean faultIn, GemFireContainer container) throws StandardException {
        return RowUtil.fetch(loc, destRow, validColumns, faultIn, container, null, null, 0, this.tran);
    }

    @Override
    public void releasePreviousByteSource() {
    }

    @Override
    public void setMaxSortingLimit(long limit) {
    }

    protected final class OrderedIterator
    extends AbstractRSIterator {
        private ExecRow templateRow;
        protected final int[] colOrdering;
        protected final boolean[] colOrderingAsc;
        protected final boolean[] colOrderingNullsLow;
        protected final boolean allColumns;
        protected final boolean sortDistinct;
        private ArraySortScan scan;
        int[] projectMapping;
        protected boolean fetchAllFirst;
        private boolean applyProjection;
        Properties sortProperties;
        private ColumnOrdering[] orderByCols;
        long maxSortLimit;
        private long sortId;
        private boolean isDone;
        private boolean caseOfIntersectOrExcept;
        final AbstractRSIterator source;
        transient int rowsInput;

        OrderedIterator(AbstractRSIterator iter, ColumnOrdering[] orderbycols, boolean isDistinct, boolean fetchEager) throws StandardException {
            boolean[] blArray;
            boolean[] blArray2;
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("Creating OrderedIterator with " + iter.getClass().getSimpleName()));
            }
            this.allColumns = orderbycols == null;
            int[] nArray = this.colOrdering = orderbycols != null ? new int[orderbycols.length] : new int[]{};
            if (orderbycols != null) {
                blArray2 = new boolean[orderbycols.length];
            } else {
                boolean[] blArray3 = new boolean[1];
                blArray2 = blArray3;
                blArray3[0] = true;
            }
            this.colOrderingAsc = blArray2;
            if (orderbycols != null) {
                blArray = new boolean[orderbycols.length];
            } else {
                boolean[] blArray4 = new boolean[1];
                blArray = blArray4;
                blArray4[0] = false;
            }
            this.colOrderingNullsLow = blArray;
            if (orderbycols != null) {
                int i = 0;
                for (ColumnOrdering co : orderbycols) {
                    this.colOrdering[i] = co.getColumnId();
                    this.colOrderingAsc[i] = co.getIsAscending();
                    this.colOrderingNullsLow[i] = co.getIsNullsOrderedLow();
                    ++i;
                }
            }
            this.sortDistinct = isDistinct;
            assert (iter != null && !(iter instanceof RoundRobinIterator) || !fetchEager) : "RoundRobin iterator cannot handle fetchEager";
            this.source = iter;
            this.applyProjection = false;
            this.orderByCols = orderbycols;
        }

        OrderedIterator(SecondaryClauseQueryInfo qInfo, boolean isDistinct, boolean fetchEager, boolean isOuterJoinCase, boolean hasIntersectOrExcept) throws StandardException {
            this(isOuterJoinCase ? this$0.new SpecialCaseOuterJoinIterator(qInfo) : (fetchEager && !hasIntersectOrExcept ? this$0.new SequentialIterator(qInfo) : this$0.new RoundRobinIterator(qInfo)), hasIntersectOrExcept ? null : qInfo.getColumnOrdering(), hasIntersectOrExcept ? false : isDistinct, fetchEager);
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)"Creating OrderedIterator");
            }
            this.projectMapping = qInfo.getProjectMapping();
            this.applyProjection = true;
            this.caseOfIntersectOrExcept = hasIntersectOrExcept;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExecRow next() throws StandardException {
            ExecRow returnRow = null;
            if (this.isDone) {
                return null;
            }
            long beginTime = GemFireDistributedResultSet.this.statisticsTimingOn ? XPLAINUtil.recordTiming(-1L) : 0L;
            try {
                if (!this.scan.next()) {
                    this.finish();
                    this.isDone = true;
                    ExecRow execRow = null;
                    return execRow;
                }
                returnRow = this.scan.fetchRow(this.templateRow);
                if (GemFireXDUtils.TraceRSIter) {
                    SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("OrderedIterator::next(): returning row " + returnRow));
                }
                if (this.applyProjection) {
                    if ((returnRow = this.doProjection(returnRow)) != null) {
                        ++this.rowsReturned;
                        ExecRow execRow = returnRow;
                        return execRow;
                    }
                    ExecRow execRow = null;
                    return execRow;
                }
                if (returnRow != null) {
                    ++this.rowsReturned;
                    ExecRow execRow = returnRow;
                    return execRow;
                }
                ExecRow execRow = null;
                return execRow;
            }
            finally {
                if (beginTime != 0L) {
                    this.nextTime += XPLAINUtil.recordTiming(beginTime);
                    this.nestedTimingIndicator = 0;
                }
            }
        }

        @Override
        public void initialize() throws StandardException {
            ExecRow r;
            AbstractRSIterator source;
            block6: {
                source = this.source;
                source.initialize();
                while ((this.templateRow = source.next()) != null) {
                    if (this.templateRow == ROUND_COMPLETE) continue;
                    break block6;
                }
                this.isDone = true;
                return;
            }
            BasicSortObserver sortObserver = new BasicSortObserver(true, this.sortDistinct, this.templateRow, false);
            GemFireTransaction tc = (GemFireTransaction)GemFireDistributedResultSet.this.act.getLanguageConnectionContext().getTransactionExecute();
            if (GemFireXDUtils.TraceSortTuning) {
                SanityManager.DEBUG_PRINT((String)"SortTuning", (String)("creating sort of template " + this.templateRow + " from row=" + this.templateRow.getClass().getName() + " with sort order " + Arrays.toString(this.orderByCols)));
            }
            if (this.orderByCols == null) {
                this.orderByCols = new IndexColumnOrder[this.templateRow.nColumns()];
                for (int idx = 0; idx < this.orderByCols.length; ++idx) {
                    this.orderByCols[idx] = new IndexColumnOrder(idx);
                }
            }
            this.sortId = tc.createSort(null, this.templateRow, this.orderByCols, sortObserver, this.orderByCols == null || this.orderByCols.length == 0, -1L, -1, this.maxSortLimit);
            ArraySorter sorter = (ArraySorter)tc.openSort(this.sortId);
            sorter.insert(this.templateRow);
            this.templateRow = this.templateRow.getNewNullRow();
            while ((r = source.next()) != null) {
                if (r == ROUND_COMPLETE) continue;
                sorter.insert(r);
            }
            if (GemFireXDUtils.TraceSortTuning) {
                SanityManager.DEBUG_PRINT((String)"SortTuning", (String)("Creating sort properties for " + this + " from initScan"));
            }
            this.createSortProps(sorter);
            sorter.completedInserts();
            this.scan = (ArraySortScan)tc.openSortScan(this.sortId, GemFireDistributedResultSet.this.activation.getResultSetHoldability());
        }

        private final void createSortProps(SortController sorter) throws StandardException {
            if (!GemFireDistributedResultSet.this.runtimeStatisticsOn) {
                if (GemFireXDUtils.TraceSortTuning) {
                    SanityManager.DEBUG_PRINT((String)"SortTuning", (String)"Not creating sort properties as runtimeStats is off.");
                }
                return;
            }
            if (sorter != null) {
                this.sortProperties = sorter.getSortInfo().getAllSortInfo(new Properties());
            } else {
                this.sortProperties = new Properties();
                this.sortProperties.put(MessageService.getTextMessage("XSAJA.U"), Integer.toString(this.rowsInput));
                this.sortProperties.put(MessageService.getTextMessage("XSAJB.U"), Integer.toString(this.rowsReturned));
            }
            if (GemFireXDUtils.TraceSortTuning) {
                SanityManager.DEBUG_PRINT((String)"SortTuning", (String)("Sort properties " + this.sortProperties + " opening sort scan ..."));
            }
        }

        private ExecRow doProjection(ExecRow inputRow) throws StandardException {
            if (this.projectMapping == null) {
                return inputRow;
            }
            if (inputRow == null) {
                return null;
            }
            ValueRow returnRow = new ValueRow(this.projectMapping.length);
            inputRow.setValuesInto(this.projectMapping, false, returnRow);
            return returnRow;
        }

        @Override
        public ExecRow getExpectedRow() {
            return this.source.getExpectedRow();
        }

        @Override
        public void accept(IteratorStatisticsVisitor visitor) {
            visitor.setNumberOfChildren(1);
            visitor.visit(this);
            this.source.accept(visitor);
        }

        @Override
        public long getCurrentTimeSpent() {
            return this.nextTime - this.source.getTimeSpent(1);
        }

        @Override
        public long estimateMemoryUsage() throws StandardException {
            long memory = 0L;
            return memory += this.source.estimateMemoryUsage();
        }

        @Override
        public void finish() throws StandardException {
            if (GemFireXDUtils.TraceSortTuning) {
                SanityManager.DEBUG_PRINT((String)"SortTuning", (String)("About to finish ordered iterator for " + this + " scan is " + (this.scan == null ? "null" : " not null")));
            }
            if (this.scan != null) {
                GemFireDistributedResultSet.this.act.getLanguageConnectionContext().getTransactionExecute().dropSort(this.sortId);
                this.scan.close();
                this.scan = null;
                this.isDone = true;
            } else {
                this.createSortProps(null);
            }
            this.source.finish();
        }

        protected class SetOrderedRow
        extends OrderedRow {
            private SetOrderedRow() throws StandardException {
                super(null);
                SanityManager.ASSERT((boolean)OrderedIterator.this.caseOfIntersectOrExcept, (String)" Only to be used for Set Operators");
            }

            private void setRow(ExecRow _row) throws StandardException {
                this.row = _row;
            }

            @Override
            public int hashCode() {
                int ret = 0;
                DataValueDescriptor[] rowArr = this.row.getRowArray();
                for (int i = 0; i < OrderedIterator.this.colOrdering.length; ++i) {
                    ret = 31 * ret + rowArr[i].hashCode();
                }
                return ret;
            }
        }

        protected class OrderedRow
        implements Comparable {
            protected ExecRow row = null;

            protected OrderedRow(ExecRow _row) throws StandardException {
                if (OrderedIterator.this.caseOfIntersectOrExcept && _row == null) {
                    return;
                }
                this.row = _row;
                assert (OrderedIterator.this.colOrdering.length <= this.row.nColumns());
            }

            public int compareTo(Object o) {
                if (this == (OrderedRow)o) {
                    return 0;
                }
                if (this.row == ((OrderedRow)o).row) {
                    return 0;
                }
                try {
                    DataValueDescriptor[] rowArr1 = this.row.getRowArray();
                    DataValueDescriptor[] rowArr2 = ((OrderedRow)o).row.getRowArray();
                    int cmp = 0;
                    int cols2Compare = OrderedIterator.this.allColumns ? rowArr1.length : OrderedIterator.this.colOrdering.length;
                    for (int i = 0; i < cols2Compare; ++i) {
                        int orderbycol = OrderedIterator.this.allColumns ? i : OrderedIterator.this.colOrdering[i];
                        boolean isNullsLow = OrderedIterator.this.allColumns ? OrderedIterator.this.colOrderingNullsLow[0] : OrderedIterator.this.colOrderingNullsLow[i];
                        boolean isAscending = OrderedIterator.this.allColumns ? OrderedIterator.this.colOrderingAsc[0] : OrderedIterator.this.colOrderingAsc[i];
                        cmp = rowArr1[orderbycol].compare(rowArr2[orderbycol], isNullsLow);
                        if (cmp == 0) continue;
                        return isAscending ? cmp : -cmp;
                    }
                }
                catch (StandardException e) {
                    throw GemFireXDRuntimeException.newRuntimeException("OrderedRow exception", e);
                }
                return 0;
            }

            public int hashCode() {
                int ret = 0;
                DataValueDescriptor[] rowArr = this.row.getRowArray();
                for (int i = 0; i < OrderedIterator.this.colOrdering.length; ++i) {
                    ret ^= rowArr[i].hashCode();
                }
                return ret;
            }

            public String toString() {
                StringBuilder orderingCols = new StringBuilder("Columns = ");
                for (DataValueDescriptor cl : this.row.getRowArray()) {
                    orderingCols.append((cl != null ? cl.toString() : "null") + "  ");
                }
                return orderingCols.toString();
            }
        }
    }

    protected final class GroupedIterator
    extends AbstractRSIterator {
        private boolean nextSatisfied;
        private boolean isScalar;
        protected GemFireAggregator[] aggregates;
        protected ColumnOrdering[] order;
        int[] projectMapping;
        BaseActivation exprEvaluator;
        ArrayList<String> exprMethodList;
        AbstractRSIterator source;
        ExecRow previousEntry;

        GroupedIterator(AbstractRSIterator iter) throws StandardException {
            this.nextSatisfied = false;
            this.source = iter;
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)"Creating GroupedIterator");
            }
            this.isScalar = !GemFireDistributedResultSet.this.qInfo.getGroupByQI().doReGrouping();
            AggregatorInfoList aggInfoList = GemFireDistributedResultSet.this.qInfo.getGroupByQI().getAggInfo();
            ClassFactory cf = GemFireDistributedResultSet.this.lcc.getLanguageConnectionFactory().getClassFactory();
            int count = aggInfoList.size();
            this.aggregates = new GemFireAggregator[count];
            for (int i = 0; i < count; ++i) {
                AggregatorInfo aggInfo = (AggregatorInfo)aggInfoList.elementAt(i);
                this.aggregates[i] = new GemFireAggregator(aggInfo, cf);
            }
            this.order = GemFireDistributedResultSet.this.qInfo.getGroupByQI().getColumnOrdering();
            this.projectMapping = GemFireDistributedResultSet.this.qInfo.getGroupByQI().getPostGroupingProjectMapping();
            this.exprEvaluator = GemFireDistributedResultSet.this.qInfo.getGroupByQI().getExpressionEvaluator(GemFireDistributedResultSet.this.lcc);
            if (this.exprEvaluator != null && GemFireDistributedResultSet.this.pvs != null) {
                this.exprEvaluator.setParameters(GemFireDistributedResultSet.this.pvs, null);
            }
            this.exprMethodList = GemFireDistributedResultSet.this.qInfo.getGroupByQI().getExprMethodList();
            this.previousEntry = null;
        }

        @Override
        public void initialize() throws StandardException {
            this.source.initialize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExecRow next() throws StandardException {
            long beginTime = GemFireDistributedResultSet.this.statisticsTimingOn ? XPLAINUtil.recordTiming(-1L) : 0L;
            ExecRow returnRow = null;
            try {
                do {
                    ExecRow entry;
                    returnRow = null;
                    ExecRow accumulateRow = GemFireDistributedResultSet.this.qInfo.getGroupByQI().getTemplateRow().getNewNullRow();
                    for (GemFireAggregator currAggregate : this.aggregates) {
                        currAggregate.initialize(accumulateRow);
                    }
                    while ((entry = this.source.next()) != null || this.previousEntry != null) {
                        if (returnRow == null) {
                            if (this.previousEntry != null) {
                                returnRow = this.previousEntry;
                                this.previousEntry = null;
                                for (GemFireAggregator currAggregate : this.aggregates) {
                                    currAggregate.merge(returnRow, accumulateRow);
                                }
                                if (GemFireXDUtils.TraceGroupByIter) {
                                    SanityManager.DEBUG_PRINT((String)"TraceGroupByRSIteration", (String)("GroupedIterator::next(): processing previously held row " + returnRow + (this.aggregates.length != 0 ? " resulting accumulated row " + accumulateRow : "")));
                                }
                            } else {
                                returnRow = entry.getClone();
                            }
                        }
                        if (!this.sameGroupingValues(returnRow, entry)) {
                            assert (!(this.source instanceof RoundRobinIterator));
                            this.previousEntry = entry;
                            if (!GemFireXDUtils.TraceGroupByIter) break;
                            SanityManager.DEBUG_PRINT((String)"TraceGroupByRSIteration", (String)("GroupedIterator::next(): holding as previous entry " + this.previousEntry));
                            break;
                        }
                        for (GemFireAggregator currAggregate : this.aggregates) {
                            currAggregate.merge(entry, accumulateRow);
                        }
                        if (!GemFireXDUtils.TraceGroupByIter) continue;
                        SanityManager.DEBUG_PRINT((String)"TraceGroupByRSIteration", (String)("GroupedIterator::next(): entry=" + entry + (this.aggregates.length != 0 ? " accumulateRow=" + accumulateRow : "")));
                    }
                    if (this.nextSatisfied && returnRow == null) {
                        ExecRow execRow = null;
                        return execRow;
                    }
                    if (this.isScalar && !this.nextSatisfied && returnRow == null) {
                        returnRow = GemFireDistributedResultSet.this.qInfo.getGroupByQI().getInComingProjectionExecRow().getNewNullRow();
                        this.isScalar = false;
                    }
                    boolean eliminatedNulls = false;
                    for (GemFireAggregator currAggregate : this.aggregates) {
                        if (!currAggregate.finish(accumulateRow, returnRow)) continue;
                        eliminatedNulls = true;
                    }
                    if (eliminatedNulls) {
                        GemFireDistributedResultSet.this.activation.addNullEliminatedWarning();
                    }
                    if (!GemFireXDUtils.TraceGroupByIter) continue;
                    SanityManager.DEBUG_PRINT((String)"TraceGroupByRSIteration", (String)("GroupedIterator::next(): returnRow before projection/having restriction " + (returnRow != null ? returnRow : " null ")));
                } while (this.restrictCurrentRow(returnRow));
                this.nextSatisfied = true;
                returnRow = this.doProjection(returnRow);
                if (GemFireXDUtils.TraceGroupByIter) {
                    SanityManager.DEBUG_PRINT((String)"TraceGroupByRSIteration", (String)("GroupedIterator::next(): returning " + (returnRow != null ? returnRow : " null ")));
                }
                ++this.rowsReturned;
                ExecRow execRow = returnRow;
                return execRow;
            }
            finally {
                if (returnRow == null && this.exprEvaluator != null) {
                    try {
                        this.exprEvaluator.close();
                    }
                    catch (Exception exception) {}
                }
                if (beginTime != 0L) {
                    this.nextTime += XPLAINUtil.recordTiming(beginTime);
                    this.nestedTimingIndicator = 0;
                }
            }
        }

        private boolean sameGroupingValues(ExecRow currRow, ExecRow newRow) throws StandardException {
            if (currRow == null || newRow == null) {
                return true;
            }
            if (this.order == null) {
                return true;
            }
            for (ColumnOrdering element : this.order) {
                DataValueDescriptor newOrderable;
                DataValueDescriptor currOrderable = currRow.getColumn(element.getColumnId() + 1);
                if (currOrderable.compare(2, newOrderable = newRow.getColumn(element.getColumnId() + 1), true, true)) continue;
                return false;
            }
            return true;
        }

        private boolean restrictCurrentRow(ExecRow inputRow) throws StandardException {
            if (inputRow == null) {
                return false;
            }
            if (this.exprEvaluator == null) {
                return false;
            }
            this.exprEvaluator.setCurrentRow(inputRow, 0);
            boolean restrict = false;
            int msize = this.exprMethodList.size();
            for (int index = this.projectMapping == null ? 0 : this.projectMapping.length; index < msize; ++index) {
                String filter = this.exprMethodList.get(index);
                if (filter == null) continue;
                DataValueDescriptor booleanRetVal = (DataValueDescriptor)this.exprEvaluator.getMethod(filter).invoke(this.exprEvaluator);
                boolean bl = restrict = !booleanRetVal.isNull() && !booleanRetVal.getBoolean();
                if (!restrict) continue;
                if (!GemFireXDUtils.TraceGroupByIter) break;
                SanityManager.DEBUG_PRINT((String)"TraceGroupByRSIteration", (String)("GroupedIterator::doProjection(): filtering out row " + inputRow));
                break;
            }
            return restrict;
        }

        private ExecRow doProjection(ExecRow inputRow) throws StandardException {
            if (this.projectMapping == null) {
                return inputRow;
            }
            if (inputRow == null) {
                return null;
            }
            if (this.exprEvaluator != null) {
                this.exprEvaluator.setCurrentRow(inputRow, 0);
            }
            ValueRow returnRow = new ValueRow(this.projectMapping.length);
            for (int index = 0; index < this.projectMapping.length; ++index) {
                if (this.projectMapping[index] >= 0 || this.exprEvaluator == null) continue;
                int idx = -this.projectMapping[index] - 1;
                DataValueDescriptor result = (DataValueDescriptor)this.exprEvaluator.getMethod(this.exprMethodList.get(idx)).invoke(this.exprEvaluator);
                returnRow.setColumn(index + 1, result);
            }
            inputRow.setValuesInto(this.projectMapping, false, returnRow);
            return returnRow;
        }

        @Override
        public ExecRow getExpectedRow() {
            return this.source.getExpectedRow();
        }

        @Override
        public void accept(IteratorStatisticsVisitor visitor) {
            visitor.setNumberOfChildren(1);
            visitor.visit(this);
            this.source.accept(visitor);
        }

        @Override
        public long getCurrentTimeSpent() {
            return this.nextTime - this.source.getTimeSpent(1);
        }

        @Override
        public long estimateMemoryUsage() throws StandardException {
            return this.source.estimateMemoryUsage();
        }

        @Override
        public void finish() throws StandardException {
            this.source.finish();
        }
    }

    private final class GemFireAggregator
    extends GenericAggregator {
        ExecAggregator inputAgg;
        UserDataValue inputVal;

        GemFireAggregator(AggregatorInfo aggInfo, ClassFactory cf) {
            super(aggInfo, cf);
            this.inputVal = null;
        }

        @Override
        public void initialize(ExecRow row) throws StandardException {
            super.initialize(row);
            this.inputAgg = super.getAggregatorInstance();
        }

        @Override
        public void merge(ExecRow inputRow, ExecRow mergeRow) throws StandardException {
            if (inputRow == null) {
                return;
            }
            DataValueDescriptor mergeColumn = mergeRow.getColumn(this.aggregatorColumnId + 1);
            DataValueDescriptor inputColumn = inputRow.getColumn(this.inputColumnId);
            if (inputColumn.isNull()) {
                return;
            }
            if (this.aggInfo.isDistinct()) {
                this.mergeDistinctEntries(mergeRow.getColumn(this.resultColumnId + 1), inputColumn);
                return;
            }
            this.inputAgg.setup("", inputColumn);
            if (this.inputVal == null) {
                this.inputVal = (UserDataValue)mergeColumn.getClone();
            }
            this.inputVal.setValue(this.inputAgg);
            if (GemFireXDUtils.TraceAggreg) {
                SanityManager.DEBUG_PRINT((String)"TraceAggregation", (String)("GemFireAggregator#merge: inputVal [" + this.inputVal + "] mergeColumn: " + mergeColumn));
            }
            this.merge(this.inputVal, mergeColumn);
        }

        boolean finish(ExecRow input, ExecRow output) throws StandardException {
            if (output == null) {
                return false;
            }
            if (this.aggInfo.isDistinct()) {
                this.enumerateDistinctEntries(input);
            }
            boolean eliminatedNulls = super.finish(input, this.resultColumnId);
            output.setColumn(this.inputColumnId, input.getColumn(this.resultColumnId));
            return eliminatedNulls;
        }

        void mergeDistinctEntries(DataValueDescriptor resultColumn, DataValueDescriptor inputColumn) {
            assert (resultColumn instanceof DVDSet) : " resultColumn must be instance of DVDSet";
            assert (inputColumn instanceof DVDSet) : " inputColumn must be instance of DVDSet";
            ((DVDSet)resultColumn).merge((DVDSet)inputColumn);
        }

        void enumerateDistinctEntries(ExecRow mergeRow) throws StandardException {
            DataValueDescriptor inputColumn = mergeRow.getColumn(this.resultColumnId + 1);
            DataValueDescriptor aggregator = mergeRow.getColumn(this.aggregatorColumnId + 1);
            Object values = ((DVDSet)inputColumn).getObject();
            Iterator iterator = ((ArrayList)values).iterator();
            while (iterator.hasNext()) {
                Object dvd = iterator.next();
                this.accumulate((DataValueDescriptor)dvd, aggregator);
            }
        }
    }

    protected final class RowCountIterator
    extends AbstractRSIterator {
        private final long offset;
        private final long fetchFirst;
        private int rowsFetched;
        private boolean offsetApplied;
        private final AbstractRSIterator source;

        RowCountIterator(AbstractRSIterator iterator, long offsetOrOffsetPrm, long fetchFirstOrFetchFirstPrm, boolean dynamicOffset, boolean dynamicFetchFirst) throws StandardException {
            this.rowsFetched = 0;
            this.offsetApplied = false;
            this.source = iterator;
            this.offset = dynamicOffset ? ((BaseActivation)GemFireDistributedResultSet.this.getActivation()).getParameter((int)offsetOrOffsetPrm).getLong() : offsetOrOffsetPrm;
            this.fetchFirst = dynamicFetchFirst ? ((BaseActivation)GemFireDistributedResultSet.this.getActivation()).getParameter((int)fetchFirstOrFetchFirstPrm).getLong() : fetchFirstOrFetchFirstPrm;
            long fetchFirst = this.fetchFirst;
            if (fetchFirst > 0L && iterator instanceof OrderedIterator) {
                ((OrderedIterator)iterator).maxSortLimit = this.offset <= 0L ? fetchFirst : fetchFirst + this.offset;
            }
        }

        @Override
        public void initialize() throws StandardException {
            this.source.initialize();
        }

        @Override
        public ExecRow getExpectedRow() {
            return this.source.getExpectedRow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExecRow next() throws StandardException {
            long beginTime = GemFireDistributedResultSet.this.statisticsTimingOn ? XPLAINUtil.recordTiming(-1L) : 0L;
            try {
                if (this.fetchFirst != -1L && (long)this.rowsFetched >= this.fetchFirst) {
                    ExecRow execRow = null;
                    return execRow;
                }
                ExecRow result = null;
                if (!this.offsetApplied && this.offset > 0L) {
                    this.offsetApplied = true;
                    long offsetCtr = this.offset;
                    do {
                        if ((result = this.source.next()) != null) continue;
                        ExecRow execRow = null;
                        return execRow;
                    } while (--offsetCtr >= 0L);
                } else {
                    result = this.source.next();
                }
                if (result != null) {
                    ++this.rowsFetched;
                }
                ++this.rowsReturned;
                ExecRow execRow = result;
                return execRow;
            }
            finally {
                if (beginTime != 0L) {
                    this.nextTime += XPLAINUtil.recordTiming(beginTime);
                    this.nestedTimingIndicator = 0;
                }
            }
        }

        @Override
        public void accept(IteratorStatisticsVisitor visitor) {
            visitor.setNumberOfChildren(1);
            visitor.visit(this);
            this.source.accept(visitor);
        }

        @Override
        public long getCurrentTimeSpent() {
            return this.nextTime - this.source.getTimeSpent(1);
        }

        @Override
        public long estimateMemoryUsage() throws StandardException {
            return this.source.estimateMemoryUsage();
        }

        @Override
        public void finish() throws StandardException {
            this.source.finish();
        }
    }

    protected final class SetOperatorIterator
    extends AbstractRSIterator {
        public static final int LEFT_CHILD = 0;
        public static final int RIGHT_CHILD = 1;
        public static final int INTERSECT_OP = 1;
        public static final int EXCEPT_OP = 2;
        public static final int INTERSECT_ALL_OP = 3;
        public static final int EXCEPT_ALL_OP = 4;
        private final int opType;
        private final OrderedIterator sourceOrderedIter;
        private ExecRow currentRow;
        private ExecRow previousRow;
        private final OrderedIterator.SetOrderedRow wrapCurrentRowToCompare;
        private final OrderedIterator.SetOrderedRow wrapPreviousRowToCompare;
        private boolean firstCall;
        private int previousRowDuplicates;
        private final int[] perChildDuplicatesCount;
        private boolean compareReturnPositive;
        private boolean compareReturnNegative;

        SetOperatorIterator(OrderedIterator orderedIter, String operatorName) throws StandardException {
            this.currentRow = null;
            this.previousRow = null;
            this.firstCall = true;
            this.previousRowDuplicates = 0;
            this.perChildDuplicatesCount = new int[]{0, 0};
            OrderedIterator orderedIterator = this.sourceOrderedIter = orderedIter;
            orderedIterator.getClass();
            this.wrapCurrentRowToCompare = orderedIterator.new OrderedIterator.SetOrderedRow();
            OrderedIterator orderedIterator2 = this.sourceOrderedIter;
            orderedIterator2.getClass();
            this.wrapPreviousRowToCompare = orderedIterator2.new OrderedIterator.SetOrderedRow();
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)(" GemfireDistributedResultset::SetOperatorIterator Creating SetOperatorIterator with source " + this.sourceOrderedIter.getClass().getSimpleName() + " Operator = " + operatorName));
            }
            if (operatorName.equals("INTERSECT")) {
                this.opType = 1;
            } else if (operatorName.equals("EXCEPT")) {
                this.opType = 2;
            } else if (operatorName.equals("INTERSECTALL")) {
                this.opType = 3;
            } else if (operatorName.equals("EXCEPTALL")) {
                this.opType = 4;
            } else {
                this.opType = 0;
                SanityManager.ASSERT((boolean)true, (String)"Operator name doesn't matches Intersect or Except");
            }
        }

        @Override
        public void initialize() throws StandardException {
            this.sourceOrderedIter.initialize();
        }

        private void setPreviousRow(ExecRow prow) throws StandardException {
            SanityManager.ASSERT((this.previousRowDuplicates == 0 ? 1 : 0) != 0, (String)" Duplicates should be zero ");
            this.previousRow = prow;
            this.wrapPreviousRowToCompare.setRow(this.previousRow);
            if (this.previousRow != null) {
                this.initializeDuplicatesCount();
            }
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)(" SetOperatorIterator::setPreviousRow: new previous row " + (this.previousRow == null ? "null" : this.wrapPreviousRowToCompare.toString())));
            }
        }

        private void cleanUpBeforeReturn() {
            this.clearPreviousRow();
            this.currentRow = null;
            this.compareReturnNegative = false;
            this.compareReturnPositive = false;
        }

        private void clearPreviousRow() {
            this.previousRow = null;
            this.perChildDuplicatesCount[0] = 0;
            this.perChildDuplicatesCount[1] = 0;
            this.previousRowDuplicates = 0;
        }

        private int getSetOperationCount() {
            SanityManager.ASSERT((this.previousRow != null ? 1 : 0) != 0, (String)" SetOperatorIterator previousRow is null ");
            SanityManager.ASSERT((this.perChildDuplicatesCount[0] != 0 || this.perChildDuplicatesCount[1] != 0 ? 1 : 0) != 0, (String)" SetOperatorIterator duplicate count should not be empty ");
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("SetOperatorIterator::getSetOperationCount: Dump of perChildDuplicatesCount = " + this.perChildDuplicatesCount[0] + " " + this.perChildDuplicatesCount[1]));
            }
            int rowDuplicates = Integer.MAX_VALUE;
            switch (this.opType) {
                case 1: {
                    if (this.perChildDuplicatesCount[0] != 0 && this.perChildDuplicatesCount[1] != 0) {
                        rowDuplicates = 1;
                        break;
                    }
                    rowDuplicates = 0;
                    break;
                }
                case 2: {
                    if (this.perChildDuplicatesCount[0] != 0 && this.perChildDuplicatesCount[1] == 0) {
                        rowDuplicates = 1;
                        break;
                    }
                    rowDuplicates = 0;
                    break;
                }
                case 3: {
                    rowDuplicates = this.perChildDuplicatesCount[0];
                    if (rowDuplicates <= this.perChildDuplicatesCount[1]) break;
                    rowDuplicates = this.perChildDuplicatesCount[1];
                    break;
                }
                case 4: {
                    rowDuplicates = this.perChildDuplicatesCount[0] - this.perChildDuplicatesCount[1];
                    if (rowDuplicates >= 0) break;
                    rowDuplicates = 0;
                }
            }
            if (rowDuplicates == Integer.MAX_VALUE) {
                SanityManager.THROWASSERT((String)("SetOperatorIterator produces invalid count for set operation opType: " + this.opType));
            }
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("SetOperatorIterator::getSetOperationCount set operation opType: " + this.opType + " returned duplicates = " + rowDuplicates));
            }
            return rowDuplicates;
        }

        private void initializeDuplicatesCount() {
            SanityManager.ASSERT((this.previousRow != null ? 1 : 0) != 0, (String)"SetOperatorIterator initializeDuplicatesCount");
            SanityManager.ASSERT((this.perChildDuplicatesCount[0] == 0 && this.perChildDuplicatesCount[1] == 0 ? 1 : 0) != 0, (String)" SetOperatorIterator Map should be empty ");
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("SetOperatorIterator::initializeDuplicatesCount: tuple is =" + this.previousRow.toString()));
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("SetOperatorIterator::initializeDuplicatesCount: raks of the above tuple =" + this.previousRow.getAllRegionAndKeyInfo().toString()));
            }
            if (this.previousRow.getAllRegionAndKeyInfo().first().isLeftSideTreeOfSetOperatorNode()) {
                this.perChildDuplicatesCount[0] = this.perChildDuplicatesCount[0] + 1;
            } else {
                this.perChildDuplicatesCount[1] = this.perChildDuplicatesCount[1] + 1;
            }
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("SetOperatorIterator::initializeDuplicatesCount:  Dump of perChildDuplicatesCount = " + this.perChildDuplicatesCount[0] + " " + this.perChildDuplicatesCount[1]));
            }
        }

        private void updateDuplicatesCount(ExecRow vRow) {
            SanityManager.ASSERT((this.previousRow != null ? 1 : 0) != 0, (String)"SetOperatorIterator updateDuplicatesCount");
            SanityManager.ASSERT((vRow != null ? 1 : 0) != 0, (String)"SetOperatorIterator updateDuplicatesCount");
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("SetOperatorIterator::updateDuplicatesCount: tuple is =" + vRow.toString()));
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("SetOperatorIterator::updateDuplicatesCount: raks of the above tuple =" + vRow.getAllRegionAndKeyInfo().toString()));
            }
            if (vRow.getAllRegionAndKeyInfo().first().isLeftSideTreeOfSetOperatorNode()) {
                this.perChildDuplicatesCount[0] = this.perChildDuplicatesCount[0] + 1;
            } else {
                this.perChildDuplicatesCount[1] = this.perChildDuplicatesCount[1] + 1;
            }
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("SetOperatorIterator::updateDuplicatesCount:  Dump of perChildDuplicatesCount = " + this.perChildDuplicatesCount[0] + " " + this.perChildDuplicatesCount[1]));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExecRow next() throws StandardException {
            long beginTime = GemFireDistributedResultSet.this.statisticsTimingOn ? XPLAINUtil.recordTiming(-1L) : 0L;
            try {
                if (this.firstCall) {
                    this.firstCall = false;
                    SanityManager.ASSERT((this.previousRow == null ? 1 : 0) != 0, (String)" Previously row should be null ");
                    SanityManager.ASSERT((this.currentRow == null ? 1 : 0) != 0, (String)" Current row should be null ");
                    SanityManager.ASSERT((this.previousRowDuplicates == 0 ? 1 : 0) != 0, (String)" Duplicate count should be zero ");
                    if (GemFireXDUtils.TraceRSIter) {
                        SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)"SetOperatorIterator::next First call");
                    }
                    this.currentRow = this.sourceOrderedIter.next();
                    if (GemFireXDUtils.TraceRSIter) {
                        if (this.currentRow == null) {
                            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)"SetOperatorIterator::next Found new row (first row) = Null ");
                        } else {
                            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("SetOperatorIterator::next Found new row (first row) = " + GemFireXDUtils.addressOf(this.currentRow) + " " + this.currentRow.toString()));
                        }
                    }
                    assert (this.checkRegionAndKeyInRow(this.currentRow));
                    this.setPreviousRow(this.currentRow);
                    this.currentRow = null;
                    ExecRow execRow = this.next();
                    return execRow;
                }
                if (this.previousRow == null) {
                    SanityManager.ASSERT((this.previousRowDuplicates == 0 ? 1 : 0) != 0, (String)" Duplicates should be zero ");
                    if (GemFireXDUtils.TraceRSIter) {
                        SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("SetOperatorIterator::next Exit ; Rows returned = " + this.rowsReturned));
                    }
                    this.cleanUpBeforeReturn();
                    ExecRow execRow = null;
                    return execRow;
                }
                if (this.previousRowDuplicates > 0) {
                    SanityManager.ASSERT((this.previousRow != null ? 1 : 0) != 0, (String)" Previously returned row is null ");
                    if (GemFireXDUtils.TraceRSIter) {
                        SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("SetOperatorIterator::next Returns duplicate [" + this.previousRowDuplicates + "] for row: " + this.previousRow.toString()));
                    }
                    ExecRow returnRow = this.previousRow;
                    if (--this.previousRowDuplicates == 0) {
                        this.clearPreviousRow();
                        this.setPreviousRow(this.currentRow);
                        this.currentRow = null;
                    }
                    ++this.rowsReturned;
                    ExecRow execRow = returnRow;
                    return execRow;
                }
                if (this.previousRowDuplicates == 0) {
                    SanityManager.ASSERT((this.previousRow != null ? 1 : 0) != 0, (String)" Previously returned row is null ");
                    SanityManager.ASSERT((this.currentRow == null ? 1 : 0) != 0, (String)" Current row should be null ");
                    if (GemFireXDUtils.TraceRSIter) {
                        SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)"SetOperatorIterator::next; get next from source");
                    }
                    while ((this.currentRow = this.sourceOrderedIter.next()) != null) {
                        assert (this.checkRegionAndKeyInRow(this.currentRow));
                        this.wrapCurrentRowToCompare.setRow(this.currentRow);
                        if (GemFireXDUtils.TraceRSIter) {
                            if (this.currentRow == null) {
                                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)"SetOperatorIterator::next Found new row = Null ");
                            } else {
                                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("SetOperatorIterator::next Found new row = " + GemFireXDUtils.addressOf(this.currentRow) + " " + this.currentRow.toString()));
                            }
                        }
                        int compareReturn = 0;
                        compareReturn = this.wrapCurrentRowToCompare.compareTo(this.wrapPreviousRowToCompare);
                        if (compareReturn == 0) {
                            if (GemFireXDUtils.TraceRSIter) {
                                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)"SetOperatorIterator New found row is duplicate of previous");
                            }
                            this.updateDuplicatesCount(this.currentRow);
                            continue;
                        }
                        if (GemFireXDUtils.TraceRSIter) {
                            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("SetOperatorIterator new found row is not-duplicate of previous. compare = " + compareReturn));
                        }
                        if (compareReturn > 0) {
                            SanityManager.ASSERT((!this.compareReturnNegative ? 1 : 0) != 0, (String)" New found row is in out of order. ");
                            this.compareReturnPositive = true;
                        } else {
                            SanityManager.ASSERT((!this.compareReturnNegative ? 1 : 0) != 0, (String)" New found row is in out of order. ");
                            this.compareReturnNegative = true;
                        }
                        this.previousRowDuplicates = this.getSetOperationCount();
                        if (this.previousRowDuplicates > 0) {
                            ExecRow execRow = this.next();
                            return execRow;
                        }
                        this.clearPreviousRow();
                        this.setPreviousRow(this.currentRow);
                        this.currentRow = null;
                    }
                    SanityManager.ASSERT((this.currentRow == null ? 1 : 0) != 0, (String)" Current row should be null ");
                    if (GemFireXDUtils.TraceRSIter) {
                        SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)"SetOperatorIterator::next No more rows ");
                    }
                    this.previousRowDuplicates = this.getSetOperationCount();
                    if (this.previousRowDuplicates > 0) {
                        ExecRow execRow = this.next();
                        return execRow;
                    }
                    this.cleanUpBeforeReturn();
                    ExecRow execRow = null;
                    return execRow;
                }
                if (GemFireXDUtils.TraceRSIter) {
                    SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("SetOperatorIterator::next Unexpected return with duplicate [" + this.previousRowDuplicates + "] for previous row: " + (this.previousRow == null ? "" : this.previousRow.toString()) + " and for current row: " + (this.currentRow == null ? "" : this.currentRow.toString()) + " . Total rows returned = " + this.rowsReturned));
                }
                SanityManager.THROWASSERT((String)" Previously returned row handlling error. ");
                ExecRow execRow = null;
                return execRow;
            }
            finally {
                if (beginTime != 0L) {
                    this.nextTime += XPLAINUtil.recordTiming(beginTime);
                    this.nestedTimingIndicator = 0;
                }
            }
        }

        private boolean checkRegionAndKeyInRow(ExecRow currentRow) {
            if (currentRow != null) {
                SanityManager.ASSERT((currentRow.getAllRegionAndKeyInfo() != null ? 1 : 0) != 0, (String)" First row's key-info is null ");
                SanityManager.ASSERT((currentRow.getAllRegionAndKeyInfo().size() > 0 ? 1 : 0) != 0, (String)" First row's key-info is empty ");
                SanityManager.ASSERT((boolean)currentRow.getAllRegionAndKeyInfo().first().isForSpecialUseOfSetOperators(), (String)" First row's key-info is invalid for set operators ");
            }
            return true;
        }

        @Override
        public ExecRow getExpectedRow() {
            return this.sourceOrderedIter.getExpectedRow();
        }

        @Override
        public void accept(IteratorStatisticsVisitor visitor) {
            visitor.setNumberOfChildren(1);
            visitor.visit(this);
            this.sourceOrderedIter.accept(visitor);
        }

        @Override
        public long getCurrentTimeSpent() {
            return this.nextTime - this.sourceOrderedIter.getTimeSpent(1);
        }

        @Override
        public long estimateMemoryUsage() throws StandardException {
            long memory = 0L;
            return memory += this.sourceOrderedIter.estimateMemoryUsage();
        }

        @Override
        public void finish() throws StandardException {
            this.sourceOrderedIter.finish();
        }
    }

    protected final class SpecialCaseOuterJoinIterator
    extends AbstractRSIterator {
        final SequentialIterator source;
        LinkedHashMap lhm;
        private Map<String, Object> driverTablesMap;
        private Iterator<?> iter;
        private Iterator<?> activeListItr;

        public SpecialCaseOuterJoinIterator(SecondaryClauseQueryInfo sqinfo) throws StandardException {
            this.driverTablesMap = null;
            this.source = new SequentialIterator(sqinfo);
            this.initializeDriver();
        }

        private void initializeDriver() {
            this.driverTablesMap = GemFireDistributedResultSet.this.qInfo.getDriverRegionsForOuterJoins();
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("GemfireDistributedResultset::OJ_Itr::initializeDriver:driver=" + this.driverTablesMap));
            }
        }

        public SpecialCaseOuterJoinIterator() throws StandardException {
            this.driverTablesMap = null;
            this.source = new SequentialIterator();
            this.initializeDriver();
        }

        private int getPRCount(TreeSet<RegionAndKey> allInfos, ExecRow erow) {
            int prCount = 0;
            Iterator<RegionAndKey> itr = allInfos.iterator();
            if (GemFireXDUtils.TraceOuterJoin) {
                SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("GemfireDistributedResultset::SpecialcaseOuteroinIterator::getPRCount::finding pr count for erow: " + erow));
            }
            while (itr.hasNext()) {
                RegionAndKey tmprak = itr.next();
                if (!tmprak.isReplicatedRegion()) {
                    ++prCount;
                }
                if (!GemFireXDUtils.TraceOuterJoin) continue;
                SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("GemfireDistributedResultset::SpecialcaseOuteroinIterator::getPRCount::rak is: " + tmprak));
            }
            return prCount;
        }

        Set<RegionAndKey> getDriverRegionKey(TreeSet<RegionAndKey> allInfos) {
            THashSet driverKeys = new THashSet(allInfos.size());
            for (RegionAndKey tmprak : allInfos) {
                if (!tmprak.isReplicatedRegion() || !this.driverTablesMap.containsKey(tmprak.getRegionName())) continue;
                driverKeys.add(tmprak);
            }
            assert (driverKeys.size() != 0);
            return driverKeys;
        }

        void populateHashMap() throws StandardException {
            if (GemFireXDUtils.TraceOuterJoin) {
                SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("GemfireDistributedResultset::SpecialcaseOuteroinIterator::populateHashMap: started with driverTablesMap: " + this.driverTablesMap));
            }
            int keysize = 0;
            if (this.lhm == null) {
                this.lhm = new LinkedHashMap();
                ExecRow erow = null;
                while ((erow = this.source.next()) != null) {
                    if (erow == ROUND_COMPLETE) continue;
                    ExecRow newErow = null;
                    if (erow == null) continue;
                    TreeSet<RegionAndKey> allinfos = erow.getAllRegionAndKeyInfo();
                    if (GemFireXDUtils.TraceOuterJoin) {
                        SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("GemfireDistributedResultset::SpecialcaseOuteroinIterator::populateHashMap: tuple is =" + erow));
                        SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("GemfireDistributedResultset::SpecialcaseOuteroinIterator::populateHashMap: raks of the above tuple =" + allinfos));
                    }
                    if (allinfos == null) continue;
                    newErow = erow.getClone();
                    erow.clearAllRegionAndKeyInfo();
                    Set<RegionAndKey> driverKeys = this.getDriverRegionKey(allinfos);
                    int prCnt = this.getPRCount(allinfos, erow);
                    if (GemFireXDUtils.TraceOuterJoin) {
                        SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("GemfireDistributedResultset::SpecialcaseOuteroinIterator::populateHashMap: driverKeys are: " + driverKeys + " and pr cnt is: " + prCnt));
                    }
                    if (allinfos.size() > keysize) {
                        keysize = allinfos.size();
                    }
                    Object oldObj = this.lhm.get(driverKeys);
                    if (GemFireXDUtils.TraceOuterJoin) {
                        SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("GemfireDistributedResultset::SpecialcaseOuteroinIterator::populateHashMap: old object for driverKeys: " + driverKeys + " is " + oldObj));
                    }
                    if (oldObj != null) {
                        if (oldObj instanceof List) {
                            List prsetsExecRows = (List)oldObj;
                            if (prCnt == 0) {
                                if (!GemFireXDUtils.TraceOuterJoin) continue;
                                SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("GemfireDistributedResultset::OJ_Itr::popHashMap: Ignoring new row = " + newErow + " as a valid row containing pr row is already there"));
                                continue;
                            }
                            if (GemFireXDUtils.TraceOuterJoin) {
                                SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("GemfireDistributedResultset::OJ_Itr::popHashMap:Old object List, match level > 0 adding new row = " + newErow + " for driverKeys: " + driverKeys));
                            }
                            prsetsExecRows.add(newErow);
                            continue;
                        }
                        assert (oldObj instanceof ExecRow);
                        if (prCnt == 0) {
                            if (!GemFireXDUtils.TraceOuterJoin) continue;
                            SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("GemfireDistributedResultset::OJ_Iterator::popHashMap: Ignoring tuple =" + newErow + " because pr cnt is 0 and we have an old object " + oldObj));
                            continue;
                        }
                        if (GemFireXDUtils.TraceOuterJoin) {
                            SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("GemfireDistributedResultset::OJ_Iterator::popHashMap: Replacing " + oldObj + " with " + newErow));
                        }
                        ArrayList<ExecRow> temp = new ArrayList<ExecRow>(5);
                        temp.add(newErow);
                        if (GemFireXDUtils.TraceOuterJoin) {
                            SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("GemfireDistributedResultset::SpecialcaseOuteroinIterator::populateHashMap: putting_two driverKeys : " + driverKeys + " values: " + temp + " in lhm"));
                        }
                        this.lhm.put(driverKeys, temp);
                        continue;
                    }
                    Object toPut = null;
                    if (prCnt == 0) {
                        toPut = newErow;
                    } else {
                        ArrayList<ExecRow> temp = new ArrayList<ExecRow>(5);
                        temp.add(newErow);
                        toPut = temp;
                    }
                    if (GemFireXDUtils.TraceOuterJoin) {
                        SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("GemfireDistributedResultset::SpecialcaseOuteroinIterator::populateHashMap: putting_one driverKeys : " + driverKeys + " values: " + toPut + " in lhm"));
                    }
                    this.lhm.put(driverKeys, toPut);
                }
                if (GemFireXDUtils.TraceOuterJoin) {
                    SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("GemfireDistributedResultset::SpecialcaseOuteroinIterator::populateHashMap:Final Map is=" + this.lhm));
                }
                this.iter = this.lhm.entrySet().iterator();
                this.activeListItr = null;
            }
        }

        @Override
        public ExecRow getExpectedRow() {
            return this.source.getExpectedRow();
        }

        private boolean hasNext() throws StandardException {
            if (this.lhm == null) {
                this.populateHashMap();
            }
            if (this.activeListItr == null) {
                return this.iter.hasNext();
            }
            if (this.activeListItr.hasNext()) {
                return true;
            }
            this.activeListItr = null;
            return this.iter.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExecRow next() throws StandardException {
            long beginTime = GemFireDistributedResultSet.this.statisticsTimingOn ? XPLAINUtil.recordTiming(-1L) : 0L;
            try {
                if (!this.hasNext()) {
                    ExecRow execRow = null;
                    return execRow;
                }
                if (this.activeListItr != null) {
                    ExecRow tmprow = (ExecRow)this.activeListItr.next();
                    ++this.rowsReturned;
                    ExecRow execRow = tmprow;
                    return execRow;
                }
                Map.Entry e = (Map.Entry)this.iter.next();
                Object obj = e.getValue();
                if (obj instanceof List) {
                    List currlist = (List)obj;
                    this.activeListItr = currlist.iterator();
                    ExecRow tmprow = (ExecRow)this.activeListItr.next();
                    ++this.rowsReturned;
                    ExecRow execRow = tmprow;
                    return execRow;
                }
                assert (obj instanceof ExecRow);
                ExecRow execRow = (ExecRow)obj;
                return execRow;
            }
            finally {
                if (beginTime != 0L) {
                    this.nextTime += XPLAINUtil.recordTiming(beginTime);
                    this.nestedTimingIndicator = 0;
                }
            }
        }

        @Override
        public void accept(IteratorStatisticsVisitor visitor) {
            visitor.setNumberOfChildren(1);
            visitor.visit(this);
            this.source.accept(visitor);
        }

        @Override
        public long getCurrentTimeSpent() {
            return this.nextTime - this.source.getTimeSpent(1);
        }

        @Override
        public long estimateMemoryUsage() throws StandardException {
            long memory = 0L;
            if (this.lhm != null) {
                try {
                    for (Map.Entry e : this.lhm.entrySet()) {
                        Object k = e.getKey();
                        Object v = e.getValue();
                        assert (k instanceof RegionAndKey);
                        assert (v instanceof List || v instanceof ExecRow);
                        memory += ((RegionAndKey)k).estimateMemoryUsage();
                        if (v instanceof List) {
                            for (Object li : (List)v) {
                                assert (li instanceof RegionAndKey);
                                memory += ((RegionAndKey)li).estimateMemoryUsage();
                            }
                            continue;
                        }
                        memory += ((RegionAndKey)v).estimateMemoryUsage();
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            return memory += this.source.estimateMemoryUsage();
        }

        @Override
        public void finish() throws StandardException {
            this.source.finish();
        }
    }

    protected final class RoundRobinIterator
    extends AbstractRSIterator {
        private ExecRow templateValueRow;
        private ExecRow templateCompactRow;
        private ExecRow expectedRow;
        private Iterator<?> rhlistiter;
        private final ArrayList<ResultHolder> rhlist;
        private final SecondaryClauseQueryInfo sqinfo;
        private ResultHolder active;
        private byte flags;
        private static final byte USING_RHLIST = 1;

        public RoundRobinIterator(SecondaryClauseQueryInfo sqinfo) throws StandardException {
            this.rhlistiter = GemFireDistributedResultSet.this.resultHolderList.iterator();
            this.active = null;
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)"Creating RoundRobinIterator");
            }
            this.sqinfo = sqinfo;
            ExecRow templateRow = sqinfo != null ? sqinfo.getInComingProjectionExecRow().getNewNullRow() : GemFireDistributedResultSet.this.act.getProjectionExecRow();
            if (templateRow instanceof AbstractCompactExecRow) {
                this.templateCompactRow = templateRow;
            } else {
                this.templateValueRow = templateRow;
            }
            if (GemFireDistributedResultSet.this.resultHolderList instanceof ArrayList) {
                this.rhlist = (ArrayList)GemFireDistributedResultSet.this.resultHolderList;
                this.flags = 1;
            } else {
                this.rhlist = new ArrayList();
            }
        }

        private boolean isRHListEmpty() {
            return (this.flags & 1) != 0 && this.rhlist.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ExecRow next() throws StandardException {
            if (this.isRHListEmpty()) {
                return null;
            }
            long beginTime = GemFireDistributedResultSet.this.statisticsTimingOn ? XPLAINUtil.recordTiming(-1L) : 0L;
            try {
                this.active = null;
                if (!this.rhlistiter.hasNext()) {
                    this.rhlistiter = this.rhlist.iterator();
                    this.flags = GemFireXDUtils.set(this.flags, (byte)1);
                    ExecRow execRow = ROUND_COMPLETE;
                    return execRow;
                }
                while (true) {
                    if (this.isRHListEmpty()) {
                        ExecRow execRow = null;
                        return execRow;
                    }
                    if (!this.rhlistiter.hasNext()) {
                        if (this.rhlist.isEmpty()) {
                            ExecRow execRow = null;
                            return execRow;
                        }
                        this.rhlistiter = this.rhlist.iterator();
                        this.flags = GemFireXDUtils.set(this.flags, (byte)1);
                    }
                    this.active = (ResultHolder)this.rhlistiter.next();
                    if (GemFireXDUtils.TraceRSIter) {
                        SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("Picking next round robin ResultHolder " + this.active));
                    }
                    this.active.setRowFormatter(this.getRowFormatter(this.sqinfo), GemFireDistributedResultSet.this.objectStore || GemFireDistributedResultSet.this.qInfo.isTableVTI());
                    this.active.setDistinctAggUnderlyingType(GemFireDistributedResultSet.this.getDistinctAggUnderlyingType());
                    boolean iterOk = false;
                    try {
                        if (!this.active.hasNext(GemFireDistributedResultSet.this.activation)) {
                            iterOk = true;
                            if (GemFireXDUtils.isSet(this.flags, (byte)1)) {
                                this.rhlistiter.remove();
                            }
                            if (GemFireDistributedResultSet.this.statisticsTimingOn) {
                                this.statsRHs.add(this.active);
                            }
                            this.active = null;
                            continue;
                        }
                        iterOk = true;
                    }
                    finally {
                        if (iterOk) continue;
                        this.finish();
                        continue;
                    }
                    break;
                }
                if (!GemFireXDUtils.isSet(this.flags, (byte)1)) {
                    this.rhlist.add(this.active);
                }
                if (this.active.hasProjectionFromRemote()) {
                    if (this.templateValueRow == null) {
                        this.templateValueRow = new ValueRow(this.templateCompactRow.getRowArrayClone());
                    }
                    this.expectedRow = this.active.getNext(this.templateValueRow, GemFireDistributedResultSet.this.activation);
                } else {
                    this.expectedRow = this.templateCompactRow = this.active.getNext(this.templateCompactRow, GemFireDistributedResultSet.this.activation);
                }
                if (this.expectedRow != null) {
                    Object bs = this.expectedRow.getByteSource();
                    if (bs instanceof OffHeapByteSource) {
                        GemFireDistributedResultSet.this.tran.addByteSource((OffHeapByteSource)((Object)bs));
                    } else {
                        GemFireDistributedResultSet.this.tran.addByteSource(null);
                    }
                }
                if (GemFireXDUtils.TraceRSIter) {
                    SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("Picking next row from round robin ResultHolder " + this.expectedRow + " RegionAndKeys = " + (this.expectedRow != null ? this.expectedRow.getAllRegionAndKeyInfo() : "null")));
                }
                ++this.rowsReturned;
                ExecRow execRow = this.expectedRow;
                return execRow;
            }
            finally {
                if (beginTime != 0L) {
                    this.nextTime += XPLAINUtil.recordTiming(beginTime);
                    this.nestedTimingIndicator = 0;
                }
            }
        }

        @Override
        public ExecRow getExpectedRow() {
            return this.expectedRow;
        }

        @Override
        public void accept(IteratorStatisticsVisitor visitor) {
            visitor.setNumberOfChildren(this.statsRHs.size());
            visitor.visit(this);
            for (ResultHolder rh : this.statsRHs) {
                rh.assertNoData();
                visitor.visit(rh);
            }
        }

        @Override
        public long getCurrentTimeSpent() {
            Iterator rhi = this.statsRHs.iterator();
            long totalChildTime = 0L;
            while (rhi.hasNext()) {
                ResultHolder rh = (ResultHolder)rhi.next();
                totalChildTime += rh.ser_deser_time + rh.process_time + rh.throttle_time;
            }
            return this.nextTime - totalChildTime;
        }

        @Override
        public long estimateMemoryUsage() throws StandardException {
            Iterator<Object> iterator = GemFireDistributedResultSet.this.resultHolderList instanceof GfxdQueryStreamingResultCollector ? ((GfxdQueryStreamingResultCollector)GemFireDistributedResultSet.this.resultHolderList).reusableIterator() : GemFireDistributedResultSet.this.resultHolderList.iterator();
            long memory = 0L;
            while (iterator.hasNext()) {
                Object res = iterator.next();
                if (!(res instanceof ResultHolder)) continue;
                memory += ((ResultHolder)res).estimateMemoryUsage();
            }
            if (GemFireDistributedResultSet.this.statisticsTimingOn) {
                memory += (long)this.statsRHs.size();
            }
            return memory;
        }

        @Override
        public void finish() throws StandardException {
            block9: {
                if (GemFireXDUtils.isOffHeapEnabled()) {
                    try {
                        if (this.active != null && this.active.isGenuinelyLocallyExecuted()) {
                            this.freeOffHeapReferences(this.active);
                            break block9;
                        }
                        if (this.isRHListEmpty()) {
                            return;
                        }
                        if (GemFireXDUtils.isSet(this.flags, (byte)1)) {
                            this.rhlistiter = this.rhlist.iterator();
                        }
                        int loopCount = 0;
                        do {
                            if (loopCount == 1) {
                                this.rhlistiter = this.rhlist.iterator();
                                this.flags = GemFireXDUtils.set(this.flags, (byte)1);
                            }
                            while (this.rhlistiter.hasNext()) {
                                ResultHolder next = (ResultHolder)this.rhlistiter.next();
                                if (next == null || !next.isGenuinelyLocallyExecuted()) continue;
                                this.freeOffHeapReferences(next);
                                break block9;
                            }
                            ++loopCount;
                        } while (!GemFireXDUtils.isSet(this.flags, (byte)1));
                    }
                    catch (Throwable ignore) {
                        if (!GemFireXDUtils.TraceRSIter) break block9;
                        SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)"RoundRobinIterator::finish: Problem in consuming the results. Ignoring", (Throwable)ignore);
                    }
                }
            }
        }
    }

    protected final class SequentialIterator
    extends AbstractRSIterator {
        private final Iterator<?> RSIterator;
        private final SecondaryClauseQueryInfo sqinfo;
        private ResultHolder active;
        private boolean activeHasProjection;
        private ExecRow templateValueRow;
        private ExecRow templateCompactRow;
        private ExecRow expectedRow;
        private boolean isAllDone;

        SequentialIterator() throws StandardException {
            this(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SequentialIterator(SecondaryClauseQueryInfo sqinfo) throws StandardException {
            this.isAllDone = false;
            this.RSIterator = GemFireDistributedResultSet.this.resultHolderList.iterator();
            this.sqinfo = sqinfo;
            ExecRow expectedRow = sqinfo != null ? sqinfo.getInComingProjectionExecRow().getNewNullRow() : GemFireDistributedResultSet.this.act.getProjectionExecRow();
            if (expectedRow instanceof AbstractCompactExecRow) {
                this.templateCompactRow = expectedRow;
            } else {
                this.templateValueRow = expectedRow;
            }
            while (this.RSIterator.hasNext()) {
                ResultHolder next = (ResultHolder)this.RSIterator.next();
                boolean iterOk = false;
                try {
                    if (next != null && next.hasNext(GemFireDistributedResultSet.this.activation)) {
                        this.active = next;
                        this.activeHasProjection = next.hasProjectionFromRemote();
                        if (GemFireDistributedResultSet.this.statisticsTimingOn) {
                            this.statsRHs.add(next);
                        }
                        this.active.setRowFormatter(this.getRowFormatter(sqinfo), GemFireDistributedResultSet.this.objectStore || GemFireDistributedResultSet.this.qInfo.isTableVTI());
                        this.active.setDistinctAggUnderlyingType(GemFireDistributedResultSet.this.getDistinctAggUnderlyingType());
                        iterOk = true;
                        break;
                    }
                    iterOk = true;
                }
                finally {
                    if (iterOk) continue;
                    this.finish();
                }
            }
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)"Creating SequentialIterator");
            }
        }

        @Override
        public ExecRow next() throws StandardException {
            if (this.isAllDone) {
                return null;
            }
            long beginTime = GemFireDistributedResultSet.this.statisticsTimingOn ? XPLAINUtil.recordTiming(-1L) : 0L;
            try {
                Object next;
                if (this.active == null) {
                    this.isAllDone = true;
                    ExecRow execRow = null;
                    return execRow;
                }
                if (this.active.hasNext(GemFireDistributedResultSet.this.activation)) {
                    this.expectedRow = this.extractRowFromActiveResultHolder();
                    ++this.rowsReturned;
                    ExecRow execRow = this.expectedRow;
                    return execRow;
                }
                this.active = null;
                while (this.RSIterator.hasNext()) {
                    next = (ResultHolder)this.RSIterator.next();
                    if (!((ResultHolder)next).hasNext(GemFireDistributedResultSet.this.activation)) continue;
                    this.setActiveResultHolder((ResultHolder)next);
                    break;
                }
                if (GemFireXDUtils.TraceRSIter) {
                    SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("Returning next active ResultHolder " + this.active));
                }
                next = this.next();
                return next;
            }
            catch (StandardException se) {
                this.finish();
                throw se;
            }
            catch (RuntimeException re) {
                this.finish();
                throw re;
            }
            finally {
                if (beginTime != 0L) {
                    this.nextTime += XPLAINUtil.recordTiming(beginTime);
                    this.nestedTimingIndicator = 0;
                }
            }
        }

        private void setActiveResultHolder(ResultHolder next) {
            this.active = next;
            this.activeHasProjection = next.hasProjectionFromRemote();
            if (GemFireDistributedResultSet.this.statisticsTimingOn) {
                this.statsRHs.add(next);
            }
            this.active.setRowFormatter(this.getRowFormatter(this.sqinfo), GemFireDistributedResultSet.this.objectStore || GemFireDistributedResultSet.this.qInfo.isTableVTI());
            this.active.setDistinctAggUnderlyingType(GemFireDistributedResultSet.this.getDistinctAggUnderlyingType());
            this.isAllDone = false;
        }

        private ExecRow extractRowFromActiveResultHolder() throws StandardException {
            ExecRow row = null;
            if (this.activeHasProjection) {
                if (this.templateValueRow == null) {
                    this.templateValueRow = new ValueRow(this.templateCompactRow.getRowArrayClone());
                }
                row = this.active.getNext(this.templateValueRow, GemFireDistributedResultSet.this.activation);
            } else {
                row = this.templateCompactRow = this.active.getNext(this.templateCompactRow, GemFireDistributedResultSet.this.activation);
            }
            if (GemFireXDUtils.isOffHeapEnabled() && this.active.isGenuinelyLocallyExecuted() && row != null) {
                Object bs = row.getByteSource();
                if (bs instanceof OffHeapByteSource) {
                    GemFireDistributedResultSet.this.tran.addByteSource((OffHeapByteSource)((Object)bs));
                } else {
                    GemFireDistributedResultSet.this.tran.addByteSource(null);
                }
            }
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("Returning next row from active ResultHolder " + row));
            }
            return row;
        }

        @Override
        public ExecRow getExpectedRow() {
            return this.expectedRow;
        }

        @Override
        public void accept(IteratorStatisticsVisitor visitor) {
            visitor.setNumberOfChildren(this.statsRHs.size());
            visitor.visit(this);
            Iterator rhi = this.statsRHs.iterator();
            while (rhi.hasNext()) {
                visitor.visit((ResultHolder)rhi.next());
            }
        }

        @Override
        public long getCurrentTimeSpent() {
            Iterator rhi = this.statsRHs.iterator();
            long totalChildTime = 0L;
            while (rhi.hasNext()) {
                ResultHolder rh = (ResultHolder)rhi.next();
                totalChildTime += rh.ser_deser_time + rh.process_time + rh.throttle_time;
            }
            return this.nextTime - totalChildTime;
        }

        @Override
        public long estimateMemoryUsage() throws StandardException {
            if (GemFireDistributedResultSet.this.observer != null) {
                GemFireDistributedResultSet.this.observer.estimatingMemoryUsage(GemFireDistributedResultSet.this.act.getStatementText(), this);
            }
            Iterator<Object> iterator = GemFireDistributedResultSet.this.resultHolderList instanceof GfxdQueryStreamingResultCollector ? ((GfxdQueryStreamingResultCollector)GemFireDistributedResultSet.this.resultHolderList).reusableIterator() : GemFireDistributedResultSet.this.resultHolderList.iterator();
            long memory = 0L;
            while (iterator.hasNext()) {
                Object res = iterator.next();
                if (!(res instanceof ResultHolder)) continue;
                memory += ((ResultHolder)res).estimateMemoryUsage();
            }
            return memory += (long)this.statsRHs.size();
        }

        @Override
        public void finish() throws StandardException {
            block5: {
                if (GemFireXDUtils.isOffHeapEnabled()) {
                    try {
                        if (this.active != null && this.active.isGenuinelyLocallyExecuted()) {
                            this.freeOffHeapReferences(this.active);
                            break block5;
                        }
                        while (this.RSIterator.hasNext()) {
                            ResultHolder next = (ResultHolder)this.RSIterator.next();
                            if (next == null || !next.isGenuinelyLocallyExecuted()) continue;
                            this.freeOffHeapReferences(next);
                            break;
                        }
                    }
                    catch (Throwable ignore) {
                        if (!GemFireXDUtils.TraceRSIter) break block5;
                        SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)"SequentialIterator::finish: Problem in consuming the results. Ignoring", (Throwable)ignore);
                    }
                }
            }
        }
    }

    protected abstract class AbstractRSIterator
    implements RSIterator {
        protected final List<ResultHolder> statsRHs;
        public transient int rowsReturned;
        protected transient long nextTime;
        protected transient short nestedTimingIndicator;

        AbstractRSIterator() {
            this.statsRHs = GemFireDistributedResultSet.this.statisticsTimingOn ? new ArrayList<ResultHolder>() : Collections.emptyList();
        }

        protected abstract long getCurrentTimeSpent();

        @Override
        public long getTimeSpent(int type) {
            if (type == 1) {
                return this.nextTime;
            }
            return this.getCurrentTimeSpent();
        }

        public void initialize() throws StandardException {
        }

        protected final RowFormatter getRowFormatter(SecondaryClauseQueryInfo sqinfo) {
            RowFormatter rf;
            if (sqinfo != null && (rf = sqinfo.getRowFormatter()) != null) {
                return rf;
            }
            return GemFireDistributedResultSet.this.getRowFormatter();
        }

        public void close() {
        }

        protected void freeOffHeapReferences(ResultHolder holder) throws StandardException {
            block3: {
                try {
                    if (holder != null) {
                        holder.freeOffHeapForCachedRowsAndCloseResultSet();
                    }
                }
                catch (Throwable ignore) {
                    if (!GemFireXDUtils.TraceRSIter) break block3;
                    SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)"AbstractRSIterator::freeOffHeapReferences: Problem in consuming the results. Ignoring", (Throwable)ignore);
                }
            }
        }
    }

    protected static interface RSIterator {
        public ExecRow next() throws StandardException;

        public long getTimeSpent(int var1);

        public ExecRow getExpectedRow();

        public void accept(IteratorStatisticsVisitor var1);

        public long estimateMemoryUsage() throws StandardException;

        public void finish() throws StandardException;
    }
}

