/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.catalog;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.cache.locks.LockMode;
import com.gemstone.gemfire.internal.cache.locks.ReentrantReadWriteWriteShareLock;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import java.io.IOException;

public class IRFLockAcquireOp
extends MemOperation {
    private final ReentrantReadWriteWriteShareLock lock;
    private final Object owner;
    private LogWriter logger;

    public IRFLockAcquireOp(ReentrantReadWriteWriteShareLock irf2Lock, Object lockOwner) {
        super(null);
        this.lock = irf2Lock;
        this.owner = lockOwner;
        this.logger = Misc.getCacheLogWriter();
    }

    public void takeLock() {
        if (this.logger.fineEnabled() || GemFireXDUtils.TracePersistIndex) {
            GfxdIndexManager.traceIndex("IRFLockAcquireOp::takeLock calling acquiring lock on=%s ", this.lock);
        }
        this.lock.attemptLock(LockMode.EX, -1L, this.owner);
        if (this.logger.fineEnabled() || GemFireXDUtils.TracePersistIndex) {
            GfxdIndexManager.traceIndex("IRFLockAcquireOp::takeLock acquired lock on=%s ", this.lock);
        }
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        if (this.logger.fineEnabled() || GemFireXDUtils.TracePersistIndex) {
            GfxdIndexManager.traceIndex("IRFLockAcquireOp::doMe called releasing lock on=%s ", this.lock);
        }
        this.lock.releaseLock(LockMode.EX, false, this.owner);
        if (this.logger.fineEnabled() || GemFireXDUtils.TracePersistIndex) {
            GfxdIndexManager.traceIndex("IRFLockAcquireOp::doMe called acquired lock on=%s ", this.lock);
        }
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        return null;
    }

    @Override
    public boolean doAtCommitOrAbort() {
        return true;
    }
}

