/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management.impl;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.snappy.CallbackFactoryProvider;
import com.gemstone.gemfire.management.ManagementException;
import com.gemstone.gemfire.management.internal.BaseManagementService;
import com.gemstone.gemfire.management.internal.FederationComponent;
import com.gemstone.gemfire.management.internal.LocalManager;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.ProxyListener;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import com.gemstone.gemfire.management.internal.beans.MemberMBeanBridge;
import com.gemstone.gemfire.management.internal.beans.RegionMBeanBridge;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.management.GfxdMemberMXBean;
import com.pivotal.gemfirexd.internal.engine.management.StatementMXBean;
import com.pivotal.gemfirexd.internal.engine.management.TableMXBean;
import com.pivotal.gemfirexd.internal.engine.management.impl.Cleanable;
import com.pivotal.gemfirexd.internal.engine.management.impl.GfxdDistributedSystemBridge;
import com.pivotal.gemfirexd.internal.engine.management.impl.GfxdMBeanAggregator;
import com.pivotal.gemfirexd.internal.engine.management.impl.GfxdMemberMBean;
import com.pivotal.gemfirexd.internal.engine.management.impl.GfxdMemberMBeanBridge;
import com.pivotal.gemfirexd.internal.engine.management.impl.MBeanDataUpdater;
import com.pivotal.gemfirexd.internal.engine.management.impl.MBeanUpdateScheduler;
import com.pivotal.gemfirexd.internal.engine.management.impl.ManagementUtils;
import com.pivotal.gemfirexd.internal.engine.management.impl.MemberMBeanDataUpdater;
import com.pivotal.gemfirexd.internal.engine.management.impl.StatementMBean;
import com.pivotal.gemfirexd.internal.engine.management.impl.StatementMBeanBridge;
import com.pivotal.gemfirexd.internal.engine.management.impl.TableMBean;
import com.pivotal.gemfirexd.internal.engine.management.impl.TableMBeanBridge;
import com.pivotal.gemfirexd.internal.engine.management.impl.TableMBeanDataUpdater;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.PreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.Statement;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.sql.GenericStatement;
import com.pivotal.gemfirexd.internal.impl.sql.StatementStats;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.management.ObjectName;

public class InternalManagementService {
    private static final Set<String> DEFAULT_SERVERGROUP_SET = Collections.singleton("DEFAULT");
    private static final Object INSTANCE_LOCK = InternalManagementService.class;
    private static final Map<GemFireStore, InternalManagementService> INSTANCES = new ConcurrentHashMap<GemFireStore, InternalManagementService>(4, 0.7f, 1);
    private SystemManagementService gfManagementService;
    private ConnectionWrapperHolder connectionWrapperHolder;
    private MBeanUpdateScheduler updateScheduler;
    private LogWriter logger;
    private MBeanDataUpdater<GfxdMemberMBeanBridge> memberMBeanDataUpdater;
    private MBeanDataUpdater<TableMBeanBridge> tableMBeanDataUpdater;
    private Map<ObjectName, Cleanable> cleanables = new HashMap<ObjectName, Cleanable>();
    private boolean isStopped;

    private InternalManagementService(GemFireStore store) {
        GemFireCacheImpl cache = store.getGemFireCache();
        this.gfManagementService = (SystemManagementService)BaseManagementService.getManagementService((Cache)cache);
        this.logger = cache.getLogger();
        this.connectionWrapperHolder = new ConnectionWrapperHolder();
        this.updateScheduler = new MBeanUpdateScheduler();
        this.memberMBeanDataUpdater = new MemberMBeanDataUpdater();
        this.tableMBeanDataUpdater = new TableMBeanDataUpdater();
        this.updateScheduler.scheduleTaskWithFixedDelay(this.memberMBeanDataUpdater, MemberMBeanDataUpdater.class.getSimpleName(), 500L);
        this.updateScheduler.scheduleTaskWithFixedDelay(this.tableMBeanDataUpdater, TableMBeanDataUpdater.class.getSimpleName(), 500L);
        this.isStopped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalManagementService getInstance(GemFireStore store) {
        InternalManagementService foundInstance = null;
        GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
        if (cache != null && !cache.isClosed() && !cache.isCacheAtShutdownAll() && store != null && (foundInstance = INSTANCES.get(store)) == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                foundInstance = INSTANCES.get(store);
                if (foundInstance == null) {
                    foundInstance = new InternalManagementService(store);
                    INSTANCES.clear();
                    INSTANCES.put(store, foundInstance);
                }
            }
        }
        return foundInstance;
    }

    public static InternalManagementService getAnyInstance() {
        Iterator<InternalManagementService> iterator = INSTANCES.values().iterator();
        if (iterator.hasNext()) {
            InternalManagementService inst = iterator.next();
            return inst;
        }
        return null;
    }

    public GfxdConnectionWrapper getConnectionWrapperForTEST() {
        ConnectionWrapperHolder holder = this.connectionWrapperHolder;
        return holder != null ? holder.wrapper : null;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() {
        this.cleanUp();
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            INSTANCES.clear();
        }
        this.isStopped = true;
    }

    void cleanUp() {
        this.updateScheduler.stopAllTasks();
        this.updateScheduler = null;
        if (this.connectionWrapperHolder.hasConnection()) {
            this.connectionWrapperHolder.cleanUp();
        }
        this.connectionWrapperHolder = null;
        this.gfManagementService = null;
        this.logger = null;
    }

    public static boolean isGfManagementDisabled() {
        try {
            return Misc.getDistributedSystem().isManagementDisabled();
        }
        catch (DistributedSystemDisconnectedException e) {
            return true;
        }
    }

    public <T> void handleEvent(int eventId, T eventData) {
        try {
            switch (eventId) {
                case 2: {
                    this.handleFabricDBBoot((GemFireStore)eventData);
                    break;
                }
                case 3: {
                    this.handleFabricDBStop((GemFireStore)eventData);
                    break;
                }
                case 5: {
                    this.handleTableCreate((Object[])eventData);
                    break;
                }
                case 9: {
                    this.handleTableAlter((Object[])eventData);
                    break;
                }
                case 6: {
                    this.handleTableDrop((String)eventData);
                    break;
                }
                case 7: {
                    this.handleStatementCreate((GenericStatement)eventData);
                    break;
                }
                case 8: {
                    this.handleStatementInvalidate((GenericStatement)eventData);
                    break;
                }
                case 4: {
                    this.handleEmbedConnectionInit((EmbedConnection)eventData);
                    break;
                }
            }
        }
        catch (Throwable t) {
            this.logWarning("Error occurred while handling management event for " + eventData, t);
        }
    }

    private void logWarning(String message, Throwable t) {
        if (this.logger != null) {
            this.logger.warning(message, t);
        } else {
            SanityManager.DEBUG_PRINT((String)Level.WARNING.toString().toLowerCase(), (String)message, (Throwable)t);
        }
    }

    private void logInfo(String message) {
        this.logInfo(message, null);
    }

    private void logInfo(String message, Throwable t) {
        if (this.logger != null && this.logger.infoEnabled()) {
            this.logger.info(message, t);
        } else {
            SanityManager.DEBUG_PRINT((String)Level.INFO.toString().toLowerCase(), (String)message, (Throwable)t);
        }
    }

    private void logFine(String message, Throwable t) {
        if (this.logger != null && this.logger.fineEnabled()) {
            this.logger.fine(message, t);
        } else {
            SanityManager.DEBUG_PRINT((String)Level.FINE.toString().toLowerCase(), (String)message, (Throwable)t);
        }
    }

    private void handleFabricDBBoot(GemFireStore store) {
        Set<String> serverGroups = InternalManagementService.getMyServerGroups();
        GemFireCacheImpl cache = store.getGemFireCache();
        InternalDistributedMember thisMember = cache.getDistributedSystem().getDistributedMember();
        GfxdMemberMBeanBridge gfxdMemberBeanBridge = new GfxdMemberMBeanBridge(thisMember, serverGroups, this.connectionWrapperHolder);
        MemberMBeanBridge memberMBeanBridge = new MemberMBeanBridge(cache, this.gfManagementService);
        String memberNameOrId = MBeanJMXAdapter.getMemberNameOrId((DistributedMember)thisMember);
        GfxdMBeanAggregator gfxdMBeanAggregator = this.registerGFXDMbeanAggregator(thisMember);
        for (String serverGroup : serverGroups) {
            GfxdMemberMBean gfxdMemberBean = new GfxdMemberMBean(gfxdMemberBeanBridge, memberMBeanBridge);
            ObjectName memberMBeanName = ManagementUtils.getMemberMBeanName(memberNameOrId, serverGroup);
            if (this.gfManagementService.isRegistered(memberMBeanName)) {
                this.unregisterMBean(memberMBeanName);
            }
            ObjectName registeredMBeanName = this.registerMBean(gfxdMemberBean, memberMBeanName);
            this.gfManagementService.federate(registeredMBeanName, GfxdMemberMXBean.class, true);
        }
        this.memberMBeanDataUpdater.addUpdatable(memberNameOrId, gfxdMemberBeanBridge);
        if (this.isManager()) {
            this.handleGFXDMbeansAggregation(gfxdMBeanAggregator);
        }
    }

    public GfxdMBeanAggregator registerGFXDMbeanAggregator(InternalDistributedMember thisMember) {
        GfxdDistributedSystemBridge gfxdDsBridge = new GfxdDistributedSystemBridge(this.gfManagementService, this.connectionWrapperHolder, thisMember);
        GfxdMBeanAggregator gfxdMbeanAggregator = new GfxdMBeanAggregator(gfxdDsBridge);
        this.gfManagementService.addProxyListener((ProxyListener)gfxdMbeanAggregator);
        return gfxdMbeanAggregator;
    }

    private void handleFabricDBStop(GemFireStore store) {
        this.logInfo("Stopping GemFireXD Management/Monitoring ... ");
        Set<String> serverGroups = InternalManagementService.getMyServerGroups();
        GemFireCacheImpl cache = store.getGemFireCache();
        InternalDistributedMember thisMember = cache.getDistributedSystem().getDistributedMember();
        String memberNameOrId = MBeanJMXAdapter.getMemberNameOrId((DistributedMember)thisMember);
        this.memberMBeanDataUpdater.removeUpdatable(memberNameOrId);
        for (String serverGroup : serverGroups) {
            ObjectName memberMBeanName = ManagementUtils.getMemberMBeanName(memberNameOrId, serverGroup);
            this.unregisterMBean(memberMBeanName);
        }
        Set<ObjectName> unregisteredMBeanByPattern = this.unregisterMBeanByPattern(ManagementUtils.getGfxdMBeanPattern());
        this.logInfo("Unregistered GemFireXD MBeans: " + unregisteredMBeanByPattern);
        this.stopService();
    }

    public static Set<String> getMyServerGroups() {
        SortedSet<String> serverGroups = ServerGroupUtils.getMyGroupsSet();
        serverGroups.add("DEFAULT");
        return serverGroups;
    }

    private void handleTableCreate(Object[] data) {
        GemFireContainer container = (GemFireContainer)data[0];
        Set<String> serverGroupsToUse = Collections.EMPTY_SET;
        LocalRegion region = container.getRegion();
        if (region == null || this.hasInternalTableSchema(container)) {
            return;
        }
        RegionMBeanBridge regionMBeanBridge = RegionMBeanBridge.getInstance((Region)region);
        TableMBeanBridge tableMBeanBridge = new TableMBeanBridge(container, this.connectionWrapperHolder, this.getTableDefinition(container.getSchemaName(), container.getTableName()));
        GemFireCacheImpl cache = Misc.getGemFireCache();
        InternalDistributedMember thisMember = cache.getDistributedSystem().getDistributedMember();
        String memberNameOrId = MBeanJMXAdapter.getMemberNameOrId((DistributedMember)thisMember);
        SortedSet<String> tableServerGroups = ServerGroupUtils.getServerGroupsFromContainer(container);
        if (tableServerGroups != null && !tableServerGroups.isEmpty()) {
            serverGroupsToUse = new TreeSet<String>(tableServerGroups);
            Set<String> memberGroupsSet = InternalManagementService.getMyServerGroups();
            serverGroupsToUse.retainAll(memberGroupsSet);
        }
        if (serverGroupsToUse.isEmpty()) {
            serverGroupsToUse = DEFAULT_SERVERGROUP_SET;
        }
        for (String serverGroup : serverGroupsToUse) {
            TableMBean tableMBean = new TableMBean(tableMBeanBridge, regionMBeanBridge);
            ObjectName tableMBeanName = ManagementUtils.getTableMBeanName(serverGroup, memberNameOrId, container.getQualifiedTableName());
            if (this.gfManagementService.isRegistered(tableMBeanName)) {
                this.unregisterMBean(tableMBeanName);
            }
            ObjectName registeredMBeanName = this.registerMBean(tableMBean, tableMBeanName);
            this.gfManagementService.federate(registeredMBeanName, TableMXBean.class, false);
        }
        this.tableMBeanDataUpdater.addUpdatable(tableMBeanBridge.getFullName(), tableMBeanBridge);
    }

    private boolean hasInternalTableSchema(GemFireContainer container) {
        for (String schema : CallbackFactoryProvider.getStoreCallbacks().getInternalTableSchemas()) {
            if (!schema.equalsIgnoreCase(container.getSchemaName())) continue;
            return true;
        }
        return false;
    }

    List<String> getTableDefinition(String parentSchema, String tableName) {
        ArrayList<String> columnList = new ArrayList<String>();
        EmbedConnection conn = this.connectionWrapperHolder.getConnection();
        if (conn == null) {
            return columnList;
        }
        try {
            ColumnDescriptorList allColumns;
            LanguageConnectionContext lcc = conn.getLanguageConnectionContext();
            TransactionController tc = lcc.getTransactionExecute();
            SchemaDescriptor sd = lcc.getDataDictionary().getSchemaDescriptor(parentSchema, tc, true);
            TableDescriptor td = lcc.getDataDictionary().getTableDescriptor(tableName, sd, tc);
            ArrayList<String> primaryKeyList = new ArrayList<String>();
            ReferencedKeyConstraintDescriptor rkcd = td.getPrimaryKey();
            if (rkcd != null && rkcd.getColumnDescriptors().size() > 0) {
                ColumnDescriptorList ls = rkcd.getColumnDescriptors();
                for (ColumnDescriptor cd : ls) {
                    primaryKeyList.add(cd.getColumnName());
                }
            }
            if ((allColumns = td.getColumnDescriptorList()).size() > 0) {
                for (ColumnDescriptor cd : allColumns) {
                    String colName = cd.getColumnName();
                    String type = cd.columnType.getTypeName();
                    int size = cd.columnType.getMaximumWidth();
                    boolean isNullable = cd.isNullable;
                    columnList.add("ColumnName=" + colName + ";  Type=" + type + ";  ColumnSize=" + size + ";  IsNullable=" + (isNullable ? "YES" : "NO") + ";  ColumnDefintion=" + null + "; " + (primaryKeyList.contains(colName) ? "IsPrimaryKey=YES" : ""));
                }
            }
            Misc.getGemFireCache().getCancelCriterion().checkCancelInProgress(null);
        }
        catch (Exception e) {
            this.logger.warning(" Error while fetching table definition for table " + parentSchema + "." + tableName + " Cause: " + e.getMessage() + " Full Exception : " + e, (Throwable)e);
        }
        return columnList;
    }

    private void handleTableAlter(Object[] data) {
        GemFireContainer container = (GemFireContainer)data[0];
        String tableName = container.getQualifiedTableName();
        Set<String> serverGroupsToUse = Collections.EMPTY_SET;
        GemFireCacheImpl cache = Misc.getGemFireCache();
        InternalDistributedMember thisMember = cache.getDistributedSystem().getDistributedMember();
        String memberNameOrId = MBeanJMXAdapter.getMemberNameOrId((DistributedMember)thisMember);
        SortedSet<String> tableServerGroups = ServerGroupUtils.getServerGroupsFromContainer(container);
        if (tableServerGroups != null && !tableServerGroups.isEmpty()) {
            serverGroupsToUse = new TreeSet<String>(tableServerGroups);
            Set<String> memberGroupsSet = InternalManagementService.getMyServerGroups();
            serverGroupsToUse.retainAll(memberGroupsSet);
        }
        if (serverGroupsToUse.isEmpty()) {
            serverGroupsToUse = DEFAULT_SERVERGROUP_SET;
        }
        try {
            for (String serverGroup : serverGroupsToUse) {
                ObjectName tableMBeanName = ManagementUtils.getTableMBeanName(serverGroup, memberNameOrId, tableName);
                TableMXBean mbean = InternalManagementService.getAnyInstance().getMBeanInstance(tableMBeanName, TableMXBean.class);
                if (mbean == null) continue;
                TableMBean tableMbean = (TableMBean)mbean;
                tableMbean.setDefinition(this.getTableDefinition(container.getSchemaName(), container.getTableName()));
            }
        }
        catch (Exception ex) {
            this.logger.warning("handleTableAlter exception == " + ex.getMessage() + " Full Exception = " + ex);
        }
    }

    private void handleTableDrop(String fullTableName) {
        GemFireCacheImpl cache = Misc.getGemFireCache();
        InternalDistributedMember thisMember = cache.getDistributedSystem().getDistributedMember();
        String memberNameOrId = MBeanJMXAdapter.getMemberNameOrId((DistributedMember)thisMember);
        this.tableMBeanDataUpdater.removeUpdatable(fullTableName);
        Set<ObjectName> unregisteredMBeanByPattern = this.unregisterMBeanByPattern(ManagementUtils.getTableMBeanGroupPattern(memberNameOrId, fullTableName));
        this.logFine("Unregistered following MBeans for \"" + fullTableName + "\": " + unregisteredMBeanByPattern, null);
    }

    private void handleEmbedConnectionInit(EmbedConnection connection) {
        GfxdConnectionHolder holder = GfxdConnectionHolder.getHolder();
        GfxdConnectionWrapper connectionWrapper = null;
        try {
            Properties props = new Properties();
            props.setProperty("query-HDFS", Boolean.toString(connection.getLanguageConnectionContext().getQueryHDFS()));
            props.setProperty("route-query", Boolean.toString(connection.getLanguageConnectionContext().isQueryRoutingEnabled()));
            connectionWrapper = holder.createWrapper(connection.getSchema(), GemFireXDUtils.newUUID(), false, props);
        }
        catch (SQLException e) {
            this.logInfo("Error creating EmbedConnection for Management. Reason: " + e.getMessage());
            this.logFine(e.getMessage(), e);
        }
        if (this.connectionWrapperHolder.hasConnection()) {
            this.connectionWrapperHolder.cleanUp();
        }
        this.connectionWrapperHolder.setConnectionWrapper(connectionWrapper);
    }

    private void handleStatementCreate(GenericStatement genericStatement) {
        GemFireCacheImpl cache = Misc.getGemFireCache();
        InternalDistributedMember thisMember = cache.getDistributedSystem().getDistributedMember();
        String memberNameOrId = MBeanJMXAdapter.getMemberNameOrId((DistributedMember)thisMember);
        PreparedStatement preparedStatement = genericStatement.getPreparedStatement();
        String statsId = preparedStatement.getStatementStats().getStatsId();
        ObjectName statementMBeanName = ManagementUtils.getStatementMBeanName(memberNameOrId, statsId);
        Object statementMBeanObject = this.gfManagementService.getJMXAdapter().getMBeanObject(statementMBeanName);
        if (statementMBeanObject != null) {
            StatementMBean statementMBean = (StatementMBean)statementMBeanObject;
            statementMBean.updateBridge(genericStatement);
        } else {
            StatementMBeanBridge statementMBeanBridge = new StatementMBeanBridge(genericStatement);
            StatementMBean statementMbean = new StatementMBean(statementMBeanBridge);
            ObjectName changedMBeanName = this.registerMBean(statementMbean, statementMBeanName);
            this.gfManagementService.federate(changedMBeanName, StatementMXBean.class, false);
        }
    }

    private void handleStatementInvalidate(Statement statement) {
        GemFireCacheImpl cache;
        if (statement instanceof GenericStatement && (cache = Misc.getGemFireCacheNoThrow()) != null) {
            StatementStats statementStats;
            InternalDistributedMember thisMember = cache.getDistributedSystem().getDistributedMember();
            String memberNameOrId = MBeanJMXAdapter.getMemberNameOrId((DistributedMember)thisMember);
            GenericStatement genericStatement = (GenericStatement)statement;
            PreparedStatement preparedStatement = genericStatement.getPreparedStatement();
            if (preparedStatement != null && (statementStats = preparedStatement.getStatementStats()) != null) {
                String statsId = statementStats.getStatsId();
                ObjectName statementMBeanName = ManagementUtils.getStatementMBeanName(memberNameOrId, statsId);
                Object statementMBeanObject = this.gfManagementService.getJMXAdapter().getMBeanObject(statementMBeanName);
                if (statementMBeanObject != null) {
                    StatementMBean statementMBean = (StatementMBean)statementMBeanObject;
                    if (statementMBean.getRefCount() <= 1) {
                        this.unregisterMBean(ManagementUtils.getStatementMBeanName(memberNameOrId, statsId));
                    } else {
                        statementMBean.decRefCount();
                    }
                }
            }
        }
    }

    public long getLastMemoryAnalyticsQueryTime() {
        if (this.tableMBeanDataUpdater != null) {
            return ((TableMBeanDataUpdater)this.tableMBeanDataUpdater).lastMemoryAnalyticsQueryTime();
        }
        return -2L;
    }

    public int getUpdateSchedulerRate() {
        if (this.updateScheduler != null) {
            return this.updateScheduler.getUpdateRate();
        }
        return -2;
    }

    public GfxdMemberMXBean getMemberMXBean() {
        return (GfxdMemberMXBean)this.gfManagementService.getMemberMXBean();
    }

    public LocalManager getLocalManager() {
        return this.gfManagementService.getLocalManager();
    }

    public <T> ObjectName registerMBean(T bean, ObjectName objectName) {
        if (bean instanceof Cleanable) {
            this.cleanables.put(objectName, (Cleanable)bean);
        }
        return this.gfManagementService.registerGfxdInternalMBean(bean, objectName);
    }

    public void unregisterMBean(ObjectName objectName) {
        this.gfManagementService.unregisterMBean(objectName);
        Cleanable cleanable = this.cleanables.get(objectName);
        if (cleanable != null) {
            cleanable.cleanUp();
        }
    }

    public Set<ObjectName> unregisterMBeanByPattern(ObjectName objectNamePattern) {
        Set unregisterdMBeans = this.gfManagementService.unregisterMBeanByPattern(objectNamePattern);
        for (ObjectName objectName : unregisterdMBeans) {
            Cleanable cleanable = this.cleanables.get(objectName);
            if (cleanable == null) continue;
            cleanable.cleanUp();
        }
        return unregisterdMBeans;
    }

    public <T> T getMBeanInstance(ObjectName objectName, Class<T> interfaceClass) {
        return (T)this.gfManagementService.getMBeanInstance(objectName, interfaceClass);
    }

    public boolean isManager() {
        return this.gfManagementService.isManager();
    }

    public void startManager() {
        this.gfManagementService.startManager();
    }

    public void stopManager() {
        if (this.gfManagementService.isManager()) {
            try {
                this.gfManagementService.stopManager();
            }
            catch (ManagementException managementException) {
                // empty catch block
            }
        }
    }

    public void afterCreateProxy(ObjectName objectName, Class<?> interfaceClass, Object proxyObject, FederationComponent newVal) {
        this.gfManagementService.afterCreateProxy(objectName, interfaceClass, proxyObject, newVal);
    }

    public void afterRemoveProxy(ObjectName objectName, Class<?> interfaceClass, Object proxyObject, FederationComponent oldVal) {
        this.gfManagementService.afterRemoveProxy(objectName, interfaceClass, proxyObject, oldVal);
    }

    public void afterUpdateProxy(ObjectName objectName, Class<?> interfaceClass, Object proxyObject, FederationComponent newVal, FederationComponent oldVal) {
        this.gfManagementService.afterUpdateProxy(objectName, interfaceClass, proxyObject, newVal, oldVal);
    }

    private void handleGFXDMbeansAggregation(GfxdMBeanAggregator gfxdMBeanAggregator) {
        try {
            Map gemFireXDMBeansHolder = this.gfManagementService.getGemFireXDMBeansHolder();
            if (gemFireXDMBeansHolder.size() > 0) {
                String memberNameOrId = MBeanJMXAdapter.getMemberNameOrId((DistributedMember)Misc.getGemFireCache().getDistributedSystem().getDistributedMember());
                ObjectName thisMemberName = ManagementUtils.getMemberMBeanName(memberNameOrId, "DEFAULT");
                for (SystemManagementService.GemFireXDMBean gemFireXDMBean : gemFireXDMBeansHolder.values()) {
                    try {
                        if (gemFireXDMBean.objectName.equals(thisMemberName)) continue;
                        gfxdMBeanAggregator.afterCreateProxy(gemFireXDMBean.objectName, gemFireXDMBean.interfaceClass, gemFireXDMBean.proxyObject, gemFireXDMBean.newVal);
                    }
                    catch (Exception e) {
                        this.logger.warning("Error in handleGFXDMbeansAggregation for:  objectName=" + gemFireXDMBean.objectName + " thisMemberName=" + thisMemberName + " Exception cause = " + e.getCause() + " Exception = " + e);
                    }
                }
                this.gfManagementService.clearGemFireXDMBeans();
            } else {
                this.logger.info("In restart no GFXDMBeans to be aggregated for " + MBeanJMXAdapter.getMemberNameOrId((DistributedMember)Misc.getGemFireCache().getDistributedSystem().getDistributedMember()));
            }
        }
        catch (Exception ex) {
            this.logger.warning("Exception in handleGFXDMbeansAggregation, cause=" + ex.getCause() + " Exception=" + ex);
        }
    }

    public static class ConnectionWrapperHolder
    implements Cleanable {
        private GfxdConnectionWrapper wrapper;

        private ConnectionWrapperHolder() {
            this((GfxdConnectionWrapper)null);
        }

        private ConnectionWrapperHolder(GfxdConnectionWrapper wrapper) {
            this.wrapper = wrapper;
        }

        @Override
        public void cleanUp() {
            if (this.hasConnection()) {
                this.wrapper.close();
            }
            this.wrapper = null;
        }

        public boolean hasConnection() {
            return this.getConnection() != null;
        }

        public EmbedConnection getConnection() {
            GfxdConnectionWrapper wrapper = this.wrapper;
            return wrapper != null ? wrapper.getConnectionOrNull() : null;
        }

        public void setConnectionWrapper(GfxdConnectionWrapper wrapper) {
            this.wrapper = wrapper;
        }

        public String toString() {
            return "ConnectionWrapperHolder [hasConnection()=" + this.hasConnection() + "]";
        }
    }
}

