/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.DVDIOUtil;
import com.pivotal.gemfirexd.internal.engine.distributed.FunctionExecutionException;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.SnappyResultHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.message.BitSetSet;
import com.pivotal.gemfirexd.internal.engine.distributed.message.MemberExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDecimal;
import com.pivotal.gemfirexd.internal.impl.sql.GenericParameterValueSet;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.snappy.CallbackFactoryProvider;
import com.pivotal.gemfirexd.internal.snappy.LeadNodeExecutionContext;
import com.pivotal.gemfirexd.internal.snappy.SparkSQLExecute;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Set;

public final class LeadNodeExecutorMsg
extends MemberExecutorMessage<Object> {
    private String sql;
    private LeadNodeExecutionContext ctx;
    private transient SparkSQLExecute exec;
    private String schema;
    protected ParameterValueSet pvs;
    private transient byte[] pvsData;
    private transient int[] pvsTypes;
    private transient byte leadNodeFlags;
    private static final byte IS_PREPARED_STATEMENT = 1;
    private static final byte IS_PREPARED_PHASE = 2;
    private static final byte IS_UPDATE_OR_DELETE = 4;

    public LeadNodeExecutorMsg(String sql, String schema, LeadNodeExecutionContext ctx, GfxdResultCollector<Object> rc, ParameterValueSet inpvs, boolean isPreparedStatement, boolean isPreparedPhase, Boolean isUpdateOrDelete) {
        super(rc, (TXStateInterface)null, false, true);
        this.schema = schema;
        this.sql = sql;
        this.ctx = ctx;
        this.pvs = inpvs;
        if (isPreparedStatement) {
            this.leadNodeFlags = (byte)(this.leadNodeFlags | 1);
        }
        if (isPreparedPhase) {
            this.leadNodeFlags = (byte)(this.leadNodeFlags | 2);
        }
        if (isUpdateOrDelete.booleanValue()) {
            this.leadNodeFlags = (byte)(this.leadNodeFlags | 4);
        }
    }

    public LeadNodeExecutorMsg() {
        super(true);
    }

    public boolean isPreparedStatement() {
        return (this.leadNodeFlags & 1) != 0;
    }

    public boolean isPreparedPhase() {
        return (this.leadNodeFlags & 2) != 0;
    }

    public boolean isUpdateOrDelete() {
        return (this.leadNodeFlags & 4) != 0;
    }

    @Override
    public Set<DistributedMember> getMembers() {
        return Misc.getLeadNode();
    }

    @Override
    public void postExecutionCallback() {
    }

    @Override
    public boolean isHA() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    protected void execute() throws Exception {
        try {
            if (this.isPreparedStatement() && !this.isPreparedPhase()) {
                this.getParams();
            }
            if (GemFireXDUtils.TraceQuery) {
                StringBuilder str = new StringBuilder();
                this.appendFields(str);
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)("LeadNodeExecutorMsg.execute: Got sql = " + str.toString()));
            }
            InternalDistributedMember m = this.getSenderForReply();
            Version v = m.getVersionObject();
            this.exec = CallbackFactoryProvider.getClusterCallbacks().getSQLExecute(this.sql, this.schema, this.ctx, v, this.isPreparedStatement(), this.isPreparedPhase(), this.pvs);
            SnappyResultHolder srh = new SnappyResultHolder(this.exec, this.isUpdateOrDelete());
            srh.prepareSend(this);
            this.lastResultSent = true;
            this.endMessage();
            if (GemFireXDUtils.TraceQuery) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"LeadNodeExecutorMsg.execute: Sent Last result ");
            }
        }
        catch (Exception ex) {
            throw LeadNodeExecutorMsg.getExceptionToSendToServer(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Exception getExceptionToSendToServer(Exception ex) {
        boolean wrapExcepton = false;
        try (HeapDataOutputStream hdos = null;){
            hdos = new HeapDataOutputStream();
            DataSerializer.writeObject((Object)ex, (DataOutput)hdos);
        }
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            if (cause.getClass().getName().contains("AnalysisException")) {
                return StandardException.newException("38000", !wrapExcepton ? cause : new SparkExceptionWrapper(cause), (Object)cause.getMessage());
            }
            if (cause.getClass().getName().contains("apache.spark.storage")) {
                return StandardException.newException("XSDA4.S", !wrapExcepton ? cause : new SparkExceptionWrapper(cause), (Object)cause.getMessage());
            }
            if (!cause.getClass().getName().contains("apache.spark.sql")) continue;
            for (Throwable nestedCause = cause.getCause(); nestedCause != null; nestedCause = nestedCause.getCause()) {
                if (!nestedCause.getClass().getName().contains("ErrorLimitExceededException")) continue;
                return StandardException.newException("38000", !wrapExcepton ? nestedCause : new SparkExceptionWrapper(nestedCause), (Object)nestedCause.getMessage());
            }
            return StandardException.newException("38000", !wrapExcepton ? cause : new SparkExceptionWrapper(cause), (Object)cause.getMessage());
        }
        return ex;
    }

    @Override
    protected void executeFunction(boolean enableStreaming) throws StandardException, SQLException {
        try {
            super.executeFunction(enableStreaming);
        }
        catch (RuntimeException re) {
            throw LeadNodeExecutorMsg.handleLeadNodeException(re);
        }
    }

    public static RuntimeException handleLeadNodeException(RuntimeException re) {
        DiskAccessException dae;
        RegionDestroyedException rde;
        Throwable cause = re;
        if (re instanceof GemFireXDRuntimeException || re instanceof FunctionException || re instanceof FunctionExecutionException || re instanceof ReplyException) {
            cause = re.getCause();
        }
        if (cause instanceof RegionDestroyedException && (rde = (RegionDestroyedException)cause).isRemote()) {
            rde.setNotRemote();
        }
        if (cause instanceof DiskAccessException && (dae = (DiskAccessException)cause).isRemote()) {
            dae.setNotRemote();
        }
        return re;
    }

    @Override
    protected LeadNodeExecutorMsg clone() {
        LeadNodeExecutorMsg msg = new LeadNodeExecutorMsg(this.sql, this.schema, this.ctx, (GfxdResultCollector)this.userCollector, this.pvs, this.isPreparedStatement(), this.isPreparedPhase(), this.isUpdateOrDelete());
        msg.exec = this.exec;
        return msg;
    }

    @Override
    public byte getGfxdID() {
        return 56;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.sql = DataSerializer.readString((DataInput)in);
        this.schema = DataSerializer.readString((DataInput)in);
        this.ctx = (LeadNodeExecutionContext)DataSerializer.readObject((DataInput)in);
        this.leadNodeFlags = DataSerializer.readByte((DataInput)in);
        if (this.isPreparedStatement() && !this.isPreparedPhase()) {
            this.pvsTypes = DataSerializer.readIntArray((DataInput)in);
            this.pvsData = DataSerializer.readByteArray((DataInput)in);
        }
    }

    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString((String)this.sql, (DataOutput)out);
        DataSerializer.writeString((String)this.schema, (DataOutput)out);
        DataSerializer.writeObject((Object)this.ctx, (DataOutput)out);
        DataSerializer.writeByte((Byte)this.leadNodeFlags, (DataOutput)out);
        if (this.isPreparedStatement() && !this.isPreparedPhase()) {
            int paramCount = this.pvs != null ? this.pvs.getParameterCount() : 0;
            int numEightColGroups = BitSetSet.udiv8(paramCount);
            int numPartialCols = BitSetSet.umod8(paramCount);
            try {
                if (this.pvsTypes == null) {
                    this.pvsTypes = new int[paramCount * 3 + 1];
                    this.pvsTypes[0] = paramCount;
                    for (int i = 0; i < paramCount; ++i) {
                        DataValueDescriptor dvd = this.pvs.getParameter(i);
                        this.pvsTypes[i * 3 + 1] = dvd.getTypeFormatId();
                        if (dvd instanceof SQLDecimal) {
                            this.pvsTypes[i * 3 + 2] = ((SQLDecimal)dvd).getDecimalValuePrecision();
                            this.pvsTypes[i * 3 + 3] = ((SQLDecimal)dvd).getDecimalValueScale();
                            continue;
                        }
                        this.pvsTypes[i * 3 + 2] = -1;
                        this.pvsTypes[i * 3 + 3] = -1;
                    }
                }
                DataSerializer.writeIntArray((int[])this.pvsTypes, (DataOutput)out);
                if (paramCount > 0) {
                    HeapDataOutputStream hdos = new HeapDataOutputStream();
                    DVDIOUtil.writeParameterValueSet(this.pvs, numEightColGroups, numPartialCols, (DataOutput)hdos);
                    InternalDataSerializer.writeArrayLength((int)hdos.size(), (DataOutput)out);
                    hdos.sendTo(out);
                } else {
                    InternalDataSerializer.writeArrayLength((int)-1, (DataOutput)out);
                }
            }
            catch (StandardException ex) {
                throw GemFireXDRuntimeException.newRuntimeException("unexpected exception in writing parameters", ex);
            }
        }
    }

    @Override
    public void appendFields(StringBuilder sb) {
        sb.append("sql: " + this.sql);
        sb.append(" ;schema: " + this.schema);
        sb.append(" ;isUpdateOrDelete=").append(this.isUpdateOrDelete());
        sb.append(" ;isPreparedStatement=").append(this.isPreparedStatement());
        sb.append(" ;isPreparedPhase=").append(this.isPreparedPhase());
        sb.append(" ;pvs=").append(this.pvs);
        sb.append(" ;pvsData=").append(Arrays.toString(this.pvsData));
    }

    private void readStatementPVS(ByteArrayDataInput in) throws IOException, SQLException, ClassNotFoundException, StandardException {
        int numberOfParameters = this.pvsTypes[0];
        DataTypeDescriptor[] types = new DataTypeDescriptor[numberOfParameters];
        for (int i = 0; i < numberOfParameters; ++i) {
            int index = i * 3 + 1;
            SnappyResultHolder.getNewNullDVD(this.pvsTypes[index], i, types, this.pvsTypes[index + 1], this.pvsTypes[index + 2], true);
        }
        this.pvs = new GenericParameterValueSet(null, numberOfParameters, false);
        this.pvs.initialize(types);
        int paramCount = this.pvs.getParameterCount();
        int numEightColGroups = BitSetSet.udiv8(paramCount);
        int numPartialCols = BitSetSet.umod8(paramCount);
        DVDIOUtil.readParameterValueSet(this.pvs, in, numEightColGroups, numPartialCols);
    }

    public ParameterValueSet getParams() throws Exception {
        if (this.pvsData != null) {
            ByteArrayDataInput dis = new ByteArrayDataInput();
            dis.initialize(this.pvsData, null);
            this.readStatementPVS(dis);
        }
        return this.pvs;
    }

    @Override
    public void reset() {
        super.reset();
        this.schema = null;
        this.sql = null;
        this.ctx = null;
        this.leadNodeFlags = 0;
        this.pvsData = null;
        this.pvsTypes = null;
        this.pvs = null;
    }

    private static class SparkExceptionWrapper
    extends Exception {
        public SparkExceptionWrapper(Throwable ex) {
            super(ex.getClass().getName() + ": " + ex.getMessage(), ex.getCause());
            this.setStackTrace(ex.getStackTrace());
        }
    }
}

