/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.concurrent.CustomEntryConcurrentHashMap;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public final class GfxdConnectionHolder
implements MembershipListener {
    private final CustomEntryConcurrentHashMap<Long, GfxdConnectionWrapper> idToConnMap = new CustomEntryConcurrentHashMap();
    private static final GfxdConnectionHolder singleton = new GfxdConnectionHolder();

    private GfxdConnectionHolder() {
    }

    public static GfxdConnectionHolder getHolder() {
        return singleton;
    }

    public GfxdConnectionWrapper createWrapper(String defaultSchema, long connId, boolean remoteDDL, Properties props) throws SQLException {
        GfxdConnectionWrapper wrapper = null;
        assert (connId != -1L) : "unexpected uninitialized connection";
        boolean isCached = connId != -2L;
        Long id = null;
        if (isCached) {
            id = connId;
            wrapper = this.getWrapper(id, false);
        }
        if (wrapper == null) {
            wrapper = new GfxdConnectionWrapper(defaultSchema, connId, isCached, true, remoteDDL, props);
            if (isCached) {
                assert (id != null);
                GfxdConnectionWrapper old = (GfxdConnectionWrapper)this.idToConnMap.putIfAbsent((Object)id, (Object)wrapper);
                if (old != null) {
                    wrapper.close();
                    wrapper = old;
                }
            }
        } else {
            wrapper.setDefaultSchema(defaultSchema);
        }
        return wrapper;
    }

    public GfxdConnectionWrapper getExistingWrapper(Long connId) {
        return this.getWrapper(connId, true);
    }

    public GfxdConnectionWrapper getWrapper(Long connId, boolean removeClosed) {
        assert (connId != -1L) : "unexpected uninitialized connection requested";
        if (connId == -2L) {
            return null;
        }
        GfxdConnectionWrapper wrapper = (GfxdConnectionWrapper)this.idToConnMap.get((Object)connId);
        return wrapper;
    }

    public static GfxdConnectionWrapper getOrCreateWrapper(String defaultSchema, long connId, boolean remoteDDL, Properties props) throws SQLException {
        return GfxdConnectionHolder.getHolder().createWrapper(defaultSchema, connId, remoteDDL, props);
    }

    public void clear() {
        for (Long connId : this.idToConnMap.keySet()) {
            GfxdConnectionWrapper wrapper = this.removeWrapper(connId);
            if (wrapper == null) continue;
            wrapper.close();
        }
        this.idToConnMap.clear();
    }

    public final GfxdConnectionWrapper removeWrapper(Long connId) {
        return (GfxdConnectionWrapper)this.idToConnMap.remove((Object)connId);
    }

    public void memberJoined(InternalDistributedMember id) {
    }

    public void memberDeparted(InternalDistributedMember id, boolean crashed) {
        for (Long connId : this.idToConnMap.keySet()) {
            GfxdConnectionWrapper wrapper;
            if (!GemFireXDUtils.getDistributedMemberFromUUID(connId).equals(id) || (wrapper = this.removeWrapper(connId)) == null) continue;
            wrapper.close();
        }
    }

    public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected) {
    }

    public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
    }

    public ConcurrentMap<Long, GfxdConnectionWrapper> getWrapperMap() {
        return this.idToConnMap;
    }
}

