/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl.wan.messages;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.AbstractOperationMessage;
import com.gemstone.gemfire.internal.cache.Conflatable;
import com.gemstone.gemfire.internal.cache.EventID;
import com.pivotal.gemfirexd.internal.engine.ddl.GfxdDDLRegionQueue;
import com.pivotal.gemfirexd.internal.engine.ddl.ReplayableConflatable;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class AbstractGfxdReplayableMessage
extends GfxdMessage
implements ReplayableConflatable {
    protected long replayKey;
    protected boolean skipInLocalExecution;
    protected boolean executing;

    protected AbstractGfxdReplayableMessage() {
    }

    protected AbstractGfxdReplayableMessage(boolean createMsg) {
        GfxdDDLRegionQueue ddlQ;
        GemFireStore store = GemFireStore.getBootingInstance();
        this.skipInLocalExecution = store != null && (ddlQ = store.getDDLQueueNoThrow()) != null && (!ddlQ.isInitialized() || !store.initialDDLReplayInProgress() && !store.initialDDLReplayInProgress());
    }

    public void setReplayKey(long replayKey) {
        this.replayKey = replayKey;
    }

    @Override
    public boolean skipInLocalExecution() {
        return this.skipInLocalExecution;
    }

    @Override
    public void markExecuting() {
        this.executing = true;
    }

    @Override
    public boolean isExecuting() {
        return this.executing;
    }

    @Override
    protected void processMessage(DistributionManager dm) {
        block9: {
            if (!GemFireXDUtils.getMyVMKind().isAccessorOrStore()) {
                if (GemFireXDUtils.TraceDDLQueue) {
                    SanityManager.DEBUG_PRINT((String)"TraceDDLQueue", (String)(this.toString() + ": Skipping execution of system procedure on " + GemFireXDUtils.getMyVMKind() + " JVM"));
                }
                return;
            }
            if (AbstractGfxdReplayableMessage.isOKToSkip(this.replayKey)) {
                if (this.processorId > 0) {
                    ReplyMessage.send((InternalDistributedMember)this.getSender(), (int)this.processorId, null, (ReplySender)dm, (AbstractOperationMessage)this);
                }
                return;
            }
            LogWriter logger = dm.getLoggerI18n().convertToLogWriter();
            if (logger.infoEnabled()) {
                logger.info("AbstractGfxdReplayableMessage: Executing with fields as: " + this.toString());
            }
            try {
                this.execute();
                if (logger.infoEnabled()) {
                    logger.info("AbstractGfxdReplayableMessage: Successfully executed message with fields: " + this.toString());
                }
            }
            catch (StandardException ex) {
                if (logger.severeEnabled()) {
                    logger.severe("AbstractGfxdReplayableMessage: SQL exception in executing message with fields as " + this.toString(), (Throwable)ex);
                }
                if (this.processorId <= 0) break block9;
                throw new ReplyException("Unexpected SQLException on member " + dm.getDistributionManagerId(), (Throwable)ex);
            }
        }
    }

    @Override
    protected final void sendReply(ReplyException ex, DistributionManager dm) {
        ReplyMessage.send((InternalDistributedMember)this.getSender(), (int)this.processorId, (ReplyException)ex, (ReplySender)dm, (AbstractOperationMessage)this);
    }

    @Override
    protected boolean waitForNodeInitialization() {
        return false;
    }

    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writePrimitiveLong((long)this.replayKey, (DataOutput)out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.replayKey = DataSerializer.readPrimitiveLong((DataInput)in);
    }

    @Override
    public void appendFields(StringBuilder sb) {
        super.appendFields(sb);
        sb.append("; replayKey=").append(this.replayKey);
    }

    public void setLatestValue(Object value) {
        throw new AssertionError((Object)(this.getShortClassName() + "#setLatestValue: not expected to be invoked"));
    }

    public EventID getEventId() {
        throw new AssertionError((Object)(this.getShortClassName() + "#getEventId: not expected to be invoked"));
    }

    public boolean shouldBeMerged() {
        return false;
    }

    public boolean merge(Conflatable existing) {
        throw new AssertionError((Object)"not expected to be invoked");
    }

    public abstract void execute() throws StandardException;

    public abstract String getSQLStatement() throws StandardException;

    public String getSchemaName() {
        return null;
    }
}

