/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.callbacks;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.ManagerLogWriter;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.pivotal.gemfirexd.callbacks.AsyncEventHelper;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.callbacks.TableMetaData;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventErrorLogger {
    protected String errorFile = "failedevents.xml";
    protected OutputStream errorStream;
    protected XMLStreamWriter errorWriter;
    protected static final String ERROR_ENTRIES_SUFFIX = "_entries";
    protected static final String ERR_XML_ROOT = "failures";
    protected static final String ERR_XML_ENTRIES_ENTITY = "errorEntries";
    protected static final String ERR_XML_FAILURE = "failure";
    protected static final String ERR_XML_SQL = "sql";
    protected static final String ERR_XML_PARAMS = "parameters";
    protected static final String ERR_XML_PARAM = "param";
    protected static final String ERR_XML_ATTR_TYPE = "jtype";
    protected static final String ERR_XML_ATTR_NULL = "isnull";
    protected static final String ERR_XML_EXCEPTION = "exception";
    protected static final String ERR_XML_SQLSTATE = "sqlstate";
    protected static final String ERR_XML_ERRCODE = "errorcode";
    protected static final String ERR_XML_EX_MESSAGE = "message";
    protected static final String ERR_XML_EX_CLASS = "class";
    protected static final String ERR_XML_EX_STACK = "stack";
    protected final Logger logger2 = LoggerFactory.getLogger((String)"com.pivotal.gemfirexd");
    protected static final String Gfxd_EVENT_ERROR_LOGGER = "GfxdEventErrorLogger::init: could not rename '%s' to '%s'.";

    public EventErrorLogger(String errorFileName) {
        this.errorFile = errorFileName;
    }

    public String rollFileIfRequired(String logfile, Logger logger) {
        File logFile = new File(logfile);
        if (logFile.exists()) {
            File oldMain = ManagerLogWriter.getLogNameForOldMainLog((File)logFile, (boolean)false);
            if (!logFile.renameTo(oldMain)) {
                logfile = oldMain.getPath();
                if (logger.isWarnEnabled()) {
                    logger.info(Gfxd_EVENT_ERROR_LOGGER, (Object)logFile, (Object)oldMain);
                }
            } else {
                logfile = logFile.getPath();
            }
        }
        return logfile;
    }

    protected synchronized void initErrorFile() throws Exception {
        if (this.errorFile != null && this.errorWriter == null) {
            int dotIndex = this.errorFile.lastIndexOf(46);
            if (dotIndex <= 0 || !"xml".equalsIgnoreCase(this.errorFile.substring(dotIndex + 1))) {
                this.errorFile = this.errorFile.concat(".xml");
            }
            String errorFileName = this.errorFile.substring(0, this.errorFile.length() - 4);
            String errorEntriesFile = errorFileName + ERROR_ENTRIES_SUFFIX + ".xml";
            String errorRootFile = this.errorFile;
            this.errorFile = errorEntriesFile;
            errorEntriesFile = this.rollFileIfRequired(errorEntriesFile, this.logger2);
            FileOutputStream xmlStream = new FileOutputStream(errorRootFile);
            String encoding = "UTF-8";
            XMLOutputFactory xmlFactory = XMLOutputFactory.newFactory();
            XMLStreamWriter xmlWriter = xmlFactory.createXMLStreamWriter(xmlStream, "UTF-8");
            xmlWriter.writeStartDocument("UTF-8", "1.0");
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeDTD("<!DOCTYPE staticinc [ <!ENTITY errorEntries SYSTEM \"" + new File(errorEntriesFile).getName() + "\"> ]>");
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeStartElement(ERR_XML_ROOT);
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeEntityRef(ERR_XML_ENTRIES_ENTITY);
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeEndElement();
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeEndDocument();
            xmlWriter.flush();
            xmlWriter.close();
            xmlStream.flush();
            xmlStream.close();
            this.errorStream = new BufferedOutputStream(new FileOutputStream(this.errorFile));
            if (xmlFactory.isPropertySupported("com.ctc.wstx.outputValidateStructure")) {
                xmlFactory.setProperty("com.ctc.wstx.outputValidateStructure", Boolean.FALSE);
            }
            this.errorWriter = xmlFactory.createXMLStreamWriter(this.errorStream, "UTF-8");
        }
    }

    public void logError(Event event, Exception e) throws Exception {
        int[] paramTypes;
        List<Object> paramsBatch;
        String dmlString;
        this.initErrorFile();
        int indentStep = 2;
        int indent = 2;
        this.errorWriter.writeStartElement(ERR_XML_FAILURE);
        String tableName = event.getTableName();
        switch (event.getType()) {
            case AFTER_INSERT: {
                int jdbcType;
                ResultSetMetaData metadata = event.getResultSetMetaData();
                int numColumns = metadata.getColumnCount();
                dmlString = AsyncEventHelper.getInsertString(tableName, (TableMetaData)metadata, false);
                String[] params = new String[numColumns];
                paramsBatch = Collections.singletonList(params);
                paramTypes = new int[numColumns];
                ResultSet rows = event.getNewRowsAsResultSet();
                for (int colIdx = 1; colIdx <= numColumns; ++colIdx) {
                    jdbcType = metadata.getColumnType(colIdx);
                    params[colIdx - 1] = EventErrorLogger.getColumnAsString(rows, colIdx, jdbcType);
                    paramTypes[colIdx - 1] = jdbcType;
                }
                break;
            }
            case AFTER_UPDATE: {
                int colIdx;
                int jdbcType;
                ResultSet rows = event.getNewRowsAsResultSet();
                ResultSetMetaData metadata = rows.getMetaData();
                int numUpdatedCols = metadata.getColumnCount();
                ResultSet pkResultSet = event.getPrimaryKeysAsResultSet();
                ResultSetMetaData pkMetaData = pkResultSet.getMetaData();
                int n = pkMetaData.getColumnCount();
                int numColumns = numUpdatedCols + n;
                dmlString = AsyncEventHelper.getUpdateString(tableName, pkMetaData, metadata);
                String[] params = new String[numColumns];
                paramsBatch = Collections.singletonList(params);
                paramTypes = new int[numColumns];
                for (colIdx = 1; colIdx <= numUpdatedCols; ++colIdx) {
                    jdbcType = metadata.getColumnType(colIdx);
                    params[colIdx - 1] = EventErrorLogger.getColumnAsString(rows, colIdx, jdbcType);
                    paramTypes[colIdx - 1] = jdbcType;
                }
                for (colIdx = 1; colIdx <= n; ++colIdx) {
                    jdbcType = pkMetaData.getColumnType(colIdx);
                    params[colIdx + numUpdatedCols - 1] = EventErrorLogger.getColumnAsString(pkResultSet, colIdx, jdbcType);
                    paramTypes[colIdx + numUpdatedCols - 1] = jdbcType;
                }
                break;
            }
            case AFTER_DELETE: {
                int colIdx;
                int jdbcType;
                ResultSet pkResultSet = event.getPrimaryKeysAsResultSet();
                ResultSetMetaData pkMetaData = pkResultSet.getMetaData();
                dmlString = AsyncEventHelper.getDeleteString(tableName, pkMetaData);
                int numColumns = pkMetaData.getColumnCount();
                String[] params = new String[numColumns];
                paramsBatch = Collections.singletonList(params);
                paramTypes = new int[numColumns];
                for (colIdx = 1; colIdx <= numColumns; ++colIdx) {
                    jdbcType = pkMetaData.getColumnType(colIdx);
                    params[colIdx - 1] = EventErrorLogger.getColumnAsString(pkResultSet, colIdx, jdbcType);
                    paramTypes[colIdx - 1] = jdbcType;
                }
                break;
            }
            case BULK_DML: {
                int colIdx;
                int jdbcType;
                ResultSet rows;
                int numColumns;
                ResultSetMetaData metadata;
                dmlString = event.getDMLString();
                paramsBatch = null;
                paramTypes = null;
                if (!event.hasParameters() || (rows = event.getNewRowsAsResultSet()) == null || (numColumns = (metadata = rows.getMetaData()).getColumnCount()) <= 0) break;
                String[] params = new String[numColumns];
                paramsBatch = Collections.singletonList(params);
                paramTypes = new int[numColumns];
                for (colIdx = 1; colIdx <= numColumns; ++colIdx) {
                    jdbcType = metadata.getColumnType(colIdx);
                    params[colIdx - 1] = EventErrorLogger.getColumnAsString(rows, colIdx, jdbcType);
                    paramTypes[colIdx - 1] = jdbcType;
                }
                break;
            }
            case BULK_INSERT: {
                int jdbcType;
                String[] params;
                dmlString = event.getDMLString();
                ResultSet rows = event.getNewRowsAsResultSet();
                ResultSetMetaData metadata = rows.getMetaData();
                int numColumns = metadata.getColumnCount();
                paramsBatch = new ArrayList();
                paramTypes = new int[numColumns];
                boolean firstIter = true;
                while (rows.next()) {
                    params = new String[numColumns];
                    paramsBatch.add(params);
                    for (int colIdx = 1; colIdx <= numColumns; ++colIdx) {
                        if (firstIter) {
                            paramTypes[colIdx - 1] = jdbcType = metadata.getColumnType(colIdx);
                        } else {
                            jdbcType = paramTypes[colIdx - 1];
                        }
                        params[colIdx - 1] = EventErrorLogger.getColumnAsString(rows, colIdx, jdbcType);
                    }
                    firstIter = false;
                }
                break;
            }
            default: {
                dmlString = event.toString();
                paramsBatch = null;
                paramTypes = null;
            }
        }
        this.indentInErrorXML(indent);
        this.errorWriter.writeStartElement(ERR_XML_SQL);
        this.errorWriter.writeCharacters(dmlString);
        this.errorWriter.writeEndElement();
        if (paramsBatch != null) {
            for (String[] stringArray : paramsBatch) {
                this.indentInErrorXML(indent);
                this.errorWriter.writeStartElement(ERR_XML_PARAMS);
                indent += 2;
                for (int i = 0; i < stringArray.length; ++i) {
                    this.indentInErrorXML(indent);
                    this.errorWriter.writeStartElement(ERR_XML_PARAM);
                    this.errorWriter.writeAttribute(ERR_XML_ATTR_TYPE, Integer.toString(paramTypes[i]));
                    if (stringArray[i] != null) {
                        this.errorWriter.writeCharacters(stringArray[i]);
                    } else {
                        this.errorWriter.writeAttribute(ERR_XML_ATTR_NULL, "true");
                    }
                    this.errorWriter.writeEndElement();
                }
                this.indentInErrorXML(indent -= 2);
                this.errorWriter.writeEndElement();
            }
        }
        this.writeExceptionInErrorXML(e, indent, 2, true);
        this.errorWriter.writeCharacters("\n");
        this.errorWriter.writeEndElement();
        this.errorWriter.writeCharacters("\n");
        this.errorWriter.flush();
        this.errorStream.flush();
    }

    protected void indentInErrorXML(int level) throws XMLStreamException {
        this.errorWriter.writeCharacters("\n");
        char[] indent = new char[level];
        for (int idx = 0; idx < level; ++idx) {
            indent[idx] = 32;
        }
        this.errorWriter.writeCharacters(indent, 0, indent.length);
    }

    protected void writeExceptionInErrorXML(Exception sqle, int indent, int indentStep, boolean printStack) throws XMLStreamException {
        this.indentInErrorXML(indent);
        this.errorWriter.writeStartElement(ERR_XML_EXCEPTION);
        this.writeObjectInErrorXML(ERR_XML_SQLSTATE, sqle instanceof SQLException ? ((SQLException)sqle).getSQLState() : "", indent += indentStep);
        this.writeObjectInErrorXML(ERR_XML_ERRCODE, sqle instanceof SQLException ? Integer.valueOf(((SQLException)sqle).getErrorCode()) : "", indent);
        this.writeObjectInErrorXML(ERR_XML_EX_MESSAGE, sqle.getMessage(), indent);
        if (printStack) {
            StringBuilder sb = new StringBuilder();
            ClientSharedUtils.getStackTrace((Throwable)sqle, (StringBuilder)sb, null);
            this.writeObjectInErrorXML(ERR_XML_EX_STACK, sb.toString(), indent);
        } else {
            this.writeObjectInErrorXML(ERR_XML_EX_STACK, sqle.toString(), indent);
        }
        if (sqle instanceof SQLException && (sqle = ((SQLException)sqle).getNextException()) != null) {
            this.writeExceptionInErrorXML(sqle, indent, indentStep, false);
        }
        this.indentInErrorXML(indent -= indentStep);
        this.errorWriter.writeEndElement();
    }

    protected void writeObjectInErrorXML(String tag, Object o, int indent) throws XMLStreamException {
        this.indentInErrorXML(indent);
        if (o != null) {
            this.errorWriter.writeStartElement(tag);
            this.errorWriter.writeCharacters(o.toString());
            this.errorWriter.writeEndElement();
        } else {
            this.errorWriter.writeEmptyElement(tag);
        }
    }

    public static final String getColumnAsString(ResultSet rs, int columnIndex, int jdbcType) throws SQLException {
        switch (jdbcType) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                byte[] bytes = rs.getBytes(columnIndex);
                if (bytes != null) {
                    return ClientSharedUtils.toHexString((byte[])bytes, (int)0, (int)bytes.length);
                }
                return null;
            }
            case 2000: {
                Object v = rs.getObject(columnIndex);
                if (v != null) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(bos);
                    try {
                        DataSerializer.writeObject((Object)v, (DataOutput)dos);
                        dos.flush();
                    }
                    catch (IOException ioe) {
                        throw new SQLException(ioe.getMessage(), "XJ001", 0, ioe);
                    }
                    byte[] bytes = bos.toByteArray();
                    return ClientSharedUtils.toHexString((byte[])bytes, (int)0, (int)bytes.length);
                }
                return null;
            }
        }
        return rs.getString(columnIndex);
    }

    public String toString() {
        return "GFXD_EVENT_ERROR_LOGGER_" + (this.errorFile == null ? "" : this.errorFile);
    }
}

