/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.tools.dataextractor.extractor;

import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.pivotal.gemfirexd.FabricServer;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.GfxdDataDictionary;
import com.pivotal.gemfirexd.internal.tools.dataextractor.diskstore.GFXDDiskStoreImpl;
import com.pivotal.gemfirexd.internal.tools.dataextractor.domain.ServerInfo;
import com.pivotal.gemfirexd.internal.tools.dataextractor.help.HelpStrings;
import com.pivotal.gemfirexd.internal.tools.dataextractor.report.ReportGenerator;
import com.pivotal.gemfirexd.internal.tools.dataextractor.snapshot.GFXDSnapshotExportStat;
import com.pivotal.gemfirexd.internal.tools.dataextractor.snapshot.GFXDSnapshotExporter;
import com.pivotal.gemfirexd.internal.tools.dataextractor.utils.ExtractorUtils;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.commons.io.FilenameUtils;

public class GemFireXDDataExtractorImpl {
    public static final String PROPERTY_FILE_ARG = "property-file";
    public static final String USE_DDL_OPT = "--use-ddl-file";
    public static final String HELP_OPT = "--help";
    public static final String LOG_LEVEL_OPT = "--log-level";
    public static final String LOG_FILE_OPT = "--log-file";
    public static final String STRING_DELIMITER = "--string-delimiter";
    public static final String EXTRACT_IN_SERVER_OPT = "--save-in-server-working-dir";
    public static final String EXTRACTOR_OUTPUT_DIR_OPT = "--output-dir";
    public static final String USER_NAME_OPT = "--user-name";
    public static final String NUM_THREADS_OPT = "--num-threads";
    public static final String DEFAULT_STRING_DELIMITER = "\"";
    public static final String DEFAULT_SALVAGER_LOG_FILE = "extractor.log";
    public static final String DRIVER_STRING = "com.pivotal.gemfirexd.jdbc.EmbeddedDriver";
    public static final String LOGGER_NAME = "extractor.logger";
    public static volatile Logger logger = Logger.getLogger("extractor.logger");
    protected static FileHandler logFileHandler;
    protected Connection jdbcConn = null;
    private Driver driver;
    private Map<String, List<GFXDSnapshotExportStat>> hostToStatsMap;
    private Map<ServerInfo, List<GFXDSnapshotExportStat>> hostToDdlMap;
    private List<List<GFXDSnapshotExportStat>> rankedAndGroupedDdlStats;
    private boolean useSingleDDL = false;
    private boolean extractInServerDir = false;
    private String logFilePath = null;
    private String logLevelString = Level.INFO.toString();
    private String propFilePath = null;
    private boolean showHelp = false;
    private String singleDdlFilePath = null;
    private String userName;
    private boolean userOverrideNumThreads = false;
    private int userNumThreads = 0;
    protected final Properties extractorProperties = new Properties();
    private String stringDelimiter = "\"";
    private String extractedFilesDirPrefix = "EXTRACTED_FILES";
    private File outputDirectory = null;
    private String outputDirectoryPath = null;
    private static List<String> reportableErrors;

    public GemFireXDDataExtractorImpl() {
        this.hostToStatsMap = new ConcurrentHashMap<String, List<GFXDSnapshotExportStat>>();
        this.hostToDdlMap = new ConcurrentHashMap<ServerInfo, List<GFXDSnapshotExportStat>>();
        this.extractorProperties.setProperty(USE_DDL_OPT, "");
        this.extractorProperties.setProperty(PROPERTY_FILE_ARG, "");
        this.extractorProperties.setProperty(HELP_OPT, Boolean.toString(false));
        this.extractorProperties.setProperty(EXTRACTOR_OUTPUT_DIR_OPT, "");
        this.extractorProperties.setProperty(STRING_DELIMITER, DEFAULT_STRING_DELIMITER);
        this.extractorProperties.setProperty(LOG_LEVEL_OPT, Level.INFO.toString());
        this.extractorProperties.setProperty(LOG_FILE_OPT, DEFAULT_SALVAGER_LOG_FILE);
        this.extractorProperties.setProperty(EXTRACTOR_OUTPUT_DIR_OPT, System.getProperty("user.dir"));
        this.extractorProperties.setProperty(USER_NAME_OPT, "");
        this.extractorProperties.setProperty(NUM_THREADS_OPT, "");
    }

    public GemFireXDDataExtractorImpl(String[] args) {
        this();
    }

    protected void printHelp() throws IOException {
        System.out.println(HelpStrings.helpText);
    }

    protected void configureLogger() throws SecurityException, IOException {
        if (logger == null) {
            logger = Logger.getLogger(LOGGER_NAME);
        }
        logger.setUseParentHandlers(false);
        logFileHandler = new FileHandler(this.logFilePath);
        logFileHandler.setFormatter(new SimpleFormatter());
        Level logLevel = Level.INFO;
        try {
            logLevel = Level.parse(this.logLevelString);
        }
        catch (IllegalArgumentException e) {
            GemFireXDDataExtractorImpl.logInfo("Unrecognized log level :" + this.logLevelString + " defaulting to :" + logLevel);
        }
        logFileHandler.setLevel(logLevel);
        logger.addHandler(logFileHandler);
    }

    public void consumeProperties() throws IOException {
        this.propFilePath = this.extractorProperties.getProperty(PROPERTY_FILE_ARG);
        this.outputDirectoryPath = this.extractorProperties.getProperty(EXTRACTOR_OUTPUT_DIR_OPT);
        this.logFilePath = FilenameUtils.concat((String)this.getOutputDirectory(), (String)this.extractorProperties.getProperty(LOG_FILE_OPT, DEFAULT_SALVAGER_LOG_FILE));
        this.logLevelString = this.extractorProperties.getProperty(LOG_LEVEL_OPT, Level.INFO.getName());
        this.stringDelimiter = this.extractorProperties.getProperty(STRING_DELIMITER);
        this.extractInServerDir = Boolean.valueOf(this.extractorProperties.getProperty(EXTRACT_IN_SERVER_OPT));
        this.showHelp = Boolean.valueOf(this.extractorProperties.getProperty(HELP_OPT));
        String ddlFilePath = this.extractorProperties.getProperty(USE_DDL_OPT);
        if (ddlFilePath != null && !ddlFilePath.isEmpty()) {
            this.useSingleDDL = true;
        }
        this.userName = this.extractorProperties.getProperty(USER_NAME_OPT);
        String numThreads = this.extractorProperties.getProperty(NUM_THREADS_OPT);
        if (StringUtils.isBlank((String)numThreads)) {
            this.userOverrideNumThreads = false;
        } else {
            int userNumThreads = -1;
            try {
                this.userNumThreads = userNumThreads = Integer.valueOf(numThreads).intValue();
                this.userOverrideNumThreads = true;
                if (this.userNumThreads < 1) {
                    this.userNumThreads = 1;
                }
            }
            catch (NumberFormatException nfe) {
                System.out.println("Invalid value for --num-threads");
                this.userOverrideNumThreads = false;
            }
        }
    }

    public void extract() throws Exception {
        long startTime = System.currentTimeMillis();
        if (this.showHelp) {
            this.printHelp();
            return;
        }
        GemFireXDDataExtractorImpl.logInfo("Reading the properties file : " + this.propFilePath);
        Map<String, ServerInfo> serverInfoMap = ServerInfo.createServerInfoList(this.propFilePath);
        if (!this.extractInServerDir && !ExtractorUtils.checkDiskSpaceInTargetDirectory(serverInfoMap, this.getOutputDirectory())) {
            return;
        }
        if (this.useSingleDDL) {
            try {
                List<String> ddlStatements = ExtractorUtils.readSqlStatements(this.singleDdlFilePath);
                boolean enableOffHeap = this.isOffHeapUsed(ddlStatements);
                this.createConnection(enableOffHeap);
                ExtractorUtils.executeDdlFromSqlFile((EmbedConnection)this.jdbcConn, ddlStatements);
            }
            catch (Exception e) {
                String exceptionMessage = "Exception occurred while replaying the DDL from file : " + this.singleDdlFilePath;
                reportableErrors.add(exceptionMessage);
                throw new Exception(exceptionMessage, e);
            }
        } else {
            this.createConnection(false);
        }
        List<DiskStoreImpl> defaultAndDataDictionaryDiskStores = GemFireXDDataExtractorImpl.listDiskStores(true);
        this.extractDDLs(serverInfoMap);
        if (!this.useSingleDDL) {
            this.stopServer();
            ExtractorUtils.cleanDiskStores(defaultAndDataDictionaryDiskStores, true);
            if (this.hostToDdlMap.isEmpty()) {
                GemFireXDDataExtractorImpl.logSevere("Unable to extract the schema for any server(s). Unable to continue data extraction");
                return;
            }
        }
        this.rankedAndGroupedDdlStats = ReportGenerator.rankAndGroupDdlStats(this.hostToDdlMap);
        for (List<GFXDSnapshotExportStat> serverStatGroup : this.rankedAndGroupedDdlStats) {
            String sqlFile = serverStatGroup.get(0).getFileName();
            List<String> ddlStatements = ExtractorUtils.readSqlStatements(sqlFile);
            if (!this.useSingleDDL) {
                boolean enableOffHeap = this.isOffHeapUsed(ddlStatements);
                this.createConnection(enableOffHeap);
            }
            ExtractorUtils.executeDdlFromSqlFile(this.jdbcConn, ddlStatements);
            ArrayList<ServerInfo> serverInfoGroup = new ArrayList<ServerInfo>();
            for (GFXDSnapshotExportStat serverStat : serverStatGroup) {
                serverInfoGroup.add(serverInfoMap.get(serverStat.getServerName()));
            }
            this.retrieveAllRowFormatters();
            List<DiskStoreImpl> userCreatedDiskStoresOnLoner = GemFireXDDataExtractorImpl.listDiskStores(true);
            this.extractDataFromServers(serverInfoGroup, GemFireXDDataExtractorImpl.listDiskStores(false));
            if (!this.useSingleDDL) {
                this.stopServer();
            }
            ExtractorUtils.cleanDiskStores(defaultAndDataDictionaryDiskStores, true);
            ExtractorUtils.cleanDiskStores(userCreatedDiskStoresOnLoner, false);
        }
        String outputDirectory = this.getOutputDirectory();
        long endTime = System.currentTimeMillis();
        double exportTime = (double)(endTime - startTime) / 1000.0;
        System.out.println("Total extraction time : " + exportTime + "s");
        GemFireXDDataExtractorImpl.logInfo("Generating the extraction summary and recommendation...");
        ReportGenerator repGen = new ReportGenerator(this.rankedAndGroupedDdlStats, this.hostToStatsMap, reportableErrors);
        repGen.printReport(new File(outputDirectory, "Summary.txt").getAbsolutePath(), new File(outputDirectory, "Recommended.txt").getAbsolutePath());
        GemFireXDDataExtractorImpl.logInfo("Completed the generation of extraction summary and recommendation");
    }

    protected void createConnection(boolean enableOffHeap) throws SQLException {
        EmbedConnection embeddedConnection = null;
        this.loadDriver(DRIVER_STRING);
        Connection conn = this.getConnection("jdbc:gemfirexd:", this.createConnectionProperties(enableOffHeap));
        embeddedConnection = (EmbedConnection)conn;
        embeddedConnection.getTR().setupContextStack();
    }

    public void createTestConnection() throws SQLException {
        EmbedConnection embeddedConnection = null;
        this.loadDriver(DRIVER_STRING);
        Connection conn = this.getConnection("jdbc:gemfirexd:", new Properties());
        embeddedConnection = (EmbedConnection)conn;
        embeddedConnection.getTR().setupContextStack();
    }

    protected boolean isOffHeapUsed(List<String> ddlStatements) {
        boolean isOffHeapEnabled = false;
        for (String ddlStatment : ddlStatements) {
            if (!ddlStatment.toLowerCase().contains("offheap")) continue;
            GemFireXDDataExtractorImpl.logInfo("Found off heap tables in the schema");
            isOffHeapEnabled = true;
            break;
        }
        return isOffHeapEnabled;
    }

    protected void extractDDLs(Map<String, ServerInfo> serverInfoMap) {
        ServerInfo serverInfo;
        HashMap<ServerInfo, FutureTask<List<GFXDSnapshotExportStat>>> ddlExportTasks = new HashMap<ServerInfo, FutureTask<List<GFXDSnapshotExportStat>>>();
        ExecutorService executor = Executors.newFixedThreadPool(10);
        for (Map.Entry<String, ServerInfo> entry : serverInfoMap.entrySet()) {
            serverInfo = entry.getValue();
            FutureTask<List<GFXDSnapshotExportStat>> futureTask = new FutureTask<List<GFXDSnapshotExportStat>>(new Callable<List<GFXDSnapshotExportStat>>(){

                @Override
                public List<GFXDSnapshotExportStat> call() throws Exception {
                    return GemFireXDDataExtractorImpl.this.extractDDL(serverInfo);
                }
            });
            ddlExportTasks.put(serverInfo, futureTask);
            executor.execute(futureTask);
        }
        for (Map.Entry<String, ServerInfo> entry : serverInfoMap.entrySet()) {
            serverInfo = entry.getValue();
            try {
                FutureTask task = (FutureTask)ddlExportTasks.get(serverInfo);
                List ddlStats = (List)task.get();
                if (ddlStats == null || ddlStats.isEmpty()) {
                    GemFireXDDataExtractorImpl.logSevere("Unable to extract the schema for server : " + serverInfo.getServerName() + ". Cannot proceed with the data extract for server", reportableErrors);
                    continue;
                }
                this.hostToDdlMap.put(serverInfo, ddlStats);
            }
            catch (ExecutionException e) {
                GemFireXDDataExtractorImpl.logSevere("ExecutionException: Unable to extract the schema for server : " + serverInfo.getServerName() + ". Cannot proceed with the data extract for server", reportableErrors);
            }
            catch (InterruptedException e) {
                GemFireXDDataExtractorImpl.logSevere("Interrupted: Unable to extract the schema for server : " + serverInfo.getServerName() + ". Cannot proceed with the data extract for server", reportableErrors);
                Thread.currentThread().interrupt();
            }
        }
        executor.shutdown();
    }

    protected int getNumberOfThreads(List<ServerInfo> serverInfoList, List<DiskStoreImpl> diskStores) {
        long maxDiskStoreSizeOnDisk = 0L;
        int maxNumberOfServersInParallel = 1;
        double mbDiv = Math.pow(1024.0, 2.0);
        for (ServerInfo serverInfo : serverInfoList) {
            long maxDiskStoreSizeForServer = ExtractorUtils.getMaxDiskStoreSizeForServer(serverInfo, diskStores);
            if (maxDiskStoreSizeOnDisk >= maxDiskStoreSizeForServer) continue;
            maxDiskStoreSizeOnDisk = maxDiskStoreSizeForServer;
        }
        GemFireXDDataExtractorImpl.logInfo("Maximum disk-store size on disk " + (double)maxDiskStoreSizeOnDisk / mbDiv + " MB");
        MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemUsage = memBean.getHeapMemoryUsage();
        long usedMemory = heapMemUsage.getUsed();
        long committedMemory = heapMemUsage.getCommitted();
        long availableMemory = committedMemory - usedMemory;
        GemFireXDDataExtractorImpl.logInfo("Available memory : " + (double)availableMemory / mbDiv + " MB");
        double maxMemoryPerServer = 2.2 * (double)maxDiskStoreSizeOnDisk;
        if (maxMemoryPerServer < 1.0) {
            maxMemoryPerServer = 1.0;
        }
        GemFireXDDataExtractorImpl.logInfo("Estimated memory needed per server : " + maxMemoryPerServer / mbDiv + " MB");
        if ((double)availableMemory < maxMemoryPerServer) {
            GemFireXDDataExtractorImpl.logWarning("Not enough memory to extract the server, extractor could possibly run out of memory");
        }
        if ((maxNumberOfServersInParallel = (int)((double)availableMemory / maxMemoryPerServer)) < 1) {
            maxNumberOfServersInParallel = 1;
        }
        GemFireXDDataExtractorImpl.logInfo("Recommended number of threads to extract server(s) in parallel : " + maxNumberOfServersInParallel);
        return maxNumberOfServersInParallel;
    }

    protected List<GFXDSnapshotExportStat> extractDDL(ServerInfo serverInfo) {
        String serverName = serverInfo.getServerName();
        String serverDirectory = serverInfo.getServerDirectory();
        List<GFXDSnapshotExportStat> ddlStats = null;
        try {
            String serverOutputDirectory = this.getServerOutputDirectory(serverName);
            if (this.extractInServerDir) {
                serverOutputDirectory = FilenameUtils.concat((String)serverDirectory, (String)this.getSalvageDirName());
            }
            GemFireXDDataExtractorImpl.logInfo("Extracting DDL for server : " + serverInfo.getServerName());
            ddlStats = GemFireXDDataExtractorImpl.exportOfflineDDL(serverDirectory + File.separator + "datadictionary", serverOutputDirectory, this.stringDelimiter);
            GemFireXDDataExtractorImpl.logInfo("Completed extraction of DDL's for server : " + serverInfo.getServerName());
        }
        catch (DiskAccessException e) {
            GemFireXDDataExtractorImpl.logSevere("Disk Access issues, possibly permissions related for " + serverDirectory + ".  Issue: " + e.getMessage(), e, reportableErrors);
        }
        catch (Exception e) {
            GemFireXDDataExtractorImpl.logSevere("Error occured while extracting the DDL's from " + serverDirectory, e, reportableErrors);
        }
        return ddlStats;
    }

    protected void extractDataFromServers(List<ServerInfo> serverInfoList, final List<DiskStoreImpl> diskStores) {
        int numThreads;
        int threadPoolSize = numThreads = ExtractorUtils.getNumberOfThreads(serverInfoList, diskStores);
        if (this.userOverrideNumThreads) {
            if (numThreads < this.userNumThreads) {
                GemFireXDDataExtractorImpl.logWarning("User specified a high thread count. Extractor could possibly run out of memory.");
            }
            threadPoolSize = this.userNumThreads;
        }
        HashMap<ServerInfo, FutureTask<List<GFXDSnapshotExportStat>>> salvageServerTasks = new HashMap<ServerInfo, FutureTask<List<GFXDSnapshotExportStat>>>();
        ExecutorService executor = Executors.newFixedThreadPool(threadPoolSize);
        for (final ServerInfo serverInfo : serverInfoList) {
            FutureTask<List<GFXDSnapshotExportStat>> futureTask = new FutureTask<List<GFXDSnapshotExportStat>>(new Callable<List<GFXDSnapshotExportStat>>(){

                @Override
                public List<GFXDSnapshotExportStat> call() {
                    try {
                        return GemFireXDDataExtractorImpl.this.extractDataFromServer(serverInfo, diskStores);
                    }
                    catch (Exception e) {
                        GemFireXDDataExtractorImpl.logSevere("Exception occured while extracting the server " + serverInfo.getServerName(), e, reportableErrors);
                        return new ArrayList<GFXDSnapshotExportStat>();
                    }
                }
            });
            salvageServerTasks.put(serverInfo, futureTask);
            executor.execute(futureTask);
        }
        for (final ServerInfo serverInfo : serverInfoList) {
            try {
                FutureTask task = (FutureTask)salvageServerTasks.get(serverInfo);
                List salvageServerStats = (List)task.get();
                this.hostToStatsMap.put(serverInfo.getServerName(), salvageServerStats);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                GemFireXDDataExtractorImpl.logSevere("ExecutionException: Unable to extact the data for server : " + serverInfo.getServerName() + ". Cannot proceed with the data extract for server", reportableErrors);
            }
            catch (InterruptedException e) {
                GemFireXDDataExtractorImpl.logSevere("Interrupted: Unable to extract the data for server : " + serverInfo.getServerName() + ". Cannot proceed with the data extract for server", reportableErrors);
                Thread.currentThread().interrupt();
            }
        }
        executor.shutdown();
    }

    protected List<GFXDSnapshotExportStat> extractDataFromServer(ServerInfo serverInfo, List<DiskStoreImpl> diskStores) throws IOException, Exception {
        String serverName = serverInfo.getServerName();
        String serverDirectory = serverInfo.getServerDirectory();
        GemFireXDDataExtractorImpl.logInfo("Started data extraction for Server : " + serverName);
        List<String> diskStoreDirectories = serverInfo.getDiskStoreDirectories();
        String serverOutputDirectory = this.getServerOutputDirectory(serverName);
        if (this.extractInServerDir) {
            serverOutputDirectory = FilenameUtils.concat((String)serverDirectory, (String)this.getSalvageDirName());
        }
        return this.extractDiskStores(serverName, diskStores, diskStoreDirectories, serverOutputDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printTables() throws SQLException {
        try (Statement statement = null;){
            statement = this.jdbcConn.createStatement();
            ResultSet result = statement.executeQuery("select TABLESCHEMANAME, TABLENAME from SYS.SYSTABLES order by TABLESCHEMANAME");
            while (result.next()) {
                String schema = result.getString(1);
                String table = result.getString(2);
                System.out.println("TABLE:" + schema + "." + table);
            }
            result = statement.executeQuery("select * from SYS.SYSCONGLOMERATES");
            while (result.next()) {
                String conglomerateName = result.getString("CONGLOMERATENAME");
                boolean isConstraint = result.getBoolean("ISCONSTRAINT");
                String conglomerateSchemaName = result.getString("CONGLOMSCHEMANAME");
                GemFireXDDataExtractorImpl.logInfo("CONGLOMERATE NAME : " + conglomerateName + "ISCONSTRAINT : " + isConstraint + "CONGLOMSCHEMANAME" + conglomerateSchemaName);
            }
            result = statement.executeQuery(" select * from SYS.SYSCONSTRAINTS");
            while (result.next()) {
                String constraintName = result.getString("CONSTRAINTNAME");
                GemFireXDDataExtractorImpl.logInfo("CONSTRAINTNAME" + constraintName + "ISCONSTRAINT : ");
            }
        }
    }

    public void retrieveAllRowFormatters() throws SQLException, StandardException {
        GFXDSnapshotExporter.tableNameRowFormatterMap = this.retrieveAllRowFormatters(this.jdbcConn);
    }

    private Map<String, RowFormatter> retrieveAllRowFormatters(Connection jdbcConn) throws SQLException, StandardException {
        ConcurrentHashMap<String, RowFormatter> tableNameRowFormatterMap = new ConcurrentHashMap<String, RowFormatter>();
        Statement statement = jdbcConn.createStatement();
        ResultSet result = statement.executeQuery("select TABLESCHEMANAME, TABLENAME from SYS.SYSTABLES order by TABLESCHEMANAME");
        while (result.next()) {
            String schemaName = result.getString(1);
            String tableName = result.getString(2);
            String schemaTableName = schemaName + tableName;
            if (schemaName.equals("SYS")) continue;
            try {
                GemFireContainer container;
                RowFormatter rowFormatter;
                GfxdDataDictionary dd = Misc.getMemStore().getDatabase().getDataDictionary();
                TransactionController tc = Misc.getLanguageConnectionContext().getTransactionCompile();
                SchemaDescriptor sd = dd.getSchemaDescriptor(schemaName, tc, true);
                TableDescriptor tableDescriptor = dd.getTableDescriptor(tableName, sd, tc);
                if (tableDescriptor == null) {
                    sd = dd.getSchemaDescriptor("APP", tc, true);
                    tableDescriptor = dd.getTableDescriptor(tableName, sd, tc);
                }
                if ((rowFormatter = (container = Misc.getMemStore().getContainer(ContainerKey.valueOf(0L, tableDescriptor.getHeapConglomerateId()))).getCurrentRowFormatter()) != null) {
                    tableNameRowFormatterMap.put(schemaTableName, rowFormatter);
                    continue;
                }
                System.out.println("NULL ROW FORMATTER FOR:" + schemaTableName);
            }
            catch (NullPointerException npe) {
                GemFireXDDataExtractorImpl.logInfo("Could not get meta data for " + schemaName + "." + tableName);
            }
        }
        return tableNameRowFormatterMap;
    }

    protected static String getUserInput() {
        Scanner in;
        GemFireXDDataExtractorImpl.logInfo("Possibly insufficient disk space to carry out data extraction");
        String userInput = null;
        do {
            System.out.println("Do you wish to continue [y\n] ?");
        } while (!"y".equalsIgnoreCase(userInput = (in = new Scanner(System.in)).next()) && !"n".equalsIgnoreCase(userInput));
        return userInput;
    }

    public void processArgs(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            throw new Exception("Please provide the 'property-file' , try --help for arguments and options");
        }
        for (String arg : args) {
            if (arg.equals(HELP_OPT)) {
                this.extractorProperties.setProperty(HELP_OPT, Boolean.toString(Boolean.TRUE));
                continue;
            }
            String[] tokens = arg.split("=");
            if (tokens.length < 2) {
                throw new Exception("Invalid argument : " + arg);
            }
            String key = tokens[0].trim();
            String value = tokens[1].trim();
            if (this.extractorProperties.containsKey(key)) {
                this.extractorProperties.setProperty(key, value);
                continue;
            }
            throw new Exception("Invalid option : " + key);
        }
    }

    public List<GFXDSnapshotExportStat> extractDiskStores(String serverName, List<String> diskStoreDirectories, String serverOutputDirectory) throws Exception {
        List<DiskStoreImpl> diskStores = GemFireXDDataExtractorImpl.listDiskStores(false);
        return this.extractDiskStores(serverName, diskStores, diskStoreDirectories, serverOutputDirectory);
    }

    protected List<GFXDSnapshotExportStat> extractDiskStores(String serverName, List<DiskStoreImpl> diskStores, List<String> diskStoreDirectories, String serverOutputDirectory) throws Exception {
        GemFireXDDataExtractorImpl.logInfo("Server : " + serverName + " Started extraction of  disk stores...");
        ArrayList<GFXDSnapshotExportStat> listOfStatsObjects = new ArrayList<GFXDSnapshotExportStat>();
        for (String diskStoreDirectory : diskStoreDirectories) {
            diskStoreDirectory = diskStoreDirectory.trim();
            for (DiskStoreImpl diskStore : diskStores) {
                try {
                    List<GFXDSnapshotExportStat> listOfStats = this.extractDiskStore(serverName, diskStore, diskStoreDirectory, serverOutputDirectory);
                    listOfStatsObjects.addAll(listOfStats);
                }
                catch (IllegalStateException e) {
                    GemFireXDDataExtractorImpl.logInfo("Disk-store:" + diskStore.getName() + " was not recovered from directory : " + diskStoreDirectory, e);
                }
                catch (DiskAccessException e) {
                    GemFireXDDataExtractorImpl.logSevere("Could not access files for " + diskStore.getName() + " from directory " + diskStoreDirectory + " due to: " + e.getMessage(), reportableErrors);
                }
            }
        }
        GemFireXDDataExtractorImpl.logInfo("Server : " + serverName + " Completed extraction of disk stores");
        return listOfStatsObjects;
    }

    private List<GFXDSnapshotExportStat> extractDiskStore(String serverName, DiskStoreImpl diskStore, String diskStoreDirectory, String serverOutputDirectory) throws Exception {
        String diskStoreName = diskStore.getName();
        GemFireXDDataExtractorImpl.logInfo("Server : " + serverName + " Attempting extraction of diskstore:" + diskStoreName + " from directory: " + diskStoreDirectory);
        if (!GFXDDiskStoreImpl.diskStoreExists((String)diskStore.getName(), (File)new File(diskStoreDirectory))) {
            throw new IllegalStateException("could not locate .if file for :" + diskStore.getName());
        }
        List<GFXDSnapshotExportStat> listOfStats = GemFireXDDataExtractorImpl.exportDataOpLog(diskStoreName, diskStoreDirectory, serverOutputDirectory, false, this.stringDelimiter);
        boolean possibleCorrupt = false;
        List<GFXDSnapshotExportStat> listOfStatsUsingKRF = null;
        try {
            listOfStatsUsingKRF = GemFireXDDataExtractorImpl.exportDataOpLog(diskStoreName, diskStoreDirectory, serverOutputDirectory, true, this.stringDelimiter);
        }
        catch (DiskAccessException e) {
            possibleCorrupt = true;
        }
        this.detectCorruption(listOfStats, listOfStatsUsingKRF, possibleCorrupt);
        for (GFXDSnapshotExportStat stat : listOfStats) {
            stat.setServerName(serverName);
        }
        GemFireXDDataExtractorImpl.logInfo("Server : " + serverName + "Completed extraction of diskstore:" + diskStoreName + " from directory: " + diskStoreDirectory);
        return listOfStats;
    }

    private void detectCorruption(List<GFXDSnapshotExportStat> listOfStats, List<GFXDSnapshotExportStat> listOfStatsUsingKRF, boolean possibleCorrupt) {
        block0: for (GFXDSnapshotExportStat stat : listOfStats) {
            if (possibleCorrupt) {
                stat.setCorrupt(true);
                continue;
            }
            Iterator<GFXDSnapshotExportStat> iter = listOfStatsUsingKRF.iterator();
            while (iter.hasNext()) {
                GFXDSnapshotExportStat krfStat = iter.next();
                if (!stat.isSameTableStat(krfStat) || stat.getNumValuesDecoded() == krfStat.getNumValuesDecoded()) continue;
                stat.setCorrupt(true);
                iter.remove();
                continue block0;
            }
        }
    }

    static List<GFXDSnapshotExportStat> exportDataOpLog(String diskStoreName, String inputDirectory, String outputDirectory, boolean forceKRFRecovery, String stringDelimiter) throws Exception {
        return GFXDDiskStoreImpl.exportOfflineSnapshotXD(diskStoreName, new File[]{new File(inputDirectory)}, new File(outputDirectory), forceKRFRecovery, stringDelimiter);
    }

    public static List<GFXDSnapshotExportStat> exportDataOpLog(String diskStoreName, String inputDirectory, String outputDirectory, boolean forceKRFRecovery) throws Exception {
        return GFXDDiskStoreImpl.exportOfflineSnapshotXD(diskStoreName, new File[]{new File(inputDirectory)}, new File(outputDirectory), forceKRFRecovery, DEFAULT_STRING_DELIMITER);
    }

    static List<GFXDSnapshotExportStat> exportOfflineDDL(String ddDirectory, String outputDirectory, String stringDelimiter) throws Exception {
        return GFXDDiskStoreImpl.exportOfflineSnapshotXD("GFXD-DD-DISKSTORE", new File[]{new File(ddDirectory)}, new File(outputDirectory), false, stringDelimiter);
    }

    public static List<GFXDSnapshotExportStat> exportOfflineDDL(String ddDirectory, String outputDirectory) throws Exception {
        return GFXDDiskStoreImpl.exportOfflineSnapshotXD("GFXD-DD-DISKSTORE", new File[]{new File(ddDirectory)}, new File(outputDirectory), false, DEFAULT_STRING_DELIMITER);
    }

    private static List<DiskStoreImpl> listDiskStores(boolean includeDataDictionary) {
        ArrayList<DiskStoreImpl> diskStoresList = new ArrayList<DiskStoreImpl>();
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        Collection diskStores = cache.listDiskStoresIncludingRegionOwned();
        for (DiskStoreImpl diskStore : diskStores) {
            if (diskStore.getName().equals("GFXD-DD-DISKSTORE") && !includeDataDictionary) continue;
            diskStoresList.add(diskStore);
        }
        return diskStoresList;
    }

    public String getOutputDirectory() throws IOException {
        if (this.outputDirectory == null) {
            this.outputDirectoryPath = this.outputDirectoryPath == null || this.outputDirectoryPath.isEmpty() ? FilenameUtils.concat((String)".", (String)this.getSalvageDirName()) : FilenameUtils.concat((String)this.outputDirectoryPath, (String)this.getSalvageDirName());
            this.outputDirectory = new File(this.outputDirectoryPath);
            if (!this.outputDirectory.exists() && !this.outputDirectory.mkdir()) {
                throw new IOException("Could not create output directory:" + this.outputDirectory.getAbsolutePath());
            }
        }
        return this.outputDirectory.getCanonicalPath();
    }

    public String getSalvageDirName() {
        return this.extractedFilesDirPrefix;
    }

    public boolean useOverrodeNumThreads() {
        return this.userOverrideNumThreads;
    }

    public int getUserNumThreads() {
        return this.userNumThreads;
    }

    private String getServerOutputDirectory(String serverName) throws IOException {
        String outputDirectory = this.getOutputDirectory();
        File file = new File(outputDirectory, serverName);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Server : " + serverName + " could not create output directories :" + file.getCanonicalPath());
        }
        return file.getCanonicalPath();
    }

    private void stopServer() throws SQLException, Exception {
        try {
            if (this.jdbcConn != null) {
                this.jdbcConn.close();
            }
            DriverManager.deregisterDriver(this.driver);
            FabricServer fs = FabricServiceManager.getFabricServerInstance();
            if (fs != null) {
                fs.stop(new Properties());
            }
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            InternalDistributedSystem ds = null;
            if (cache != null && (ds = cache.getDistributedSystem()) != null) {
                ds.disconnect();
            }
        }
        catch (Exception e) {
            GemFireXDDataExtractorImpl.logSevere("Unable to stop the server ", e, reportableErrors);
        }
        GFXDDiskStoreImpl.cleanUpOffline();
    }

    public void loadDriver(String driver) {
        try {
            if (this.driver == null) {
                this.driver = (Driver)Class.forName(driver).newInstance();
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            GemFireXDDataExtractorImpl.logSevere("Unable to load the JDBC driver ", cnfe, reportableErrors);
        }
        catch (InstantiationException ie) {
            ie.printStackTrace();
            GemFireXDDataExtractorImpl.logSevere("Unable to instantiate the JDBC driver", ie, reportableErrors);
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            GemFireXDDataExtractorImpl.logSevere("Not allowed to access the JDBC driver ", iae, reportableErrors);
        }
    }

    private boolean setPropertyIfAbsent(Properties props, String key, String value) {
        if (props == null) {
            if (!key.startsWith("gemfire.") && !key.startsWith(GfxdConstants.GFXD_PREFIX)) {
                key = "gemfire." + key;
            }
            if (System.getProperty(key) == null) {
                System.setProperty(key, value);
                return true;
            }
        } else if (!props.containsKey(key)) {
            props.put(key, value);
            return true;
        }
        return false;
    }

    public Properties createConnectionProperties(boolean enableOffHeap) {
        String outputDir = ".";
        try {
            outputDir = this.getOutputDirectory();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String gemfirelog = FilenameUtils.concat((String)outputDir, (String)"system");
        Properties props = new Properties();
        if (this.setPropertyIfAbsent(props, "log-file", gemfirelog + ".log")) {
            this.setPropertyIfAbsent(null, GfxdConstants.GFXD_LOG_FILE, gemfirelog + ".log");
        }
        this.setPropertyIfAbsent(null, "gemfirexd.client.log-file", gemfirelog + "-client.log");
        this.setPropertyIfAbsent(props, "mcast-port", "0");
        this.setPropertyIfAbsent(props, "table-default-partitioned", "true");
        if (enableOffHeap) {
            this.setPropertyIfAbsent(props, "off-heap-memory-size", "1m");
        }
        if (!StringUtils.isEmpty((String)this.userName)) {
            this.setPropertyIfAbsent(props, "user", this.userName);
        }
        return props;
    }

    public synchronized Connection getConnection(String protocol, Properties props) throws SQLException {
        if (this.jdbcConn == null || this.jdbcConn.isClosed()) {
            Connection conn;
            this.jdbcConn = conn = DriverManager.getConnection(protocol, props);
        }
        return this.jdbcConn;
    }

    public Map<String, List<GFXDSnapshotExportStat>> getHostToStatsMap() {
        return this.hostToStatsMap;
    }

    public static void logSevere(String msg) {
        GemFireXDDataExtractorImpl.logSevere(msg, false);
    }

    public static void logSevere(String msg, boolean reportError) {
        GemFireXDDataExtractorImpl.logSevere(msg, GemFireXDDataExtractorImpl.getReportableErrors());
    }

    public static void logSevere(String msg, List<String> reportableErrors) {
        System.out.println(msg);
        logger.log(Level.SEVERE, msg);
        if (reportableErrors != null) {
            reportableErrors.add(msg);
        }
        if (logFileHandler != null) {
            logFileHandler.flush();
        }
    }

    public static void logSevere(String msg, Throwable e) {
        GemFireXDDataExtractorImpl.logSevere(msg, e, null);
    }

    public static void logSevere(String msg, Throwable e, List<String> reportableErrors) {
        System.out.println(msg);
        logger.log(Level.SEVERE, msg, e);
        if (reportableErrors != null) {
            reportableErrors.add(msg + "::" + e.getMessage());
        }
        if (logFileHandler != null) {
            logFileHandler.flush();
        }
    }

    public static void logInfo(String msg) {
        System.out.println(msg);
        logger.log(Level.INFO, msg);
    }

    public static void logInfo(String msg, Throwable e) {
        System.out.println(msg);
        logger.log(Level.INFO, msg, e);
    }

    public static void logConfig(String msg) {
        System.out.println(msg);
        logger.log(Level.CONFIG, msg);
    }

    public static void logFine(String msg) {
        System.out.println(msg);
        logger.log(Level.FINE, msg);
    }

    public static void logWarning(String msg) {
        System.out.println("WARNING : " + msg);
        logger.warning(msg);
    }

    public static void main(String[] args) throws Exception {
        GemFireXDDataExtractorImpl.doMain(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GemFireXDDataExtractorImpl doMain(String[] args) throws Exception {
        try {
            if (args.length < 1) {
                throw new Exception("Please specify the location of extraction properties file");
            }
            GemFireXDDataExtractorImpl extractor = new GemFireXDDataExtractorImpl();
            extractor.processArgs(args);
            extractor.consumeProperties();
            extractor.configureLogger();
            extractor.extract();
            GemFireXDDataExtractorImpl gemFireXDDataExtractorImpl = extractor;
            return gemFireXDDataExtractorImpl;
        }
        finally {
            if (logFileHandler != null) {
                logFileHandler.flush();
                logFileHandler.close();
            }
        }
    }

    public String getPropFilePath() {
        return this.propFilePath;
    }

    public void setPropFilePath(String propFilePath) {
        this.propFilePath = propFilePath;
    }

    public boolean isShowHelp() {
        return this.showHelp;
    }

    public void setShowHelp(boolean showHelp) {
        this.showHelp = showHelp;
    }

    public String getSingleDdlFilePath() {
        return this.singleDdlFilePath;
    }

    public void setSingleDdlFilePath(String singleDdlFilePath) {
        this.singleDdlFilePath = singleDdlFilePath;
    }

    public String getStringDelimiter() {
        return this.stringDelimiter;
    }

    public boolean useSingleDDl() {
        return this.useSingleDDL;
    }

    public static Logger getLogger() {
        return logger;
    }

    protected static FileHandler getLogFileHandler() {
        return logFileHandler;
    }

    protected Connection getJdbcConn() {
        return this.jdbcConn;
    }

    protected Driver getDriver() {
        return this.driver;
    }

    protected Map<ServerInfo, List<GFXDSnapshotExportStat>> getHostToDdlMap() {
        return this.hostToDdlMap;
    }

    public boolean isUseSingleDDL() {
        return this.useSingleDDL;
    }

    public boolean isSalvageInServerDir() {
        return this.extractInServerDir;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public String getLogLevelString() {
        return this.logLevelString;
    }

    public Properties getToolProperties() {
        return this.extractorProperties;
    }

    public static String getDefaultStringDelimiter() {
        return DEFAULT_STRING_DELIMITER;
    }

    public String getSalvageDirPrefix() {
        return this.extractedFilesDirPrefix;
    }

    public String getOutputDirectoryPath() {
        return this.outputDirectoryPath;
    }

    public static List<String> getReportableErrors() {
        return reportableErrors;
    }

    public List<List<GFXDSnapshotExportStat>> getRankedAndGroupedDDLStats() {
        return this.rankedAndGroupedDdlStats;
    }

    static {
        reportableErrors = Collections.synchronizedList(new ArrayList());
    }
}

