/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.conglomerate;

import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapResourceHolder;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.raw.FetchDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.store.access.conglomerate.GenericController;
import com.pivotal.gemfirexd.internal.impl.store.access.conglomerate.RowPosition;

public abstract class GenericConglomerateController
extends GenericController
implements ConglomerateController {
    @Override
    public void close() throws StandardException {
        super.close();
        if (this.open_conglom != null && this.open_conglom.getXactMgr() != null) {
            this.open_conglom.getXactMgr().closeMe(this);
        }
    }

    @Override
    public boolean closeForEndTransaction(boolean closeHeldScan) throws StandardException {
        super.close();
        if (!this.open_conglom.getHold() || closeHeldScan) {
            if (this.open_conglom != null && this.open_conglom.getXactMgr() != null) {
                this.open_conglom.getXactMgr().closeMe(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean delete(RowLocation loc) throws StandardException {
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                if (this.open_conglom.isClosed()) {
                    this.open_conglom.reopen();
                }
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        RowPosition pos = this.open_conglom.getRuntimeMem().get_scratch_row_position();
        this.getRowPositionFromRowLocation(loc, pos);
        if (!this.open_conglom.latchPage(pos)) {
            return false;
        }
        this.open_conglom.lockPositionForWrite(pos, false, true);
        boolean ret_val = true;
        if (pos.current_page.isDeletedAtSlot(pos.current_slot)) {
            ret_val = false;
        } else {
            pos.current_page.deleteAtSlot(pos.current_slot, true, null);
            if (pos.current_page.shouldReclaimSpace(pos.current_page.getPageNumber() == 1L ? 1 : 0, pos.current_slot)) {
                this.queueDeletePostCommitWork(pos);
            }
        }
        pos.current_page.unlatch();
        return ret_val;
    }

    @Override
    public RowLocation fetch(RowLocation loc, DataValueDescriptor[] row, FormatableBitSet validColumns, boolean faultIn) throws StandardException {
        boolean ret_val;
        int invalidColumn;
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                if (this.open_conglom.isClosed()) {
                    this.open_conglom.reopen();
                }
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        if ((invalidColumn = RowUtil.columnOutOfRange(row, validColumns, this.open_conglom.getFormatIds().length)) >= 0) {
            throw StandardException.newException("XSCH5.S", (Object)new Long(invalidColumn), (Object)new Long(this.open_conglom.getFormatIds().length));
        }
        RowPosition pos = this.open_conglom.getRuntimeMem().get_scratch_row_position();
        this.getRowPositionFromRowLocation(loc, pos);
        if (!this.open_conglom.latchPage(pos)) {
            return null;
        }
        if (this.open_conglom.isForUpdate()) {
            this.open_conglom.lockPositionForWrite(pos, false, true);
        } else {
            this.open_conglom.lockPositionForRead(pos, null, false, true);
        }
        boolean bl = ret_val = pos.current_page.fetchFromSlot(pos.current_rh, pos.current_slot, row, new FetchDescriptor(row.length, validColumns, null), false) != null;
        if (!this.open_conglom.isForUpdate()) {
            this.open_conglom.unlockPositionAfterRead(pos);
        }
        pos.current_page.unlatch();
        return ret_val ? loc : null;
    }

    @Override
    public RowLocation fetch(RowLocation loc, ExecRow row, FormatableBitSet validColumns, boolean faultIn) throws StandardException {
        throw new AssertionError((Object)"should not be called");
    }

    @Override
    public RowLocation fetch(RowLocation loc, ExecRow destRow, FormatableBitSet validColumns, boolean faultIn, OffHeapResourceHolder offheapOwner) throws StandardException {
        throw new AssertionError((Object)"should not be called");
    }

    @Override
    public RowLocation fetch(RowLocation loc, DataValueDescriptor[] row, FormatableBitSet validColumns, boolean waitForLock, boolean faultIn) throws StandardException {
        boolean ret_val;
        int invalidColumn;
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                if (this.open_conglom.isClosed()) {
                    this.open_conglom.reopen();
                }
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        if ((invalidColumn = RowUtil.columnOutOfRange(row, validColumns, this.open_conglom.getFormatIds().length)) >= 0) {
            throw StandardException.newException("XSCH5.S", (Object)new Long(invalidColumn), (Object)new Long(this.open_conglom.getFormatIds().length));
        }
        RowPosition pos = this.open_conglom.getRuntimeMem().get_scratch_row_position();
        this.getRowPositionFromRowLocation(loc, pos);
        if (!this.open_conglom.latchPage(pos)) {
            return null;
        }
        if (this.open_conglom.isForUpdate()) {
            this.open_conglom.lockPositionForWrite(pos, false, waitForLock);
        } else {
            this.open_conglom.lockPositionForRead(pos, null, false, waitForLock);
        }
        boolean bl = ret_val = pos.current_page.fetchFromSlot(pos.current_rh, pos.current_slot, row, new FetchDescriptor(row.length, validColumns, null), false) != null;
        if (!this.open_conglom.isForUpdate()) {
            this.open_conglom.unlockPositionAfterRead(pos);
        }
        pos.current_page.unlatch();
        return ret_val ? loc : null;
    }

    @Override
    public boolean replace(RowLocation loc, DataValueDescriptor[] row, FormatableBitSet validColumns) throws StandardException {
        int invalidColumn;
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                if (this.open_conglom.isClosed()) {
                    this.open_conglom.reopen();
                }
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        if ((invalidColumn = RowUtil.columnOutOfRange(row, validColumns, this.open_conglom.getFormatIds().length)) >= 0) {
            throw StandardException.newException("XSCH5.S", (Object)new Long(invalidColumn), (Object)new Long(this.open_conglom.getFormatIds().length));
        }
        RowPosition pos = this.open_conglom.getRuntimeMem().get_scratch_row_position();
        this.getRowPositionFromRowLocation(loc, pos);
        if (!this.open_conglom.latchPage(pos)) {
            return false;
        }
        this.open_conglom.lockPositionForWrite(pos, false, true);
        boolean ret_val = true;
        if (pos.current_page.isDeletedAtSlot(pos.current_slot)) {
            ret_val = false;
        } else {
            pos.current_page.updateAtSlot(pos.current_slot, row, validColumns);
        }
        pos.current_page.unlatch();
        return ret_val;
    }
}

