/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.btree.index;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.raw.FetchDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RecordHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BTree;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BTreeLockingPolicy;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BTreeRowPosition;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.ControlRow;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.LeafControlRow;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.OpenBTree;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.WaitError;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.index.B2I;

class B2IRowLocking3
implements BTreeLockingPolicy {
    protected ConglomerateController base_cc;
    protected OpenBTree open_btree;
    private LockingPolicy scan_locking_policy;
    private Transaction rawtran;

    B2IRowLocking3(Transaction rawtran, int lock_level, LockingPolicy locking_policy, ConglomerateController base_cc, OpenBTree open_btree) {
        this.rawtran = rawtran;
        this.base_cc = base_cc;
        this.open_btree = open_btree;
        this.scan_locking_policy = rawtran.newLockingPolicy(1, 2, true);
    }

    private boolean _lockScan(RecordHandle rh, boolean forUpdate, boolean wait) throws StandardException {
        boolean ret_val = true;
        ret_val = !forUpdate ? this.scan_locking_policy.lockRecordForRead(this.rawtran, this.open_btree.getContainerHandle(), rh, wait, false) : this.scan_locking_policy.lockRecordForWrite(this.rawtran, rh, false, wait);
        return ret_val;
    }

    private boolean lockPreviousToFirstKey(LeafControlRow current_leaf, LeafControlRow aux_leaf, int lock_operation, int lock_duration) throws StandardException {
        boolean ret_status = this.base_cc.lockRow(1L, 3, lock_operation, false, lock_duration);
        if (!ret_status) {
            current_leaf.release();
            current_leaf = null;
            if (aux_leaf != null) {
                aux_leaf.release();
                aux_leaf = null;
            }
            this.base_cc.lockRow(1L, 3, lock_operation, true, lock_duration);
        }
        return ret_status;
    }

    private boolean lockRowOnPage(BTree btree, LeafControlRow current_leaf, LeafControlRow aux_leaf, int current_slot, boolean check_changed_rowloc, FetchDescriptor lock_fetch_desc, DataValueDescriptor[] lock_template, RowLocation lock_row_loc, int lock_operation, int lock_duration) throws StandardException {
        SanityManager.ASSERT((current_leaf != null ? 1 : 0) != 0);
        if (current_slot <= 0 || current_slot >= current_leaf.getPage().recordCount()) {
            SanityManager.THROWASSERT((String)("current_slot = " + current_slot + "; current_leaf.getPage().recordCount() = " + current_leaf.getPage().recordCount()));
        }
        if (!(btree instanceof B2I)) {
            SanityManager.THROWASSERT((String)("btree not instance of B2I, it is " + btree.getClass().getName()));
        }
        SanityManager.ASSERT((lock_template != null ? 1 : 0) != 0, (String)"template is null");
        SanityManager.ASSERT((lock_row_loc == lock_template[lock_template.length - 1] ? 1 : 0) != 0, (String)"row_loc is not the object in last column of lock_template.");
        RecordHandle rec_handle = current_leaf.getPage().fetchFromSlot(null, current_slot, lock_template, lock_fetch_desc, true);
        boolean ret_status = this.base_cc.lockRow(lock_row_loc, lock_operation, false, lock_duration);
        if (!ret_status) {
            if (current_leaf != null) {
                current_leaf.release();
                current_leaf = null;
            }
            if (aux_leaf != null) {
                aux_leaf.release();
                aux_leaf = null;
            }
            this.base_cc.lockRow(lock_row_loc, lock_operation, true, lock_duration);
        }
        return ret_status;
    }

    private boolean searchLeftAndLockPreviousKey(B2I b2i, LeafControlRow current_leaf, int current_slot, FetchDescriptor lock_fetch_desc, DataValueDescriptor[] lock_template, RowLocation lock_row_loc, OpenBTree open_btree, int lock_operation, int lock_duration) throws StandardException {
        long previous_pageno;
        LeafControlRow prev_leaf;
        boolean latches_released = false;
        try {
            prev_leaf = (LeafControlRow)current_leaf.getLeftSibling(open_btree);
        }
        catch (WaitError e) {
            previous_pageno = current_leaf.getleftSiblingPageNumber();
            current_leaf.release();
            current_leaf = null;
            prev_leaf = (LeafControlRow)ControlRow.get(open_btree, previous_pageno);
            latches_released = true;
        }
        block4: while (true) {
            try {
                while (true) {
                    if (prev_leaf.getPage().recordCount() > 1) {
                        boolean ret_status = this.lockRowOnPage(b2i, prev_leaf, current_leaf, prev_leaf.getPage().recordCount() - 1, false, lock_fetch_desc, lock_template, lock_row_loc, lock_operation, lock_duration);
                        if (ret_status) break block4;
                        prev_leaf = null;
                        current_leaf = null;
                        latches_released = true;
                        break block4;
                    }
                    if (prev_leaf.isLeftmostLeaf()) {
                        boolean ret_status = this.lockPreviousToFirstKey(prev_leaf, current_leaf, lock_operation, lock_duration);
                        if (ret_status) break block4;
                        prev_leaf = null;
                        current_leaf = null;
                        latches_released = true;
                        break block4;
                    }
                    LeafControlRow prev_prev_leaf = (LeafControlRow)prev_leaf.getLeftSibling(open_btree);
                    prev_leaf.release();
                    prev_leaf = prev_prev_leaf;
                    prev_prev_leaf = null;
                }
            }
            catch (WaitError e) {
                previous_pageno = prev_leaf.getleftSiblingPageNumber();
                if (current_leaf != null) {
                    current_leaf.release();
                    current_leaf = null;
                }
                prev_leaf.release();
                prev_leaf = null;
                prev_leaf = (LeafControlRow)ControlRow.get(open_btree, previous_pageno);
                latches_released = true;
                continue;
            }
            break;
        }
        if (prev_leaf != null) {
            prev_leaf.release();
        }
        return !latches_released;
    }

    protected boolean _lockScanRow(OpenBTree open_btree, BTree btree, BTreeRowPosition pos, boolean request_row_lock, boolean request_scan_lock, FetchDescriptor lock_fetch_desc, DataValueDescriptor[] lock_template, RowLocation lock_row_loc, boolean previous_key_lock, boolean forUpdate, int lock_operation) throws StandardException {
        boolean latch_released = false;
        B2I b2i = (B2I)btree;
        if (request_row_lock) {
            if (pos.current_slot == 0) {
                latch_released = !this.lockNonScanPreviousRow(btree, pos.current_leaf, 1, lock_fetch_desc, lock_template, lock_row_loc, open_btree, lock_operation, 2);
                latch_released = OpenBTree.test_errors(open_btree, "B2iRowLocking3_1_lockScanRow", false, this, pos.current_leaf, latch_released);
            } else {
                latch_released = !this.lockRowOnPage(btree, pos.current_leaf, null, pos.current_slot, true, lock_fetch_desc, lock_template, lock_row_loc, lock_operation, 2);
                latch_released = OpenBTree.test_errors(open_btree, "B2iRowLocking3_2_lockScanRow", false, this, pos.current_leaf, latch_released);
            }
        }
        if (request_scan_lock && !latch_released) {
            latch_released = !this.lockScan(pos.current_leaf, null, false, 0);
            latch_released = OpenBTree.test_errors(open_btree, "B2iRowLocking3_3_lockScanRow", true, this, pos.current_leaf, latch_released);
        }
        return !latch_released;
    }

    @Override
    public boolean lockScan(LeafControlRow current_leaf, ControlRow aux_control_row, boolean forUpdate, int lock_operation) throws StandardException {
        RecordHandle scan_lock_rh = current_leaf.getPage().getProtectionRecordHandle();
        boolean ret_status = this._lockScan(scan_lock_rh, forUpdate, false);
        if (!ret_status) {
            current_leaf.release();
            current_leaf = null;
            if (aux_control_row != null) {
                aux_control_row.release();
                aux_control_row = null;
            }
            this._lockScan(scan_lock_rh, forUpdate, true);
            if (!forUpdate) {
                this.scan_locking_policy.unlockRecordAfterRead(this.rawtran, this.open_btree.getContainerHandle(), scan_lock_rh, false, true);
            }
        }
        return ret_status;
    }

    @Override
    public boolean lockScanForReclaimSpace(LeafControlRow current_leaf) throws StandardException {
        RecordHandle scan_lock_rh = current_leaf.getPage().getProtectionRecordHandle();
        return this._lockScan(scan_lock_rh, true, false);
    }

    @Override
    public boolean lockScanCommittedDeletedRow(OpenBTree open_btree, LeafControlRow leaf, DataValueDescriptor[] template, FetchDescriptor lock_fetch_desc, int slot_no) throws StandardException {
        SanityManager.ASSERT((leaf != null ? 1 : 0) != 0);
        if (slot_no <= 0 || slot_no >= leaf.getPage().recordCount()) {
            SanityManager.THROWASSERT((String)("slot_no = " + slot_no + "; leaf.getPage().recordCount() = " + leaf.getPage().recordCount()));
        }
        SanityManager.ASSERT((template != null ? 1 : 0) != 0, (String)"template is null");
        RowLocation row_loc = (RowLocation)template[((B2I)open_btree.getConglomerate()).rowLocationColumn];
        leaf.getPage().fetchFromSlot(null, slot_no, template, lock_fetch_desc, true);
        return this.base_cc.lockRow(row_loc, 1, false, 2);
    }

    @Override
    public boolean lockScanRow(OpenBTree open_btree, BTree btree, BTreeRowPosition pos, boolean request_scan_lock, FetchDescriptor lock_fetch_desc, DataValueDescriptor[] lock_template, RowLocation lock_row_loc, boolean previous_key_lock, boolean forUpdate, int lock_operation) throws StandardException {
        return this._lockScanRow(open_btree, btree, pos, true, request_scan_lock, lock_fetch_desc, lock_template, lock_row_loc, previous_key_lock, forUpdate, lock_operation);
    }

    @Override
    public void unlockScanRecordAfterRead(BTreeRowPosition pos, boolean forUpdate) throws StandardException {
    }

    @Override
    public void unlockScan(RecordHandle scan_lock_rh) {
        try {
            this.scan_locking_policy.unlockRecordAfterRead(this.rawtran, this.open_btree.getContainerHandle(), scan_lock_rh, false, true);
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT((Throwable)se);
        }
    }

    @Override
    public boolean lockNonScanPreviousRow(BTree btree, LeafControlRow current_leaf, int current_slot, FetchDescriptor lock_fetch_desc, DataValueDescriptor[] lock_template, RowLocation lock_row_loc, OpenBTree open_btree, int lock_operation, int lock_duration) throws StandardException {
        boolean ret_status;
        SanityManager.ASSERT((boolean)(btree instanceof B2I));
        if (current_slot > 1) {
            ret_status = this.lockRowOnPage(btree, current_leaf, null, current_slot - 1, false, lock_fetch_desc, lock_template, lock_row_loc, lock_operation, lock_duration);
        } else {
            SanityManager.ASSERT((current_slot == 1 ? 1 : 0) != 0);
            ret_status = current_leaf.isLeftmostLeaf() ? this.lockPreviousToFirstKey(current_leaf, null, lock_operation, lock_duration) : this.searchLeftAndLockPreviousKey((B2I)btree, current_leaf, current_slot, lock_fetch_desc, lock_template, lock_row_loc, open_btree, lock_operation, lock_duration);
        }
        return ret_status;
    }

    @Override
    public boolean lockNonScanRow(BTree btree, LeafControlRow current_leaf, LeafControlRow aux_leaf, DataValueDescriptor[] current_row, int lock_operation) throws StandardException {
        SanityManager.ASSERT((boolean)(btree instanceof B2I));
        B2I b2i = (B2I)btree;
        boolean ret_status = this.base_cc.lockRow((RowLocation)current_row[b2i.rowLocationColumn], lock_operation, false, 2);
        if (!ret_status) {
            if (current_leaf != null) {
                current_leaf.release();
                current_leaf = null;
            }
            if (aux_leaf != null) {
                aux_leaf.release();
                aux_leaf = null;
            }
            this.base_cc.lockRow((RowLocation)current_row[b2i.rowLocationColumn], lock_operation, true, 2);
        }
        return ret_status;
    }

    @Override
    public boolean lockNonScanRowOnPage(BTree btree, LeafControlRow current_leaf, int current_slot, FetchDescriptor lock_fetch_desc, DataValueDescriptor[] lock_template, RowLocation lock_row_loc, int lock_operation) throws StandardException {
        return this.lockRowOnPage(btree, current_leaf, null, current_slot, false, lock_fetch_desc, lock_template, lock_row_loc, lock_operation, 2);
    }
}

