/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute.rts;

import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.ResultSetStatistics;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Vector;

abstract class RealBasicNoPutResultSetStatistics
implements ResultSetStatistics {
    public int numOpens;
    public int rowsSeen;
    public int rowsFiltered;
    public long constructorTime;
    public long openTime;
    public long nextTime;
    public long closeTime;
    public long inspectOverall;
    public long inspectNum;
    public String inspectDesc;
    public double optimizerEstimatedRowCount;
    public double optimizerEstimatedCost;
    private static DecimalFormat df = null;

    public RealBasicNoPutResultSetStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        this.numOpens = numOpens;
        this.rowsSeen = rowsSeen;
        this.rowsFiltered = rowsFiltered;
        this.constructorTime = constructorTime;
        this.openTime = openTime;
        this.nextTime = nextTime;
        this.closeTime = closeTime;
        this.optimizerEstimatedRowCount = optimizerEstimatedRowCount;
        this.optimizerEstimatedCost = optimizerEstimatedCost;
    }

    protected final String dumpTimeStats(String indent, String subIndent) {
        return subIndent + MessageService.getTextMessage("42Z33.U") + " " + this.constructorTime + "\n" + subIndent + MessageService.getTextMessage("42Z34.U") + " " + this.openTime + "\n" + subIndent + MessageService.getTextMessage("42Z35.U") + " " + this.nextTime + "\n" + subIndent + MessageService.getTextMessage("42Z36.U") + " " + this.closeTime;
    }

    protected final String dumpEstimatedCosts(String subIndent) {
        return subIndent + MessageService.getTextMessage("43X07.U") + ": " + this.formatDouble(this.optimizerEstimatedRowCount) + "\n" + subIndent + MessageService.getTextMessage("43X08.U") + ": " + this.formatDouble(this.optimizerEstimatedCost) + "\n";
    }

    private String formatDouble(double toFormat) {
        String retval;
        if (df == null) {
            df = new DecimalFormat("###########0.00");
            df.setMinimumIntegerDigits(1);
        }
        if ((retval = df.format(toFormat)).length() < 15) {
            retval = "               ".substring(0, 15 - retval.length()) + retval;
        }
        return retval;
    }

    public Vector getChildren() {
        return new Vector();
    }

    public long getTotalTime() {
        return this.openTime + this.nextTime + this.closeTime;
    }

    public long getChildrenTime() {
        long childrenTime = 0L;
        Enumeration e = this.getChildren().elements();
        while (e.hasMoreElements()) {
            childrenTime += ((RealBasicNoPutResultSetStatistics)e.nextElement()).getTotalTime();
        }
        return childrenTime;
    }

    public long getNodeTime() {
        return this.getTotalTime() - this.getChildrenTime();
    }

    public abstract String getNodeName();

    public String getNodeOn() {
        return "";
    }

    @Override
    public double getEstimatedRowCount() {
        return this.optimizerEstimatedRowCount;
    }
}

