/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableArrayHolder;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortController;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortObserver;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BasicNoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BasicSortObserver;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.util.Properties;

public final class SortResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public int rowsInput;
    public int rowsReturned;
    public boolean distinct;
    private NoPutResultSet source;
    private GeneratedMethod rowAllocator;
    private ColumnOrdering[] order;
    private ColumnOrdering[] savedOrder;
    private SortObserver observer;
    private ExecRow sortTemplateRow;
    public boolean isInSortedOrder;
    private NoPutResultSet originalSource;
    private int maxRowSize;
    private long maxSortLimit;
    private ScanController scanController;
    ExecRow sortResultRow;
    ExecRow currSortedRow;
    private boolean nextCalled;
    private int numColumns;
    private long genericSortId;
    private boolean dropGenericSort;
    private boolean sorted;
    SortController sorter;
    public Properties sortProperties = new Properties();

    public SortResultSet(NoPutResultSet s, boolean distinct, boolean isInSortedOrder, int orderingItem, Activation a, GeneratedMethod ra, int maxRowSize, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(a, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.distinct = distinct;
        this.isInSortedOrder = isInSortedOrder;
        this.source = s;
        this.originalSource = s;
        this.rowAllocator = ra;
        this.maxRowSize = maxRowSize;
        this.sortTemplateRow = (ExecRow)this.rowAllocator.invoke(this.activation);
        this.order = (ColumnOrdering[])((FormatableArrayHolder)a.getSavedObject(orderingItem)).getArray(ColumnOrdering.class);
        this.savedOrder = this.order;
        this.observer = new BasicSortObserver(true, distinct, this.sortTemplateRow, true);
        this.recordConstructorTime();
        this.printResultSetHierarchy();
    }

    @Override
    public void openCore() throws StandardException {
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null) {
            observer.onSortResultSetOpen(this);
        }
        this.nextCalled = false;
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"SortResultSet already open");
        this.isOpen = true;
        this.order = this.savedOrder;
        this.sortResultRow = this.sortTemplateRow.getClone();
        this.source.openCore();
        if (this.isInSortedOrder && this.distinct) {
            this.currSortedRow = this.getNextRowFromRS();
            if (this.currSortedRow != null) {
                this.currSortedRow = this.currSortedRow.getClone();
            }
        } else {
            this.scanController = this.loadSorter();
            this.sorted = true;
        }
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public final void setMaxSortingLimit(long limit) {
        this.maxSortLimit = limit;
    }

    private ScanController loadSorter() throws StandardException {
        ExecRow inputRow;
        boolean inOrder = this.order.length == 0 || this.isInSortedOrder;
        int inputRowCountEstimate = (int)this.optimizerEstimatedRowCount;
        TransactionController tc = this.getTransactionController();
        long sortId = tc.createSort(null, this.sortTemplateRow, this.order, this.observer, inOrder, inputRowCountEstimate, this.maxRowSize, this.maxSortLimit);
        this.sorter = tc.openSort(sortId);
        this.genericSortId = sortId;
        this.dropGenericSort = true;
        while ((inputRow = this.getNextRowFromRS()) != null) {
            this.sorter.insert(inputRow);
        }
        this.source.close(false);
        this.sortProperties = this.sorter.getSortInfo().getAllSortInfo(this.sortProperties);
        this.sorter.completedInserts();
        return tc.openSortScan(sortId, this.activation.getResultSetHoldability());
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isInSortedOrder && this.distinct) {
            if (this.currSortedRow == null) {
                if (this.statisticsTimingOn) {
                    this.nextTime += this.getElapsedNanos(this.beginTime);
                }
                return null;
            }
            if (!this.nextCalled) {
                this.nextCalled = true;
                this.numColumns = this.currSortedRow.getRowArray().length;
                if (this.statisticsTimingOn) {
                    this.nextTime += this.getElapsedNanos(this.beginTime);
                }
                ++this.rowsReturned;
                this.setCurrentRow(this.currSortedRow);
                return this.currSortedRow;
            }
            ExecRow sortResult = this.getNextRowFromRS();
            while (sortResult != null) {
                if (!this.filterRow(this.currSortedRow, sortResult)) {
                    this.currSortedRow = sortResult.getClone();
                    this.setCurrentRow(this.currSortedRow);
                    if (this.statisticsTimingOn) {
                        this.nextTime += this.getElapsedNanos(this.beginTime);
                    }
                    ++this.rowsReturned;
                    return this.currSortedRow;
                }
                sortResult = this.getNextRowFromRS();
            }
            this.currSortedRow = null;
            if (this.statisticsTimingOn) {
                this.nextTime += this.getElapsedNanos(this.beginTime);
            }
            return null;
        }
        ExecRow sortResult = this.getNextRowFromRS();
        if (sortResult != null) {
            this.setCurrentRow(sortResult);
            ++this.rowsReturned;
        }
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return sortResult;
    }

    private boolean filterRow(ExecRow currRow, ExecRow newRow) throws StandardException {
        for (int index = 1; index <= this.numColumns; ++index) {
            DataValueDescriptor newOrderable;
            DataValueDescriptor currOrderable = currRow.getColumn(index);
            if (currOrderable.compare(2, newOrderable = newRow.getColumn(index), true, true)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            this.clearCurrentRow();
            this.sortResultRow = null;
            this.sorter = null;
            this.closeSource();
            if (this.dropGenericSort) {
                this.getTransactionController().dropSort(this.genericSortId);
                this.dropGenericSort = false;
            }
            super.close(cleanupOnError);
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of SortResultSet repeated");
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
        this.isOpen = false;
    }

    @Override
    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (type == 0) {
            return time - this.originalSource.getTimeSpent(1, timeType);
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        RowLocation rl = this.scanController.newRowLocationTemplate();
        rl = this.scanController.fetchLocation(rl);
        return rl;
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        SanityManager.ASSERT((boolean)this.isOpen, (String)"SortResultSet expected to be open");
        return this.currentRow;
    }

    private ExecRow getNextRowFromRS() throws StandardException {
        return this.scanController == null ? this.getRowFromResultSet() : this.getRowFromSorter();
    }

    private ExecRow getRowFromResultSet() throws StandardException {
        this.source.releasePreviousByteSource();
        ExecRow sourceRow = this.source.getNextRowCore();
        if (sourceRow != null) {
            ++this.rowsInput;
        }
        return sourceRow;
    }

    private ExecRow getRowFromSorter() throws StandardException {
        this.checkCancellationFlag();
        ExecRow inputRow = null;
        if (this.scanController.next()) {
            this.currentRow = this.sortResultRow = this.scanController.fetchRow(this.sortResultRow);
            inputRow = this.sortResultRow;
        }
        return inputRow;
    }

    private void closeSource() throws StandardException {
        if (this.scanController == null) {
            this.source.close(false);
        } else {
            this.scanController.close();
            this.scanController = null;
        }
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        this.scanController.upgradeCurrentRowLocationLockToWrite();
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        if (localTXState != null) {
            this.scanController.releaseCurrentRowLocationReadLock();
        }
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        if (this.source != null) {
            visitor.setNumberOfChildren(1);
        } else {
            visitor.setNumberOfChildren(0);
        }
        visitor.visit(this);
        if (this.source != null) {
            this.source.accept(visitor);
        }
    }

    @Override
    public boolean isReplicateIfSetOpSupported() throws StandardException {
        SanityManager.ASSERT((boolean)(this.source instanceof BasicNoPutResultSetImpl), (String)"Member 'source' is expected to be of type BasicNoPutResultSetImpl");
        return ((BasicNoPutResultSetImpl)this.source).isReplicateIfSetOpSupported();
    }

    @Override
    public void resetStatistics() {
        this.rowsInput = 0;
        this.rowsReturned = 0;
        super.resetStatistics();
        this.source.resetStatistics();
    }

    public NoPutResultSet getSource() {
        return this.source;
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "GROUPBY");
        if (this.source != null) {
            this.source.buildQueryPlan(builder, context.pushContext());
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber + " with source = " + (this.source != null ? this.source.getClass().getSimpleName() : null) + " and source ResultSetNumber = " + (this.source != null ? this.source.resultSetNumber() : -1)));
        }
    }
}

