/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.sql.execute.GfxdSubqueryResultSet;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ResultSetStatisticsFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.RunTimeStatistics;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AnyResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CallStatementResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CurrentOfResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DeleteCascadeResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DeleteResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DeleteVTIResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DependentResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DistinctScalarAggregateResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DistinctScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GroupedAggregateResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.HashJoinResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.HashLeftOuterJoinResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.HashScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.HashTableResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexRowToBaseRowResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.InsertResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.InsertVTIResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.LastIndexKeyResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.MaterializedResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NestedLoopJoinResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NestedLoopLeftOuterJoinResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NormalizeResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.OnceResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ProjectRestrictResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RowCountResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RowResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ScalarAggregateResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ScrollInsensitiveResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.SetOpResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.SortResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TableScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.UnionResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.UpdateResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.VTIResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.WindowResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealAnyResultSetStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealCurrentOfStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealDeleteCascadeResultSetStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealDeleteResultSetStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealDeleteVTIResultSetStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealDistinctScalarAggregateStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealDistinctScanStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealGroupedAggregateStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealHashJoinStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealHashLeftOuterJoinStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealHashScanStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealHashTableStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealIndexRowToBaseRowStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealInsertResultSetStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealInsertVTIResultSetStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealLastIndexKeyScanStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealMaterializedResultSetStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealNestedLoopJoinStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealNestedLoopLeftOuterJoinStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealNoRowsResultSetStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealNormalizeResultSetStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealOnceResultSetStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealProjectRestrictStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealRowCountStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealRowResultSetStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealScalarAggregateStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealScrollInsensitiveResultSetStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealSetOpResultSetStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealSortStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealTableScanStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealUnionResultSetStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealUpdateResultSetStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealVTIStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealWindowResultSetStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.ResultSetStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RunTimeStatisticsImpl;

public class RealResultSetStatisticsFactory
implements ResultSetStatisticsFactory {
    private final boolean TraceMemEstimation = SanityManager.DEBUG_ON((String)"TraceMemoryEstimation");

    @Override
    public RunTimeStatistics getRunTimeStatistics(Activation activation, ResultSet rs, NoPutResultSet[] subqueryTrackingArray) throws StandardException {
        ExecPreparedStatement preStmt = activation.getPreparedStatement();
        if (preStmt == null) {
            return null;
        }
        ResultSetStatistics topResultSetStatistics = rs instanceof NoPutResultSet ? this.getResultSetStatistics((NoPutResultSet)rs) : this.getResultSetStatistics(rs);
        int subqueryTrackingArrayLength = subqueryTrackingArray == null ? 0 : subqueryTrackingArray.length;
        ResultSetStatistics[] subqueryRSS = new ResultSetStatistics[subqueryTrackingArrayLength];
        boolean anyAttached = false;
        for (int index = 0; index < subqueryTrackingArrayLength; ++index) {
            if (subqueryTrackingArray[index] == null || subqueryTrackingArray[index].getPointOfAttachment() != -1) continue;
            subqueryRSS[index] = this.getResultSetStatistics(subqueryTrackingArray[index]);
            anyAttached = true;
        }
        if (!anyAttached) {
            subqueryRSS = null;
        }
        return new RunTimeStatisticsImpl(preStmt.getSPSName(), activation.getCursorName(), preStmt.getUserQueryString(activation.getLanguageConnectionContext()), preStmt.getCompileTimeInMillis(), preStmt.getParseTimeInMillis(), preStmt.getBindTimeInMillis(), preStmt.getOptimizeTimeInMillis(), preStmt.getGenerateTimeInMillis(), rs.getExecuteTime(), preStmt.getBeginCompileTimestamp(), preStmt.getEndCompileTimestamp(), rs.getBeginExecutionTimestamp(), rs.getEndExecutionTimestamp(), subqueryRSS, topResultSetStatistics);
    }

    @Override
    public ResultSetStatistics getResultSetStatistics(ResultSet rs) {
        if (!rs.returnsRows()) {
            return this.getNoRowsResultSetStatistics(rs);
        }
        if (rs instanceof NoPutResultSet) {
            return this.getResultSetStatistics((NoPutResultSet)rs);
        }
        return null;
    }

    @Override
    public ResultSetStatistics getNoRowsResultSetStatistics(ResultSet rs) {
        RealNoRowsResultSetStatistics retval = null;
        if (rs instanceof InsertResultSet) {
            InsertResultSet irs = (InsertResultSet)rs;
            retval = new RealInsertResultSetStatistics(irs.rowCount, irs.constants.deferred, irs.constants.irgs.length, irs.userSpecifiedBulkInsert, irs.bulkInsertPerformed, irs.constants.lockMode == 7, irs.getExecuteTime(), this.getResultSetStatistics(irs.savedSource));
            irs.savedSource = null;
        } else if (rs instanceof InsertVTIResultSet) {
            InsertVTIResultSet iVTIrs = (InsertVTIResultSet)rs;
            retval = new RealInsertVTIResultSetStatistics(iVTIrs.rowCount, iVTIrs.constants.deferred, iVTIrs.getExecuteTime(), this.getResultSetStatistics(iVTIrs.savedSource));
            iVTIrs.savedSource = null;
        } else if (rs instanceof UpdateResultSet) {
            UpdateResultSet urs = (UpdateResultSet)rs;
            retval = new RealUpdateResultSetStatistics(urs.rowCount, urs.constants.deferred, urs.constants.irgs.length, urs.constants.lockMode == 7, urs.getExecuteTime(), this.getResultSetStatistics(urs.savedSource));
            urs.savedSource = null;
        } else if (rs instanceof DeleteCascadeResultSet) {
            DeleteCascadeResultSet dcrs = (DeleteCascadeResultSet)rs;
            int dependentTrackingArrayLength = dcrs.dependentResultSets == null ? 0 : dcrs.dependentResultSets.length;
            ResultSetStatistics[] dependentTrackingArray = new ResultSetStatistics[dependentTrackingArrayLength];
            boolean anyAttached = false;
            for (int index = 0; index < dependentTrackingArrayLength; ++index) {
                if (dcrs.dependentResultSets[index] == null) continue;
                dependentTrackingArray[index] = this.getResultSetStatistics(dcrs.dependentResultSets[index]);
                anyAttached = true;
            }
            if (!anyAttached) {
                dependentTrackingArray = null;
            }
            retval = new RealDeleteCascadeResultSetStatistics(dcrs.rowCount, dcrs.constants.deferred, dcrs.constants.irgs.length, dcrs.constants.lockMode == 7, dcrs.getExecuteTime(), this.getResultSetStatistics(dcrs.savedSource), dependentTrackingArray);
            dcrs.savedSource = null;
        } else if (rs instanceof DeleteResultSet) {
            DeleteResultSet drs = (DeleteResultSet)rs;
            retval = new RealDeleteResultSetStatistics(drs.rowCount, drs.constants.deferred, drs.constants.irgs.length, drs.constants.lockMode == 7, drs.getExecuteTime(), this.getResultSetStatistics(drs.savedSource));
            drs.savedSource = null;
        } else if (rs instanceof DeleteVTIResultSet) {
            DeleteVTIResultSet dVTIrs = (DeleteVTIResultSet)rs;
            retval = new RealDeleteVTIResultSetStatistics(dVTIrs.rowCount, dVTIrs.getExecuteTime(), this.getResultSetStatistics(dVTIrs.savedSource));
            dVTIrs.savedSource = null;
        }
        return retval;
    }

    @Override
    public ResultSetStatistics getResultSetStatistics(NoPutResultSet rs) {
        if (rs instanceof ProjectRestrictResultSet) {
            ProjectRestrictResultSet prrs = (ProjectRestrictResultSet)rs;
            int subqueryTrackingArrayLength = prrs.subqueryTrackingArray == null ? 0 : prrs.subqueryTrackingArray.length;
            ResultSetStatistics[] subqueryTrackingArray = new ResultSetStatistics[subqueryTrackingArrayLength];
            boolean anyAttached = false;
            for (int index = 0; index < subqueryTrackingArrayLength; ++index) {
                if (prrs.subqueryTrackingArray[index] == null || prrs.subqueryTrackingArray[index].getPointOfAttachment() != prrs.resultSetNumber) continue;
                subqueryTrackingArray[index] = this.getResultSetStatistics(prrs.subqueryTrackingArray[index]);
                anyAttached = true;
            }
            if (!anyAttached) {
                subqueryTrackingArray = null;
            }
            return new RealProjectRestrictStatistics(prrs.numOpens, prrs.rowsSeen, prrs.rowsFiltered, prrs.constructorTime, prrs.openTime, prrs.nextTime, prrs.closeTime, prrs.resultSetNumber, prrs.restrictionTime, prrs.projectionTime, subqueryTrackingArray, prrs.restriction != null, prrs.doesProjection, prrs.optimizerEstimatedRowCount, prrs.optimizerEstimatedCost, this.getResultSetStatistics(prrs.source));
        }
        if (rs instanceof RowCountResultSet) {
            RowCountResultSet rcrs = (RowCountResultSet)rs;
            return new RealRowCountStatistics(rcrs.numOpens, rcrs.rowsSeen, rcrs.rowsFiltered, rcrs.constructorTime, rcrs.openTime, rcrs.nextTime, rcrs.closeTime, rcrs.resultSetNumber, rcrs.optimizerEstimatedRowCount, rcrs.optimizerEstimatedCost, this.getResultSetStatistics(rcrs.source));
        }
        if (rs instanceof SortResultSet) {
            SortResultSet srs = (SortResultSet)rs;
            return new RealSortStatistics(srs.numOpens, srs.rowsSeen, srs.rowsFiltered, srs.constructorTime, srs.openTime, srs.nextTime, srs.closeTime, srs.resultSetNumber, srs.rowsInput, srs.rowsReturned, srs.distinct, srs.isInSortedOrder, srs.sortProperties, srs.optimizerEstimatedRowCount, srs.optimizerEstimatedCost, this.getResultSetStatistics(srs.getSource()));
        }
        if (rs instanceof DistinctScalarAggregateResultSet) {
            DistinctScalarAggregateResultSet dsars = (DistinctScalarAggregateResultSet)rs;
            return new RealDistinctScalarAggregateStatistics(dsars.numOpens, dsars.rowsSeen, dsars.rowsFiltered, dsars.constructorTime, dsars.openTime, dsars.nextTime, dsars.closeTime, dsars.resultSetNumber, dsars.rowsInput, dsars.optimizerEstimatedRowCount, dsars.optimizerEstimatedCost, this.getResultSetStatistics(dsars.source));
        }
        if (rs instanceof ScalarAggregateResultSet) {
            ScalarAggregateResultSet sars = (ScalarAggregateResultSet)rs;
            return new RealScalarAggregateStatistics(sars.numOpens, sars.rowsSeen, sars.rowsFiltered, sars.constructorTime, sars.openTime, sars.nextTime, sars.closeTime, sars.resultSetNumber, sars.singleInputRow, sars.rowsInput, sars.optimizerEstimatedRowCount, sars.optimizerEstimatedCost, this.getResultSetStatistics(sars.source));
        }
        if (rs instanceof GroupedAggregateResultSet) {
            GroupedAggregateResultSet gars = (GroupedAggregateResultSet)rs;
            return new RealGroupedAggregateStatistics(gars.numOpens, gars.rowsSeen, gars.rowsFiltered, gars.constructorTime, gars.openTime, gars.nextTime, gars.closeTime, gars.resultSetNumber, gars.rowsInput, gars.hasDistinctAggregate, gars.isInSortedOrder, gars.sortProperties, gars.optimizerEstimatedRowCount, gars.optimizerEstimatedCost, this.getResultSetStatistics(gars.source));
        }
        if (rs instanceof TableScanResultSet) {
            boolean instantaneousLocks = false;
            TableScanResultSet tsrs = (TableScanResultSet)rs;
            String startPosition = null;
            String stopPosition = null;
            String isolationLevel = null;
            String lockString = null;
            String lockRequestString = null;
            switch (tsrs.isolationLevel) {
                case 5: {
                    isolationLevel = MessageService.getTextMessage("42Z80.U");
                    break;
                }
                case 4: {
                    isolationLevel = MessageService.getTextMessage("42Z92");
                    break;
                }
                case 3: {
                    instantaneousLocks = true;
                }
                case 2: {
                    isolationLevel = MessageService.getTextMessage("42Z81.U");
                    break;
                }
                case 1: {
                    isolationLevel = MessageService.getTextMessage("42Z9A");
                }
            }
            lockString = tsrs.forUpdate() ? MessageService.getTextMessage("42Z82.U") : (instantaneousLocks ? MessageService.getTextMessage("42Z83.U") : MessageService.getTextMessage("42Z84.U"));
            switch (tsrs.lockMode) {
                case 7: {
                    lockRequestString = lockString + " " + MessageService.getTextMessage("42Z85.U");
                    break;
                }
                case 6: {
                    lockRequestString = lockString + " " + MessageService.getTextMessage("42Z86.U");
                }
            }
            if (tsrs.indexName != null) {
                startPosition = tsrs.startPositionString;
                if (startPosition == null) {
                    startPosition = tsrs.printStartPosition();
                }
                if ((stopPosition = tsrs.stopPositionString) == null) {
                    stopPosition = tsrs.printStopPosition();
                }
            }
            return new RealTableScanStatistics(tsrs.numOpens, tsrs.rowsSeen, tsrs.rowsFiltered, tsrs.constructorTime, tsrs.openTime, tsrs.nextTime, tsrs.closeTime, tsrs.resultSetNumber, tsrs.tableName, tsrs.userSuppliedOptimizerOverrides, tsrs.indexName, tsrs.isConstraint(), TableScanResultSet.printQualifiers(tsrs.qualifiers, true), tsrs.getScanProperties(), startPosition, stopPosition, isolationLevel, lockRequestString, tsrs.rowsPerRead, tsrs.coarserLock(), tsrs.optimizerEstimatedRowCount, tsrs.optimizerEstimatedCost);
        }
        if (rs instanceof LastIndexKeyResultSet) {
            LastIndexKeyResultSet lrs = (LastIndexKeyResultSet)rs;
            String isolationLevel = null;
            String lockRequestString = null;
            switch (lrs.isolationLevel) {
                case 5: {
                    isolationLevel = MessageService.getTextMessage("42Z80.U");
                    break;
                }
                case 4: {
                    isolationLevel = MessageService.getTextMessage("42Z92");
                    break;
                }
                case 2: 
                case 3: {
                    isolationLevel = MessageService.getTextMessage("42Z81.U");
                    break;
                }
                case 1: {
                    isolationLevel = MessageService.getTextMessage("42Z9A");
                }
            }
            switch (lrs.lockMode) {
                case 7: {
                    lockRequestString = MessageService.getTextMessage("42Z87.U");
                    break;
                }
                case 6: {
                    lockRequestString = MessageService.getTextMessage("42Z88.U");
                }
            }
            return new RealLastIndexKeyScanStatistics(lrs.numOpens, lrs.constructorTime, lrs.openTime, lrs.nextTime, lrs.closeTime, lrs.resultSetNumber, lrs.tableName, lrs.indexName, isolationLevel, lockRequestString, lrs.optimizerEstimatedRowCount, lrs.optimizerEstimatedCost);
        }
        if (rs instanceof HashLeftOuterJoinResultSet) {
            HashLeftOuterJoinResultSet hlojrs = (HashLeftOuterJoinResultSet)rs;
            return new RealHashLeftOuterJoinStatistics(hlojrs.numOpens, hlojrs.rowsSeen, hlojrs.rowsFiltered, hlojrs.constructorTime, hlojrs.openTime, hlojrs.nextTime, hlojrs.closeTime, hlojrs.resultSetNumber, hlojrs.rowsSeenLeft, hlojrs.rowsSeenRight, hlojrs.rowsReturned, hlojrs.restrictionTime, hlojrs.optimizerEstimatedRowCount, hlojrs.optimizerEstimatedCost, hlojrs.userSuppliedOptimizerOverrides, this.getResultSetStatistics(hlojrs.leftResultSet), this.getResultSetStatistics(hlojrs.rightResultSet), hlojrs.emptyRightRowsReturned);
        }
        if (rs instanceof NestedLoopLeftOuterJoinResultSet) {
            NestedLoopLeftOuterJoinResultSet nllojrs = (NestedLoopLeftOuterJoinResultSet)rs;
            return new RealNestedLoopLeftOuterJoinStatistics(nllojrs.numOpens, nllojrs.rowsSeen, nllojrs.rowsFiltered, nllojrs.constructorTime, nllojrs.openTime, nllojrs.nextTime, nllojrs.closeTime, nllojrs.resultSetNumber, nllojrs.rowsSeenLeft, nllojrs.rowsSeenRight, nllojrs.rowsReturned, nllojrs.restrictionTime, nllojrs.optimizerEstimatedRowCount, nllojrs.optimizerEstimatedCost, nllojrs.userSuppliedOptimizerOverrides, this.getResultSetStatistics(nllojrs.leftResultSet), this.getResultSetStatistics(nllojrs.rightResultSet), nllojrs.emptyRightRowsReturned);
        }
        if (rs instanceof HashJoinResultSet) {
            HashJoinResultSet hjrs = (HashJoinResultSet)rs;
            return new RealHashJoinStatistics(hjrs.numOpens, hjrs.rowsSeen, hjrs.rowsFiltered, hjrs.constructorTime, hjrs.openTime, hjrs.nextTime, hjrs.closeTime, hjrs.resultSetNumber, hjrs.rowsSeenLeft, hjrs.rowsSeenRight, hjrs.rowsReturned, hjrs.restrictionTime, hjrs.oneRowRightSide, hjrs.optimizerEstimatedRowCount, hjrs.optimizerEstimatedCost, hjrs.userSuppliedOptimizerOverrides, this.getResultSetStatistics(hjrs.leftResultSet), this.getResultSetStatistics(hjrs.rightResultSet));
        }
        if (rs instanceof NestedLoopJoinResultSet) {
            NestedLoopJoinResultSet nljrs = (NestedLoopJoinResultSet)rs;
            return new RealNestedLoopJoinStatistics(nljrs.numOpens, nljrs.rowsSeen, nljrs.rowsFiltered, nljrs.constructorTime, nljrs.openTime, nljrs.nextTime, nljrs.closeTime, nljrs.resultSetNumber, nljrs.rowsSeenLeft, nljrs.rowsSeenRight, nljrs.rowsReturned, nljrs.restrictionTime, nljrs.oneRowRightSide, nljrs.optimizerEstimatedRowCount, nljrs.optimizerEstimatedCost, nljrs.userSuppliedOptimizerOverrides, this.getResultSetStatistics(nljrs.leftResultSet), this.getResultSetStatistics(nljrs.rightResultSet));
        }
        if (rs instanceof IndexRowToBaseRowResultSet) {
            IndexRowToBaseRowResultSet irtbrrs = (IndexRowToBaseRowResultSet)rs;
            return new RealIndexRowToBaseRowStatistics(irtbrrs.numOpens, irtbrrs.rowsSeen, irtbrrs.rowsFiltered, irtbrrs.constructorTime, irtbrrs.openTime, irtbrrs.nextTime, irtbrrs.closeTime, irtbrrs.resultSetNumber, irtbrrs.indexName, irtbrrs.accessedHeapCols, irtbrrs.optimizerEstimatedRowCount, irtbrrs.optimizerEstimatedCost, this.getResultSetStatistics(irtbrrs.source));
        }
        if (rs instanceof WindowResultSet) {
            WindowResultSet wrs = (WindowResultSet)rs;
            return new RealWindowResultSetStatistics(wrs.numOpens, wrs.rowsSeen, wrs.rowsFiltered, wrs.constructorTime, wrs.openTime, wrs.nextTime, wrs.closeTime, wrs.resultSetNumber, wrs.optimizerEstimatedRowCount, wrs.optimizerEstimatedCost, this.getResultSetStatistics(wrs.source));
        }
        if (rs instanceof RowResultSet) {
            RowResultSet rrs = (RowResultSet)rs;
            return new RealRowResultSetStatistics(rrs.numOpens, rrs.rowsSeen, rrs.rowsFiltered, rrs.constructorTime, rrs.openTime, rrs.nextTime, rrs.closeTime, rrs.resultSetNumber, rrs.rowsReturned, rrs.optimizerEstimatedRowCount, rrs.optimizerEstimatedCost);
        }
        if (rs instanceof SetOpResultSet) {
            SetOpResultSet srs = (SetOpResultSet)rs;
            return new RealSetOpResultSetStatistics(srs.getOpType(), srs.numOpens, srs.rowsSeen, srs.rowsFiltered, srs.constructorTime, srs.openTime, srs.nextTime, srs.closeTime, srs.getResultSetNumber(), srs.getRowsSeenLeft(), srs.getRowsSeenRight(), srs.getRowsReturned(), srs.optimizerEstimatedRowCount, srs.optimizerEstimatedCost, this.getResultSetStatistics(srs.getLeftSourceInput()), this.getResultSetStatistics(srs.getRightSourceInput()));
        }
        if (rs instanceof UnionResultSet) {
            UnionResultSet urs = (UnionResultSet)rs;
            return new RealUnionResultSetStatistics(urs.numOpens, urs.rowsSeen, urs.rowsFiltered, urs.constructorTime, urs.openTime, urs.nextTime, urs.closeTime, urs.resultSetNumber, urs.rowsSeenLeft, urs.rowsSeenRight, urs.rowsReturned, urs.optimizerEstimatedRowCount, urs.optimizerEstimatedCost, this.getResultSetStatistics(urs.source1), this.getResultSetStatistics(urs.source2));
        }
        if (rs instanceof AnyResultSet) {
            AnyResultSet ars = (AnyResultSet)rs;
            return new RealAnyResultSetStatistics(ars.numOpens, ars.rowsSeen, ars.rowsFiltered, ars.constructorTime, ars.openTime, ars.nextTime, ars.closeTime, ars.resultSetNumber, ars.subqueryNumber, ars.pointOfAttachment, ars.optimizerEstimatedRowCount, ars.optimizerEstimatedCost, this.getResultSetStatistics(ars.source));
        }
        if (rs instanceof OnceResultSet) {
            OnceResultSet ors = (OnceResultSet)rs;
            return new RealOnceResultSetStatistics(ors.numOpens, ors.rowsSeen, ors.rowsFiltered, ors.constructorTime, ors.openTime, ors.nextTime, ors.closeTime, ors.resultSetNumber, ors.subqueryNumber, ors.pointOfAttachment, ors.optimizerEstimatedRowCount, ors.optimizerEstimatedCost, this.getResultSetStatistics(ors.source));
        }
        if (rs instanceof NormalizeResultSet) {
            NormalizeResultSet nrs = (NormalizeResultSet)rs;
            return new RealNormalizeResultSetStatistics(nrs.numOpens, nrs.rowsSeen, nrs.rowsFiltered, nrs.constructorTime, nrs.openTime, nrs.nextTime, nrs.closeTime, nrs.resultSetNumber, nrs.optimizerEstimatedRowCount, nrs.optimizerEstimatedCost, this.getResultSetStatistics(nrs.source));
        }
        if (rs instanceof MaterializedResultSet) {
            MaterializedResultSet mrs = (MaterializedResultSet)rs;
            return new RealMaterializedResultSetStatistics(mrs.numOpens, mrs.rowsSeen, mrs.rowsFiltered, mrs.constructorTime, mrs.openTime, mrs.nextTime, mrs.closeTime, mrs.createTCTime, mrs.fetchTCTime, mrs.resultSetNumber, mrs.optimizerEstimatedRowCount, mrs.optimizerEstimatedCost, this.getResultSetStatistics(mrs.source));
        }
        if (rs instanceof ScrollInsensitiveResultSet) {
            ScrollInsensitiveResultSet sirs = (ScrollInsensitiveResultSet)rs;
            return new RealScrollInsensitiveResultSetStatistics(sirs.numOpens, sirs.rowsSeen, sirs.rowsFiltered, sirs.constructorTime, sirs.openTime, sirs.nextTime, sirs.closeTime, sirs.numFromHashTable, sirs.numToHashTable, sirs.resultSetNumber, sirs.optimizerEstimatedRowCount, sirs.optimizerEstimatedCost, this.getResultSetStatistics(sirs.source));
        }
        if (rs instanceof CurrentOfResultSet) {
            CurrentOfResultSet cors = (CurrentOfResultSet)rs;
            return new RealCurrentOfStatistics(cors.numOpens, cors.rowsSeen, cors.rowsFiltered, cors.constructorTime, cors.openTime, cors.nextTime, cors.closeTime, cors.resultSetNumber);
        }
        if (rs instanceof HashScanResultSet) {
            boolean instantaneousLocks = false;
            HashScanResultSet hsrs = (HashScanResultSet)rs;
            String startPosition = null;
            String stopPosition = null;
            String isolationLevel = null;
            String lockString = null;
            switch (hsrs.isolationLevel) {
                case 5: {
                    isolationLevel = MessageService.getTextMessage("42Z80.U");
                    break;
                }
                case 4: {
                    isolationLevel = MessageService.getTextMessage("42Z92");
                    break;
                }
                case 3: {
                    instantaneousLocks = true;
                }
                case 2: {
                    isolationLevel = MessageService.getTextMessage("42Z81.U");
                }
            }
            lockString = hsrs.forUpdate ? MessageService.getTextMessage("42Z82.U") : (instantaneousLocks ? MessageService.getTextMessage("42Z83.U") : MessageService.getTextMessage("42Z84.U"));
            switch (hsrs.lockMode) {
                case 7: {
                    lockString = lockString + " " + MessageService.getTextMessage("42Z85.U");
                    break;
                }
                case 6: {
                    lockString = lockString + " " + MessageService.getTextMessage("42Z86.U");
                }
            }
            if (hsrs.indexName != null) {
                startPosition = hsrs.startPositionString;
                if (startPosition == null) {
                    startPosition = hsrs.printStartPosition();
                }
                if ((stopPosition = hsrs.stopPositionString) == null) {
                    stopPosition = hsrs.printStopPosition();
                }
            }
            if (rs instanceof DistinctScanResultSet) {
                return new RealDistinctScanStatistics(hsrs.numOpens, hsrs.rowsSeen, hsrs.rowsFiltered, hsrs.constructorTime, hsrs.openTime, hsrs.nextTime, hsrs.closeTime, hsrs.resultSetNumber, hsrs.tableName, hsrs.indexName, hsrs.isConstraint, hsrs.hashtableSize, hsrs.keyColumns, HashScanResultSet.printQualifiers(hsrs.scanQualifiers, true), HashScanResultSet.printQualifiers(hsrs.nextQualifiers, true), hsrs.getScanProperties(), startPosition, stopPosition, isolationLevel, lockString, hsrs.optimizerEstimatedRowCount, hsrs.optimizerEstimatedCost);
            }
            return new RealHashScanStatistics(hsrs.numOpens, hsrs.rowsSeen, hsrs.rowsFiltered, hsrs.constructorTime, hsrs.openTime, hsrs.nextTime, hsrs.closeTime, hsrs.resultSetNumber, hsrs.tableName, hsrs.indexName, hsrs.isConstraint, hsrs.hashtableSize, hsrs.keyColumns, HashScanResultSet.printQualifiers(hsrs.scanQualifiers, true), HashScanResultSet.printQualifiers(hsrs.nextQualifiers, true), hsrs.getScanProperties(), startPosition, stopPosition, isolationLevel, lockString, hsrs.optimizerEstimatedRowCount, hsrs.optimizerEstimatedCost);
        }
        if (rs instanceof HashTableResultSet) {
            HashTableResultSet htrs = (HashTableResultSet)rs;
            int subqueryTrackingArrayLength = htrs.subqueryTrackingArray == null ? 0 : htrs.subqueryTrackingArray.length;
            ResultSetStatistics[] subqueryTrackingArray = new ResultSetStatistics[subqueryTrackingArrayLength];
            boolean anyAttached = false;
            for (int index = 0; index < subqueryTrackingArrayLength; ++index) {
                if (htrs.subqueryTrackingArray[index] == null || htrs.subqueryTrackingArray[index].getPointOfAttachment() != htrs.resultSetNumber) continue;
                subqueryTrackingArray[index] = this.getResultSetStatistics(htrs.subqueryTrackingArray[index]);
                anyAttached = true;
            }
            if (!anyAttached) {
                subqueryTrackingArray = null;
            }
            return new RealHashTableStatistics(htrs.numOpens, htrs.rowsSeen, htrs.rowsFiltered, htrs.constructorTime, htrs.openTime, htrs.nextTime, htrs.closeTime, htrs.resultSetNumber, htrs.hashtableSize, htrs.keyColumns, HashScanResultSet.printQualifiers(htrs.nextQualifiers, true), htrs.scanProperties, htrs.optimizerEstimatedRowCount, htrs.optimizerEstimatedCost, subqueryTrackingArray, this.getResultSetStatistics(htrs.source));
        }
        if (rs instanceof VTIResultSet) {
            VTIResultSet vtirs = (VTIResultSet)rs;
            return new RealVTIStatistics(vtirs.numOpens, vtirs.rowsSeen, vtirs.rowsFiltered, vtirs.constructorTime, vtirs.openTime, vtirs.nextTime, vtirs.closeTime, vtirs.resultSetNumber, vtirs.javaClassName, vtirs.optimizerEstimatedRowCount, vtirs.optimizerEstimatedCost);
        }
        if (rs instanceof DependentResultSet) {
            boolean instantaneousLocks = false;
            DependentResultSet dsrs = (DependentResultSet)rs;
            String startPosition = null;
            String stopPosition = null;
            String isolationLevel = null;
            String lockString = null;
            String lockRequestString = null;
            switch (dsrs.isolationLevel) {
                case 5: {
                    isolationLevel = MessageService.getTextMessage("42Z80.U");
                    break;
                }
                case 4: {
                    isolationLevel = MessageService.getTextMessage("42Z92");
                    break;
                }
                case 3: {
                    instantaneousLocks = true;
                }
                case 2: {
                    isolationLevel = MessageService.getTextMessage("42Z81.U");
                    break;
                }
                case 1: {
                    isolationLevel = MessageService.getTextMessage("42Z9A");
                }
            }
            lockString = dsrs.forUpdate ? MessageService.getTextMessage("42Z82.U") : (instantaneousLocks ? MessageService.getTextMessage("42Z83.U") : MessageService.getTextMessage("42Z84.U"));
            switch (dsrs.lockMode) {
                case 7: {
                    lockRequestString = lockString + " " + MessageService.getTextMessage("42Z85.U");
                    break;
                }
                case 6: {
                    lockRequestString = lockString + " " + MessageService.getTextMessage("42Z86.U");
                }
            }
            startPosition = dsrs.startPositionString;
            if (startPosition == null) {
                startPosition = dsrs.printStartPosition();
            }
            if ((stopPosition = dsrs.stopPositionString) == null) {
                stopPosition = dsrs.printStopPosition();
            }
            return new RealTableScanStatistics(dsrs.numOpens, dsrs.rowsSeen, dsrs.rowsFiltered, dsrs.constructorTime, dsrs.openTime, dsrs.nextTime, dsrs.closeTime, dsrs.resultSetNumber, dsrs.tableName, null, dsrs.indexName, dsrs.isConstraint, dsrs.printQualifiers(), dsrs.getScanProperties(), startPosition, stopPosition, isolationLevel, lockRequestString, dsrs.rowsPerRead, dsrs.coarserLock, dsrs.optimizerEstimatedRowCount, dsrs.optimizerEstimatedCost);
        }
        return null;
    }

    @Override
    public long getResultSetMemoryUsage(ResultSet rs) throws StandardException {
        if (rs == null) {
            return 0L;
        }
        if (rs instanceof CallStatementResultSet) {
            if (((CallStatementResultSet)rs).isSysProc) {
                return 0L;
            }
            return 2L;
        }
        if (!rs.returnsRows()) {
            if (rs instanceof DeleteResultSet) {
                return 0L;
            }
            return 1L;
        }
        if (rs instanceof NoPutResultSet) {
            return this.getResultSetMemoryUsage((NoPutResultSet)rs, 0);
        }
        return 0L;
    }

    public long getResultSetMemoryUsage(NoPutResultSet rs, int depth) throws StandardException {
        long totalRowsMemory = 0L;
        StringBuilder logbuffer = null;
        if (this.TraceMemEstimation) {
            logbuffer = new StringBuilder(100);
            for (int i = depth; i > 0; --i) {
                logbuffer.append("\t");
            }
            SanityManager.DEBUG_PRINT((String)"TraceMemoryEstimation", (String)(logbuffer.toString() + "estimating " + rs.getClass().getSimpleName()));
        }
        if (rs instanceof ProjectRestrictResultSet) {
            ProjectRestrictResultSet prrs = (ProjectRestrictResultSet)rs;
            String indent = null;
            if (this.TraceMemEstimation) {
                indent = logbuffer.toString();
            }
            if (prrs.isTopResultSet && !prrs.doesProjection && prrs.currentRow instanceof AbstractCompactExecRow) {
                totalRowsMemory += (long)(prrs.rowsSeen - prrs.rowsFiltered) * (prrs.currentRow != null ? prrs.currentRow.estimateRowSize() : 1L);
            }
            int subqueryTrackingArrayLength = prrs.subqueryTrackingArray == null ? 0 : prrs.subqueryTrackingArray.length;
            for (int index = 0; index < subqueryTrackingArrayLength; ++index) {
                if (prrs.subqueryTrackingArray[index] == null || prrs.subqueryTrackingArray[index].getPointOfAttachment() != prrs.resultSetNumber) continue;
                totalRowsMemory += this.getResultSetMemoryUsage(prrs.subqueryTrackingArray[index], depth + 1);
                if (!this.TraceMemEstimation) continue;
                indent = indent + "\nsubquery[" + index + "] " + prrs.subqueryTrackingArray[index].getClass().getSimpleName() + "  " + totalRowsMemory + "\n";
            }
            totalRowsMemory += this.getResultSetMemoryUsage(prrs.source, depth + 1);
            if (this.TraceMemEstimation) {
                indent = indent + prrs.getClass().getSimpleName() + "  " + totalRowsMemory + "\n";
                SanityManager.DEBUG_PRINT((String)"TraceMemoryEstimation", (String)indent);
            }
        } else if (rs instanceof SortResultSet) {
            SortController sorter;
            SortResultSet srs = (SortResultSet)rs;
            totalRowsMemory = srs.isInSortedOrder && srs.distinct ? this.getResultSetMemoryUsage(srs.getSource(), depth + 1) : ((sorter = srs.sorter) != null ? sorter.estimateMemoryUsage(srs.sortResultRow) : (long)srs.rowsInput * (srs.sortResultRow != null ? srs.sortResultRow.estimateRowSize() : 1L));
            if (this.TraceMemEstimation) {
                String indent = logbuffer.toString();
                indent = indent + srs.getClass().getSimpleName() + "  " + totalRowsMemory;
                SanityManager.DEBUG_PRINT((String)"TraceMemoryEstimation", (String)indent);
            }
        } else if (rs instanceof DistinctScalarAggregateResultSet) {
            DistinctScalarAggregateResultSet dsars = (DistinctScalarAggregateResultSet)rs;
            totalRowsMemory = (long)dsars.rowsInput * (dsars.sortResultRow != null ? dsars.sortResultRow.estimateRowSize() : 1L);
            totalRowsMemory += this.getResultSetMemoryUsage(dsars.source, depth + 1);
        } else if (!(rs instanceof ScalarAggregateResultSet)) {
            if (rs instanceof GroupedAggregateResultSet) {
                GroupedAggregateResultSet gars = (GroupedAggregateResultSet)rs;
                totalRowsMemory = (long)gars.rowsInput * gars.estimateMemoryUsage();
                totalRowsMemory += this.getResultSetMemoryUsage(gars.source, depth + 1);
            } else if (rs instanceof TableScanResultSet) {
                TableScanResultSet tsrs = (TableScanResultSet)rs;
                long estimatedRowCount = 1L;
                long estimatedRowSize = 0L;
                long stat_numRows = 1L;
                try {
                    if (tsrs.scanController != null) {
                        estimatedRowCount = tsrs.scanController.getEstimatedRowCount();
                    }
                    if (tsrs.candidate != null) {
                        estimatedRowSize = tsrs.candidate.estimateRowSize();
                    }
                    totalRowsMemory = estimatedRowCount * estimatedRowSize;
                }
                catch (StandardException ignore) {
                    stat_numRows = tsrs.rowsSeen - tsrs.rowsFiltered;
                    if (tsrs.candidate != null) {
                        estimatedRowSize = tsrs.candidate.estimateRowSize();
                    }
                    totalRowsMemory = stat_numRows * estimatedRowSize;
                }
                if (this.TraceMemEstimation) {
                    String indent = logbuffer.toString();
                    indent = indent + tsrs.getClass().getSimpleName() + "  " + " estimatedRowCount=" + estimatedRowCount + " stat_numRows=" + stat_numRows + " esimatedRowSize=" + estimatedRowSize + " totalRowsMemory=" + totalRowsMemory;
                    SanityManager.DEBUG_PRINT((String)"TraceMemoryEstimation", (String)indent);
                }
            } else if (rs instanceof LastIndexKeyResultSet) {
                LastIndexKeyResultSet tsrs = (LastIndexKeyResultSet)rs;
            } else if (rs instanceof HashLeftOuterJoinResultSet) {
                HashLeftOuterJoinResultSet hlojrs = (HashLeftOuterJoinResultSet)rs;
                totalRowsMemory = this.getResultSetMemoryUsage(hlojrs.leftResultSet, depth + 1) + this.getResultSetMemoryUsage(hlojrs.rightResultSet, depth + 1) + (long)hlojrs.rowsReturned * (hlojrs.mergedRow != null ? hlojrs.mergedRow.estimateRowSize() : 1L);
            } else if (rs instanceof NestedLoopLeftOuterJoinResultSet) {
                NestedLoopLeftOuterJoinResultSet nllojrs = (NestedLoopLeftOuterJoinResultSet)rs;
                totalRowsMemory = this.getResultSetMemoryUsage(nllojrs.leftResultSet, depth + 1) + this.getResultSetMemoryUsage(nllojrs.rightResultSet, depth + 1) + (long)nllojrs.rowsReturned * (nllojrs.mergedRow != null ? nllojrs.mergedRow.estimateRowSize() : 1L);
            } else if (rs instanceof NestedLoopJoinResultSet) {
                NestedLoopJoinResultSet nljrs = (NestedLoopJoinResultSet)rs;
                totalRowsMemory = this.getResultSetMemoryUsage(nljrs.leftResultSet, depth + 1) + this.getResultSetMemoryUsage(nljrs.rightResultSet, depth + 1) + (long)nljrs.rowsReturned * (nljrs.mergedRow != null ? nljrs.mergedRow.estimateRowSize() : 1L);
            } else if (rs instanceof IndexRowToBaseRowResultSet) {
                IndexRowToBaseRowResultSet irtbrrs = (IndexRowToBaseRowResultSet)rs;
                totalRowsMemory = this.getResultSetMemoryUsage(irtbrrs.source, depth + 1) + (long)(irtbrrs.rowsSeen - irtbrrs.rowsFiltered) * (irtbrrs.currentRow != null ? irtbrrs.currentRow.estimateRowSize() : 1L);
                if (this.TraceMemEstimation) {
                    String indent = logbuffer.toString();
                    indent = indent + irtbrrs.getClass().getSimpleName() + "  " + "totalMemoryUsage=" + totalRowsMemory;
                    SanityManager.DEBUG_PRINT((String)"TraceMemoryEstimation", (String)indent);
                }
            } else if (rs instanceof WindowResultSet) {
                WindowResultSet irtbrrs = (WindowResultSet)rs;
            } else if (rs instanceof RowResultSet) {
                RowResultSet irtbrrs = (RowResultSet)rs;
            } else if (rs instanceof SetOpResultSet) {
                SetOpResultSet irtbrrs = (SetOpResultSet)rs;
            } else if (rs instanceof UnionResultSet) {
                UnionResultSet urs = (UnionResultSet)rs;
                totalRowsMemory = this.getResultSetMemoryUsage(urs.source1, depth + 1) + this.getResultSetMemoryUsage(urs.source2, depth + 1) + (long)urs.rowsReturned * (urs.currentRow != null ? urs.currentRow.estimateRowSize() : 1L);
                if (this.TraceMemEstimation) {
                    String indent = logbuffer.toString();
                    indent = indent + urs.getClass().getSimpleName() + "  " + "totalMemoryUsage=" + totalRowsMemory;
                    SanityManager.DEBUG_PRINT((String)"TraceMemoryEstimation", (String)indent);
                }
            } else if (rs instanceof AnyResultSet) {
                AnyResultSet urs = (AnyResultSet)rs;
            } else if (rs instanceof OnceResultSet) {
                OnceResultSet urs = (OnceResultSet)rs;
            } else if (rs instanceof NormalizeResultSet) {
                NormalizeResultSet urs = (NormalizeResultSet)rs;
            } else if (rs instanceof MaterializedResultSet) {
                MaterializedResultSet urs = (MaterializedResultSet)rs;
            } else if (rs instanceof ScrollInsensitiveResultSet) {
                ScrollInsensitiveResultSet urs = (ScrollInsensitiveResultSet)rs;
            } else if (rs instanceof CurrentOfResultSet) {
                CurrentOfResultSet urs = (CurrentOfResultSet)rs;
            } else if (rs instanceof HashScanResultSet) {
                HashScanResultSet hsrs = (HashScanResultSet)rs;
                String startPosition = null;
                String stopPosition = null;
                if (hsrs.indexName != null) {
                    startPosition = hsrs.startPositionString;
                    if (startPosition == null) {
                        startPosition = hsrs.printStartPosition();
                    }
                    if ((stopPosition = hsrs.stopPositionString) == null) {
                        stopPosition = hsrs.printStopPosition();
                    }
                }
                try {
                    totalRowsMemory = (long)(hsrs.hashtable != null ? hsrs.hashtable.size() : 1) * (hsrs.compactRow != null ? hsrs.compactRow.estimateRowSize() : 1L);
                }
                catch (StandardException estimatedRowSize) {
                    // empty catch block
                }
                if (this.TraceMemEstimation) {
                    String indent = logbuffer.toString();
                    indent = indent + hsrs.getClass().getSimpleName() + "  " + "totalMemoryUsage=" + totalRowsMemory;
                    SanityManager.DEBUG_PRINT((String)"TraceMemoryEstimation", (String)indent);
                }
            } else if (rs instanceof HashTableResultSet) {
                HashTableResultSet htrs = (HashTableResultSet)rs;
                int subqueryTrackingArrayLength = htrs.subqueryTrackingArray == null ? 0 : htrs.subqueryTrackingArray.length;
                for (int index = 0; index < subqueryTrackingArrayLength; ++index) {
                    if (htrs.subqueryTrackingArray[index] == null || htrs.subqueryTrackingArray[index].getPointOfAttachment() != htrs.resultSetNumber) continue;
                    totalRowsMemory += this.getResultSetMemoryUsage(htrs.subqueryTrackingArray[index], depth + 1);
                }
            } else if (rs instanceof VTIResultSet) {
                VTIResultSet htrs = (VTIResultSet)rs;
            } else if (rs instanceof DependentResultSet) {
                boolean instantaneousLocks = false;
                DependentResultSet dsrs = (DependentResultSet)rs;
                String startPosition = null;
                String stopPosition = null;
                Object isolationLevel = null;
                Object lockString = null;
                Object lockRequestString = null;
                startPosition = dsrs.startPositionString;
                if (startPosition == null) {
                    startPosition = dsrs.printStartPosition();
                }
                if ((stopPosition = dsrs.stopPositionString) == null) {
                    stopPosition = dsrs.printStopPosition();
                }
            } else if (rs instanceof GfxdSubqueryResultSet) {
                GfxdSubqueryResultSet ssrs = (GfxdSubqueryResultSet)rs;
                totalRowsMemory += ssrs.estimateMemoryUsage();
            }
        }
        return totalRowsMemory;
    }
}

