/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewayReceiverFactory;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.operations.ReceiverCreateOperation;
import com.pivotal.gemfirexd.internal.engine.ddl.ServerGroupsTableAttribute;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GfxdGatewayReceiverDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class CreateGatewayReceiverConstantAction
extends DDLConstantAction {
    private final String id;
    private final ServerGroupsTableAttribute serverGroups;
    private final int startPort;
    private final int endPort;
    private final String bindAddress;
    private final int maxTimeBetPings;
    private final int socketBufferSize;
    private String hostNameForSenders;
    public static final String REGION_PREFIX_FOR_CONFLATION = "__GFXD_INTERNAL_GATEWAYRECEIVER_";
    private static final String ipv4Pattern = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
    private static Pattern VALID_IPV4_PATTERN = null;

    CreateGatewayReceiverConstantAction(String id, ServerGroupsTableAttribute serverGroups, int startPort, int endPort, String bindAddress, int maxTimeBetPings, int socketBufferSize, String hostNameForSenders) throws StandardException {
        this.id = id;
        this.serverGroups = serverGroups;
        this.startPort = startPort;
        this.endPort = endPort;
        this.bindAddress = bindAddress;
        this.maxTimeBetPings = maxTimeBetPings;
        this.socketBufferSize = socketBufferSize;
        this.hostNameForSenders = this.determineHostNameForSenders(hostNameForSenders);
    }

    private String determineHostNameForSenders(String hostNameForSenders) throws StandardException {
        if (hostNameForSenders == null || hostNameForSenders.isEmpty()) {
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)"HostNameForSender is Empty");
            return null;
        }
        Matcher m1 = VALID_IPV4_PATTERN.matcher(hostNameForSenders);
        if (m1.matches()) {
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)"HostNameForSender is valid IPv4 address");
            return hostNameForSenders;
        }
        if (hostNameForSenders.equalsIgnoreCase("localhost")) {
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)"HostNameForSender is localhost");
            return "localhost";
        }
        Properties udp = Misc.getDistributedSystem().getConfig().getUserDefinedProps();
        if (udp == null) {
            throw StandardException.newException("22008.S", (Object)"User defined properties missing ", (Object)"CREATE GATEWAYRECEIVER");
        }
        String value = udp.getProperty("gemfirexd.custom." + hostNameForSenders);
        if (value == null) {
            throw StandardException.newException("22008.S", (Object)("Env property " + hostNameForSenders + " not defined for HOSTNAMEFORSENDERS"), (Object)"CREATE GATEWAYRECEIVER");
        }
        SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("HostNameForSender is custom property = " + value));
        value = value.replaceAll("^\"|\"$", "");
        return value;
    }

    public String toString() {
        return "CREATE GATEWAYRECEIVER " + this.id;
    }

    @Override
    public final String getSchemaName() {
        return "SYS";
    }

    @Override
    public final String getTableName() {
        return REGION_PREFIX_FOR_CONFLATION + this.id;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        if (!ServerGroupUtils.isDataStore()) {
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("Skipping create gateway receiver for " + this.id + " on JVM of kind " + GemFireXDUtils.getMyVMKind()));
            return;
        }
        Set<DistributedMember> members = null;
        members = this.serverGroups != null ? GemFireXDUtils.getGfxdAdvisor().adviseOperationNodes(this.serverGroups.getServerGroupSet()) : GemFireXDUtils.getGfxdAdvisor().adviseOperationNodes(null);
        GemFireCacheImpl cache = Misc.getGemFireCache();
        if (this.startPort > this.endPort) {
            throw StandardException.newException("22008.S", (Object)"Gateway start port is greater than end port", (Object)"CREATE GATEWAYRECEIVER");
        }
        if (this.startPort < 0 || this.endPort < 0 || this.startPort > 65535 || this.endPort > 65535) {
            throw StandardException.newException("22008.S", (Object)"Start/end port out of range (0-65535)", (Object)"CREATE GATEWAYRECEIVER");
        }
        if (cache.getGatewayReceiver(this.id) != null) {
            throw StandardException.newException("X0Y68.S", (Object)"GATEWAYRECEIVER", (Object)this.id);
        }
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        GemFireTransaction tc = (GemFireTransaction)lcc.getTransactionExecute();
        dd.startWriting(lcc);
        InternalDistributedMember myId = cache.getMyId();
        boolean self = members.remove(myId);
        if (self) {
            GatewayReceiverFactory factory = cache.createGatewayReceiverFactory();
            factory.setBindAddress(this.bindAddress);
            factory.setStartPort(this.startPort);
            factory.setEndPort(this.endPort);
            factory.setMaximumTimeBetweenPings(this.maxTimeBetPings);
            factory.setSocketBufferSize(this.socketBufferSize);
            factory.setHostnameForSenders(this.hostNameForSenders);
            GatewayReceiver rcvr = factory.create(this.id);
            ReceiverCreateOperation startOp = new ReceiverCreateOperation(rcvr, this.serverGroups);
            try {
                Misc.getMemStoreBooting().addPendingOperation(startOp, tc);
            }
            catch (IOException ioe) {
                if (ioe instanceof UnknownHostException) {
                    GatewayReceiver server = cache.getGatewayReceiver(this.id);
                    if (server != null) {
                        try {
                            cache.removeGatewayReceiver(server);
                            server.stop();
                        }
                        catch (Exception ex) {
                            throw StandardException.newException("X0Z22.S", ex, (Object)this.id, (Object)ex.toString());
                        }
                    }
                    throw StandardException.newException("22008.S", (Object)("BINDADDRESS " + this.bindAddress + " is not a reachable host name/address"), (Object)"CREATE GATEWAYRECEIVER");
                }
                throw StandardException.newException("XSDA4.S", ioe);
            }
        }
        int runningPort = 0;
        UUID uuid = dd.getUUIDFactory().recreateUUID(String.valueOf(runningPort));
        String servers = SharedUtils.toCSV(this.serverGroups.getServerGroupSet());
        GfxdGatewayReceiverDescriptor ghd = new GfxdGatewayReceiverDescriptor(dd, uuid, this.id, servers, this.startPort, this.endPort, runningPort, this.socketBufferSize, this.maxTimeBetPings, this.bindAddress, this.hostNameForSenders);
        dd.addDescriptor(ghd, null, 23, false, tc);
        SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("CreateGatewayReceiverNode:: inserted GatewayReceiver configuration for " + this.id + " in SYS table"));
    }

    static {
        try {
            VALID_IPV4_PATTERN = Pattern.compile(ipv4Pattern, 2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }
}

