/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.io;

import com.pivotal.gemfirexd.internal.impl.io.BaseStorageFactory;
import com.pivotal.gemfirexd.internal.impl.io.CPStorageFactory;
import com.pivotal.gemfirexd.internal.impl.io.InputStreamFile;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;

class CPFile
extends InputStreamFile {
    private final CPStorageFactory storageFactory;

    CPFile(CPStorageFactory storageFactory, String path) {
        super(storageFactory, path);
        this.storageFactory = storageFactory;
    }

    CPFile(CPStorageFactory storageFactory, String parent, String name) {
        super((BaseStorageFactory)storageFactory, parent, name);
        this.storageFactory = storageFactory;
    }

    CPFile(CPFile dir, String name) {
        super(dir, name);
        this.storageFactory = dir.storageFactory;
    }

    private CPFile(CPStorageFactory storageFactory, String child, int pathLen) {
        super((BaseStorageFactory)storageFactory, child, pathLen);
        this.storageFactory = storageFactory;
    }

    @Override
    public boolean exists() {
        return this.getURL() != null;
    }

    @Override
    StorageFile getParentDir(int pathLen) {
        return new CPFile(this.storageFactory, this.path, pathLen);
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        InputStream is = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            is = cl.getResourceAsStream(this.path);
        }
        if (is == null) {
            cl = this.getClass().getClassLoader();
            is = cl != null ? cl.getResourceAsStream(this.path) : ClassLoader.getSystemResourceAsStream(this.path);
        }
        if (is == null) {
            throw new FileNotFoundException(this.toString());
        }
        return is;
    }

    @Override
    public URL getURL() {
        URL myURL;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null && (myURL = cl.getResource(this.path)) != null) {
            return myURL;
        }
        cl = this.getClass().getClassLoader();
        if (cl != null) {
            return cl.getResource(this.path);
        }
        return ClassLoader.getSystemResource(this.path);
    }
}

