/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.util;

import java.util.Enumeration;
import java.util.Properties;

public final class DoubleProperties
extends Properties {
    private final Properties read;
    private final Properties write;

    public DoubleProperties(Properties read, Properties write) {
        this.read = read;
        this.write = write;
    }

    @Override
    public Object put(Object key, Object value) {
        return this.write.put(key, value);
    }

    @Override
    public String getProperty(String key) {
        return this.read.getProperty(key, this.write.getProperty(key));
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.read.getProperty(key, this.write.getProperty(key, defaultValue));
    }

    public Enumeration propertyNames() {
        String val;
        String key;
        Enumeration<?> e;
        Properties p = new Properties();
        if (this.write != null) {
            e = this.write.propertyNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                val = this.write.getProperty(key);
                if (val == null) continue;
                p.put(key, val);
            }
        }
        if (this.read != null) {
            e = this.read.propertyNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                val = this.read.getProperty(key);
                if (val == null) continue;
                p.put(key, val);
            }
        }
        return p.keys();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DoubleProperties@" + System.identityHashCode(this));
        sb.append("\n read properties ");
        sb.append(this.read.toString());
        sb.append("\n write properties");
        sb.append(this.write.toString());
        return sb.toString();
    }
}

