/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.catalog.ReferencedColumns;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;

public class CheckConstraintDescriptor
extends ConstraintDescriptor {
    private ReferencedColumns referencedColumns;
    private String constraintText;

    CheckConstraintDescriptor(DataDictionary dataDictionary, TableDescriptor table, String constraintName, boolean deferrable, boolean initiallyDeferred, UUID constraintId, String constraintText, ReferencedColumns referencedColumns, SchemaDescriptor schemaDesc, boolean isEnabled) {
        super(dataDictionary, table, constraintName, deferrable, initiallyDeferred, null, constraintId, schemaDesc, isEnabled);
        this.constraintText = constraintText;
        this.referencedColumns = referencedColumns;
    }

    @Override
    public boolean hasBackingIndex() {
        return false;
    }

    @Override
    public int getConstraintType() {
        return 4;
    }

    @Override
    public String getConstraintText() {
        return this.constraintText;
    }

    @Override
    public UUID getConglomerateId() {
        return null;
    }

    public ReferencedColumns getReferencedColumnsDescriptor() {
        return this.referencedColumns;
    }

    public void setReferencedColumnsDescriptor(ReferencedColumns rcd) {
        this.referencedColumns = rcd;
    }

    @Override
    public int[] getReferencedColumns() {
        return this.referencedColumns.getReferencedColumnPositions();
    }

    @Override
    public boolean needsToFire(int stmtType, int[] modifiedCols) {
        if (!this.isEnabled) {
            return false;
        }
        if (stmtType == 1) {
            return true;
        }
        if (stmtType == 4) {
            return false;
        }
        return CheckConstraintDescriptor.doColumnsIntersect(modifiedCols, this.getReferencedColumns());
    }

    @Override
    public String toString() {
        return "constraintText: " + this.constraintText + "\n" + "referencedColumns: " + this.referencedColumns + "\n" + super.toString();
    }
}

