/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ui;

import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.ui.SnappyRegionStats;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SnappyRegionStatsCollectorResult
extends GfxdDataSerializable {
    private transient List<SnappyRegionStats> combinedStats = new ArrayList<SnappyRegionStats>();

    public void addRegionStat(SnappyRegionStats stats) {
        this.combinedStats.add(stats);
    }

    public List<SnappyRegionStats> getRegionStats() {
        return this.combinedStats;
    }

    @Override
    public byte getGfxdID() {
        return 122;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.combinedStats.size());
        for (SnappyRegionStats stats : this.combinedStats) {
            InternalDataSerializer.writeString((String)stats.getRegionName(), (DataOutput)out);
            InternalDataSerializer.writeLong((Long)stats.getTotalSize(), (DataOutput)out);
            InternalDataSerializer.writeLong((Long)stats.getSizeInMemory(), (DataOutput)out);
            InternalDataSerializer.writeLong((Long)stats.getRowCount(), (DataOutput)out);
            InternalDataSerializer.writeBoolean((Boolean)stats.isColumnTable(), (DataOutput)out);
            InternalDataSerializer.writeBoolean((Boolean)stats.isReplicatedTable(), (DataOutput)out);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException {
        for (int size = in.readInt(); size > 0; --size) {
            String regionName = InternalDataSerializer.readString((DataInput)in);
            long totalSize = InternalDataSerializer.readLong((DataInput)in);
            long memorySize = InternalDataSerializer.readLong((DataInput)in);
            long count = InternalDataSerializer.readLong((DataInput)in);
            boolean isColumnTable = InternalDataSerializer.readBoolean((DataInput)in);
            boolean isReplicated = InternalDataSerializer.readBoolean((DataInput)in);
            this.addRegionStat(new SnappyRegionStats(regionName, totalSize, memorySize, count, isColumnTable, isReplicated));
        }
    }
}

