/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ui;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.DiskEntry;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.DiskRegionStats;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.size.SingleObjectSizer;
import com.gemstone.gemfire.internal.snappy.CallbackFactoryProvider;
import com.gemstone.gemfire.internal.snappy.StoreCallbacks;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.RegionMXBean;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.ui.SnappyRegionStats;
import com.pivotal.gemfirexd.internal.engine.ui.SnappyRegionStatsCollectorResult;
import com.pivotal.gemfirexd.tools.sizer.GemFireXDInstrumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class SnappyRegionStatsCollectorFunction
implements Function,
Declarable {
    public static String ID = "SnappyRegionStatsCollectorFunction";

    public void init(Properties props) {
    }

    public boolean hasResult() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FunctionContext context) {
        SnappyRegionStatsCollectorResult result = new SnappyRegionStatsCollectorResult();
        HashMap<String, SnappyRegionStats> cachBatchStats = new HashMap<String, SnappyRegionStats>();
        ArrayList<SnappyRegionStats> otherStats = new ArrayList<SnappyRegionStats>();
        try {
            List<GemFireContainer> containers = Misc.getMemStore().getAllContainers();
            SystemManagementService managementService = (SystemManagementService)ManagementService.getManagementService((Cache)Misc.getGemFireCache());
            for (GemFireContainer container : containers) {
                RegionMXBean bean;
                if (!container.isApplicationTable()) continue;
                LocalRegion r = container.getRegion();
                if (managementService == null || r == null || (bean = managementService.getLocalRegionMBean(r.getFullPath())) == null || r.getFullPath().startsWith("/SNAPPY_HIVE_METASTORE/")) continue;
                SnappyRegionStats dataCollector = this.collectDataFromBean(r, bean);
                if (dataCollector.isColumnTable()) {
                    cachBatchStats.put(dataCollector.getRegionName(), dataCollector);
                    continue;
                }
                otherStats.add(dataCollector);
            }
            if (Misc.reservoirRegionCreated) {
                for (SnappyRegionStats tableStats : otherStats) {
                    RegionMXBean reservoirBean;
                    String reservoirRegionName;
                    PartitionedRegion pr;
                    String rgnName = tableStats.getRegionName();
                    StoreCallbacks callback = CallbackFactoryProvider.getStoreCallbacks();
                    String catchBatchTableName = callback.cachedBatchTableName(tableStats.getRegionName());
                    if (!cachBatchStats.containsKey(catchBatchTableName) || (pr = Misc.getReservoirRegionForSampleTable(reservoirRegionName = Misc.getReservoirRegionNameForSampleTable("APP", rgnName))) == null || (reservoirBean = managementService.getLocalRegionMBean(pr.getFullPath())) == null) continue;
                    SnappyRegionStats rStats = this.collectDataFromBeanImpl((LocalRegion)pr, reservoirBean, true);
                    SnappyRegionStats cStats = (SnappyRegionStats)cachBatchStats.get(catchBatchTableName);
                    cachBatchStats.put(catchBatchTableName, cStats.getCombinedStats(rStats));
                }
            }
            for (SnappyRegionStats tableStats : otherStats) {
                StoreCallbacks callback = CallbackFactoryProvider.getStoreCallbacks();
                String catchBatchTableName = callback.cachedBatchTableName(tableStats.getRegionName());
                if (cachBatchStats.containsKey(catchBatchTableName)) {
                    result.addRegionStat(tableStats.getCombinedStats((SnappyRegionStats)cachBatchStats.get(catchBatchTableName)));
                    continue;
                }
                result.addRegionStat(tableStats);
            }
        }
        catch (CacheClosedException cacheClosedException) {
        }
        finally {
            context.getResultSender().lastResult((Object)result);
        }
    }

    private SnappyRegionStats collectDataFromBean(LocalRegion lr, RegionMXBean bean) {
        return this.collectDataFromBeanImpl(lr, bean, false);
    }

    private long getEntryOverhead(RegionEntry entry, GemFireXDInstrumentation sizer) {
        long entryOverhead = sizer.sizeof(entry);
        if (entry instanceof DiskEntry) {
            entryOverhead += sizer.sizeof(((DiskEntry)entry).getDiskId());
        }
        return entryOverhead;
    }

    private SnappyRegionStats collectDataFromBeanImpl(LocalRegion lr, RegionMXBean bean, boolean isReservoir) {
        String regionName = Misc.getFullTableNameFromRegionPath(bean.getFullPath());
        SnappyRegionStats tableStats = new SnappyRegionStats(regionName);
        boolean isColumnTable = bean.isColumnTable();
        tableStats.setColumnTable(isColumnTable);
        tableStats.setReplicatedTable(this.isReplicatedTable(lr.getDataPolicy()));
        if (isReservoir) {
            long numLocalEntries = bean.getRowsInReservoir();
            tableStats.setRowCount(numLocalEntries);
        } else {
            tableStats.setRowCount(isColumnTable ? bean.getRowsInCachedBatches() : bean.getEntryCount());
        }
        GemFireXDInstrumentation sizer = GemFireXDInstrumentation.getInstance();
        if (this.isReplicatedTable(lr.getDataPolicy()).booleanValue()) {
            long entryCount = 0L;
            Iterator ri = lr.entries.regionEntries().iterator();
            long size = lr.estimateMemoryOverhead((SingleObjectSizer)sizer);
            long entryOverhead = -1L;
            while (ri.hasNext()) {
                RegionEntry re = (RegionEntry)ri.next();
                if (entryOverhead < 0L) {
                    entryOverhead = this.getEntryOverhead(re, sizer);
                }
                size += entryOverhead;
                Object key = re.getRawKey();
                Object value = re._getValue();
                if (key != null) {
                    size += (long)CachedDeserializableFactory.calcMemSize((Object)key);
                }
                if (value != null) {
                    size += (long)CachedDeserializableFactory.calcMemSize((Object)value);
                }
                ++entryCount;
            }
            tableStats.setSizeInMemory(size);
            DiskRegion dr = lr.getDiskRegion();
            if (dr != null) {
                DiskRegionStats stats = dr.getStats();
                long diskBytes = stats.getBytesWritten();
                if (lr.getDataPolicy().withPersistence()) {
                    long numOverflow = stats.getNumOverflowOnDisk();
                    if (numOverflow > 0L) {
                        double avgDiskEntrySize = Math.max(1.0, (double)diskBytes / (double)entryCount);
                        size += (long)(avgDiskEntrySize * (double)numOverflow);
                    }
                } else {
                    size += diskBytes;
                }
            }
            tableStats.setTotalSize(size);
        } else {
            PartitionedRegionDataStore datastore = ((PartitionedRegion)lr).getDataStore();
            long sizeInMemory = 0L;
            long sizeOfRegion = 0L;
            long entryOverhead = 0L;
            long entryCount = 0L;
            if (datastore != null) {
                Set bucketRegions = datastore.getAllLocalBucketRegions();
                for (BucketRegion br : bucketRegions) {
                    Iterator iter;
                    long constantOverhead = br.estimateMemoryOverhead((SingleObjectSizer)sizer);
                    if (entryOverhead == 0L && (iter = br.entries.regionEntries().iterator()).hasNext()) {
                        RegionEntry re = (RegionEntry)iter.next();
                        entryOverhead = this.getEntryOverhead(re, sizer);
                    }
                    sizeInMemory += constantOverhead + br.getSizeInMemory();
                    sizeOfRegion += constantOverhead + br.getTotalBytes();
                    entryCount += (long)br.entryCount();
                }
            }
            if (entryOverhead > 0L) {
                entryOverhead *= entryCount;
            }
            tableStats.setSizeInMemory(sizeInMemory + entryOverhead);
            tableStats.setTotalSize(sizeOfRegion + entryOverhead);
        }
        return tableStats;
    }

    public Boolean isReplicatedTable(DataPolicy dataPolicy) {
        if (dataPolicy == DataPolicy.PERSISTENT_REPLICATE || dataPolicy == DataPolicy.REPLICATE) {
            return true;
        }
        return false;
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public boolean isHA() {
        return true;
    }
}

