/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ui;

public class SnappyRegionStats {
    private boolean isColumnTable = false;
    private String regionName;
    private long rowCount = 0L;
    private long sizeInMemory = 0L;
    private long totalSize = 0L;
    private Boolean isReplicatedTable = false;

    public SnappyRegionStats(String regionName) {
        this.regionName = regionName;
    }

    public SnappyRegionStats(String regionName, long totalSize, long sizeInMemory, long rowCount, boolean isColumnTable, boolean isReplicatedTable) {
        this.regionName = regionName;
        this.totalSize = totalSize;
        this.sizeInMemory = sizeInMemory;
        this.rowCount = rowCount;
        this.isColumnTable = isColumnTable;
        this.isReplicatedTable = isReplicatedTable;
    }

    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public boolean isColumnTable() {
        return this.isColumnTable;
    }

    public boolean isReplicatedTable() {
        return this.isReplicatedTable;
    }

    public void setReplicatedTable(boolean replicatedTable) {
        this.isReplicatedTable = replicatedTable;
    }

    public void setColumnTable(boolean columnTable) {
        this.isColumnTable = columnTable;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    public long getSizeInMemory() {
        return this.sizeInMemory;
    }

    public void setSizeInMemory(long sizeInMemory) {
        this.sizeInMemory = sizeInMemory;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public SnappyRegionStats getCombinedStats(SnappyRegionStats stats) {
        String regionName = this.isColumnTable ? stats.regionName : this.regionName;
        SnappyRegionStats combinedStats = new SnappyRegionStats(regionName);
        if (this.isReplicatedTable()) {
            combinedStats.setRowCount(stats.rowCount);
        } else {
            combinedStats.setRowCount(stats.rowCount + this.rowCount);
        }
        combinedStats.setSizeInMemory(stats.sizeInMemory + this.sizeInMemory);
        combinedStats.setTotalSize(stats.totalSize + this.totalSize);
        combinedStats.setColumnTable(this.isColumnTable || stats.isColumnTable);
        combinedStats.setReplicatedTable(this.isReplicatedTable());
        return combinedStats;
    }
}

