/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.HostStatHelper;
import com.gemstone.gemfire.internal.LinuxSystemStats;
import com.gemstone.gemfire.internal.PureJavaMode;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.SolarisSystemStats;
import com.gemstone.gemfire.internal.VMStatsContract;
import com.gemstone.gemfire.internal.WindowsSystemStats;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.stats50.VMStats50;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdDistributionAdvisor;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GfxdFunctionMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.MemberExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.management.NetworkServerConnectionStats;
import com.pivotal.gemfirexd.internal.engine.stats.ConnectionStats;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.snappy.CallbackFactoryProvider;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class MemberStatisticsMessage
extends MemberExecutorMessage {
    private static final long MBFactor = 0x100000L;
    private GemFireCacheImpl gemFireCache;
    private Statistics vmStats;
    private Statistics vmHeapStats;
    private Statistics systemStat;
    private UUID diskStoreUUID;
    private String diskStoreName;

    public MemberStatisticsMessage() {
        super(true);
    }

    public MemberStatisticsMessage(ResultCollector<Object, Object> rc) {
        super(rc, null, false, true);
    }

    private MemberStatisticsMessage(MemberStatisticsMessage other) {
        super(other);
    }

    @Override
    protected void execute() throws Exception {
        this.gemFireCache = GemFireCacheImpl.getExisting();
        InternalDistributedSystem ids = this.gemFireCache.getDistributedSystem();
        String memberId = ids.getMemberId();
        this.updateStats(ids);
        NetworkServerConnectionStats clientConnectionStats = this.getMemberClientConnectionStats(ids);
        HashMap<String, Object> memberStatsMap = new HashMap<String, Object>();
        memberStatsMap.put("id", memberId);
        memberStatsMap.put("name", ids.getName());
        memberStatsMap.put("host", this.getHost());
        memberStatsMap.put("locator", this.isLocator());
        memberStatsMap.put("dataServer", this.isDataServer());
        memberStatsMap.put("activeLead", this.isActiveLead(ids.getDistributedMember()));
        memberStatsMap.put("lead", this.isLead());
        memberStatsMap.put("maxMemory", this.getMaxMemory());
        memberStatsMap.put("freeMemory", this.getFreeMemory());
        memberStatsMap.put("totalMemory", this.getTotalMemory());
        memberStatsMap.put("usedMemory", this.getUsedMemory());
        memberStatsMap.put("cpuActive", this.getHostCpuUsage());
        memberStatsMap.put("clients", clientConnectionStats.getConnectionsOpen());
        memberStatsMap.put("diskStoreUUID", this.getDiskStoreUUID());
        memberStatsMap.put("diskStoreName", this.getDiskStoreName());
        this.lastResult(memberStatsMap);
    }

    private void updateStats(InternalDistributedSystem system) {
        VMStatsContract vmStatsContract;
        if (PureJavaMode.osStatsAreAvailable()) {
            Statistics[] systemStats = null;
            if (HostStatHelper.isSolaris()) {
                systemStats = system.findStatisticsByType(SolarisSystemStats.getType());
            } else if (HostStatHelper.isLinux()) {
                systemStats = system.findStatisticsByType(LinuxSystemStats.getType());
            } else if (HostStatHelper.isOSX()) {
                systemStats = null;
            } else if (HostStatHelper.isWindows()) {
                systemStats = system.findStatisticsByType(WindowsSystemStats.getType());
            }
            if (systemStats != null) {
                this.systemStat = systemStats[0];
            }
        }
        if ((vmStatsContract = system.getStatSampler().getVMStats()) != null && vmStatsContract instanceof VMStats50) {
            Statistics vmHeapStats;
            VMStats50 vmStats50 = (VMStats50)vmStatsContract;
            Statistics vmStats = vmStats50.getVMStats();
            if (vmStats != null) {
                this.vmStats = vmStats;
            }
            if ((vmHeapStats = vmStats50.getVMHeapStats()) != null) {
                this.vmHeapStats = vmHeapStats;
            }
            Collection diskStores = this.gemFireCache.listDiskStores();
            for (DiskStoreImpl dsi : diskStores) {
                if (!dsi.getName().equals(GemFireCacheImpl.getDefaultDiskStoreName())) continue;
                this.diskStoreUUID = dsi.getDiskStoreUUID();
                this.diskStoreName = dsi.getName();
            }
        }
    }

    private String getHost() {
        try {
            InetAddress addr = SocketCreator.getLocalHost();
            return addr.getHostName();
        }
        catch (UnknownHostException ex) {
            return "localhost";
        }
    }

    private boolean isLocator() {
        return Locator.hasLocator();
    }

    private boolean isDataServer() {
        return ServerGroupUtils.isDataStore();
    }

    private boolean isActiveLead(InternalDistributedMember member) {
        GfxdDistributionAdvisor advisor = GemFireXDUtils.getGfxdAdvisor();
        GfxdDistributionAdvisor.GfxdProfile profile = advisor.getProfile(member);
        return profile != null && profile.hasSparkURL();
    }

    private boolean isLead() {
        HashSet<String> leadGroup = CallbackFactoryProvider.getClusterCallbacks().getLeaderGroup();
        boolean isLead = leadGroup != null && leadGroup.size() > 0 && ServerGroupUtils.isGroupMember(leadGroup);
        return isLead;
    }

    private int getHostCpuUsage() {
        if (this.systemStat != null) {
            return this.systemStat.get("cpuActive").intValue();
        }
        return -1;
    }

    private long getMaxMemory() {
        return this.vmStats.get("maxMemory").longValue();
    }

    private long getFreeMemory() {
        return this.vmStats.get("freeMemory").longValue();
    }

    private long getTotalMemory() {
        return this.vmStats.get("totalMemory").longValue();
    }

    public long getUsedMemory() {
        return this.vmHeapStats.get("usedMemory").longValue();
    }

    public UUID getDiskStoreUUID() {
        return this.diskStoreUUID;
    }

    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    private NetworkServerConnectionStats getMemberClientConnectionStats(InternalDistributedSystem system) {
        NetworkServerConnectionStats clientConnectionStats = new NetworkServerConnectionStats("Client", 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        StatisticsType connectionStatsType = system.findType(ConnectionStats.name);
        if (connectionStatsType != null) {
            Statistics[] foundStatistics;
            for (Statistics statistics : foundStatistics = system.findStatisticsByType(connectionStatsType)) {
                clientConnectionStats.updateNetworkServerConnectionStats(statistics.getLong("clientConnectionsOpened"), statistics.getLong("clientConnectionsClosed"), statistics.getLong("clientConnectionsAttempted"), statistics.getLong("clientConnectionsFailed"), statistics.getLong("clientConnectionsLifeTime"), statistics.getLong("clientConnectionsOpen"), statistics.getLong("clientConnectionsIdle"));
            }
        }
        return clientConnectionStats;
    }

    @Override
    public Set<DistributedMember> getMembers() {
        return MemberStatisticsMessage.getAllGfxdMembers();
    }

    @Override
    public void postExecutionCallback() {
    }

    @Override
    public boolean isHA() {
        return false;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    protected GfxdFunctionMessage clone() {
        return new MemberStatisticsMessage(this);
    }

    @Override
    public byte getGfxdID() {
        return 55;
    }
}

