/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.procedure.coordinate;

import com.pivotal.gemfirexd.procedure.IncomingResultSet;
import java.sql.ResultSetMetaData;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class IncomingResultSetImpl
implements IncomingResultSet {
    private ReentrantLock lock = new ReentrantLock();
    private Condition notEmpty = this.lock.newCondition();
    private LinkedBlockingQueue<List<Object>> queue = new LinkedBlockingQueue();
    private boolean finished = false;

    @Override
    public ResultSetMetaData getMetaData() {
        return null;
    }

    @Override
    public List<Object> peekRow() {
        return this.queue.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> peekRow(long timeout, TimeUnit unit) throws InterruptedException {
        long remainingTime = unit.toNanos(timeout);
        List<Object> retValue = null;
        this.lock.lock();
        try {
            while ((retValue = this.queue.peek()) == null && remainingTime > 0L) {
                remainingTime = this.notEmpty.awaitNanos(remainingTime);
            }
            List<Object> list = retValue;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> pollRow() {
        List<Object> list = this.queue.poll();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> pollRow(long timeout, TimeUnit unit) throws InterruptedException {
        List<Object> list = this.queue.poll(timeout, unit);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> takeRow() throws InterruptedException {
        List<Object> list = this.queue.take();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> waitPeekRow() throws InterruptedException {
        List<Object> retValue = null;
        this.lock.lock();
        try {
            while ((retValue = this.queue.peek()) == null) {
                this.notEmpty.await();
            }
            List<Object> list = retValue;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(List<Object> row) {
        this.lock.lock();
        try {
            this.queue.add(row);
            this.notEmpty.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void finish() {
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

