/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.procedure.cohort;

import com.gemstone.gemfire.cache.execute.ResultSender;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.cache.execute.InternalResultSender;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.procedure.ProcedureChunkMessage;
import com.pivotal.gemfirexd.internal.engine.procedure.cohort.OutgoingResultSetImpl;
import com.pivotal.gemfirexd.internal.engine.procedure.cohort.ProcedureExecutionContextImpl;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.procedure.OutgoingResultSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public final class ProcedureSender {
    protected InternalResultSender sender;
    private final AtomicInteger seqno;
    private ProcedureExecutionContextImpl procedureExecutionContext;
    private final EmbedConnection parentConn;

    public ProcedureSender(ResultSender<?> sender, EmbedConnection conn) {
        this.sender = (InternalResultSender)sender;
        this.sender.enableOrderedResultStreaming(GemFireXDUtils.PROCEDURE_ORDER_RESULTS);
        this.seqno = new AtomicInteger(0);
        this.parentConn = conn;
    }

    public void initialize() {
    }

    public void addOutgoingResultSet(OutgoingResultSet outgoingResultSet) {
        assert (outgoingResultSet != null) : "Expect a non-null dynamicResultSet!";
        OutgoingResultSetImpl rs = (OutgoingResultSetImpl)outgoingResultSet;
        rs.setResultSetSender(this);
    }

    void send(ProcedureChunkMessage message) {
        int seqNo = this.seqno.getAndIncrement();
        message.setPrevSeqNumber(seqNo);
        message.setSeqNumber(seqNo + 1);
        if (GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"DataAwareDistribution", (String)("Sending " + message));
        }
        this.sender.sendResult((Object)message);
    }

    void sendLast(ProcedureChunkMessage message) {
        int seqNo = this.seqno.getAndIncrement();
        message.setPrevSeqNumber(seqNo);
        message.setSeqNumber(seqNo + 1);
        if (GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"DataAwareDistribution", (String)("Sending " + message.toString()));
        }
        this.sender.lastResult((Object)message);
    }

    public void close() {
    }

    public void sendOutParameters(ParameterValueSet pvs) throws StandardException {
        ArrayList<Object> outParameters = new ArrayList<Object>();
        int numParameters = pvs.getParameterCount();
        for (int i = 1; i <= numParameters; ++i) {
            short mode = pvs.getParameterMode(i);
            if (mode != 2 && mode != 4) continue;
            DataValueDescriptor dvd = pvs.getParameterForGet(i - 1);
            assert (dvd != null) : "the dvd should not be null!";
            outParameters.add(dvd.getObject());
        }
        ArrayList<List<Object>> chunks = new ArrayList<List<Object>>();
        if (outParameters.size() > 0) {
            chunks.add(outParameters);
            ProcedureChunkMessage message = new ProcedureChunkMessage(1, 0, chunks);
            this.send(message);
        }
    }

    public void sendResultSet(EmbedResultSet rs) throws SQLException {
        ArrayList<List<Object>> chunk = this.getRowSet(rs);
        ProcedureChunkMessage message = new ProcedureChunkMessage(3, rs.getResultsetIndex(), chunk);
        message.setLast();
        this.send(message);
    }

    private ArrayList<List<Object>> getRowSet(EmbedResultSet rs) throws SQLException {
        int colCount = rs.getMetaData().getColumnCount();
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        while (rs.next()) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (int colIndex = 1; colIndex <= colCount; ++colIndex) {
                row.add(colIndex - 1, rs.getObject(colIndex));
            }
            rows.add(row);
        }
        return rows;
    }

    public void endProcedureCall() {
        if (GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"DataAwareDistribution", (String)"End procedure call");
        }
        this.sendLast(new ProcedureChunkMessage(4));
        this.closeNestedConnections();
    }

    public EmbedConnection setProcedureExecutionContext(ProcedureExecutionContextImpl pecImpl) {
        this.procedureExecutionContext = pecImpl;
        return this.parentConn;
    }

    private void closeNestedConnections() {
        block5: {
            try {
                if (this.procedureExecutionContext == null) {
                    return;
                }
                ArrayList<Connection> nestedConns = this.procedureExecutionContext.getNestedConnectionList();
                if (nestedConns != null) {
                    for (Connection conn : nestedConns) {
                        conn.close();
                    }
                }
            }
            catch (SQLException e) {
                LogWriterI18n logger = Misc.getI18NLogWriter();
                if (!logger.warningEnabled()) break block5;
                logger.warning(LocalizedStrings.DEBUG, (Throwable)e);
            }
        }
    }
}

