/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.management.impl;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.management.impl.Cleanable;
import com.pivotal.gemfirexd.internal.engine.management.impl.Updatable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class MBeanDataUpdater<T>
implements Runnable,
Cleanable {
    protected Map<String, Updatable<T>> updatables = new ConcurrentHashMap<String, Updatable<T>>();

    public void addUpdatable(String key, Updatable<T> updatable) {
        this.updatables.put(key, updatable);
    }

    public void removeUpdatable(String key) {
        this.updatables.remove(key);
    }

    @Override
    public void cleanUp() {
        this.updatables.clear();
    }

    public boolean isCacheRunning() {
        GemFireCacheImpl gemFireCache = Misc.getGemFireCacheNoThrow();
        return gemFireCache != null && !gemFireCache.isClosed();
    }

    protected void logFine(Exception e) {
        LogWriter logWriter = Misc.getCacheLogWriterNoThrow();
        if (logWriter != null && logWriter.fineEnabled()) {
            logWriter.fine((Throwable)e);
        }
    }

    protected void logInfo(String str) {
        LogWriter logWriter = Misc.getCacheLogWriterNoThrow();
        if (logWriter != null) {
            logWriter.info(str);
        }
    }

    protected void logFiner(Exception e) {
        LogWriter logWriter = Misc.getCacheLogWriterNoThrow();
        if (logWriter != null && logWriter.finerEnabled()) {
            logWriter.finer((Throwable)e);
        }
    }

    @Override
    public void run() {
        if (!this.updatables.isEmpty() && this.isCacheRunning()) {
            try {
                this.runUpdate();
            }
            catch (Exception e) {
                this.logFine(e);
            }
        }
    }

    protected abstract void runUpdate();
}

